/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.Tracer;
import java.io.PrintStream;

public class EventTrace {
    private static int MAX_EVENTS = 100;
    public static final boolean TRACE_EVENTS = false;
    static int currentEvent = 0;
    static final EventTrace[] events = new EventTrace[MAX_EVENTS];
    static final int[] threadIdHashes = new int[MAX_EVENTS];
    static boolean disableEvents = false;
    protected String comment;

    public EventTrace(String comment) {
        this.comment = comment;
    }

    public EventTrace() {
        this.comment = null;
    }

    public String toString() {
        return this.comment;
    }

    public static boolean addEvent(EventTrace event) {
        if (disableEvents) {
            return true;
        }
        int nextEventIdx = currentEvent++ % MAX_EVENTS;
        EventTrace.events[nextEventIdx] = event;
        EventTrace.threadIdHashes[nextEventIdx] = System.identityHashCode(Thread.currentThread());
        return true;
    }

    public static boolean addEvent(String comment) {
        if (disableEvents) {
            return true;
        }
        return EventTrace.addEvent(new EventTrace(comment));
    }

    public static void dumpEvents() {
        EventTrace.dumpEvents(System.out);
    }

    public static void dumpEvents(PrintStream out) {
        if (disableEvents) {
            return;
        }
        out.println("----- Event Dump -----");
        EventTrace[] oldEvents = events;
        int[] oldThreadIdHashes = threadIdHashes;
        disableEvents = true;
        int j = 0;
        int i = currentEvent;
        while (j < MAX_EVENTS) {
            EventTrace ev = oldEvents[i % MAX_EVENTS];
            if (ev != null) {
                int thisEventIdx = i % MAX_EVENTS;
                out.print(oldThreadIdHashes[thisEventIdx] + " ");
                out.println(j + "(" + thisEventIdx + "): " + ev);
            }
            ++j;
            ++i;
        }
    }

    public static class ExceptionEventTrace
    extends EventTrace {
        private Exception event = new Exception();

        @Override
        public String toString() {
            return Tracer.getStackTrace(this.event);
        }
    }
}

