/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.cleaner.VerifyUtils;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.CmdUtil;
import com.sleepycat.je.utilint.Tracer;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class DbVerify {
    private static final String usageString = "usage: " + CmdUtil.getJavaCommand(DbVerify.class) + "\n       -h <dir>             # environment home directory\n       [-c ]                # check cleaner metadata\n       [-q ]                # quiet, exit with success or failure\n       [-s <databaseName> ] # database to verify\n       [-v <interval>]      # progress notification interval\n       [-V]                 # print JE version number";
    File envHome = null;
    Environment env;
    String dbName = null;
    boolean quiet = false;
    boolean checkLsns = false;
    boolean openReadOnly = true;
    private boolean doClose;
    private int progressInterval = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws DatabaseException {
        DbVerify verifier = new DbVerify();
        verifier.parseArgs(argv);
        boolean ret = false;
        try {
            ret = verifier.verify(System.err);
        }
        catch (Throwable T) {
            block7: {
                try {
                    if (verifier.quiet) break block7;
                    T.printStackTrace(System.err);
                }
                catch (Throwable throwable) {
                    verifier.closeEnv();
                    if (!verifier.quiet || verifier.progressInterval > 0) {
                        System.err.println("Exit status = " + ret);
                    }
                    System.exit(ret ? 0 : -1);
                    throw throwable;
                }
            }
            verifier.closeEnv();
            if (!verifier.quiet || verifier.progressInterval > 0) {
                System.err.println("Exit status = " + ret);
            }
            System.exit(ret ? 0 : -1);
        }
        verifier.closeEnv();
        if (!verifier.quiet || verifier.progressInterval > 0) {
            System.err.println("Exit status = " + ret);
        }
        System.exit(ret ? 0 : -1);
    }

    DbVerify() {
        this.doClose = true;
    }

    public DbVerify(Environment env, String dbName, boolean quiet) {
        this.env = env;
        this.dbName = dbName;
        this.quiet = quiet;
        this.doClose = false;
    }

    void printUsage(String msg) {
        System.err.println(msg);
        System.err.println(usageString);
        System.exit(-1);
    }

    void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-q")) {
                this.quiet = true;
                continue;
            }
            if (thisArg.equals("-V")) {
                System.out.println(JEVersion.CURRENT_VERSION);
                System.exit(0);
                continue;
            }
            if (thisArg.equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(argv[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (thisArg.equals("-s")) {
                if (argc < nArgs) {
                    this.dbName = argv[argc++];
                    continue;
                }
                this.printUsage("-s requires an argument");
                continue;
            }
            if (thisArg.equals("-v")) {
                if (argc < nArgs) {
                    this.progressInterval = Integer.parseInt(argv[argc++]);
                    if (this.progressInterval > 0) continue;
                    this.printUsage("-v requires a positive argument");
                    continue;
                }
                this.printUsage("-v requires an argument");
                continue;
            }
            if (thisArg.equals("-c")) {
                this.checkLsns = true;
                continue;
            }
            if (!thisArg.equals("-rw")) continue;
            this.openReadOnly = false;
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
    }

    void openEnv() throws DatabaseException {
        if (this.env == null) {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setReadOnly(this.openReadOnly);
            this.env = new Environment(this.envHome, envConfig);
        }
    }

    void closeEnv() throws DatabaseException {
        try {
            if (this.env != null) {
                this.env.close();
            }
        }
        finally {
            this.env = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(PrintStream out) throws DatabaseException {
        boolean ret = true;
        try {
            VerifyConfig verifyConfig = new VerifyConfig();
            verifyConfig.setPrintInfo(!this.quiet);
            if (this.progressInterval > 0) {
                verifyConfig.setShowProgressInterval(this.progressInterval);
                verifyConfig.setShowProgressStream(out);
            }
            this.openEnv();
            EnvironmentImpl envImpl = DbInternal.envGetEnvironmentImpl(this.env);
            List<String> dbNameList = null;
            List<String> internalDbs = null;
            DbTree dbMapTree = envImpl.getDbTree();
            if (this.dbName == null) {
                dbNameList = this.env.getDatabaseNames();
                dbNameList.addAll(dbMapTree.getInternalDbNames());
                internalDbs = dbMapTree.getInternalNoLookupDbNames();
            } else {
                dbNameList = new ArrayList<String>();
                dbNameList.add(this.dbName);
                internalDbs = new ArrayList<String>();
            }
            for (String targetDb : dbNameList) {
                Tracer.trace(Level.INFO, envImpl, "DbVerify.verify of " + targetDb + " starting");
                DatabaseConfig dbConfig = new DatabaseConfig();
                dbConfig.setReadOnly(true);
                dbConfig.setAllowCreate(false);
                DbInternal.setUseExistingConfig(dbConfig, true);
                Database db = this.env.openDatabase(null, targetDb, dbConfig);
                try {
                    if (this.verifyOneDbImpl(DbInternal.dbGetDatabaseImpl(db), targetDb, verifyConfig, out)) continue;
                    ret = false;
                }
                finally {
                    if (db != null) {
                        db.close();
                    }
                    Tracer.trace(Level.INFO, envImpl, "DbVerify.verify of " + targetDb + " ending");
                }
            }
            for (String targetDb : internalDbs) {
                Tracer.trace(Level.INFO, envImpl, "DbVerify.verify of " + targetDb + " starting");
                try {
                    DatabaseImpl dbImpl = dbMapTree.getDb(null, targetDb, null);
                    try {
                        if (this.verifyOneDbImpl(dbImpl, targetDb, verifyConfig, out)) continue;
                        ret = false;
                    }
                    finally {
                        dbMapTree.releaseDb(dbImpl);
                    }
                }
                finally {
                    Tracer.trace(Level.INFO, envImpl, "DbVerify.verify of " + targetDb + " ending");
                }
            }
            if (this.doClose) {
                this.closeEnv();
            }
        }
        catch (DatabaseException DE) {
            ret = false;
            try {
                this.closeEnv();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw DE;
        }
        return ret;
    }

    private boolean verifyOneDbImpl(DatabaseImpl dbImpl, String name, VerifyConfig verifyConfig, PrintStream out) throws DatabaseException {
        boolean status = true;
        if (verifyConfig.getPrintInfo()) {
            out.println("Verifying database " + name);
        }
        if (this.checkLsns) {
            if (verifyConfig.getPrintInfo()) {
                out.println("Checking obsolete offsets for " + name);
            }
            try {
                VerifyUtils.checkLsns(dbImpl, out);
            }
            catch (DatabaseException e) {
                if (verifyConfig.getPrintInfo()) {
                    out.println("Problem from checkLsns:" + e);
                }
                status = false;
            }
        } else {
            if (verifyConfig.getPrintInfo()) {
                out.println("Checking tree for " + name);
            }
            DatabaseStats stats = dbImpl.getEmptyStats();
            status = dbImpl.verify(verifyConfig, stats);
            if (verifyConfig.getPrintInfo()) {
                out.print(stats);
            }
        }
        if (verifyConfig.getPrintInfo()) {
            out.println();
        }
        return status;
    }
}

