/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.TxnAbort;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.txn.TxnPrepare;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.Xid;

public class Txn
extends Locker
implements Loggable {
    private static final String DEBUG_NAME = Txn.class.getName();
    private byte txnState;
    private CursorImpl cursorSet;
    private static final byte USABLE = 0;
    private static final byte CLOSED = 1;
    private static final byte ONLY_ABORTABLE = 2;
    private static final byte STATE_BITS = 3;
    private static final byte IS_PREPARED = 4;
    private static final byte XA_SUSPENDED = 8;
    private Set<Long> readLocks;
    private Map<Long, WriteLockInfo> writeInfo;
    private final int READ_LOCK_OVERHEAD = MemoryBudget.HASHSET_ENTRY_OVERHEAD;
    private final int WRITE_LOCK_OVERHEAD = MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.WRITE_LOCKINFO_OVERHEAD;
    private Set<DatabaseCleanupInfo> deletedDatabases;
    protected Map<DatabaseId, DatabaseImpl> undoDatabases;
    protected long lastLoggedLsn = -1L;
    protected long firstLoggedLsn = -1L;
    private Durability defaultDurability;
    private Durability commitDurability;
    private boolean serializableIsolation;
    private boolean readCommittedIsolation;
    private int inMemorySize;
    private int accumulatedDelta = 0;
    public static int ACCUMULATED_LIMIT = 10000;
    protected ReplicationContext repContext;
    private boolean explicitSyncConfigured = false;
    private boolean explicitDurabilityConfigured = false;
    private boolean isAutoCommit = false;

    public Txn() {
        this.lastLoggedLsn = -1L;
    }

    protected Txn(EnvironmentImpl envImpl, TransactionConfig config) throws DatabaseException {
        super(envImpl, config.getReadUncommitted(), config.getNoWait(), 0L);
        this.initTxn(envImpl, config);
    }

    static Txn createTxn(EnvironmentImpl envImpl, TransactionConfig config) throws DatabaseException {
        Txn ret = null;
        try {
            ret = envImpl.isReplicated() ? envImpl.getReplicator().createRepTxn(envImpl, config) : new Txn(envImpl, config);
            ret.initApiReadLock();
        }
        catch (DatabaseException DE) {
            if (ret != null) {
                ret.close(false);
            }
            throw DE;
        }
        return ret;
    }

    protected Txn(EnvironmentImpl envImpl, TransactionConfig config, boolean noAPIReadLock, long mandatedId) throws DatabaseException {
        super(envImpl, config.getReadUncommitted(), config.getNoWait(), noAPIReadLock, mandatedId);
        this.initTxn(envImpl, config);
    }

    public Txn(EnvironmentImpl envImpl, TransactionConfig config, ReplicationContext repContext) throws DatabaseException {
        super(envImpl, config.getReadUncommitted(), config.getNoWait(), 0L);
        this.initTxn(envImpl, config);
        this.setRepContext(repContext);
    }

    public static Txn createTxn(EnvironmentImpl envImpl, TransactionConfig config, ReplicationContext repContext) throws DatabaseException {
        Txn ret = null;
        try {
            ret = envImpl.isReplicated() ? envImpl.getReplicator().createRepTxn(envImpl, config, repContext) : new Txn(envImpl, config, repContext);
            ret.initApiReadLock();
        }
        catch (DatabaseException DE) {
            if (ret != null) {
                ret.close(false);
            }
            throw DE;
        }
        return ret;
    }

    public static Txn createAutoTxn(EnvironmentImpl envImpl, TransactionConfig config, boolean noAPIReadLock, ReplicationContext repContext) throws DatabaseException {
        Txn ret = null;
        try {
            ret = envImpl.isReplicated() ? envImpl.getReplicator().createRepTxn(envImpl, config, noAPIReadLock, 0L) : new Txn(envImpl, config, noAPIReadLock, 0L);
            ret.isAutoCommit = true;
            ret.setRepContext(repContext);
            ret.initApiReadLock();
        }
        catch (DatabaseException DE) {
            if (ret != null) {
                ret.close(false);
            }
            throw DE;
        }
        return ret;
    }

    private void initTxn(EnvironmentImpl envImpl, TransactionConfig config) throws DatabaseException {
        this.serializableIsolation = config.getSerializableIsolation();
        this.readCommittedIsolation = config.getReadCommitted();
        this.defaultDurability = config.getDurability();
        if (this.defaultDurability == null) {
            this.explicitDurabilityConfigured = false;
            this.defaultDurability = config.getDurabilityFromSync();
        } else {
            this.explicitDurabilityConfigured = true;
        }
        boolean bl = this.explicitSyncConfigured = config.getSync() || config.getNoSync() || config.getWriteNoSync();
        assert (!this.explicitDurabilityConfigured || !this.explicitSyncConfigured);
        this.lastLoggedLsn = -1L;
        this.firstLoggedLsn = -1L;
        this.txnState = 0;
        this.txnBeginHook(config);
        this.updateMemoryUsage(MemoryBudget.TXN_OVERHEAD);
        this.envImpl.getTxnManager().registerTxn(this);
    }

    @Override
    protected long generateId(TxnManager txnManager, long ignore) {
        return txnManager.getNextTxnId();
    }

    public long getLastLsn() {
        return this.lastLoggedLsn;
    }

    public Durability getCommitDurability() {
        return this.commitDurability;
    }

    public Durability getDefaultDurability() {
        return this.defaultDurability;
    }

    public boolean getPrepared() {
        return (this.txnState & 4) != 0;
    }

    public void setPrepared(boolean prepared) {
        this.txnState = prepared ? (byte)(this.txnState | 4) : (byte)(this.txnState & 0xFFFFFFFB);
    }

    public void setSuspended(boolean suspended) {
        this.txnState = suspended ? (byte)(this.txnState | 8) : (byte)(this.txnState & 0xFFFFFFF7);
    }

    public boolean isSuspended() {
        return (this.txnState & 8) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    LockResult lockInternal(long nodeId, LockType lockType, boolean noWait, DatabaseImpl database) throws DatabaseException {
        long timeout = 0L;
        boolean useNoWait = noWait || this.defaultNoWait;
        Txn txn = this;
        synchronized (txn) {
            this.checkState(false);
            if (!useNoWait) {
                timeout = this.getLockTimeout();
            }
        }
        LockGrantType grant = this.lockManager.lock(nodeId, this, lockType, timeout, useNoWait, database);
        WriteLockInfo info = null;
        if (this.writeInfo != null && grant != LockGrantType.DENIED && lockType.isWriteLock()) {
            Txn txn2 = this;
            synchronized (txn2) {
                info = this.writeInfo.get(nodeId);
                this.undoDatabases.put(database.getId(), database);
            }
        }
        return new LockResult(grant, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws DatabaseException {
        if ((this.txnState & 4) != 0) {
            throw new DatabaseException("prepare() has already been called for Transaction " + this.id + ".");
        }
        Txn txn = this;
        synchronized (txn) {
            this.checkState(false);
            if (this.checkCursorsForClose()) {
                throw new DatabaseException("Transaction " + this.id + " prepare failed because there were open cursors.");
            }
            this.setPrepared(true);
            this.envImpl.getTxnManager().notePrepare();
            if (this.writeInfo == null) {
                return 3;
            }
            SingleItemEntry prepareEntry = new SingleItemEntry(LogEntryType.LOG_TXN_PREPARE, new TxnPrepare(this.id, xid));
            LogManager logManager = this.envImpl.getLogManager();
            logManager.logForceFlush(prepareEntry, true, ReplicationContext.NO_REPLICATE);
        }
        return 0;
    }

    public void commit(Xid xid) throws DatabaseException {
        this.commit(TransactionConfig.SYNC);
        this.envImpl.getTxnManager().unRegisterXATxn(xid, true);
    }

    public void abort(Xid xid) throws DatabaseException {
        this.abort(true);
        this.envImpl.getTxnManager().unRegisterXATxn(xid, false);
    }

    public long commit() throws DatabaseException {
        return this.commit(this.defaultDurability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long commit(Durability durability) throws DatabaseException {
        DatabaseException repNoAbortException = null;
        DatabaseException repAbortException = null;
        this.commitDurability = durability;
        try {
            long commitLsn = -1L;
            Txn txn = this;
            synchronized (txn) {
                this.checkState(false);
                if (this.checkCursorsForClose()) {
                    throw new DatabaseException("Transaction " + this.id + " commit failed because there were open cursors.");
                }
                ArrayList<WriteLockInfo> transferredWriteLockInfo = null;
                if (this.handleLockToHandleMap != null) {
                    for (Map.Entry entry : this.handleLockToHandleMap.entrySet()) {
                        WriteLockInfo info;
                        Long nodeId = (Long)entry.getKey();
                        if (this.writeInfo != null && (info = this.writeInfo.get(nodeId)) != null) {
                            if (transferredWriteLockInfo == null) {
                                transferredWriteLockInfo = new ArrayList<WriteLockInfo>();
                            }
                            transferredWriteLockInfo.add(info);
                        }
                        this.transferHandleLockToHandleSet(nodeId, (Set)entry.getValue());
                    }
                }
                int numReadLocks = this.clearReadLocks();
                int numWriteLocks = 0;
                if (this.writeInfo != null) {
                    numWriteLocks = this.writeInfo.size();
                    if (this.firstLoggedLsn != -1L) {
                        try {
                            this.preLogCommitHook();
                        }
                        catch (DatabaseException preCommitException) {
                            repAbortException = preCommitException;
                            throw preCommitException;
                        }
                        try {
                            commitLsn = this.logCommitEntry(durability.getLocalSync());
                        }
                        catch (Exception e) {
                            this.postLogAbortHook();
                            throw e;
                        }
                        try {
                            this.postLogCommitHook();
                        }
                        catch (DatabaseException postCommitException) {
                            repNoAbortException = postCommitException;
                        }
                    }
                    this.setDeletedDatabaseState(true);
                    HashSet<Long> alreadyCountedLsnSet = new HashSet<Long>();
                    for (Map.Entry<Long, WriteLockInfo> entry : this.writeInfo.entrySet()) {
                        Long nodeId = entry.getKey();
                        this.lockManager.release(nodeId, this);
                        this.countWriteAbortLSN(entry.getValue(), alreadyCountedLsnSet);
                    }
                    this.writeInfo = null;
                    if (transferredWriteLockInfo != null) {
                        for (int i = 0; i < transferredWriteLockInfo.size(); ++i) {
                            WriteLockInfo info = (WriteLockInfo)transferredWriteLockInfo.get(i);
                            this.countWriteAbortLSN(info, alreadyCountedLsnSet);
                        }
                    }
                    if (this.deleteInfo != null && this.deleteInfo.size() > 0) {
                        this.envImpl.addToCompressorQueue(this.deleteInfo.values(), false);
                        this.deleteInfo.clear();
                    }
                }
                this.traceCommit(numWriteLocks, numReadLocks);
            }
            this.cleanupDatabaseImpls(true);
            this.close(true);
            if (repNoAbortException == null) {
                return commitLsn;
            }
        }
        catch (RunRecoveryException e) {
            throw e;
        }
        catch (Error e) {
            this.envImpl.invalidate(e);
            throw e;
        }
        catch (Exception t) {
            try {
                this.abortInternal(durability.getLocalSync() == Durability.SyncPolicy.SYNC, repAbortException != null || !(t instanceof DatabaseException));
                Tracer.trace(this.envImpl, "Txn", "commit", "Commit of transaction " + this.id + " failed", t);
            }
            catch (Error e) {
                this.envImpl.invalidate(e);
                throw e;
            }
            catch (Exception abortT2) {
                throw new DatabaseException("Failed while attempting to commit transaction " + this.id + ". The attempt to abort and clean up also failed. The original exception seen from commit = " + t.getMessage() + " The exception from the cleanup = " + abortT2.getMessage(), t);
            }
            if (t == repAbortException) {
                throw repAbortException;
            }
            throw new DatabaseException("Failed while attempting to commit transaction " + this.id + ", aborted instead. Original exception = " + t.getMessage(), t);
        }
        assert (repNoAbortException != null);
        throw repNoAbortException;
    }

    private long logCommitEntry(Durability.SyncPolicy flushSyncBehavior) throws DatabaseException {
        LogManager logManager = this.envImpl.getLogManager();
        SingleItemEntry commitEntry = new SingleItemEntry(LogEntryType.LOG_TXN_COMMIT, new TxnCommit(this.id, this.lastLoggedLsn, this.getReplicatorNodeId()));
        switch (flushSyncBehavior) {
            case SYNC: {
                return logManager.logForceFlush(commitEntry, true, this.repContext);
            }
            case WRITE_NO_SYNC: {
                return logManager.logForceFlush(commitEntry, false, this.repContext);
            }
        }
        return logManager.log(commitEntry, this.repContext);
    }

    private void countWriteAbortLSN(WriteLockInfo info, Set<Long> alreadyCountedLsnSet) throws DatabaseException {
        Long longLsn;
        if (info.abortLsn != -1L && !info.abortKnownDeleted && !alreadyCountedLsnSet.contains(longLsn = Long.valueOf(info.abortLsn))) {
            this.envImpl.getLogManager().countObsoleteNode(info.abortLsn, null, info.abortLogSize, info.abortDb);
            alreadyCountedLsnSet.add(longLsn);
        }
    }

    public long abort(boolean forceFlush) throws DatabaseException {
        return this.abortInternal(forceFlush, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long abortInternal(boolean forceFlush, boolean writeAbortRecord) throws DatabaseException {
        try {
            long abortLsn;
            Txn txn = this;
            synchronized (txn) {
                this.checkState(true);
                abortLsn = -1L;
                try {
                    if (this.writeInfo != null && writeAbortRecord) {
                        SingleItemEntry abortEntry = new SingleItemEntry(LogEntryType.LOG_TXN_ABORT, new TxnAbort(this.id, this.lastLoggedLsn, this.getReplicatorNodeId()));
                        abortLsn = forceFlush ? this.envImpl.getLogManager().logForceFlush(abortEntry, true, this.repContext) : this.envImpl.getLogManager().log(abortEntry, this.repContext);
                    }
                }
                finally {
                    this.undo();
                }
            }
            this.cleanupDatabaseImpls(false);
            txn = this;
            synchronized (txn) {
                boolean openCursors = this.checkCursorsForClose();
                Tracer.trace(Level.FINE, this.envImpl, "Abort:id = " + this.id + " openCursors= " + openCursors);
                if (openCursors) {
                    throw new DatabaseException("Transaction " + this.id + " detected open cursors while aborting");
                }
                if (this.handleToHandleLockMap != null) {
                    for (Database handle : this.handleToHandleLockMap.keySet()) {
                        DbInternal.dbInvalidate(handle);
                    }
                }
                long l = abortLsn;
                return l;
            }
        }
        finally {
            this.close(false);
        }
    }

    protected void undo() throws DatabaseException {
        Long nodeId = null;
        long undoLsn = this.lastLoggedLsn;
        LogManager logManager = this.envImpl.getLogManager();
        try {
            HashSet<Long> alreadyUndone = new HashSet<Long>();
            TreeLocation location = new TreeLocation();
            while (undoLsn != -1L) {
                LNLogEntry undoEntry = (LNLogEntry)logManager.getLogEntry(undoLsn);
                LN undoLN = undoEntry.getLN();
                nodeId = undoLN.getNodeId();
                if (!alreadyUndone.contains(nodeId)) {
                    alreadyUndone.add(nodeId);
                    DatabaseId dbId = undoEntry.getDbId();
                    DatabaseImpl db = this.undoDatabases.get(dbId);
                    undoLN.postFetchInit(db, undoLsn);
                    long abortLsn = undoEntry.getAbortLsn();
                    boolean abortKnownDeleted = undoEntry.getAbortKnownDeleted();
                    RecoveryManager.undo(Level.FINER, db, location, undoLN, undoEntry.getKey(), undoEntry.getDupKey(), undoLsn, abortLsn, abortKnownDeleted, null, false);
                    if (!undoLN.isDeleted()) {
                        logManager.countObsoleteNode(undoLsn, null, undoLN.getLastLoggedSize(), db);
                    }
                }
                undoLsn = undoEntry.getUserTxn().getLastLsn();
            }
        }
        catch (RuntimeException e) {
            throw new DatabaseException("Txn undo for node=" + nodeId + " LSN=" + DbLsn.getNoFormatString(undoLsn), e);
        }
        catch (DatabaseException e) {
            Tracer.trace(this.envImpl, "Txn", "undo", "for node=" + nodeId + " LSN=" + DbLsn.getNoFormatString(undoLsn), e);
            throw e;
        }
        if (this.readLocks != null) {
            this.clearReadLocks();
        }
        this.setDeletedDatabaseState(false);
        if (this.writeInfo != null) {
            this.clearWriteLocks();
        }
        this.deleteInfo = null;
    }

    private int clearWriteLocks() throws DatabaseException {
        int numWriteLocks = this.writeInfo.size();
        for (Map.Entry<Long, WriteLockInfo> entry : this.writeInfo.entrySet()) {
            Long nodeId = entry.getKey();
            this.lockManager.release(nodeId, this);
        }
        this.writeInfo = null;
        return numWriteLocks;
    }

    private int clearReadLocks() throws DatabaseException {
        int numReadLocks = 0;
        if (this.readLocks != null) {
            numReadLocks = this.readLocks.size();
            for (Long rLockNid : this.readLocks) {
                this.lockManager.release(rLockNid, this);
            }
            this.readLocks = null;
        }
        return numReadLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogInfo(long lastLsn) throws DatabaseException {
        this.lastLoggedLsn = lastLsn;
        Txn txn = this;
        synchronized (txn) {
            if (this.firstLoggedLsn == -1L) {
                this.firstLoggedLsn = lastLsn;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getFirstActiveLsn() throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            return this.firstLoggedLsn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markDeleteAtTxnEnd(DatabaseImpl dbImpl, boolean deleteAtCommit) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            int delta = 0;
            if (this.deletedDatabases == null) {
                this.deletedDatabases = new HashSet<DatabaseCleanupInfo>();
                delta += MemoryBudget.HASHSET_OVERHEAD;
            }
            this.deletedDatabases.add(new DatabaseCleanupInfo(dbImpl, deleteAtCommit));
            this.updateMemoryUsage(delta += MemoryBudget.HASHSET_ENTRY_OVERHEAD + MemoryBudget.OBJECT_OVERHEAD);
        }
    }

    private void setDeletedDatabaseState(boolean isCommit) throws DatabaseException {
        if (this.deletedDatabases != null) {
            for (DatabaseCleanupInfo info : this.deletedDatabases) {
                if (info.deleteAtCommit != isCommit) continue;
                info.dbImpl.startDeleteProcessing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupDatabaseImpls(boolean isCommit) throws DatabaseException {
        if (this.deletedDatabases != null) {
            DatabaseCleanupInfo[] infoArray;
            Txn txn = this;
            synchronized (txn) {
                infoArray = new DatabaseCleanupInfo[this.deletedDatabases.size()];
                this.deletedDatabases.toArray(infoArray);
            }
            for (int i = 0; i < infoArray.length; ++i) {
                DatabaseCleanupInfo info = infoArray[i];
                if (info.deleteAtCommit == isCommit) {
                    info.dbImpl.finishDeleteProcessing();
                    continue;
                }
                this.envImpl.getDbTree().releaseDb(info.dbImpl);
            }
            this.deletedDatabases = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addLock(Long nodeId, LockType type, LockGrantType grantStatus) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            int delta = 0;
            if (type.isWriteLock()) {
                if (this.writeInfo == null) {
                    this.writeInfo = new HashMap<Long, WriteLockInfo>();
                    this.undoDatabases = new HashMap<DatabaseId, DatabaseImpl>();
                    delta += MemoryBudget.TWOHASHMAPS_OVERHEAD;
                }
                this.writeInfo.put(nodeId, new WriteLockInfo());
                delta += this.WRITE_LOCK_OVERHEAD;
                if (grantStatus == LockGrantType.PROMOTION || grantStatus == LockGrantType.WAIT_PROMOTION) {
                    this.readLocks.remove(nodeId);
                    delta -= this.READ_LOCK_OVERHEAD;
                }
                this.updateMemoryUsage(delta);
            } else {
                this.addReadLock(nodeId);
            }
        }
    }

    private void addReadLock(Long nodeId) {
        int delta = 0;
        if (this.readLocks == null) {
            this.readLocks = new HashSet<Long>();
            delta = MemoryBudget.HASHSET_OVERHEAD;
        }
        this.readLocks.add(nodeId);
        this.updateMemoryUsage(delta += this.READ_LOCK_OVERHEAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void removeLock(long nodeId) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            if (this.readLocks != null && this.readLocks.remove(nodeId)) {
                this.updateMemoryUsage(0 - this.READ_LOCK_OVERHEAD);
            } else if (this.writeInfo != null && this.writeInfo.remove(nodeId) != null) {
                this.updateMemoryUsage(0 - this.WRITE_LOCK_OVERHEAD);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void moveWriteToReadLock(long nodeId, Lock lock) {
        boolean found = false;
        Txn txn = this;
        synchronized (txn) {
            if (this.writeInfo != null && this.writeInfo.remove(nodeId) != null) {
                found = true;
                this.updateMemoryUsage(0 - this.WRITE_LOCK_OVERHEAD);
            }
            assert (found) : "Couldn't find lock for Node " + nodeId + " in writeInfo Map.";
            this.addReadLock(nodeId);
        }
    }

    private void updateMemoryUsage(int delta) {
        this.inMemorySize += delta;
        this.accumulatedDelta += delta;
        if (this.accumulatedDelta > ACCUMULATED_LIMIT || this.accumulatedDelta < -ACCUMULATED_LIMIT) {
            this.envImpl.getMemoryBudget().updateTxnMemoryUsage(this.accumulatedDelta);
            this.accumulatedDelta = 0;
        }
    }

    int getBudgetedMemorySize() {
        return this.inMemorySize - this.accumulatedDelta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createdNode(long nodeId) throws DatabaseException {
        boolean created = false;
        Txn txn = this;
        synchronized (txn) {
            WriteLockInfo info;
            if (this.writeInfo != null && (info = this.writeInfo.get(nodeId)) != null) {
                created = info.createdThisTxn;
            }
        }
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAbortLsn(long nodeId) throws DatabaseException {
        WriteLockInfo info = null;
        Txn txn = this;
        synchronized (txn) {
            if (this.writeInfo != null) {
                info = this.writeInfo.get(nodeId);
            }
        }
        if (info == null) {
            return -1L;
        }
        return info.abortLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteLockInfo getWriteLockInfo(long nodeId) throws DatabaseException {
        WriteLockInfo wli = null;
        Txn txn = this;
        synchronized (txn) {
            if (this.writeInfo != null) {
                wli = this.writeInfo.get(nodeId);
            }
        }
        if (wli == null) {
            throw new UnsupportedOperationException("writeInfo is null in Txn.getWriteLockInfo");
        }
        return wli;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public boolean isAutoTxn() {
        return this.isAutoCommit;
    }

    @Override
    public boolean isSerializableIsolation() {
        return this.serializableIsolation;
    }

    @Override
    public boolean isReadCommittedIsolation() {
        return this.readCommittedIsolation;
    }

    public boolean getExplicitSyncConfigured() {
        return this.explicitSyncConfigured;
    }

    public boolean getExplicitDurabilityConfigured() {
        return this.explicitDurabilityConfigured;
    }

    @Override
    public Txn getTxnLocker() {
        return this;
    }

    @Override
    public Locker newNonTxnLocker() throws DatabaseException {
        return this;
    }

    @Override
    public void releaseNonTxnLocks() throws DatabaseException {
    }

    @Override
    public void nonTxnOperationEnd() throws DatabaseException {
    }

    @Override
    public void operationEnd(boolean operationOK) throws DatabaseException {
        if (!this.isAutoCommit) {
            return;
        }
        if (operationOK) {
            this.commit();
        } else {
            this.abort(false);
        }
    }

    @Override
    public void setHandleLockOwner(boolean operationOK, Database dbHandle, boolean dbIsClosing) throws DatabaseException {
        if (this.isAutoCommit) {
            if (operationOK) {
                if (!dbIsClosing) {
                    this.transferHandleLockToHandle(dbHandle);
                }
                this.unregisterHandle(dbHandle);
            }
            return;
        }
        if (dbIsClosing) {
            Long handleLockId = (Long)this.handleToHandleLockMap.get(dbHandle);
            if (handleLockId != null) {
                Set dbHandleSet = (Set)this.handleLockToHandleMap.get(handleLockId);
                boolean removed = dbHandleSet.remove(dbHandle);
                assert (removed) : "Can't find " + dbHandle + " from dbHandleSet";
                if (dbHandleSet.size() == 0) {
                    Object foo = this.handleLockToHandleMap.remove(handleLockId);
                    assert (foo != null) : "Can't find " + handleLockId + " from handleLockIdtoHandleMap.";
                }
            }
            this.unregisterHandle(dbHandle);
        } else if (dbHandle != null) {
            DbInternal.dbSetHandleLocker(dbHandle, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCursor(CursorImpl cursor) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            cursor.setLockerNext(this.cursorSet);
            if (this.cursorSet != null) {
                this.cursorSet.setLockerPrev(cursor);
            }
            this.cursorSet = cursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegisterCursor(CursorImpl cursor) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            CursorImpl prev = cursor.getLockerPrev();
            CursorImpl next = cursor.getLockerNext();
            if (prev == null) {
                this.cursorSet = next;
            } else {
                prev.setLockerNext(next);
            }
            if (next != null) {
                next.setLockerPrev(prev);
            }
            cursor.setLockerPrev(null);
            cursor.setLockerNext(null);
        }
    }

    @Override
    public boolean isHandleLockTransferrable() {
        return false;
    }

    private boolean checkCursorsForClose() throws DatabaseException {
        for (CursorImpl c = this.cursorSet; c != null; c = c.getLockerNext()) {
            if (c.isClosed()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockStats collectStats(LockStats stats) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            int nReadLocks = this.readLocks == null ? 0 : this.readLocks.size();
            stats.setNReadLocks(stats.getNReadLocks() + nReadLocks);
            int nWriteLocks = this.writeInfo == null ? 0 : this.writeInfo.size();
            stats.setNWriteLocks(stats.getNWriteLocks() + nWriteLocks);
            stats.accumulateNTotalLocks(nReadLocks + nWriteLocks);
        }
        return stats;
    }

    @Override
    public void setOnlyAbortable() {
        this.txnState = (byte)(this.txnState & 0xFFFFFFFC);
        this.txnState = (byte)(this.txnState | 2);
    }

    public boolean getOnlyAbortable() {
        return (this.txnState & 2) != 0;
    }

    @Override
    protected void checkState(boolean calledByAbort) throws DatabaseException {
        boolean ok = false;
        boolean onlyAbortable = false;
        byte state = (byte)(this.txnState & 3);
        ok = state == 0;
        boolean bl = onlyAbortable = state == 2;
        if (!calledByAbort && onlyAbortable) {
            throw new IllegalStateException("Transaction " + this.id + " must be aborted.");
        }
        if (ok || calledByAbort && onlyAbortable) {
            return;
        }
        throw new IllegalStateException("Transaction " + this.id + " has been closed.");
    }

    public void setRepContext(ReplicationContext repContext) {
        this.repContext = repContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean isCommit) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            this.txnState = (byte)(this.txnState & 0xFFFFFFFC);
            this.txnState = (byte)(this.txnState | 1);
        }
        this.envImpl.getTxnManager().unRegisterTxn(this, isCommit);
        this.close();
    }

    public boolean isClosed() {
        return (this.txnState & 1) != 0;
    }

    protected int getReplicatorNodeId() {
        return 0;
    }

    @Override
    public int getLogSize() {
        return LogUtils.getPackedLongLogSize(this.id) + LogUtils.getPackedLongLogSize(this.lastLoggedLsn);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writePackedLong(logBuffer, this.id);
        LogUtils.writePackedLong(logBuffer, this.lastLoggedLsn);
    }

    @Override
    public void readFromLog(ByteBuffer logBuffer, byte entryVersion) {
        this.id = LogUtils.readLong(logBuffer, entryVersion < 6);
        this.lastLoggedLsn = LogUtils.readLong(logBuffer, entryVersion < 6);
    }

    @Override
    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<txn id=\"");
        sb.append(this.getId());
        sb.append("\">");
        sb.append(DbLsn.toString(this.lastLoggedLsn));
        sb.append("</txn>");
    }

    @Override
    public long getTransactionId() {
        return this.getId();
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof Txn)) {
            return false;
        }
        return this.id == ((Txn)other).id;
    }

    private void transferHandleLockToHandleSet(Long handleLockId, Set<Database> dbHandleSet) throws DatabaseException {
        int numHandles = dbHandleSet.size();
        Database[] dbHandles = new Database[numHandles];
        dbHandles = dbHandleSet.toArray(dbHandles);
        Locker[] destTxns = new Locker[numHandles];
        for (int i = 0; i < numHandles; ++i) {
            destTxns[i] = BasicLocker.createBasicLocker(this.envImpl);
        }
        long nodeId = handleLockId;
        this.lockManager.transferMultiple(nodeId, this, destTxns);
        for (int i = 0; i < numHandles; ++i) {
            destTxns[i].addToHandleMaps(handleLockId, dbHandles[i]);
            DbInternal.dbSetHandleLocker(dbHandles[i], destTxns[i]);
        }
    }

    private void traceCommit(int numWriteLocks, int numReadLocks) {
        Logger logger = this.envImpl.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer();
            sb.append(" Commit:id = ").append(this.id);
            sb.append(" numWriteLocks=").append(numWriteLocks);
            sb.append(" numReadLocks = ").append(numReadLocks);
            Tracer.trace(Level.FINE, this.envImpl, sb.toString());
        }
    }

    protected void txnBeginHook(TransactionConfig config) throws DatabaseException {
    }

    protected void preLogCommitHook() throws DatabaseException {
    }

    protected void postLogCommitHook() throws DatabaseException {
    }

    protected void postLogAbortHook() {
    }

    private static class DatabaseCleanupInfo {
        DatabaseImpl dbImpl;
        boolean deleteAtCommit;

        DatabaseCleanupInfo(DatabaseImpl dbImpl, boolean deleteAtCommit) {
            this.dbImpl = dbImpl;
            this.deleteAtCommit = deleteAtCommit;
        }
    }
}

