/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;

public class BuddyLocker
extends BasicLocker {
    private Locker buddy;

    protected BuddyLocker(EnvironmentImpl env, Locker buddy) throws DatabaseException {
        super(env);
        this.buddy = buddy;
    }

    public static BuddyLocker createBuddyLocker(EnvironmentImpl env, Locker buddy) throws DatabaseException {
        BasicLocker ret = null;
        try {
            ret = new BuddyLocker(env, buddy);
            ret.initApiReadLock();
        }
        catch (DatabaseException DE) {
            ret.operationEnd(false);
            throw DE;
        }
        return ret;
    }

    Locker getBuddy() {
        return this.buddy;
    }

    @Override
    public Txn getTxnLocker() {
        return this.buddy.getTxnLocker();
    }

    @Override
    public void releaseNonTxnLocks() throws DatabaseException {
        super.releaseNonTxnLocks();
        this.buddy.releaseNonTxnLocks();
    }

    @Override
    public boolean sharesLocksWith(Locker other) {
        if (super.sharesLocksWith(other)) {
            return true;
        }
        return this.buddy == other;
    }

    @Override
    public long getLockTimeout() {
        return this.buddy.getLockTimeout();
    }

    @Override
    public long getTxnTimeout() {
        return this.buddy.getTxnTimeout();
    }

    @Override
    public void setLockTimeout(long timeout) {
        this.buddy.setLockTimeout(timeout);
    }

    @Override
    public void setTxnTimeout(long timeout) {
        this.buddy.setTxnTimeout(timeout);
    }

    @Override
    public boolean isTimedOut() throws DatabaseException {
        return this.buddy.isTimedOut();
    }
}

