/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public class DeltaInfo
implements Loggable {
    private byte[] key;
    private long lsn;
    private byte state;

    DeltaInfo(byte[] key, long lsn, byte state) {
        this.key = key;
        this.lsn = lsn;
        this.state = state;
    }

    DeltaInfo() {
        this.lsn = -1L;
    }

    @Override
    public int getLogSize() {
        return LogUtils.getByteArrayLogSize(this.key) + LogUtils.getPackedLongLogSize(this.lsn) + 1;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeByteArray(logBuffer, this.key);
        LogUtils.writePackedLong(logBuffer, this.lsn);
        logBuffer.put(this.state);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, byte entryVersion) throws LogException {
        boolean unpacked = entryVersion < 6;
        this.key = LogUtils.readByteArray(itemBuffer, unpacked);
        this.lsn = LogUtils.readLong(itemBuffer, unpacked);
        this.state = itemBuffer.get();
    }

    @Override
    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append(Key.dumpString(this.key, 0));
        sb.append(DbLsn.toString(this.lsn));
        IN.dumpDeletedState(sb, this.state);
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    byte[] getKey() {
        return this.key;
    }

    byte getState() {
        return this.state;
    }

    boolean isKnownDeleted() {
        return IN.isStateKnownDeleted(this.state);
    }

    long getLsn() {
        return this.lsn;
    }
}

