/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.DBINReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import java.nio.ByteBuffer;
import java.util.Comparator;

public final class DBIN
extends BIN
implements Loggable {
    private static final String BEGIN_TAG = "<dbin>";
    private static final String END_TAG = "</dbin>";
    private byte[] dupKey;

    public DBIN() {
    }

    public DBIN(DatabaseImpl db, byte[] identifierKey, int maxEntriesPerNode, byte[] dupKey, int level) {
        super(db, identifierKey, maxEntriesPerNode, level);
        this.dupKey = dupKey;
    }

    @Override
    protected IN createNewInstance(byte[] identifierKey, int maxEntries, int level) {
        return new DBIN(this.getDatabase(), identifierKey, maxEntries, this.dupKey, level);
    }

    @Override
    boolean isAlwaysLatchedExclusively() {
        return true;
    }

    @Override
    protected int generateLevel(DatabaseId dbId, int newLevel) {
        return newLevel;
    }

    @Override
    public final Comparator<byte[]> getKeyComparator() {
        return this.getDatabase().getDuplicateComparator();
    }

    @Override
    public byte[] getDupKey() {
        return this.dupKey;
    }

    @Override
    public byte[] getChildKey(IN child) throws DatabaseException {
        return child.getIdentifierKey();
    }

    @Override
    public byte[] selectKey(byte[] mainTreeKey, byte[] dupTreeKey) {
        return dupTreeKey;
    }

    @Override
    public byte[] getDupTreeKey() {
        return this.getIdentifierKey();
    }

    @Override
    public byte[] getMainTreeKey() {
        return this.dupKey;
    }

    @Override
    public boolean containsDuplicates() {
        return true;
    }

    @Override
    LogEntryType getBINDeltaType() {
        return LogEntryType.LOG_DUP_BIN_DELTA;
    }

    @Override
    public BINReference createReference() {
        return new DBINReference(this.getNodeId(), this.getDatabase().getId(), this.getIdentifierKey(), this.dupKey);
    }

    @Override
    protected long computeMemorySize() {
        long size = super.computeMemorySize();
        return size;
    }

    public static long computeOverhead(DbConfigManager configManager) throws DatabaseException {
        return (long)MemoryBudget.DBIN_FIXED_OVERHEAD + IN.computeArraysOverhead(configManager);
    }

    @Override
    protected long getMemoryOverhead(MemoryBudget mb) {
        return mb.getDBINOverhead();
    }

    @Override
    protected boolean canBeAncestor(boolean targetContainsDuplicates) {
        return false;
    }

    @Override
    boolean hasPinnedChildren() {
        return false;
    }

    @Override
    BIN getCursorBIN(CursorImpl cursor) {
        return cursor.getDupBIN();
    }

    @Override
    BIN getCursorBINToBeRemoved(CursorImpl cursor) {
        return cursor.getDupBINToBeRemoved();
    }

    @Override
    int getCursorIndex(CursorImpl cursor) {
        return cursor.getDupIndex();
    }

    @Override
    void setCursorBIN(CursorImpl cursor, BIN bin) {
        cursor.setDupBIN((DBIN)bin);
    }

    @Override
    void setCursorIndex(CursorImpl cursor, int index) {
        cursor.setDupIndex(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean matchLNByNodeId(TreeLocation location, long nodeId, CacheMode cacheMode) throws DatabaseException {
        this.latch();
        try {
            for (int i = 0; i < this.getNEntries(); ++i) {
                LN ln = (LN)this.fetchTarget(i);
                if (ln == null || ln.getNodeId() != nodeId) continue;
                location.bin = this;
                location.index = i;
                location.lnKey = this.getKey(i);
                location.childLsn = this.getLsn(i);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseLatch();
        }
    }

    @Override
    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processDBIN(this, this.getNodeId(), this.getLevel());
    }

    @Override
    public String beginTag() {
        return BEGIN_TAG;
    }

    @Override
    public String endTag() {
        return END_TAG;
    }

    @Override
    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append(this.beginTag());
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<dupkey>");
        sb.append(this.dupKey == null ? "" : Key.dumpString(this.dupKey, 0));
        sb.append("</dupkey>");
        sb.append('\n');
        sb.append(super.dumpString(nSpaces, false));
        sb.append(TreeUtils.indent(nSpaces));
        sb.append(this.endTag());
        return sb.toString();
    }

    @Override
    public LogEntryType getLogType() {
        return LogEntryType.LOG_DBIN;
    }

    @Override
    public int getLogSize() {
        int size = super.getLogSize();
        return size += LogUtils.getByteArrayLogSize(this.dupKey);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        LogUtils.writeByteArray(logBuffer, this.dupKey);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, byte entryVersion) throws LogException {
        super.readFromLog(itemBuffer, entryVersion);
        this.dupKey = LogUtils.readByteArray(itemBuffer, entryVersion < 6);
    }

    @Override
    protected void dumpLogAdditional(StringBuffer sb) {
        super.dumpLogAdditional(sb);
        sb.append(Key.dumpString(this.dupKey, 0));
    }

    @Override
    public String shortClassName() {
        return "DBIN";
    }
}

