/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.LogContext;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogManager;
import java.io.IOException;
import java.util.List;

public class SyncedLogManager
extends LogManager {
    public SyncedLogManager(EnvironmentImpl envImpl, boolean readOnly) throws DatabaseException {
        super(envImpl, readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void serialLog(LogItem[] itemArray, LogContext context) throws IOException, DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.serialLogInternal(itemArray, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushInternal() throws LogException, DatabaseException {
        try {
            Latch latch = this.logWriteLatch;
            synchronized (latch) {
                this.logBufferPool.writeBufferToFile(0);
            }
        }
        catch (IOException e) {
            throw new LogException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrackedFileSummary getUnflushableTrackedSummary(long file) throws DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            return this.getUnflushableTrackedSummaryInternal(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTrackedFile(TrackedFileSummary tfs) throws DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.removeTrackedFileInternal(tfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void countObsoleteNode(long lsn, LogEntryType type, int size, DatabaseImpl nodeDb) throws DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.countObsoleteNodeInternal(lsn, type, size, nodeDb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferToUtilizationTracker(LocalUtilizationTracker localTracker) throws DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.transferToUtilizationTrackerInternal(localTracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void countObsoleteINs(List<Long> lsnList, DatabaseImpl nodeDb) throws DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.countObsoleteINsInternal(lsnList, nodeDb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void countObsoleteDb(DatabaseImpl db) throws DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.countObsoleteDbInternal(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDbFileSummary(DatabaseImpl db, Long fileNum) throws DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            return this.removeDbFileSummaryInternal(db, fileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadEndOfLogStat(EnvironmentStats stats) throws DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.loadEndOfLogStatInternal(stats);
        }
    }
}

