/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogSource;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

class FileSource
implements LogSource {
    private RandomAccessFile file;
    private int readBufferSize;
    private FileManager fileManager;
    private long fileNum;

    FileSource(RandomAccessFile file, int readBufferSize, FileManager fileManager, long fileNum) {
        this.file = file;
        this.readBufferSize = readBufferSize;
        this.fileManager = fileManager;
        this.fileNum = fileNum;
    }

    @Override
    public void release() throws DatabaseException {
    }

    @Override
    public ByteBuffer getBytes(long fileOffset) throws DatabaseException, IOException {
        ByteBuffer destBuf = ByteBuffer.allocate(this.readBufferSize);
        this.fileManager.readFromFile(this.file, destBuf, fileOffset, this.fileNum);
        assert (EnvironmentImpl.maybeForceYield());
        destBuf.flip();
        return destBuf;
    }

    @Override
    public ByteBuffer getBytes(long fileOffset, int numBytes) throws DatabaseException, IOException {
        ByteBuffer destBuf = ByteBuffer.allocate(numBytes);
        this.fileManager.readFromFile(this.file, destBuf, fileOffset, this.fileNum);
        assert (EnvironmentImpl.maybeForceYield());
        destBuf.flip();
        assert (destBuf.remaining() >= numBytes) : "remaining=" + destBuf.remaining() + " numBytes=" + numBytes;
        return destBuf;
    }
}

