/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CheckpointFileReader
extends FileReader {
    private boolean isRoot;
    private boolean isCheckpointEnd;
    private boolean isCheckpointStart;

    public CheckpointFileReader(EnvironmentImpl env, int readBufferSize, boolean forward, long startLsn, long finishLsn, long endOfFileLsn) throws IOException, DatabaseException {
        super(env, readBufferSize, forward, startLsn, null, endOfFileLsn, finishLsn);
    }

    @Override
    protected boolean isTargetEntry() {
        byte logEntryTypeNumber = this.currentEntryHeader.getType();
        boolean isTarget = false;
        this.isRoot = false;
        this.isCheckpointEnd = false;
        this.isCheckpointStart = false;
        if (LogEntryType.LOG_CKPT_END.equalsType(logEntryTypeNumber)) {
            isTarget = true;
            this.isCheckpointEnd = true;
        } else if (LogEntryType.LOG_CKPT_START.equalsType(logEntryTypeNumber)) {
            isTarget = true;
            this.isCheckpointStart = true;
        } else if (LogEntryType.LOG_ROOT.equalsType(logEntryTypeNumber)) {
            isTarget = true;
            this.isRoot = true;
        }
        return isTarget;
    }

    @Override
    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        return true;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isCheckpointEnd() {
        return this.isCheckpointEnd;
    }

    public boolean isCheckpointStart() {
        return this.isCheckpointStart;
    }
}

