/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.BtreeStats;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.LockNotGrantedException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.PreloadStatus;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.cleaner.BaseUtilizationTracker;
import com.sleepycat.je.cleaner.DbFileSummary;
import com.sleepycat.je.cleaner.DbFileSummaryMap;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.ReplicatedDatabaseConfig;
import com.sleepycat.je.dbi.SortedLSNTreeWalker;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.DbOpReplicationContext;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogFileNotFoundException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.DbOperationType;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.CmdUtil;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class DatabaseImpl
implements Loggable,
Cloneable {
    private static final short NOT_DELETED = 1;
    private static final short DELETED_CLEANUP_INLIST_HARVEST = 2;
    private static final short DELETED_CLEANUP_LOG_HARVEST = 3;
    private static final short DELETED = 4;
    private byte flags;
    private static final byte DUPS_ALLOWED_BIT = 1;
    private static final byte TEMPORARY_BIT = 2;
    private static final byte IS_REPLICATED_BIT = 4;
    private static final byte NOT_REPLICATED_BIT = 8;
    private static final byte PREFIXING_ENABLED = 16;
    private static final byte UTILIZATION_REPAIR_DONE = 32;
    private DatabaseId id;
    private Tree tree;
    private EnvironmentImpl envImpl;
    private boolean transactional;
    private boolean durableDeferredWrite;
    private boolean dirtyUtilization;
    private Set<Database> referringHandles;
    private BtreeStats stats;
    private long eofNodeId;
    private volatile short deleteState;
    private AtomicInteger useCount = new AtomicInteger();
    private DbFileSummaryMap dbFileSummaries;
    private byte createdAtLogVersion;
    public static boolean forceTreeWalkForTruncateAndRemove;
    private Comparator<byte[]> btreeComparator = null;
    private Comparator<byte[]> duplicateComparator = null;
    private byte[] btreeComparatorBytes = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
    private byte[] duplicateComparatorBytes = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
    private boolean btreeComparatorByClassName = false;
    private boolean duplicateComparatorByClassName = false;
    private int binDeltaPercent;
    private int binMaxDeltas;
    private int maxMainTreeEntriesPerNode;
    private int maxDupTreeEntriesPerNode;
    private String debugDatabaseName;
    private TestHook pendingDeletedHook;
    private static final boolean forceKeyPrefixing;
    private static final HaltPreloadException TIME_EXCEEDED_PRELOAD_EXCEPTION;
    private static final HaltPreloadException MEMORY_EXCEEDED_PRELOAD_EXCEPTION;

    public DatabaseImpl(String dbName, DatabaseId id, EnvironmentImpl envImpl, DatabaseConfig dbConfig) throws DatabaseException {
        this.id = id;
        this.envImpl = envImpl;
        this.setBtreeComparator(dbConfig.getBtreeComparator(), dbConfig.getBtreeComparatorByClassName());
        this.setDuplicateComparator(dbConfig.getDuplicateComparator(), dbConfig.getDuplicateComparatorByClassName());
        if (dbConfig.getSortedDuplicates()) {
            this.setSortedDuplicates();
        }
        if (dbConfig.getKeyPrefixing() || forceKeyPrefixing) {
            this.setKeyPrefixing();
        }
        if (dbConfig.getTemporary()) {
            this.setTemporary();
        }
        if (envImpl.isReplicated()) {
            if (DbInternal.getDbConfigReplicated(dbConfig)) {
                this.setIsReplicatedBit();
            } else {
                this.setNotReplicatedBit();
            }
        }
        this.transactional = dbConfig.getTransactional();
        this.durableDeferredWrite = dbConfig.getDeferredWrite();
        this.maxMainTreeEntriesPerNode = dbConfig.getNodeMaxEntries();
        this.maxDupTreeEntriesPerNode = dbConfig.getNodeMaxDupTreeEntries();
        this.createdAtLogVersion = (byte)6;
        this.setUtilizationRepairDone();
        this.commonInit();
        this.initWithEnvironment();
        this.tree = new Tree(this);
        this.debugDatabaseName = dbName;
    }

    public DatabaseImpl() throws DatabaseException {
        this.id = new DatabaseId();
        this.envImpl = null;
        this.tree = new Tree();
        this.commonInit();
    }

    private void commonInit() {
        this.deleteState = 1;
        this.referringHandles = Collections.synchronizedSet(new HashSet());
        this.dbFileSummaries = new DbFileSummaryMap(false);
    }

    public void setDebugDatabaseName(String debugName) {
        this.debugDatabaseName = debugName;
    }

    public String getDebugName() {
        return this.debugDatabaseName;
    }

    public void setPendingDeletedHook(TestHook hook) {
        this.pendingDeletedHook = hook;
    }

    private void initWithEnvironment() throws DatabaseException {
        this.eofNodeId = this.envImpl.getNodeSequence().getNextTransientNodeId();
        assert (!this.replicatedBitSet() || !this.notReplicatedBitSet()) : "The replicated AND notReplicated bits should never be set  together";
        DbConfigManager configMgr = this.envImpl.getConfigManager();
        this.binDeltaPercent = configMgr.getInt(EnvironmentParams.BIN_DELTA_PERCENT);
        this.binMaxDeltas = configMgr.getInt(EnvironmentParams.BIN_MAX_DELTAS);
        if (this.maxMainTreeEntriesPerNode == 0) {
            this.maxMainTreeEntriesPerNode = configMgr.getInt(EnvironmentParams.NODE_MAX);
        }
        if (this.maxDupTreeEntriesPerNode == 0) {
            this.maxDupTreeEntriesPerNode = configMgr.getInt(EnvironmentParams.NODE_MAX_DUPTREE);
        }
        this.dbFileSummaries.init(this.envImpl);
        if (!this.getUtilizationRepairDone()) {
            this.dbFileSummaries.repair(this.envImpl);
            this.setDirtyUtilization();
            this.setUtilizationRepairDone();
        }
    }

    public DatabaseImpl cloneDatabase() {
        DatabaseImpl newDb;
        try {
            newDb = (DatabaseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false) : e;
            return null;
        }
        newDb.id = null;
        newDb.tree = null;
        newDb.createdAtLogVersion = (byte)6;
        newDb.dbFileSummaries = new DbFileSummaryMap(false);
        newDb.dbFileSummaries.init(this.envImpl);
        newDb.useCount = new AtomicInteger();
        return newDb;
    }

    public Tree getTree() {
        return this.tree;
    }

    void setTree(Tree tree) {
        this.tree = tree;
    }

    public DatabaseId getId() {
        return this.id;
    }

    void setId(DatabaseId id) {
        this.id = id;
    }

    public long getEofNodeId() {
        return this.eofNodeId;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean isTemporary() {
        return (this.flags & 2) != 0;
    }

    public static boolean isTemporary(byte flagVal) {
        return (flagVal & 2) != 0;
    }

    private void setTemporary() {
        this.flags = (byte)(this.flags | 2);
    }

    public boolean isDurableDeferredWrite() {
        return this.durableDeferredWrite;
    }

    public boolean isDeferredWriteMode() {
        return this.isDurableDeferredWrite() || this.isTemporary();
    }

    public void setDeferredWrite(boolean durableDeferredWrite) {
        this.durableDeferredWrite = durableDeferredWrite;
    }

    public boolean getSortedDuplicates() {
        return (this.flags & 1) != 0;
    }

    public static boolean getSortedDuplicates(byte flagVal) {
        return (flagVal & 1) != 0;
    }

    public void setSortedDuplicates() {
        this.flags = (byte)(this.flags | 1);
    }

    public boolean getKeyPrefixing() {
        return (this.flags & 0x10) != 0;
    }

    public void setKeyPrefixing() {
        this.flags = (byte)(this.flags | 0x10);
    }

    public void clearKeyPrefixing() {
        if (forceKeyPrefixing) {
            return;
        }
        this.flags = (byte)(this.flags & 0xFFFFFFEF);
    }

    public boolean isReplicated() {
        return this.replicatedBitSet();
    }

    public boolean unknownReplicated() {
        return (this.flags & 4) == 0 && (this.flags & 8) == 0;
    }

    private boolean replicatedBitSet() {
        return (this.flags & 4) != 0;
    }

    private void setIsReplicatedBit() {
        this.flags = (byte)(this.flags | 4);
    }

    private boolean notReplicatedBitSet() {
        return (this.flags & 8) != 0;
    }

    private void setNotReplicatedBit() {
        this.flags = (byte)(this.flags | 8);
    }

    public boolean getUtilizationRepairDone() {
        return (this.flags & 0x20) != 0;
    }

    private void setUtilizationRepairDone() {
        this.flags = (byte)(this.flags | 0x20);
    }

    public void clearUtilizationRepairDone() {
        this.flags = (byte)(this.flags & 0xFFFFFFDF);
    }

    public int getNodeMaxEntries() {
        return this.maxMainTreeEntriesPerNode;
    }

    public int getNodeMaxDupTreeEntries() {
        return this.maxDupTreeEntriesPerNode;
    }

    public int getAdditionalTreeMemorySize() {
        int val = 0;
        if (this.btreeComparator != null) {
            val += 2 * MemoryBudget.byteArraySize(this.btreeComparatorBytes.length);
        }
        if (this.duplicateComparator != null) {
            val += 2 * MemoryBudget.byteArraySize(this.duplicateComparatorBytes.length);
        }
        return val;
    }

    public boolean setDuplicateComparator(Comparator<byte[]> comparator, boolean byClassName) throws DatabaseException {
        this.duplicateComparator = comparator;
        byte[] newDuplicateComparatorBytes = DatabaseImpl.comparatorToBytes(comparator, byClassName, "Duplicate");
        boolean ret = Arrays.equals(newDuplicateComparatorBytes, this.duplicateComparatorBytes);
        this.duplicateComparatorBytes = newDuplicateComparatorBytes;
        this.duplicateComparatorByClassName = byClassName;
        return !ret;
    }

    public boolean setBtreeComparator(Comparator<byte[]> comparator, boolean byClassName) throws DatabaseException {
        this.btreeComparator = comparator;
        byte[] newBtreeComparatorBytes = DatabaseImpl.comparatorToBytes(comparator, byClassName, "Btree");
        boolean ret = Arrays.equals(newBtreeComparatorBytes, this.btreeComparatorBytes);
        this.btreeComparatorBytes = newBtreeComparatorBytes;
        this.btreeComparatorByClassName = byClassName;
        return !ret;
    }

    public Comparator<byte[]> getBtreeComparator() {
        return this.btreeComparator;
    }

    public Comparator<byte[]> getDuplicateComparator() {
        return this.duplicateComparator;
    }

    public boolean getBtreeComparatorByClass() {
        return this.btreeComparatorByClassName;
    }

    public boolean getDuplicateComparatorByClass() {
        return this.duplicateComparatorByClassName;
    }

    public void setEnvironmentImpl(EnvironmentImpl envImpl) throws DatabaseException {
        this.envImpl = envImpl;
        this.initWithEnvironment();
        this.tree.setDatabase(this);
    }

    public EnvironmentImpl getDbEnvironment() {
        return this.envImpl;
    }

    public boolean hasOpenHandles() {
        return this.referringHandles.size() > 0;
    }

    public void addReferringHandle(Database db) {
        this.referringHandles.add(db);
    }

    public void removeReferringHandle(Database db) {
        this.referringHandles.remove(db);
    }

    public void handleClosed(boolean doSyncDw) throws DatabaseException {
        if (this.referringHandles.isEmpty()) {
            if (this.isTemporary()) {
                BasicLocker locker = BasicLocker.createBasicLocker(this.envImpl, true);
                boolean operationOk = false;
                try {
                    this.envImpl.getDbTree().dbRemove(locker, this.getName(), this.getId());
                    operationOk = true;
                }
                catch (LockNotGrantedException lockNotGrantedException) {
                }
                catch (Error E) {
                    this.envImpl.invalidate(E);
                    throw E;
                }
                finally {
                    ((Locker)locker).operationEnd(operationOk);
                }
            }
            if (doSyncDw && this.isDurableDeferredWrite()) {
                this.sync(true);
            }
        }
    }

    public long getTreeAdminMemory() {
        return this.dbFileSummaries.getMemorySize();
    }

    public void releaseTreeAdminMemory() {
        this.dbFileSummaries.subtractFromMemoryBudget();
    }

    synchronized int getReferringHandleCount() {
        return this.referringHandles.size();
    }

    void incrementUseCount() {
        this.useCount.incrementAndGet();
    }

    void decrementUseCount() {
        assert (this.useCount.get() > 0);
        this.useCount.decrementAndGet();
    }

    public boolean isInUse() {
        return this.useCount.get() > 0;
    }

    boolean isInUseDuringDbRemove() {
        return this.useCount.get() > 1 + this.referringHandles.size();
    }

    public synchronized void sync(boolean flushLog) throws DatabaseException {
        if (!this.isDurableDeferredWrite()) {
            throw new UnsupportedOperationException("Database.sync() is only supported for deferred-write databases");
        }
        if (this.tree.rootExists()) {
            Checkpointer.syncDatabase(this.envImpl, this, flushLog);
        }
    }

    public Database findPrimaryDatabase() throws DatabaseException {
        for (Database obj : this.referringHandles) {
            if (!(obj instanceof SecondaryDatabase)) continue;
            return ((SecondaryDatabase)obj).getPrimaryDatabase();
        }
        return null;
    }

    public String getName() throws DatabaseException {
        return this.envImpl.getDbTree().getDbName(this.id);
    }

    public DbFileSummary getDbFileSummary(Long fileNum, boolean willModify) {
        if (willModify) {
            this.dirtyUtilization = true;
        }
        assert (this.dbFileSummaries != null);
        return this.dbFileSummaries.get(fileNum, true, true, this.envImpl.getFileManager());
    }

    public boolean removeDbFileSummary(Long fileNum) {
        assert (this.dbFileSummaries != null);
        boolean removed = this.dbFileSummaries.remove(fileNum);
        return removed;
    }

    public DbFileSummaryMap getDbFileSummaries() {
        return this.dbFileSummaries;
    }

    public boolean isDirtyUtilization() {
        return this.dirtyUtilization;
    }

    public void setDirtyUtilization() {
        this.dirtyUtilization = true;
    }

    public boolean isCheckpointNeeded() {
        return !this.isDeleted() && (this.isDirtyUtilization() || this.isTemporary());
    }

    public boolean isDeleted() {
        return this.deleteState != 1;
    }

    public boolean isDeleteFinished() {
        return this.deleteState == 4;
    }

    public void startDeleteProcessing() {
        assert (this.deleteState == 1);
        this.deleteState = (short)2;
    }

    void finishedINListHarvest() {
        assert (this.deleteState == 2);
        this.deleteState = (short)3;
    }

    public void startAndFinishDelete() throws DatabaseException {
        this.startDeleteProcessing();
        this.finishDeleteProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishDeleteProcessing() throws DatabaseException {
        assert (TestHookExecute.doHookIfSet(this.pendingDeletedHook));
        try {
            if (this.dbFileSummaries == null) assert (false);
            long rootLsn = this.tree.getRootLsn();
            IN rootIN = this.tree.getResidentRootIN(false);
            this.envImpl.getDbTree().deleteMapLN(this.id);
            if (this.createdAtLogVersion >= 6 && !forceTreeWalkForTruncateAndRemove) {
                this.envImpl.getLogManager().countObsoleteDb(this);
            } else {
                LocalUtilizationTracker localTracker = new LocalUtilizationTracker(this.envImpl);
                if (rootLsn != -1L) {
                    localTracker.countObsoleteNodeInexact(rootLsn, LogEntryType.LOG_IN, 0, this);
                }
                boolean fetchLNSize = this.envImpl.getCleaner().getFetchObsoleteSize();
                ObsoleteProcessor obsoleteProcessor = new ObsoleteProcessor(this, localTracker);
                ObsoleteTreeWalker walker = new ObsoleteTreeWalker(this, rootLsn, fetchLNSize, (SortedLSNTreeWalker.TreeNodeProcessor)obsoleteProcessor, rootIN);
                walker.walk();
                this.envImpl.getUtilizationProfile().flushLocalTracker(localTracker);
            }
            MemoryBudget mb = this.envImpl.getMemoryBudget();
            INList inList = this.envImpl.getInMemoryINs();
            long memoryChange = 0L;
            try {
                Iterator<IN> iter = inList.iterator();
                while (iter.hasNext()) {
                    IN thisIN = iter.next();
                    if (thisIN.getDatabase() != this) continue;
                    iter.remove();
                    memoryChange += 0L - thisIN.getBudgetedMemorySize();
                    thisIN.setInListResident(false);
                }
            }
            finally {
                mb.updateTreeMemoryUsage(memoryChange);
            }
        }
        finally {
            this.dbFileSummaries.subtractFromMemoryBudget();
            this.deleteState = (short)4;
            this.envImpl.getDbTree().releaseDb(this);
        }
    }

    public void checkIsDeleted(String operation) throws DatabaseException {
        if (this.isDeleted()) {
            throw new DatabaseException("Attempt to " + operation + " a deleted database");
        }
    }

    public void countObsoleteDb(BaseUtilizationTracker tracker, long mapLnLsn) {
        if (this.createdAtLogVersion >= 6 && !forceTreeWalkForTruncateAndRemove) {
            tracker.countObsoleteDb(this.dbFileSummaries, mapLnLsn);
        }
    }

    public DatabaseStats stat(StatsConfig config) throws DatabaseException {
        if (this.stats == null) {
            this.stats = new BtreeStats();
        }
        if (!config.getFast()) {
            if (this.tree == null) {
                return new BtreeStats();
            }
            PrintStream out = config.getShowProgressStream();
            if (out == null) {
                out = System.err;
            }
            StatsAccumulator statsAcc = new StatsAccumulator(out, config.getShowProgressInterval(), this.getEmptyStats());
            this.walkDatabaseTree(statsAcc, out, true);
            statsAcc.copyToStats(this.stats);
        }
        return this.stats;
    }

    public boolean verify(VerifyConfig config, DatabaseStats emptyStats) throws DatabaseException {
        if (this.tree == null) {
            return true;
        }
        PrintStream out = config.getShowProgressStream();
        if (out == null) {
            out = System.err;
        }
        StatsAccumulator statsAcc = new StatsAccumulator(out, config.getShowProgressInterval(), emptyStats){

            @Override
            void verifyNode(Node node) {
                try {
                    node.verify(null);
                }
                catch (DatabaseException INE) {
                    this.progressStream.println(INE);
                }
            }
        };
        boolean ok = this.walkDatabaseTree(statsAcc, out, config.getPrintInfo());
        statsAcc.copyToStats(emptyStats);
        return ok;
    }

    public DatabaseStats getEmptyStats() {
        return new BtreeStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean walkDatabaseTree(TreeWalkerStatsAccumulator statsAcc, PrintStream out, boolean verbose) throws DatabaseException {
        boolean ok;
        block11: {
            ok = true;
            BasicLocker locker = BasicLocker.createBasicLocker(this.envImpl);
            CursorImpl cursor = null;
            try {
                EnvironmentImpl.incThreadLocalReferenceCount();
                cursor = new CursorImpl(this, locker);
                this.tree.setTreeStatsAccumulator(statsAcc);
                cursor.setTreeStatsAccumulator(statsAcc);
                DatabaseEntry foundData = new DatabaseEntry();
                DatabaseEntry key = new DatabaseEntry();
                if (!cursor.positionFirstOrLast(true, null)) break block11;
                OperationStatus status = cursor.getCurrentAlreadyLatched(key, foundData, LockType.NONE, true);
                if (status == OperationStatus.SUCCESS && cursor.getDupBIN() != null) {
                    cursor.incrementLNCount();
                }
                boolean done = false;
                while (!done) {
                    this.envImpl.getEvictor().doCriticalEviction(false);
                    try {
                        status = cursor.getNext(key, foundData, LockType.NONE, true, false);
                    }
                    catch (DatabaseException e) {
                        ok = false;
                        if (cursor.advanceCursor(key, foundData)) {
                            if (verbose) {
                                out.println("Error encountered (continuing):");
                                out.println(e);
                                this.printErrorRecord(out, key, foundData);
                            }
                        }
                        throw e;
                    }
                    if (status == OperationStatus.SUCCESS) continue;
                    done = true;
                }
            }
            finally {
                if (cursor != null) {
                    cursor.setTreeStatsAccumulator(null);
                }
                this.tree.setTreeStatsAccumulator(null);
                EnvironmentImpl.decThreadLocalReferenceCount();
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        return ok;
    }

    private void printErrorRecord(PrintStream out, DatabaseEntry key, DatabaseEntry data) {
        byte[] bytes = key.getData();
        StringBuffer sb = new StringBuffer("Error Key ");
        if (bytes == null) {
            sb.append("UNKNOWN");
        } else {
            CmdUtil.formatEntry(sb, bytes, false);
            sb.append(' ');
            CmdUtil.formatEntry(sb, bytes, true);
        }
        out.println(sb);
        bytes = data.getData();
        sb = new StringBuffer("Error Data ");
        if (bytes == null) {
            sb.append("UNKNOWN");
        } else {
            CmdUtil.formatEntry(sb, bytes, false);
            sb.append(' ');
            CmdUtil.formatEntry(sb, bytes, true);
        }
        out.println(sb);
    }

    public PreloadStats preload(PreloadConfig config) throws DatabaseException {
        try {
            long maxBytes = config.getMaxBytes();
            long maxMillisecs = config.getMaxMillisecs();
            long targetTime = Long.MAX_VALUE;
            if (maxMillisecs > 0L) {
                targetTime = System.currentTimeMillis() + maxMillisecs;
            }
            long cacheBudget = this.envImpl.getMemoryBudget().getMaxMemory();
            if (maxBytes == 0L) {
                maxBytes = cacheBudget;
            } else if (maxBytes > cacheBudget) {
                throw new IllegalArgumentException("maxBytes parameter to Database.preload() was specified as " + maxBytes + " bytes \nbut the cache is only " + cacheBudget + " bytes.");
            }
            PreloadStats pstats = new PreloadStats();
            PreloadProcessor callback = new PreloadProcessor(this.envImpl, maxBytes, targetTime, pstats);
            PreloadLSNTreeWalker walker = new PreloadLSNTreeWalker(this, callback, config);
            walker.setPassNullLSNNodes(true);
            try {
                ((SortedLSNTreeWalker)walker).walk();
            }
            catch (HaltPreloadException HPE) {
                pstats.setStatus(HPE.getStatus());
            }
            assert (LatchSupport.countLatchesHeld() == 0);
            return pstats;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
    }

    public long count() throws DatabaseException {
        try {
            PreloadStats pstats = new PreloadStats();
            CountProcessor callback = new CountProcessor(this.envImpl, pstats);
            CountExceptionPredicate excPredicate = new CountExceptionPredicate();
            SortedLSNTreeWalker walker = new SortedLSNTreeWalker(this, false, this.tree.getRootLsn(), callback, null, excPredicate);
            walker.setProcessDupTree(false);
            if (this.isDurableDeferredWrite()) {
                walker.setPassNullLSNNodes(true);
            }
            walker.walk();
            assert (LatchSupport.countLatchesHeld() == 0);
            return pstats.getNLNsLoaded();
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
    }

    public String dumpString(int nSpaces) {
        StringBuffer sb = new StringBuffer();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<database id=\"");
        sb.append(this.id.toString());
        sb.append("\"");
        sb.append(" dupsort=\"");
        sb.append(this.getSortedDuplicates());
        sb.append("\"");
        sb.append(" temporary=\"");
        sb.append(this.isTemporary());
        sb.append("\"");
        sb.append(" deferredWrite=\"");
        sb.append(this.isDurableDeferredWrite());
        sb.append("\"");
        sb.append(" keyPrefixing=\"");
        sb.append(this.getKeyPrefixing());
        sb.append("\"");
        if (this.btreeComparator != null) {
            sb.append(" btc=\"");
            sb.append(DatabaseImpl.getComparatorClassName(this.btreeComparator));
            sb.append("\"");
        }
        if (this.duplicateComparator != null) {
            sb.append(" dupc=\"");
            sb.append(DatabaseImpl.getComparatorClassName(this.duplicateComparator));
            sb.append("\"");
        }
        sb.append(">");
        if (this.dbFileSummaries != null) {
            for (Map.Entry<Long, DbFileSummary> entry : this.dbFileSummaries.entrySet()) {
                Long fileNum = entry.getKey();
                DbFileSummary summary = entry.getValue();
                sb.append("<file file=\"").append(fileNum);
                sb.append("\">");
                sb.append(summary);
                sb.append("/file>");
            }
        }
        sb.append("</database>");
        return sb.toString();
    }

    @Override
    public int getLogSize() {
        int size = this.id.getLogSize() + this.tree.getLogSize() + 1 + LogUtils.getByteArrayLogSize(this.btreeComparatorBytes) + LogUtils.getByteArrayLogSize(this.duplicateComparatorBytes) + LogUtils.getPackedIntLogSize(this.maxMainTreeEntriesPerNode) + LogUtils.getPackedIntLogSize(this.maxDupTreeEntriesPerNode) + 1;
        size += LogUtils.getPackedIntLogSize(this.dbFileSummaries.size());
        for (Map.Entry<Long, DbFileSummary> entry : this.dbFileSummaries.entrySet()) {
            Long fileNum = entry.getKey();
            DbFileSummary summary = entry.getValue();
            size += LogUtils.getPackedLongLogSize(fileNum) + summary.getLogSize();
        }
        return size;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        this.id.writeToLog(logBuffer);
        this.tree.writeToLog(logBuffer);
        logBuffer.put(this.flags);
        LogUtils.writeByteArray(logBuffer, this.btreeComparatorBytes);
        LogUtils.writeByteArray(logBuffer, this.duplicateComparatorBytes);
        LogUtils.writePackedInt(logBuffer, this.maxMainTreeEntriesPerNode);
        LogUtils.writePackedInt(logBuffer, this.maxDupTreeEntriesPerNode);
        logBuffer.put(this.createdAtLogVersion);
        LogUtils.writePackedInt(logBuffer, this.dbFileSummaries.size());
        for (Map.Entry<Long, DbFileSummary> entry : this.dbFileSummaries.entrySet()) {
            Long fileNum = entry.getKey();
            DbFileSummary summary = entry.getValue();
            LogUtils.writePackedLong(logBuffer, fileNum);
            summary.writeToLog(logBuffer);
        }
        this.dirtyUtilization = false;
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, byte entryVersion) throws LogException {
        boolean version6OrLater = entryVersion >= 6;
        this.id.readFromLog(itemBuffer, entryVersion);
        this.tree.readFromLog(itemBuffer, entryVersion);
        this.flags = itemBuffer.get();
        if (forceKeyPrefixing) {
            this.setKeyPrefixing();
        }
        if (entryVersion >= 2) {
            this.btreeComparatorBytes = LogUtils.readByteArray(itemBuffer, !version6OrLater);
            this.duplicateComparatorBytes = LogUtils.readByteArray(itemBuffer, !version6OrLater);
        } else {
            String btreeClassName = LogUtils.readString(itemBuffer, !version6OrLater);
            String dupClassName = LogUtils.readString(itemBuffer, !version6OrLater);
            this.btreeComparatorBytes = btreeClassName.length() == 0 ? LogUtils.ZERO_LENGTH_BYTE_ARRAY : DatabaseImpl.objectToBytes(btreeClassName, "Btree");
            this.duplicateComparatorBytes = dupClassName.length() == 0 ? LogUtils.ZERO_LENGTH_BYTE_ARRAY : DatabaseImpl.objectToBytes(dupClassName, "Duplicate");
        }
        if (!EnvironmentImpl.getNoComparators()) {
            try {
                Object obj;
                if (this.btreeComparatorBytes.length != 0) {
                    obj = DatabaseImpl.bytesToObject(this.btreeComparatorBytes, "Btree");
                    if (obj instanceof String) {
                        String className = (String)obj;
                        Class<?> cls = Class.forName(className);
                        this.btreeComparator = DatabaseImpl.instantiateComparator(cls, "Btree");
                        this.btreeComparatorByClassName = true;
                    } else if (obj instanceof Comparator) {
                        this.btreeComparator = (Comparator)obj;
                        this.btreeComparatorByClassName = false;
                    } else assert (false) : obj.getClass().getName();
                } else {
                    this.btreeComparator = null;
                    this.btreeComparatorByClassName = false;
                }
                if (this.duplicateComparatorBytes.length != 0) {
                    obj = DatabaseImpl.bytesToObject(this.duplicateComparatorBytes, "Duplicate");
                    if (obj instanceof String) {
                        Class<?> cls = Class.forName((String)obj);
                        this.duplicateComparator = DatabaseImpl.instantiateComparator(cls, "Duplicate");
                        this.duplicateComparatorByClassName = true;
                    } else if (obj instanceof Comparator) {
                        this.duplicateComparator = (Comparator)obj;
                        this.duplicateComparatorByClassName = false;
                    } else assert (false) : obj.getClass().getName();
                } else {
                    this.duplicateComparator = null;
                    this.duplicateComparatorByClassName = false;
                }
            }
            catch (ClassNotFoundException CNFE) {
                throw new LogException("couldn't instantiate class comparator", CNFE);
            }
        }
        if (entryVersion >= 1) {
            this.maxMainTreeEntriesPerNode = LogUtils.readInt(itemBuffer, !version6OrLater);
            this.maxDupTreeEntriesPerNode = LogUtils.readInt(itemBuffer, !version6OrLater);
        }
        if (version6OrLater) {
            this.createdAtLogVersion = itemBuffer.get();
            int nFiles = LogUtils.readPackedInt(itemBuffer);
            for (int i = 0; i < nFiles; ++i) {
                long fileNum = LogUtils.readPackedLong(itemBuffer);
                DbFileSummary summary = this.dbFileSummaries.get(fileNum, false, false, null);
                summary.readFromLog(itemBuffer, entryVersion);
            }
        }
    }

    @Override
    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<database ");
        DatabaseImpl.dumpFlags(sb, verbose, this.flags);
        sb.append(" btcmp=\"");
        sb.append(DatabaseImpl.getComparatorClassName(this.btreeComparator));
        sb.append("\"");
        sb.append(" dupcmp=\"");
        sb.append(DatabaseImpl.getComparatorClassName(this.duplicateComparator));
        sb.append("\" > ");
        this.id.dumpLog(sb, verbose);
        this.tree.dumpLog(sb, verbose);
        if (this.dbFileSummaries != null) {
            for (Map.Entry<Long, DbFileSummary> entry : this.dbFileSummaries.entrySet()) {
                Long fileNum = entry.getKey();
                DbFileSummary summary = entry.getValue();
                sb.append("<file file=\"").append(fileNum);
                sb.append("\">");
                sb.append(summary);
                sb.append("</file>");
            }
        }
        sb.append("</database>");
    }

    static void dumpFlags(StringBuffer sb, boolean verbose, byte flags) {
        sb.append(" dupsort=\"").append((flags & 1) != 0);
        sb.append("\" replicated=\"").append((flags & 4) != 0);
        sb.append("\" temp=\"").append((flags & 2) != 0).append("\" ");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    private static String getComparatorClassName(Comparator<byte[]> comparator) {
        if (comparator != null) {
            return comparator.getClass().getName();
        }
        return "";
    }

    public static Comparator<byte[]> instantiateComparator(Class<? extends Comparator<byte[]>> comparatorClass, String comparatorType) throws LogException {
        if (comparatorClass == null) {
            return null;
        }
        try {
            return comparatorClass.newInstance();
        }
        catch (InstantiationException IE) {
            throw new LogException("Exception while trying to load " + comparatorType + " Comparator class: " + IE);
        }
        catch (IllegalAccessException IAE) {
            throw new LogException("Exception while trying to load " + comparatorType + " Comparator class: " + IAE);
        }
    }

    public static Comparator<byte[]> instantiateComparator(Comparator<byte[]> comparator, String comparatorType) throws DatabaseException {
        if (comparator == null) {
            return null;
        }
        return (Comparator)DatabaseImpl.bytesToObject(DatabaseImpl.objectToBytes(comparator, comparatorType), comparatorType);
    }

    private static byte[] comparatorToBytes(Comparator<byte[]> comparator, boolean byClassName, String comparatorType) throws DatabaseException {
        if (comparator == null) {
            return LogUtils.ZERO_LENGTH_BYTE_ARRAY;
        }
        Object obj = byClassName ? comparator.getClass().getName() : comparator;
        return DatabaseImpl.objectToBytes(obj, comparatorType);
    }

    public static byte[] objectToBytes(Object obj, String comparatorType) throws LogException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new LogException("Exception while trying to load " + comparatorType + ": " + e);
        }
    }

    private static Object bytesToObject(byte[] bytes, String comparatorType) throws LogException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (IOException e) {
            throw new LogException("Exception while trying to load " + comparatorType + ": " + e);
        }
        catch (ClassNotFoundException e) {
            throw new LogException("Exception while trying to load " + comparatorType + ": " + e);
        }
    }

    public static Comparator<byte[]> bytesToComparator(byte[] comparatorBytes, String comparatorType) throws LogException, ClassNotFoundException {
        Comparator<byte[]> comparator = null;
        if (comparatorBytes.length != 0) {
            Object obj = DatabaseImpl.bytesToObject(comparatorBytes, comparatorType);
            if (obj instanceof String) {
                String className = (String)obj;
                Class<?> cls = Class.forName(className);
                comparator = DatabaseImpl.instantiateComparator(cls, comparatorType);
            } else if (obj instanceof Comparator) {
                comparator = (Comparator<byte[]>)obj;
            } else assert (false) : obj.getClass().getName();
        }
        return comparator;
    }

    public int getBinDeltaPercent() {
        return this.binDeltaPercent;
    }

    public int getBinMaxDeltas() {
        return this.binMaxDeltas;
    }

    public ReplicationContext getRepContext() {
        if (this.isReplicated()) {
            return ReplicationContext.MASTER;
        }
        return ReplicationContext.NO_REPLICATE;
    }

    DbOpReplicationContext getOperationRepContext(DbOperationType operationType) {
        DbOpReplicationContext context = new DbOpReplicationContext(this.isReplicated(), operationType);
        if (operationType == DbOperationType.CREATE) {
            context.setCreateConfig(new ReplicatedDatabaseConfig(this.flags, this.maxMainTreeEntriesPerNode, this.maxDupTreeEntriesPerNode, this.btreeComparatorBytes, this.duplicateComparatorBytes));
        } else if (operationType == DbOperationType.TRUNCATE) {
            context.setTruncateOldDbId(this.id);
        }
        return context;
    }

    static {
        String forceKeyPrefixingProp = System.getProperty("je.forceKeyPrefixing");
        forceKeyPrefixing = "true".equals(forceKeyPrefixingProp);
        TIME_EXCEEDED_PRELOAD_EXCEPTION = new HaltPreloadException(PreloadStatus.EXCEEDED_TIME);
        MEMORY_EXCEEDED_PRELOAD_EXCEPTION = new HaltPreloadException(PreloadStatus.FILLED_CACHE);
    }

    private static class CountExceptionPredicate
    implements SortedLSNTreeWalker.ExceptionPredicate {
        private CountExceptionPredicate() {
        }

        @Override
        public boolean ignoreException(Exception e) {
            return e instanceof LogFileNotFoundException;
        }
    }

    private static class CountProcessor
    implements SortedLSNTreeWalker.TreeNodeProcessor {
        private EnvironmentImpl envImpl;
        private PreloadStats stats;

        CountProcessor(EnvironmentImpl envImpl, PreloadStats stats) {
            this.envImpl = envImpl;
            this.stats = stats;
        }

        @Override
        public void processLSN(long childLsn, LogEntryType childType, Node ignore, byte[] ignore2) throws DatabaseException {
            if (childType.equals(LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL) || childType.equals(LogEntryType.LOG_DUPCOUNTLN)) {
                int dupCount = 0;
                DupCountLN dcl = (DupCountLN)this.envImpl.getLogManager().get(childLsn);
                dupCount = dcl.getDupCount();
                this.stats.addLNsLoaded(dupCount);
            } else if (childType.equals(LogEntryType.LOG_LN_TRANSACTIONAL) || childType.equals(LogEntryType.LOG_LN)) {
                this.stats.incLNsLoaded();
            }
        }

        @Override
        public void processDirtyDeletedLN(long childLsn, LN ln, byte[] lnKey) throws DatabaseException {
        }

        @Override
        public void processDupCount(int count) {
            this.stats.addLNsLoaded(count);
        }
    }

    private static class PreloadLSNTreeWalker
    extends SortedLSNTreeWalker {
        private Map<Long, INEntry> lsnINMap = new HashMap<Long, INEntry>();

        PreloadLSNTreeWalker(DatabaseImpl db, SortedLSNTreeWalker.TreeNodeProcessor callback, PreloadConfig conf) throws DatabaseException {
            super(db, false, db.tree.getRootLsn(), callback, null, null);
            this.accumulateLNs = conf.getLoadLNs();
        }

        @Override
        public void walk() throws DatabaseException {
            PreloadWithRootLatched preloadWRL = new PreloadWithRootLatched();
            this.dbImpl.getTree().withRootLatchedExclusive(preloadWRL);
        }

        @Override
        protected IN getRootIN(long rootLsn) throws DatabaseException {
            return this.dbImpl.getTree().getRootIN(CacheMode.UNCHANGED);
        }

        @Override
        protected IN getResidentRootIN() throws DatabaseException {
            return this.dbImpl.getTree().getResidentRootIN(true);
        }

        @Override
        protected void releaseRootIN(IN root) throws DatabaseException {
            root.releaseLatch();
        }

        @Override
        protected void addToLsnINMap(Long lsn, IN in, int index) {
            assert (in.getDatabase() != null);
            this.lsnINMap.put(lsn, new INEntry(in, index));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Node fetchLSN(long lsn, DatabaseEntry lnKeyEntry) throws DatabaseException {
            INEntry inEntry = this.lsnINMap.remove(lsn);
            assert (inEntry != null) : DbLsn.getNoFormatString(lsn);
            IN in = inEntry.in;
            boolean isLatchedAlready = in.isLatchOwnerForWrite();
            if (!isLatchedAlready) {
                in.latch();
            }
            try {
                int index = inEntry.index;
                if (index < 0) {
                    DIN din = (DIN)in;
                    DupCountLN dupCountLN = din.getDupCountLN();
                    return dupCountLN;
                }
                if (in.isEntryKnownDeleted(index) || in.getLsn(index) != lsn) {
                    Node node = null;
                    return node;
                }
                Node node = in.fetchTarget(index);
                return node;
            }
            finally {
                if (!isLatchedAlready) {
                    in.releaseLatch();
                }
            }
        }

        private final class PreloadWithRootLatched
        implements WithRootLatched {
            private PreloadWithRootLatched() {
            }

            @Override
            public IN doWork(ChildReference root) throws DatabaseException {
                PreloadLSNTreeWalker.this.walkInternal();
                return null;
            }
        }

        private static class INEntry {
            IN in;
            int index;

            INEntry(IN in, int index) {
                this.in = in;
                this.index = index;
            }
        }
    }

    private static class PreloadProcessor
    implements SortedLSNTreeWalker.TreeNodeProcessor {
        private EnvironmentImpl envImpl;
        private long maxBytes;
        private long targetTime;
        private PreloadStats stats;

        PreloadProcessor(EnvironmentImpl envImpl, long maxBytes, long targetTime, PreloadStats stats) {
            this.envImpl = envImpl;
            this.maxBytes = maxBytes;
            this.targetTime = targetTime;
            this.stats = stats;
        }

        @Override
        public void processLSN(long childLsn, LogEntryType childType, Node ignore, byte[] ignore2) throws DatabaseException {
            assert (childLsn != -1L);
            if (System.currentTimeMillis() > this.targetTime) {
                throw TIME_EXCEEDED_PRELOAD_EXCEPTION;
            }
            if (this.envImpl.getMemoryBudget().getCacheMemoryUsage() > this.maxBytes) {
                throw MEMORY_EXCEEDED_PRELOAD_EXCEPTION;
            }
            if (childType.equals(LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL) || childType.equals(LogEntryType.LOG_DUPCOUNTLN)) {
                this.stats.incDupCountLNsLoaded();
            } else if (childType.equals(LogEntryType.LOG_LN_TRANSACTIONAL) || childType.equals(LogEntryType.LOG_LN)) {
                this.stats.incLNsLoaded();
            } else if (childType.equals(LogEntryType.LOG_DBIN)) {
                this.stats.incDBINsLoaded();
            } else if (childType.equals(LogEntryType.LOG_BIN)) {
                this.stats.incBINsLoaded();
            } else if (childType.equals(LogEntryType.LOG_DIN)) {
                this.stats.incDINsLoaded();
            } else if (childType.equals(LogEntryType.LOG_IN)) {
                this.stats.incINsLoaded();
            }
        }

        @Override
        public void processDirtyDeletedLN(long childLsn, LN ln, byte[] lnKey) throws DatabaseException {
        }

        @Override
        public void processDupCount(int ignore) {
        }
    }

    private static class HaltPreloadException
    extends RuntimeException {
        private PreloadStatus status;

        HaltPreloadException(PreloadStatus status) {
            super(status.toString());
            this.status = status;
        }

        PreloadStatus getStatus() {
            return this.status;
        }
    }

    static class StatsAccumulator
    implements TreeWalkerStatsAccumulator {
        private Set<Long> inNodeIdsSeen = new HashSet<Long>();
        private Set<Long> binNodeIdsSeen = new HashSet<Long>();
        private Set<Long> dinNodeIdsSeen = new HashSet<Long>();
        private Set<Long> dbinNodeIdsSeen = new HashSet<Long>();
        private Set<Long> dupCountLNsSeen = new HashSet<Long>();
        private long[] insSeenByLevel = null;
        private long[] binsSeenByLevel = null;
        private long[] dinsSeenByLevel = null;
        private long[] dbinsSeenByLevel = null;
        private long lnCount = 0L;
        private long deletedLNCount = 0L;
        private int mainTreeMaxDepth = 0;
        private int duplicateTreeMaxDepth = 0;
        private DatabaseStats useStats;
        PrintStream progressStream;
        int progressInterval;
        private static final int MAX_LEVELS = 100;

        StatsAccumulator(PrintStream progressStream, int progressInterval, DatabaseStats useStats) {
            this.progressStream = progressStream;
            this.progressInterval = progressInterval;
            this.insSeenByLevel = new long[100];
            this.binsSeenByLevel = new long[100];
            this.dinsSeenByLevel = new long[100];
            this.dbinsSeenByLevel = new long[100];
            this.useStats = useStats;
        }

        void verifyNode(Node node) {
        }

        @Override
        public void processIN(IN node, Long nid, int level) {
            if (this.inNodeIdsSeen.add(nid)) {
                this.tallyLevel(level, this.insSeenByLevel);
                this.verifyNode(node);
            }
        }

        @Override
        public void processBIN(BIN node, Long nid, int level) {
            if (this.binNodeIdsSeen.add(nid)) {
                this.tallyLevel(level, this.binsSeenByLevel);
                this.verifyNode(node);
            }
        }

        @Override
        public void processDIN(DIN node, Long nid, int level) {
            if (this.dinNodeIdsSeen.add(nid)) {
                this.tallyLevel(level, this.dinsSeenByLevel);
                this.verifyNode(node);
            }
        }

        @Override
        public void processDBIN(DBIN node, Long nid, int level) {
            if (this.dbinNodeIdsSeen.add(nid)) {
                this.tallyLevel(level, this.dbinsSeenByLevel);
                this.verifyNode(node);
            }
        }

        @Override
        public void processDupCountLN(DupCountLN node, Long nid) {
            this.dupCountLNsSeen.add(nid);
            this.verifyNode(node);
        }

        private void tallyLevel(int levelArg, long[] nodesSeenByLevel) {
            int level = levelArg;
            if (level >= 131072) {
                return;
            }
            if (level >= 65536) {
                if ((level &= 0xFFFEFFFF) > this.mainTreeMaxDepth) {
                    this.mainTreeMaxDepth = level;
                }
            } else if (level > this.duplicateTreeMaxDepth) {
                this.duplicateTreeMaxDepth = level;
            }
            int n = level;
            nodesSeenByLevel[n] = nodesSeenByLevel[n] + 1L;
        }

        @Override
        public void incrementLNCount() {
            ++this.lnCount;
            if (this.progressInterval != 0 && this.lnCount % (long)this.progressInterval == 0L) {
                this.copyToStats(this.useStats);
                this.progressStream.println(this.useStats);
            }
        }

        @Override
        public void incrementDeletedLNCount() {
            ++this.deletedLNCount;
        }

        Set<Long> getINNodeIdsSeen() {
            return this.inNodeIdsSeen;
        }

        Set<Long> getBINNodeIdsSeen() {
            return this.binNodeIdsSeen;
        }

        Set<Long> getDINNodeIdsSeen() {
            return this.dinNodeIdsSeen;
        }

        Set<Long> getDBINNodeIdsSeen() {
            return this.dbinNodeIdsSeen;
        }

        long[] getINsByLevel() {
            return this.insSeenByLevel;
        }

        long[] getBINsByLevel() {
            return this.binsSeenByLevel;
        }

        long[] getDINsByLevel() {
            return this.dinsSeenByLevel;
        }

        long[] getDBINsByLevel() {
            return this.dbinsSeenByLevel;
        }

        long getLNCount() {
            return this.lnCount;
        }

        Set<Long> getDupCountLNCount() {
            return this.dupCountLNsSeen;
        }

        long getDeletedLNCount() {
            return this.deletedLNCount;
        }

        int getMainTreeMaxDepth() {
            return this.mainTreeMaxDepth;
        }

        int getDuplicateTreeMaxDepth() {
            return this.duplicateTreeMaxDepth;
        }

        private void copyToStats(DatabaseStats stats) {
            BtreeStats bStats = (BtreeStats)stats;
            bStats.setInternalNodeCount(this.getINNodeIdsSeen().size());
            bStats.setBottomInternalNodeCount(this.getBINNodeIdsSeen().size());
            bStats.setDuplicateInternalNodeCount(this.getDINNodeIdsSeen().size());
            bStats.setDuplicateBottomInternalNodeCount(this.getDBINNodeIdsSeen().size());
            bStats.setLeafNodeCount(this.getLNCount());
            bStats.setDeletedLeafNodeCount(this.getDeletedLNCount());
            bStats.setDupCountLeafNodeCount(this.getDupCountLNCount().size());
            bStats.setMainTreeMaxDepth(this.getMainTreeMaxDepth());
            bStats.setDuplicateTreeMaxDepth(this.getDuplicateTreeMaxDepth());
            bStats.setINsByLevel(this.getINsByLevel());
            bStats.setBINsByLevel(this.getBINsByLevel());
            bStats.setDINsByLevel(this.getDINsByLevel());
            bStats.setDBINsByLevel(this.getDBINsByLevel());
        }
    }

    private static class ObsoleteProcessor
    implements SortedLSNTreeWalker.TreeNodeProcessor {
        private LocalUtilizationTracker localTracker;
        private DatabaseImpl db;

        ObsoleteProcessor(DatabaseImpl db, LocalUtilizationTracker localTracker) {
            this.db = db;
            this.localTracker = localTracker;
        }

        @Override
        public void processLSN(long childLsn, LogEntryType childType, Node node, byte[] lnKey) throws DatabaseException {
            assert (childLsn != -1L);
            int size = 0;
            if (lnKey != null && node instanceof LN) {
                LN ln = (LN)node;
                size = ln.getLastLoggedSize();
            }
            this.localTracker.countObsoleteNodeInexact(childLsn, childType, size, this.db);
        }

        @Override
        public void processDirtyDeletedLN(long childLsn, LN ln, byte[] lnKey) throws DatabaseException {
            assert (ln != null);
            this.localTracker.countObsoleteNodeInexact(childLsn, ln.getLogType(), 0, this.db);
        }

        @Override
        public void processDupCount(int ignore) {
        }
    }

    private static class ObsoleteTreeWalker
    extends SortedLSNTreeWalker {
        private IN rootIN;

        private ObsoleteTreeWalker(DatabaseImpl dbImpl, long rootLsn, boolean fetchLNSize, SortedLSNTreeWalker.TreeNodeProcessor callback, IN rootIN) throws DatabaseException {
            super(dbImpl, true, rootLsn, callback, null, null);
            this.accumulateLNs = fetchLNSize;
            this.rootIN = rootIN;
        }

        @Override
        protected IN getResidentRootIN() throws DatabaseException {
            return this.rootIN;
        }
    }
}

