/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.serial;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;

public class SerialOutput
extends ObjectOutputStream {
    private static final byte[] STREAM_HEADER;
    private ClassCatalog classCatalog;

    public SerialOutput(OutputStream out, ClassCatalog classCatalog) throws IOException {
        super(out);
        this.classCatalog = classCatalog;
        this.useProtocolVersion(2);
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass classdesc) throws IOException {
        try {
            byte[] id = this.classCatalog.getClassID(classdesc);
            this.writeByte(id.length);
            this.write(id);
        }
        catch (DatabaseException e) {
            throw new RuntimeExceptionWrapper(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeExceptionWrapper(e);
        }
    }

    public static byte[] getStreamHeader() {
        return STREAM_HEADER;
    }

    static {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            new SerialOutput(baos, null);
        }
        catch (IOException e) {
            throw new RuntimeExceptionWrapper(e);
        }
        STREAM_HEADER = baos.toByteArray();
    }
}

