/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.serial;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class SerialInput
extends ObjectInputStream {
    private ClassCatalog classCatalog;
    private ClassLoader classLoader;

    public SerialInput(InputStream in, ClassCatalog classCatalog) throws IOException {
        this(in, classCatalog, null);
    }

    public SerialInput(InputStream in, ClassCatalog classCatalog, ClassLoader classLoader) throws IOException {
        super(in);
        this.classCatalog = classCatalog;
        this.classLoader = classLoader;
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        try {
            byte len = this.readByte();
            byte[] id = new byte[len];
            this.readFully(id);
            return this.classCatalog.getClassFormat(id);
        }
        catch (DatabaseException e) {
            throw new RuntimeExceptionWrapper(e);
        }
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (this.classLoader != null) {
            try {
                return Class.forName(desc.getName(), false, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                return super.resolveClass(desc);
            }
        }
        return super.resolveClass(desc);
    }
}

