/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.memcached.io;

import com.gemantic.memcached.channel.MemcachedChannel;
import com.gemantic.memcached.stream.LineInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class GetInputStreamWrapper
implements LineInputStream {
    private DataInputStream is = null;
    private boolean eof = false;
    private int preReadLen = 1024;
    private byte[] bytes = new byte[this.preReadLen];
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private ByteArrayInputStream bis = null;
    private static byte[] END_BYTES = "END\r\n".getBytes();
    private static int error_len = "ERROR\r\n".getBytes().length;

    public GetInputStreamWrapper(MemcachedChannel channel) throws IOException {
        Long begtime = System.currentTimeMillis();
        if (channel != null) {
            this.is = channel.getIn();
            while (!this.eof) {
                if (System.currentTimeMillis() - begtime >= 10000L) {
                    channel.setHealth(false);
                    throw new IOException("read time out: 10000");
                }
                this.readNextByte();
            }
        }
        this.bis = new ByteArrayInputStream(this.bos.toByteArray());
    }

    public boolean isEof() {
        return this.eof;
    }

    private synchronized void readNextByte() throws IOException {
        if (this.is != null && !this.eof) {
            byte[] osBytes;
            int iRealLen = this.is.read(this.bytes, 0, this.preReadLen);
            if (iRealLen == this.preReadLen) {
                this.eof = this.checkEof(this.bytes);
            }
            if (iRealLen != -1) {
                this.bos.write(this.bytes, 0, iRealLen);
            }
            if (!this.eof && (osBytes = this.bos.toByteArray()).length >= END_BYTES.length) {
                this.eof = this.checkEof(osBytes);
            }
        }
    }

    private boolean checkEof(byte[] inputByte) {
        boolean eofTemp = true;
        int inputLen = inputByte.length - 1;
        int i = END_BYTES.length - 1;
        while (i >= 0) {
            byte endByte = END_BYTES[i];
            byte realByte = inputByte[inputLen];
            if (endByte != realByte) {
                eofTemp = false;
                break;
            }
            --i;
            --inputLen;
        }
        if (!eofTemp && inputByte.length >= error_len) {
            byte[] stats = new byte[7];
            System.arraycopy(inputByte, 0, stats, 0, stats.length);
            String statsStr = new String(stats);
            if (statsStr.indexOf("ERROR") >= 0 || statsStr.indexOf("CLIEN") >= 0 || statsStr.indexOf("SERVE") >= 0) {
                eofTemp = false;
            }
        }
        return eofTemp;
    }

    @Override
    public String readLine() throws IOException {
        byte[] b = new byte[1];
        ByteArrayOutputStream tmp_bos = new ByteArrayOutputStream();
        boolean eol = false;
        while (this.bis.read(b, 0, 1) != -1) {
            if (b[0] == 13) {
                eol = true;
            } else if (eol) {
                if (b[0] == 10) break;
                eol = false;
            }
            tmp_bos.write(b, 0, 1);
        }
        if (tmp_bos == null || tmp_bos.size() <= 0) {
            throw new IOException("++++ Stream appears to be dead, so closing it down");
        }
        return tmp_bos.toString().trim();
    }

    @Override
    public void clearEOL() throws IOException {
        byte[] b = new byte[1];
        boolean eol = false;
        while (this.bis.read(b, 0, 1) != -1) {
            if (b[0] == 13) {
                eol = true;
                continue;
            }
            if (!eol) continue;
            if (b[0] == 10) break;
            eol = false;
        }
    }

    @Override
    public void clearEnd() throws IOException {
        int len = "END".getBytes().length;
        byte[] keyByte = new byte[len];
        int writeLen = this.bis.read(keyByte, 0, len);
        byte[] b = new byte[1];
        boolean eol = false;
        while (writeLen == len && this.bis.read(b, 0, 1) != -1) {
            if (b[0] == 13) {
                eol = true;
                continue;
            }
            if (!eol) continue;
            if (b[0] == 10) break;
            eol = false;
        }
    }

    @Override
    public int read(byte[] buf) throws IOException {
        int count;
        int cnt;
        for (count = 0; count < buf.length; count += cnt) {
            cnt = this.bis.read(buf, count, buf.length - count);
        }
        return count;
    }

    @Override
    public String readKeys(String key) throws IOException {
        ByteArrayOutputStream temp_bos = new ByteArrayOutputStream();
        int len = key.getBytes().length + "VALUE".getBytes().length;
        byte[] keyByte = new byte[len];
        int writeLen = this.bis.read(keyByte, 0, len);
        if (writeLen != -1) {
            temp_bos.write(keyByte, 0, writeLen);
        }
        byte[] b = new byte[1];
        boolean eol = false;
        if (writeLen == len && keyByte[writeLen - 2] != 13 && keyByte[writeLen - 1] != 0) {
            while (this.bis.read(b, 0, 1) != -1) {
                if (b[0] == 13) {
                    eol = true;
                } else if (eol) {
                    if (b[0] == 10) break;
                    eol = false;
                }
                temp_bos.write(b, 0, 1);
            }
        }
        String result = temp_bos.toString().trim();
        return result;
    }
}

