/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.memcached.config;

import com.gemantic.dal.cache.config.model.DatasourceItem;
import com.gemantic.dal.cache.config.model.KeyPatternItem;
import com.gemantic.dal.cache.config.model.RegionItem;
import com.gemantic.memcached.channel.source.MemcachedSource;
import com.gemantic.memcached.channel.source.MemcachedSourceImpl;
import com.gemantic.memcached.channel.source.RoutingMemcachedSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class CacheConfig {
    private static Logger logger = LoggerFactory.getLogger(CacheConfig.class);
    public static String CONFIG_FILE = "/memcached_client.xml";
    private static CacheConfig config;
    private Map<String, DatasourceItem> memcachedItemMap = new HashMap<String, DatasourceItem>();
    private Map<String, RegionItem> regionItemMap = new HashMap<String, RegionItem>();
    private Map<String, MemcachedSource> memcachedSourceMap = new HashMap<String, MemcachedSource>();
    private MemcachedSource dynamicMemcachedSource = new RoutingMemcachedSource();
    private RegionItem defaultRegionItem = null;

    private CacheConfig() {
        try {
            this.init(this.getClass().getResourceAsStream(CONFIG_FILE));
            this.initDefaultRegion(this.getClass().getResourceAsStream(CONFIG_FILE));
            this.initDynamicMemcachedSource();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.out);
            }
            logger.error("init config file " + CONFIG_FILE + " error: " + e.getMessage());
        }
    }

    private void initDynamicMemcachedSource() {
        RoutingMemcachedSource memcachedSource = (RoutingMemcachedSource)this.dynamicMemcachedSource;
        memcachedSource.setResolvedMemcachedSources(this.memcachedSourceMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheConfig getInstance() {
        if (config != null) return config;
        Class<CacheConfig> clazz = CacheConfig.class;
        synchronized (CacheConfig.class) {
            if (config != null) return config;
            config = new CacheConfig();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    config.close();
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }

    private void init(InputStream groupConfigFile) {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("root", ArrayList.class);
        digester.addObjectCreate("root/cache/", ArrayList.class.getName());
        digester.addObjectCreate("root/cache/datasource", DatasourceItem.class);
        digester.addSetProperties("root/cache/datasource");
        digester.addSetNext("root/cache/datasource", "add");
        digester.addSetNext("root/cache/", "add");
        digester.addObjectCreate("root/regions/", ArrayList.class.getName());
        digester.addObjectCreate("root/regions/region", RegionItem.class);
        digester.addSetProperties("root/regions/region");
        digester.addSetNext("root/regions/region", "add");
        digester.addObjectCreate("root/regions/region/keyPattern", KeyPatternItem.class);
        digester.addSetProperties("root/regions/region/keyPattern");
        digester.addSetNext("root/regions/region/keyPattern", "addKeyPatternItem");
        digester.addSetNext("root/regions/", "add");
        try {
            Object root = digester.parse(groupConfigFile);
            if (root != null && root instanceof ArrayList) {
                List list = (List)root;
                if (CollectionUtils.isEmpty((Collection)list)) {
                    return;
                }
                for (List arrayList : list) {
                    if (!CollectionUtils.isNotEmpty((Collection)arrayList)) continue;
                    for (Object item : arrayList) {
                        if (item == null) continue;
                        if (item instanceof DatasourceItem) {
                            this.addDatasourceItem((DatasourceItem)item);
                            continue;
                        }
                        if (!(item instanceof RegionItem)) continue;
                        this.addRegionItem((RegionItem)item);
                    }
                }
            }
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            } else {
                logger.error("init error: " + e.getMessage());
            }
        }
        catch (SAXException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            }
            logger.error("init parse fail : " + e.getMessage());
        }
    }

    private void initDefaultRegion(InputStream groupConfigFile) {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("root/default/region", RegionItem.class);
        digester.addSetProperties("root/default/region");
        digester.addObjectCreate("root/default/region/keyPattern", KeyPatternItem.class);
        digester.addSetProperties("root/default/region/keyPattern");
        digester.addSetNext("root/default/region/keyPattern", "addKeyPatternItem");
        try {
            Object root = digester.parse(groupConfigFile);
            if (root instanceof RegionItem) {
                this.defaultRegionItem = (RegionItem)root;
            }
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            } else {
                logger.error("initDefaultRegion error: " + e.getMessage());
            }
        }
        catch (SAXException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            }
            logger.error("initDefaultRegion parse fail : " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        System.out.println(CacheConfig.getInstance().getMemcachedItem("photo1"));
        System.out.println(CacheConfig.getInstance().getRegionItem("com.sohu.sns.dal.test.pojo.Photo"));
    }

    private void addDatasourceItem(DatasourceItem datasourceItem) {
        if (datasourceItem != null && StringUtils.isNotBlank((String)datasourceItem.getName())) {
            if (!this.memcachedItemMap.containsKey(datasourceItem.getName())) {
                this.memcachedItemMap.put(datasourceItem.getName(), datasourceItem);
                MemcachedSourceImpl source = new MemcachedSourceImpl(datasourceItem.getServer(), datasourceItem.getPort(), datasourceItem.getTimeout());
                source.setMaxActive(datasourceItem.getMaxActive());
                source.setMaxIdle(datasourceItem.getMaxIdle());
                source.setMaxWait(datasourceItem.getMaxWait());
                this.memcachedSourceMap.put(datasourceItem.getName(), source);
            } else {
                logger.error("same name <" + datasourceItem.getName() + "> memcacheditem have exist!");
            }
        }
    }

    private void addRegionItem(RegionItem regionItem) {
        if (regionItem != null && StringUtils.isNotBlank((String)regionItem.getName())) {
            if (!this.regionItemMap.containsKey(regionItem.getName())) {
                this.regionItemMap.put(regionItem.getName(), regionItem);
            } else {
                logger.error("same name <" + regionItem.getName() + "> RegionItem have exist!");
            }
        }
    }

    public RegionItem getRegionItem(String regionName) {
        return this.regionItemMap.get(regionName);
    }

    public DatasourceItem getMemcachedItem(String memcachedItemName) {
        return this.memcachedItemMap.get(memcachedItemName);
    }

    public MemcachedSource getMemcachedSource(String name) {
        return this.memcachedSourceMap.get(name);
    }

    public Map<String, MemcachedSource> getMemcachedSourceMap() {
        return this.memcachedSourceMap;
    }

    public MemcachedSource getDynamicMemcachedSource() {
        return this.dynamicMemcachedSource;
    }

    public void close() {
        if (MapUtils.isNotEmpty(this.memcachedSourceMap)) {
            Collection<MemcachedSource> c = this.memcachedSourceMap.values();
            for (MemcachedSource source : c) {
                if (source == null) continue;
                try {
                    ((MemcachedSourceImpl)source).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public RegionItem getDefaultRegionItem() {
        return this.defaultRegionItem;
    }
}

