/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.memcached.client;

import com.gemantic.dal.cache.client.CacheClient;
import com.gemantic.memcached.channel.MemcachedChannel;
import com.gemantic.memcached.channel.source.MemcachedSource;
import com.gemantic.memcached.exception.NestedIOException;
import com.gemantic.memcached.handler.ErrorHandler;
import com.gemantic.memcached.handler.NativeHandler;
import com.gemantic.memcached.io.GetInputStreamWrapper;
import com.gemantic.memcached.io.IncrOrDecrInputStreamWrapper;
import com.gemantic.memcached.io.SetInputStreamWrapper;
import com.gemantic.memcached.stream.ContextObjectInputStream;
import com.gemantic.memcached.util.MemcachedUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.StringUtils;

public class MemCachedClientImplBak
implements CacheClient {
    public static final String VALUE = "VALUE";
    public static final String STATS = "STAT";
    public static final String ITEM = "ITEM";
    public static final String DELETED = "DELETED";
    public static final String NOTFOUND = "NOT_FOUND";
    public static final String STORED = "STORED";
    public static final String NOTSTORED = "NOT_STORED";
    public static final String OK = "OK";
    public static final String END = "END";
    public static final String ERROR = "ERROR";
    public static final String CLIENT_ERROR = "CLIENT_ERROR";
    public static final String SERVER_ERROR = "SERVER_ERROR";
    public static final byte[] B_END = "END\r\n".getBytes();
    public static final byte[] B_NOTFOUND = "NOT_FOUND\r\n".getBytes();
    public static final byte[] B_DELETED = "DELETED\r\r".getBytes();
    public static final byte[] B_STORED = "STORED\r\r".getBytes();
    public static final int MARKER_BYTE = 1;
    public static final int MARKER_BOOLEAN = 8192;
    public static final int MARKER_INTEGER = 4;
    public static final int MARKER_LONG = 16384;
    public static final int MARKER_CHARACTER = 16;
    public static final int MARKER_STRING = 32;
    public static final int MARKER_STRINGBUFFER = 64;
    public static final int MARKER_FLOAT = 128;
    public static final int MARKER_SHORT = 256;
    public static final int MARKER_DOUBLE = 512;
    public static final int MARKER_DATE = 1024;
    public static final int MARKER_STRINGBUILDER = 2048;
    public static final int MARKER_BYTEARR = 4096;
    public static final int F_COMPRESSED = 2;
    public static final int F_SERIALIZED = 8;
    private MemcachedSource source;
    private ErrorHandler errorHandler;
    private boolean sanitizeKeys;
    private boolean primitiveAsString;
    private boolean compressEnable = false;
    private long compressThreshold = 128L;
    private String defaultEncoding;
    private ClassLoader classLoader = null;

    public MemCachedClientImplBak() {
    }

    public MemCachedClientImplBak(MemcachedSource source) {
        this.source = source;
    }

    public void setSource(MemcachedSource source) {
        this.source = source;
    }

    @Override
    public boolean remove(String key) {
        return this.delete(key, null);
    }

    @Override
    public boolean delete(String key) {
        return this.delete(key, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(String key, Date expiry) {
        MemcachedChannel channel;
        block13: {
            if (key == null) {
                return false;
            }
            try {
                key = MemcachedUtils.sanitizeKey(this.sanitizeKeys, key);
            }
            catch (UnsupportedEncodingException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                }
                return false;
            }
            channel = null;
            try {
                channel = this.source.getMemcachedChannel();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (channel == null) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, new IOException("no channel to server available"), key);
                }
                return false;
            }
            StringBuilder command = new StringBuilder("delete ").append(key);
            if (expiry != null) {
                command.append(" " + expiry.getTime() / 1000L);
            }
            command.append("\r\n");
            try {
                channel.write(command.toString().getBytes());
                channel.flush();
                String line = channel.readLine();
                if (DELETED.equals(line)) {
                    this.closeMemcachedChannel(channel, key);
                    return true;
                }
                if (!NOTFOUND.equals(line)) {
                    // empty if block
                }
            }
            catch (IOException e) {
                if (this.errorHandler == null) break block13;
                this.errorHandler.handleErrorOnDelete(this, e, key);
            }
        }
        this.closeMemcachedChannel(channel, key);
        return false;
    }

    @Override
    public boolean flushAll() {
        return false;
    }

    @Override
    public Object get(String key) {
        boolean asString = false;
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        try {
            key = MemcachedUtils.sanitizeKey(this.sanitizeKeys, key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
            }
            return null;
        }
        MemcachedChannel channel = null;
        try {
            channel = this.source.getMemcachedChannel();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (channel == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no channel to server available"), key);
            }
            return null;
        }
        try {
            String line;
            StringBuffer sb = new StringBuffer();
            sb.append("get ").append(key).append("\r\n");
            channel.write(sb.toString().getBytes());
            channel.flush();
            Object o = null;
            GetInputStreamWrapper getInputStreamWrapper = new GetInputStreamWrapper(channel);
            while ((line = getInputStreamWrapper.readKeys(key)).startsWith(VALUE)) {
                String[] info = line.split(" ");
                int flag = Integer.parseInt(info[2]);
                int length = Integer.parseInt(info[3]);
                byte[] buf = new byte[length];
                getInputStreamWrapper.read(buf);
                getInputStreamWrapper.clearEOL();
                if ((flag & 2) == 2) {
                    try {
                        int count;
                        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
                        byte[] tmp = new byte[2048];
                        while ((count = gzi.read(tmp)) != -1) {
                            bos.write(tmp, 0, count);
                        }
                        buf = bos.toByteArray();
                        gzi.close();
                    }
                    catch (IOException e) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                        }
                        throw new NestedIOException("IOException thrown while trying to uncompress input stream for key: " + key, e);
                    }
                }
                if ((flag & 8) != 8) {
                    if (this.primitiveAsString || asString) {
                        o = new String(buf, this.defaultEncoding);
                        continue;
                    }
                    try {
                        o = NativeHandler.decode(buf, flag);
                        continue;
                    }
                    catch (Exception e) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                        }
                        throw new NestedIOException(e);
                    }
                }
                ContextObjectInputStream ois = new ContextObjectInputStream(new ByteArrayInputStream(buf), this.classLoader);
                try {
                    o = ois.readObject();
                }
                catch (ClassNotFoundException e) {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                    }
                    throw new NestedIOException("+++ failed while trying to deserialize for key: " + key, e);
                }
            }
            if (!END.equals(line)) {
                channel.setHealth(false);
            }
            this.closeMemcachedChannel(channel, key);
            return o;
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
            }
            this.closeMemcachedChannel(channel, key);
            this.closeMemcachedChannel(channel, key);
            return null;
        }
    }

    @Override
    public boolean replace(String key, Object value) {
        return false;
    }

    @Override
    public boolean replace(String key, Object value, Date expiry) {
        return false;
    }

    @Override
    public boolean set(String key, Object value) {
        return this.set(key, value, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean set(String key, Object value, Long seconds) {
        byte[] val;
        int flags;
        MemcachedChannel channel;
        String cmdName;
        block31: {
            ByteArrayOutputStream bos;
            if (seconds == null) {
                seconds = 0L;
            }
            cmdName = "set";
            try {
                key = MemcachedUtils.sanitizeKey(this.sanitizeKeys, key);
            }
            catch (UnsupportedEncodingException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, e, key);
                }
                return false;
            }
            if (value == null) {
                return false;
            }
            channel = null;
            try {
                channel = this.source.getMemcachedChannel();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (channel == null) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, new IOException("no channel to server available"), key);
                }
                return false;
            }
            boolean asString = false;
            flags = 0;
            if (NativeHandler.isHandled(value)) {
                if (asString) {
                    try {
                        val = value.toString().getBytes(this.defaultEncoding);
                    }
                    catch (UnsupportedEncodingException ue) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnSet(this, ue, key);
                        }
                        this.closeMemcachedChannel(channel, key);
                        return false;
                    }
                } else {
                    try {
                        flags |= NativeHandler.getMarkerFlag(value);
                        val = NativeHandler.encode(value);
                    }
                    catch (Exception e) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnSet(this, e, key);
                        }
                        this.closeMemcachedChannel(channel, key);
                        return false;
                    }
                }
            } else {
                try {
                    bos = new ByteArrayOutputStream();
                    new ObjectOutputStream(bos).writeObject(value);
                    val = bos.toByteArray();
                    flags |= 8;
                }
                catch (IOException e) {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnSet(this, e, key);
                    }
                    this.closeMemcachedChannel(channel, key);
                    return false;
                }
            }
            if (this.compressEnable && (long)val.length > this.compressThreshold) {
                try {
                    bos = new ByteArrayOutputStream(val.length);
                    GZIPOutputStream gos = new GZIPOutputStream(bos);
                    gos.write(val, 0, val.length);
                    gos.finish();
                    val = bos.toByteArray();
                    flags |= 2;
                }
                catch (IOException e) {
                    if (this.errorHandler == null) break block31;
                    this.errorHandler.handleErrorOnSet(this, e, key);
                }
            }
        }
        try {
            String cmd = String.format("%s %s %d %d %d\r\n", cmdName, key, flags, seconds, val.length);
            channel.write(cmd.getBytes());
            channel.write(val);
            channel.write("\r\n".getBytes());
            channel.flush();
            SetInputStreamWrapper setInputStreamWrapper = new SetInputStreamWrapper(channel);
            String line = setInputStreamWrapper.readLine();
            if (STORED.equals(line)) {
                this.closeMemcachedChannel(channel, key);
                return true;
            }
            if (!NOTSTORED.equals(line)) {
                // empty if block
            }
        }
        catch (Exception e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, e, key);
            }
            this.closeMemcachedChannel(channel, key);
        }
        if (channel != null) {
            this.closeMemcachedChannel(channel, key);
        }
        return false;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private void closeMemcachedChannel(MemcachedChannel channel, String key) {
        block3: {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    if (this.errorHandler == null) break block3;
                    this.errorHandler.handleErrorOnSet(this, e, key);
                }
            }
        }
    }

    @Override
    public boolean isDynamic() {
        return this.source.isDynamic();
    }

    @Override
    public Object[] getMultiArray(String[] keys) {
        String cleanKey;
        if (keys == null || keys.length == 0) {
            return null;
        }
        Object[] rets = new Object[keys.length];
        boolean asString = false;
        StringBuilder cmdString = new StringBuilder().append("get");
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (key == null) continue;
            cleanKey = key;
            try {
                cleanKey = MemcachedUtils.sanitizeKey(this.sanitizeKeys, key);
            }
            catch (UnsupportedEncodingException e) {
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                continue;
            }
            cmdString.append(" ").append(cleanKey);
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(keys.length);
        this.doMulti(asString, cmdString, ret);
        for (int i = 0; i < keys.length; ++i) {
            cleanKey = keys[i];
            try {
                cleanKey = MemcachedUtils.sanitizeKey(this.sanitizeKeys, keys[i]);
            }
            catch (UnsupportedEncodingException e) {
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, keys[i]);
                continue;
            }
            if (!ret.containsKey(cleanKey)) continue;
            rets[i] = ret.get(cleanKey);
        }
        return rets;
    }

    private void doMulti(boolean asString, StringBuilder cmdString, Map<String, Object> ret) {
        if (cmdString == null || cmdString.toString().length() == 0 || ret == null) {
            return;
        }
        MemcachedChannel channel = null;
        try {
            channel = this.source.getMemcachedChannel();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (channel == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no channel to server available"), cmdString.toString());
            }
            return;
        }
        try {
            String line;
            channel.write(cmdString.append("\r\n").toString().getBytes());
            channel.flush();
            GetInputStreamWrapper getInputStreamWrapper = new GetInputStreamWrapper(channel);
            while ((line = getInputStreamWrapper.readKeys("")).startsWith(VALUE)) {
                Object o = null;
                String[] info = line.split(" ");
                String key = info[1];
                int flag = Integer.parseInt(info[2]);
                int length = Integer.parseInt(info[3]);
                byte[] buf = new byte[length];
                getInputStreamWrapper.read(buf);
                getInputStreamWrapper.clearEOL();
                if ((flag & 2) == 2) {
                    try {
                        int count;
                        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
                        byte[] tmp = new byte[2048];
                        while ((count = gzi.read(tmp)) != -1) {
                            bos.write(tmp, 0, count);
                        }
                        buf = bos.toByteArray();
                        gzi.close();
                    }
                    catch (IOException e) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                        }
                        throw new NestedIOException("IOException thrown while trying to uncompress input stream for key: " + key, e);
                    }
                }
                if ((flag & 8) != 8) {
                    if (this.primitiveAsString || asString) {
                        o = new String(buf, this.defaultEncoding);
                    } else {
                        try {
                            o = NativeHandler.decode(buf, flag);
                        }
                        catch (Exception e) {
                            if (this.errorHandler != null) {
                                this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                            }
                            throw new NestedIOException(e);
                        }
                    }
                } else {
                    ContextObjectInputStream ois = new ContextObjectInputStream(new ByteArrayInputStream(buf), this.classLoader);
                    try {
                        o = ois.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                        }
                        throw new NestedIOException("+++ failed while trying to deserialize for key: " + key, e);
                    }
                }
                ret.put(key, o);
            }
            if (!END.equals(line)) {
                channel.setHealth(true);
            }
            this.closeMemcachedChannel(channel, cmdString.toString());
            return;
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, cmdString.toString());
            }
            this.closeMemcachedChannel(channel, cmdString.toString());
            this.closeMemcachedChannel(channel, cmdString.toString());
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long decr(String key, long inc) {
        long lresult = -1L;
        String cmdName = "decr";
        try {
            key = MemcachedUtils.sanitizeKey(this.sanitizeKeys, key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler == null) return lresult;
            this.errorHandler.handleErrorOnSet(this, e, key);
            return lresult;
        }
        MemcachedChannel channel = null;
        try {
            channel = this.source.getMemcachedChannel();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (channel == null) {
            if (this.errorHandler == null) return lresult;
            this.errorHandler.handleErrorOnSet(this, new IOException("no channel to server available"), key);
            return lresult;
        }
        String cmd = String.format("%s %s %d\r\n", cmdName, key, inc);
        try {
            channel.write(cmd.getBytes());
            channel.flush();
            IncrOrDecrInputStreamWrapper inputStreamWrapper = new IncrOrDecrInputStreamWrapper(channel);
            String line = inputStreamWrapper.readLine();
            this.closeMemcachedChannel(channel, cmd.toString());
            if (line.matches("\\d+")) {
                try {
                    return Long.parseLong(line);
                }
                catch (Exception ex) {
                    if (this.errorHandler == null) return lresult;
                    this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)ex, key);
                }
                return lresult;
            }
            if (!NOTFOUND.equals(line)) return lresult;
        }
        catch (Exception e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
            }
            e.printStackTrace(System.err);
            this.closeMemcachedChannel(channel, cmd.toString());
        }
        return lresult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long incr(String key, long inc) {
        long lresult = -1L;
        String cmdName = "incr";
        try {
            key = MemcachedUtils.sanitizeKey(this.sanitizeKeys, key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler == null) return lresult;
            this.errorHandler.handleErrorOnSet(this, e, key);
            return lresult;
        }
        MemcachedChannel channel = null;
        try {
            channel = this.source.getMemcachedChannel();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (channel == null) {
            if (this.errorHandler == null) return lresult;
            this.errorHandler.handleErrorOnSet(this, new IOException("no channel to server available"), key);
            return lresult;
        }
        String cmd = String.format("%s %s %d\r\n", cmdName, key, inc);
        try {
            channel.write(cmd.getBytes());
            channel.flush();
            IncrOrDecrInputStreamWrapper inputStreamWrapper = new IncrOrDecrInputStreamWrapper(channel);
            String line = inputStreamWrapper.readLine();
            this.closeMemcachedChannel(channel, cmd.toString());
            if (line.matches("\\d+")) {
                try {
                    return Long.parseLong(line);
                }
                catch (Exception ex) {
                    if (this.errorHandler == null) return lresult;
                    this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)ex, key);
                }
                return lresult;
            }
            if (!NOTFOUND.equals(line)) return lresult;
        }
        catch (Exception e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
            }
            e.printStackTrace(System.err);
            this.closeMemcachedChannel(channel, cmd.toString());
        }
        return lresult;
    }
}

