/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.memcached;

import com.gemantic.dal.cache.Cache;
import com.gemantic.dal.cache.CacheFactory;
import com.gemantic.dal.cache.client.CacheClient;
import com.gemantic.dal.cache.impl.CacheImpl;
import com.gemantic.dal.cache.listener.Listener;
import com.gemantic.memcached.channel.source.MemcachedSource;
import com.gemantic.memcached.client.MemCachedClientImpl;
import com.gemantic.memcached.config.helper.CacheConfigHelper;
import com.gemantic.memcached.route.RoutingServiceImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFactoryImpl
implements CacheFactory {
    private static Logger logger = LoggerFactory.getLogger(CacheFactoryImpl.class);
    private static CacheFactory cacheFactory;
    private Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private MemcachedSource source;
    private MemcachedSource dSource;
    private Lock lock = new ReentrantLock(false);

    private CacheFactoryImpl() {
        this.init();
    }

    private void init() {
        this.source = CacheConfigHelper.getMemcachedSource("default");
        this.dSource = CacheConfigHelper.getDynamicMemcachedSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheFactory getInstance() {
        if (cacheFactory != null) return cacheFactory;
        Class<CacheFactoryImpl> clazz = CacheFactoryImpl.class;
        synchronized (CacheFactoryImpl.class) {
            if (cacheFactory != null) return cacheFactory;
            cacheFactory = new CacheFactoryImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cacheFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getCache(String name) {
        CacheClient cacheClient;
        Cache cache;
        block10: {
            cache = null;
            if (StringUtils.isBlank((String)name)) {
                logger.warn("cache name must have value");
                return null;
            }
            cache = this.caches.get(name);
            if (cache == null) {
                if (!CacheConfigHelper.isExistRegion(name)) {
                    return null;
                }
                this.lock.lock();
                try {
                    cache = this.caches.get(name);
                    if (cache != null || (cache = new CacheImpl(name, cacheClient = new MemCachedClientImpl(this.source), RoutingServiceImpl.getInstance())) == null) break block10;
                    String listenerClass = CacheConfigHelper.getListenerClass(name);
                    Listener listener = null;
                    if (StringUtils.isNotEmpty((String)listenerClass)) {
                        try {
                            listener = (Listener)Class.forName(listenerClass).newInstance();
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                            e.printStackTrace(System.err);
                        }
                    }
                    cache.regListener(listener);
                    ((CacheImpl)cache).setEnableLocalCache(CacheConfigHelper.isLocalCache(name));
                    ((CacheImpl)cache).setHasClassInfo(CacheConfigHelper.isHasClassInfo(name));
                    this.caches.put(name, cache);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        if (cache != null && (cacheClient = ((CacheImpl)cache).getClient()).isDynamic()) {
            throw new RuntimeException("Cache must is  singleness module");
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getCache(String name, boolean isDynamic) {
        CacheClient cacheClient;
        Cache cache;
        block13: {
            cache = null;
            if (StringUtils.isBlank((String)name)) {
                logger.warn("cache name must have value");
                return null;
            }
            cache = this.caches.get(name);
            if (cache == null) {
                if (!CacheConfigHelper.isExistRegion(name)) {
                    return null;
                }
                this.lock.lock();
                try {
                    cache = this.caches.get(name);
                    if (cache != null) break block13;
                    if (logger.isDebugEnabled()) {
                        logger.debug("cache not exist! begin create cache " + name);
                    }
                    cacheClient = new MemCachedClientImpl();
                    if (isDynamic) {
                        ((MemCachedClientImpl)cacheClient).setSource(this.dSource);
                    } else {
                        ((MemCachedClientImpl)cacheClient).setSource(this.source);
                    }
                    cache = new CacheImpl(name, cacheClient, RoutingServiceImpl.getInstance());
                    if (cache == null) break block13;
                    String listenerClass = CacheConfigHelper.getListenerClass(name);
                    Listener listener = null;
                    if (StringUtils.isNotEmpty((String)listenerClass)) {
                        try {
                            listener = (Listener)Class.forName(listenerClass).newInstance();
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                            e.printStackTrace(System.err);
                        }
                    }
                    cache.regListener(listener);
                    ((CacheImpl)cache).setEnableLocalCache(CacheConfigHelper.isLocalCache(name));
                    ((CacheImpl)cache).setHasClassInfo(CacheConfigHelper.isHasClassInfo(name));
                    this.caches.put(name, cache);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        if (cache != null && (cacheClient = ((CacheImpl)cache).getClient()).isDynamic() != isDynamic) {
            logger.info("cacheClient dynamic is : " + cacheClient.isDynamic() + " , request is " + isDynamic);
            throw new RuntimeException("Cache don't match specify Dynamic module");
        }
        return cache;
    }

    @Override
    public void removeCache(String name) {
        if (StringUtils.isNotEmpty((String)name)) {
            this.caches.remove(name);
        }
    }
}

