/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dmemcached.config.helper;

import com.gemantic.dal.cache.client.CacheClient;
import com.gemantic.dal.cache.config.model.KeyPatternItem;
import com.gemantic.dal.cache.config.model.RegionItem;
import com.gemantic.dmemcached.config.CacheConfig;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheConfigHelper {
    private static Logger logger = LoggerFactory.getLogger(CacheConfigHelper.class);

    public static Map<String, KeyPatternItem> getKeyKeyPatternItems(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            if (regionItem == null) {
                logger.error("don't find the " + regionName + " RegionItem in " + CacheConfig.CONFIG_FILE);
                return null;
            }
            return regionItem.getKeyPatternMap();
        }
        logger.error("region name must have a value");
        return null;
    }

    public static Map<String, KeyPatternItem> getDefaultKeyKeyPatternItems() {
        RegionItem regionItem = CacheConfig.getInstance().getDefaultRegionItem();
        if (regionItem == null) {
            logger.error("cannot find the default RegionItem in " + CacheConfig.CONFIG_FILE);
            return null;
        }
        return regionItem.getKeyPatternMap();
    }

    public static CacheClient getCacheClient(String name) {
        return StringUtils.isNotEmpty((String)name) ? CacheConfig.getInstance().getCacheClient(name) : null;
    }

    public static CacheClient getDynamicCacheClient() {
        return CacheConfig.getInstance().getDynamicCacheClient();
    }

    public static String getStrategyClassName(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            if (regionItem != null) {
                return regionItem.getStrategyClass();
            }
            logger.error("don't find regionName config: " + regionName);
            return null;
        }
        logger.error("regionName is null or empty");
        return null;
    }

    public static String getListenerClass(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            if (regionItem != null) {
                return regionItem.getListenerClass();
            }
            logger.error("don't find regionName config: " + regionName);
            return null;
        }
        logger.error("regionName is null or empty");
        return null;
    }

    public static boolean isExistRegion(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            return regionItem != null;
        }
        return false;
    }

    public static boolean isLocalCache(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            return regionItem == null ? false : regionItem.isLocalCache();
        }
        return false;
    }
}

