/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dmemcached.config;

import com.danga.MemCached.MemCachedClient;
import com.danga.MemCached.SockIOPool;
import com.gemantic.dal.cache.client.CacheClient;
import com.gemantic.dal.cache.config.model.DatasourceItem;
import com.gemantic.dal.cache.config.model.KeyPatternItem;
import com.gemantic.dal.cache.config.model.RegionItem;
import com.gemantic.dmemcached.client.DMemcachedClientWrapper;
import com.gemantic.dmemcached.client.MemcachedClientWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class CacheConfig {
    private static Logger logger = LoggerFactory.getLogger(CacheConfig.class);
    public static String CONFIG_FILE = "/memcached_client.xml";
    private static CacheConfig config;
    private Map<String, DatasourceItem> memcachedItemMap = new HashMap<String, DatasourceItem>();
    private Map<String, RegionItem> regionItemMap = new HashMap<String, RegionItem>();
    private Map<String, CacheClient> cacheClientMap = new HashMap<String, CacheClient>();
    private DMemcachedClientWrapper dynamicCachedClient = new DMemcachedClientWrapper();
    private RegionItem defaultRegionItem = null;

    public RegionItem getDefaultRegionItem() {
        return this.defaultRegionItem;
    }

    private CacheConfig() {
        try {
            this.init(this.getClass().getResourceAsStream(CONFIG_FILE));
            this.initDefaultRegion(this.getClass().getResourceAsStream(CONFIG_FILE));
            this.initDynamicMemcachedSource();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.out);
            }
            logger.error("init config file " + CONFIG_FILE + " error: " + e.getMessage());
        }
    }

    private void initDynamicMemcachedSource() {
        this.dynamicCachedClient.setClients(this.cacheClientMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheConfig getInstance() {
        if (config != null) return config;
        Class<CacheConfig> clazz = CacheConfig.class;
        synchronized (CacheConfig.class) {
            if (config != null) return config;
            config = new CacheConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }

    private void init(InputStream groupConfigFile) {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("root", ArrayList.class);
        digester.addObjectCreate("root/cache/", ArrayList.class.getName());
        digester.addObjectCreate("root/cache/datasource", DatasourceItem.class);
        digester.addSetProperties("root/cache/datasource");
        digester.addSetNext("root/cache/datasource", "add");
        digester.addSetNext("root/cache/", "add");
        digester.addObjectCreate("root/regions/", ArrayList.class.getName());
        digester.addObjectCreate("root/regions/region", RegionItem.class);
        digester.addSetProperties("root/regions/region");
        digester.addSetNext("root/regions/region", "add");
        digester.addObjectCreate("root/regions/region/keyPattern", KeyPatternItem.class);
        digester.addSetProperties("root/regions/region/keyPattern");
        digester.addSetNext("root/regions/region/keyPattern", "addKeyPatternItem");
        digester.addSetNext("root/regions/", "add");
        try {
            Object root = digester.parse(groupConfigFile);
            if (root != null && root instanceof ArrayList) {
                List list = (List)root;
                if (CollectionUtils.isEmpty((Collection)list)) {
                    return;
                }
                for (List arrayList : list) {
                    if (!CollectionUtils.isNotEmpty((Collection)arrayList)) continue;
                    for (Object item : arrayList) {
                        if (item == null) continue;
                        if (item instanceof DatasourceItem) {
                            this.addDatasourceItem((DatasourceItem)item);
                            continue;
                        }
                        if (!(item instanceof RegionItem)) continue;
                        this.addRegionItem((RegionItem)item);
                    }
                }
            }
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            } else {
                logger.error("init error: " + e.getMessage());
            }
        }
        catch (SAXException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            }
            logger.error("init parse fail : " + e.getMessage());
        }
    }

    private void initDefaultRegion(InputStream groupConfigFile) {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("root/default/region", RegionItem.class);
        digester.addSetProperties("root/default/region");
        digester.addObjectCreate("root/default/region/keyPattern", KeyPatternItem.class);
        digester.addSetProperties("root/default/region/keyPattern");
        digester.addSetNext("root/default/region/keyPattern", "addKeyPatternItem");
        try {
            Object root = digester.parse(groupConfigFile);
            if (root instanceof RegionItem) {
                this.defaultRegionItem = (RegionItem)root;
            }
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            } else {
                logger.error("initDefaultRegion error: " + e.getMessage());
            }
        }
        catch (SAXException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            }
            logger.error("initDefaultRegion parse fail : " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        System.out.println(CacheConfig.getInstance().getMemcachedItem("mem1"));
        System.out.println(CacheConfig.getInstance().getRegionItem("com.gemantic.analyse.dal.demo.model.Xueying"));
    }

    private void addDatasourceItem(DatasourceItem datasourceItem) {
        if (datasourceItem != null && StringUtils.isNotBlank((String)datasourceItem.getName())) {
            if (!this.memcachedItemMap.containsKey(datasourceItem.getName())) {
                this.memcachedItemMap.put(datasourceItem.getName(), datasourceItem);
                SockIOPool pool = SockIOPool.getInstance(datasourceItem.getName());
                pool.setServers(new String[]{datasourceItem.getServer() + ":" + datasourceItem.getPort()});
                pool.setInitConn(5);
                pool.setMinConn(5);
                pool.setMaxConn(datasourceItem.getMaxActive());
                pool.setSocketConnectTO(30000);
                pool.initialize();
                MemCachedClient client = new MemCachedClient(datasourceItem.getName());
                this.cacheClientMap.put(datasourceItem.getName(), new MemcachedClientWrapper(client));
            } else {
                logger.error("same name <" + datasourceItem.getName() + "> memcacheditem have exist!");
            }
        }
    }

    private void addRegionItem(RegionItem regionItem) {
        if (regionItem != null && StringUtils.isNotBlank((String)regionItem.getName())) {
            if (!this.regionItemMap.containsKey(regionItem.getName())) {
                this.regionItemMap.put(regionItem.getName(), regionItem);
            } else {
                logger.error("same name <" + regionItem.getName() + "> RegionItem have exist!");
            }
        }
    }

    public RegionItem getRegionItem(String regionName) {
        return this.regionItemMap.get(regionName);
    }

    public DatasourceItem getMemcachedItem(String memcachedItemName) {
        return this.memcachedItemMap.get(memcachedItemName);
    }

    public CacheClient getCacheClient(String name) {
        return this.cacheClientMap.get(name);
    }

    public Map<String, CacheClient> getCacheClientMap() {
        return this.cacheClientMap;
    }

    public CacheClient getDynamicCacheClient() {
        return this.dynamicCachedClient;
    }
}

