/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dmemcached.client;

import com.gemantic.dal.cache.client.CacheClient;
import com.gemantic.dal.cache.route.ContextHolder;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMemcachedClientWrapper
implements CacheClient {
    private Map<String, CacheClient> clients = null;
    private static Logger logger = LoggerFactory.getLogger(DMemcachedClientWrapper.class);

    public void setClients(Map<String, CacheClient> clients) {
        this.clients = clients;
    }

    @Override
    public boolean delete(String key) {
        CacheClient client = this.getCacheClient();
        if (client != null) {
            return client.delete(key);
        }
        logger.error("MemCachedClient is null");
        return false;
    }

    @Override
    public boolean remove(String key) {
        CacheClient client = this.getCacheClient();
        if (client != null) {
            return client.delete(key);
        }
        logger.error("MemCachedClient is null");
        return false;
    }

    @Override
    public boolean delete(String key, Date expiry) {
        CacheClient client = this.getCacheClient();
        if (client != null) {
            return client.delete(key, expiry);
        }
        logger.error("MemCachedClient is null");
        return false;
    }

    @Override
    public boolean flushAll() {
        CacheClient client = this.getCacheClient();
        if (client != null) {
            return client.flushAll();
        }
        logger.error("MemCachedClient is null");
        return false;
    }

    @Override
    public Object get(String key) {
        CacheClient client = this.getCacheClient();
        if (client != null) {
            return client.get(key);
        }
        logger.error("MemCachedClient is null");
        return null;
    }

    @Override
    public boolean replace(String key, Object value) {
        CacheClient client = this.getCacheClient();
        if (client != null) {
            return client.replace(key, value);
        }
        logger.error("MemCachedClient is null");
        return false;
    }

    @Override
    public boolean replace(String key, Object value, Date expiry) {
        CacheClient client = this.getCacheClient();
        if (client != null) {
            return client.replace(key, value, expiry);
        }
        logger.error("MemCachedClient is null");
        return false;
    }

    @Override
    public boolean set(String key, Object value) {
        CacheClient client = this.getCacheClient();
        if (client != null) {
            return client.set(key, value);
        }
        logger.error("MemCachedClient is null");
        return false;
    }

    @Override
    public boolean set(String key, Object value, Long expiry) {
        CacheClient client = this.getCacheClient();
        if (client != null) {
            return client.set(key, value, expiry);
        }
        logger.error("MemCachedClient is null");
        return false;
    }

    private CacheClient getCacheClient() {
        CacheClient client = null;
        if (MapUtils.isNotEmpty(this.clients)) {
            Object o = ContextHolder.getMemcachedName();
            CacheClient cacheClient = client = o == null ? null : this.clients.get(o);
            if (client == null) {
                client = this.clients.values().iterator().next();
            }
        } else {
            logger.error("Please set CacheClient Map");
        }
        return client;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public Object[] getMultiArray(String[] keys) {
        CacheClient client = this.getCacheClient();
        if (client != null) {
            return client.getMultiArray(keys);
        }
        logger.error("MemCachedClient is null");
        return null;
    }

    @Override
    public long decr(String key, long inc) {
        return 0L;
    }

    @Override
    public long incr(String key, long inc) {
        return 0L;
    }
}

