/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.cache.config.model;

import com.gemantic.dal.cache.config.model.KeyPatternItem;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionItem
implements Serializable {
    private static final long serialVersionUID = -2427500931734139981L;
    private static Logger logger = LoggerFactory.getLogger(RegionItem.class);
    private String name;
    private String listenerClass;
    private String strategyClass;
    private boolean hasClassInfo = true;
    private Map<String, KeyPatternItem> keyPatternMap = new HashMap<String, KeyPatternItem>();
    private boolean localCache;

    public boolean isLocalCache() {
        return this.localCache;
    }

    public void setLocalCache(boolean localCache) {
        this.localCache = localCache;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getListenerClass() {
        return this.listenerClass;
    }

    public void setListenerClass(String listenerClass) {
        this.listenerClass = listenerClass;
    }

    public Map<String, KeyPatternItem> getKeyPatternMap() {
        return this.keyPatternMap;
    }

    public void addKeyPatternItem(KeyPatternItem item) {
        if (item != null && StringUtils.isNotEmpty((String)item.getValue())) {
            if (!this.keyPatternMap.containsKey(item.getValue())) {
                this.keyPatternMap.put(item.getValue(), item);
            } else {
                logger.error("region: " + StringUtils.defaultIfEmpty((String)this.name, (String)"") + " same patternitem <" + item.getValue() + "> exist!");
            }
        } else {
            logger.error("KeyPatternItem object is null or value is null, please set in memcached_client.xml.");
        }
    }

    public String getStrategyClass() {
        return this.strategyClass;
    }

    public void setStrategyClass(String strategyClass) {
        this.strategyClass = strategyClass;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RegionItem[");
        buffer.append("keyPatternMap = ").append(this.keyPatternMap);
        buffer.append(",\n listenerClass = ").append(this.listenerClass);
        buffer.append(",\n localCache = ").append(this.localCache);
        buffer.append(",\n name = ").append(this.name);
        buffer.append(",\n strategyClass = ").append(this.strategyClass);
        buffer.append("]");
        return buffer.toString();
    }

    public boolean isHasClassInfo() {
        return this.hasClassInfo;
    }

    public void setHasClassInfo(boolean hasClassInfo) {
        this.hasClassInfo = hasClassInfo;
    }
}

