/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheUtil {
    private static Logger logger = LoggerFactory.getLogger(CacheUtil.class);
    private static final String DELIMITER = "_";
    private static Map<String, String> shortNameMap = new ConcurrentHashMap<String, String>();
    private static final String DELETE_SUFFIX = "delmark";

    public static String keyEncode(String regionName, String sKey) {
        return CacheUtil.shortRegionName(regionName) + DELIMITER + sKey;
    }

    public static String keyDecode(String regionName, String keyEncode) {
        String sResult;
        String shortName = CacheUtil.shortRegionName(regionName);
        if (shortName.equals(sResult = keyEncode.substring(0, Math.min(shortName.length(), keyEncode.length())))) {
            return keyEncode.substring(shortName.length() + DELIMITER.length());
        }
        logger.error("don't decode keyEncode " + keyEncode);
        return null;
    }

    public static String shortRegionName(String regionName) {
        String shortName = shortNameMap.get(regionName);
        if (shortName != null) {
            return shortName;
        }
        int iPos = regionName.lastIndexOf(".");
        if (iPos > 0) {
            String sTemp = regionName.substring(iPos + 1);
            shortNameMap.put(regionName, sTemp);
            return sTemp;
        }
        return regionName;
    }

    public static String delMarkKey(String regionName, String sKey) {
        return CacheUtil.shortRegionName(regionName) + DELIMITER + sKey + DELIMITER + DELETE_SUFFIX;
    }

    public static void main(String[] args) {
        System.out.println(CacheUtil.keyEncode("com.sohu.com.photo", "156"));
        System.out.println(CacheUtil.delMarkKey("com.sohu.com.photo", "1"));
        System.out.println(CacheUtil.keyDecode("com.sohu.com.photo", "photo_156"));
        System.out.println(CacheUtil.shortRegionName("com.sohu.com.photo"));
    }
}

