/*
 * Decompiled with CFR 0.152.
 */
package com.danga.MemCached;

import com.danga.MemCached.LineInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SockIOPool {
    private static Logger log = LoggerFactory.getLogger((String)SockIOPool.class.getName());
    private static Map<String, SockIOPool> pools = new HashMap<String, SockIOPool>();
    private static ThreadLocal<MessageDigest> MD5 = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                log.error("++++ no md5 algorithm found");
                throw new IllegalStateException("++++ no md5 algorythm found");
            }
        }
    };
    private static final Integer ZERO = new Integer(0);
    public static final int NATIVE_HASH = 0;
    public static final int OLD_COMPAT_HASH = 1;
    public static final int NEW_COMPAT_HASH = 2;
    public static final int CONSISTENT_HASH = 3;
    public static final long MAX_RETRY_DELAY = 600000L;
    private MaintThread maintThread;
    private boolean initialized = false;
    private int maxCreate = 1;
    private int poolMultiplier = 3;
    private int initConn = 1;
    private int minConn = 1;
    private int maxConn = 10;
    private long maxIdle = 300000L;
    private long maxBusyTime = 30000L;
    private long maintSleep = 30000L;
    private int socketTO = 30000;
    private int socketConnectTO = 3000;
    private boolean aliveCheck = false;
    private boolean failover = true;
    private boolean failback = true;
    private boolean nagle = true;
    private int hashingAlg = 0;
    private final ReentrantLock hostDeadLock = new ReentrantLock();
    private String[] servers;
    private Integer[] weights;
    private Integer totalWeight = 0;
    private List<String> buckets;
    private TreeMap<Long, String> consistentBuckets;
    private Map<String, Date> hostDead;
    private Map<String, Long> hostDeadDur;
    private Map<String, Map<SockIO, Long>> availPool;
    private Map<String, Map<SockIO, Long>> busyPool;
    private Map<SockIO, Integer> deadPool;

    protected SockIOPool() {
    }

    public static synchronized SockIOPool getInstance(String poolName) {
        if (pools.containsKey(poolName)) {
            return pools.get(poolName);
        }
        SockIOPool pool = new SockIOPool();
        pools.put(poolName, pool);
        return pool;
    }

    public static SockIOPool getInstance() {
        return SockIOPool.getInstance("default");
    }

    public void setServers(String[] servers) {
        this.servers = servers;
    }

    public String[] getServers() {
        return this.servers;
    }

    public void setWeights(Integer[] weights) {
        this.weights = weights;
    }

    public Integer[] getWeights() {
        return this.weights;
    }

    public void setInitConn(int initConn) {
        this.initConn = initConn;
    }

    public int getInitConn() {
        return this.initConn;
    }

    public void setMinConn(int minConn) {
        this.minConn = minConn;
    }

    public int getMinConn() {
        return this.minConn;
    }

    public void setMaxConn(int maxConn) {
        this.maxConn = maxConn;
    }

    public int getMaxConn() {
        return this.maxConn;
    }

    public void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    public long getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxBusyTime(long maxBusyTime) {
        this.maxBusyTime = maxBusyTime;
    }

    public long getMaxBusy() {
        return this.maxBusyTime;
    }

    public void setMaintSleep(long maintSleep) {
        this.maintSleep = maintSleep;
    }

    public long getMaintSleep() {
        return this.maintSleep;
    }

    public void setSocketTO(int socketTO) {
        this.socketTO = socketTO;
    }

    public int getSocketTO() {
        return this.socketTO;
    }

    public void setSocketConnectTO(int socketConnectTO) {
        this.socketConnectTO = socketConnectTO;
    }

    public int getSocketConnectTO() {
        return this.socketConnectTO;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    public boolean getFailover() {
        return this.failover;
    }

    public void setFailback(boolean failback) {
        this.failback = failback;
    }

    public boolean getFailback() {
        return this.failback;
    }

    public void setAliveCheck(boolean aliveCheck) {
        this.aliveCheck = aliveCheck;
    }

    public boolean getAliveCheck() {
        return this.aliveCheck;
    }

    public void setNagle(boolean nagle) {
        this.nagle = nagle;
    }

    public boolean getNagle() {
        return this.nagle;
    }

    public void setHashingAlg(int alg) {
        this.hashingAlg = alg;
    }

    public int getHashingAlg() {
        return this.hashingAlg;
    }

    private static long origCompatHashingAlg(String key) {
        long hash = 0L;
        char[] cArr = key.toCharArray();
        for (int i = 0; i < cArr.length; ++i) {
            hash = hash * 33L + (long)cArr[i];
        }
        return hash;
    }

    private static long newCompatHashingAlg(String key) {
        CRC32 checksum = new CRC32();
        checksum.update(key.getBytes());
        long crc = checksum.getValue();
        return crc >> 16 & 0x7FFFL;
    }

    private static long md5HashingAlg(String key) {
        MessageDigest md5 = MD5.get();
        md5.reset();
        md5.update(key.getBytes());
        byte[] bKey = md5.digest();
        long res = (long)(bKey[3] & 0xFF) << 24 | (long)(bKey[2] & 0xFF) << 16 | (long)(bKey[1] & 0xFF) << 8 | (long)(bKey[0] & 0xFF);
        return res;
    }

    private long getHash(String key, Integer hashCode) {
        if (hashCode != null) {
            if (this.hashingAlg == 3) {
                return hashCode.longValue() & 0xFFFFFFFFL;
            }
            return hashCode.longValue();
        }
        switch (this.hashingAlg) {
            case 0: {
                return key.hashCode();
            }
            case 1: {
                return SockIOPool.origCompatHashingAlg(key);
            }
            case 2: {
                return SockIOPool.newCompatHashingAlg(key);
            }
            case 3: {
                return SockIOPool.md5HashingAlg(key);
            }
        }
        this.hashingAlg = 0;
        return key.hashCode();
    }

    private long getBucket(String key, Integer hashCode) {
        long hc = this.getHash(key, hashCode);
        if (this.hashingAlg == 3) {
            return this.findPointFor(hc);
        }
        long bucket = hc % (long)this.buckets.size();
        if (bucket < 0L) {
            bucket *= -1L;
        }
        return bucket;
    }

    private Long findPointFor(Long hv) {
        SortedMap<Long, String> tmap = this.consistentBuckets.tailMap(hv);
        return tmap.isEmpty() ? this.consistentBuckets.firstKey() : tmap.firstKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        SockIOPool sockIOPool = this;
        synchronized (sockIOPool) {
            if (this.initialized && (this.buckets != null || this.consistentBuckets != null) && this.availPool != null && this.busyPool != null) {
                log.error("++++ trying to initialize an already initialized pool");
                return;
            }
            this.availPool = new HashMap<String, Map<SockIO, Long>>(this.servers.length * this.initConn);
            this.busyPool = new HashMap<String, Map<SockIO, Long>>(this.servers.length * this.initConn);
            this.deadPool = new IdentityHashMap<SockIO, Integer>();
            this.hostDeadDur = new HashMap<String, Long>();
            this.hostDead = new HashMap<String, Date>();
            int n = this.maxCreate = this.poolMultiplier > this.minConn ? this.minConn : this.minConn / this.poolMultiplier;
            if (log.isDebugEnabled()) {
                log.debug("++++ initializing pool with following settings:");
                log.debug("++++ initial size: " + this.initConn);
                log.debug("++++ min spare   : " + this.minConn);
                log.debug("++++ max spare   : " + this.maxConn);
            }
            if (this.servers == null || this.servers.length <= 0) {
                log.error("++++ trying to initialize with no servers");
                throw new IllegalStateException("++++ trying to initialize with no servers");
            }
            if (this.hashingAlg == 3) {
                this.populateConsistentBuckets();
            } else {
                this.populateBuckets();
            }
            this.initialized = true;
            if (this.maintSleep > 0L) {
                this.startMaintThread();
            }
        }
    }

    private void populateBuckets() {
        if (log.isDebugEnabled()) {
            log.debug("++++ initializing internal hashing structure for consistent hashing");
        }
        this.buckets = new ArrayList<String>();
        block0: for (int i = 0; i < this.servers.length; ++i) {
            if (this.weights != null && this.weights.length > i) {
                for (int k = 0; k < this.weights[i]; ++k) {
                    this.buckets.add(this.servers[i]);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("++++ added " + this.servers[i] + " to server bucket");
                }
            } else {
                this.buckets.add(this.servers[i]);
                if (log.isDebugEnabled()) {
                    log.debug("++++ added " + this.servers[i] + " to server bucket");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("+++ creating initial connections (" + this.initConn + ") for host: " + this.servers[i]);
            }
            for (int j = 0; j < this.initConn; ++j) {
                SockIO socket = this.createSocket(this.servers[i]);
                if (socket == null) {
                    log.error("++++ failed to create connection to: " + this.servers[i] + " -- only " + j + " created.");
                    continue block0;
                }
                this.addSocketToPool(this.availPool, this.servers[i], socket);
                if (!log.isDebugEnabled()) continue;
                log.debug("++++ created and added socket: " + socket.toString() + " for host " + this.servers[i]);
            }
        }
    }

    private void populateConsistentBuckets() {
        int i;
        if (log.isDebugEnabled()) {
            log.debug("++++ initializing internal hashing structure for consistent hashing");
        }
        this.consistentBuckets = new TreeMap();
        MessageDigest md5 = MD5.get();
        if (this.totalWeight <= 0 && this.weights != null) {
            for (i = 0; i < this.weights.length; ++i) {
                SockIOPool sockIOPool = this;
                Integer.valueOf(sockIOPool.totalWeight + (this.weights[i] == null ? 1 : this.weights[i]));
                sockIOPool.totalWeight = sockIOPool.totalWeight;
            }
        } else if (this.weights == null) {
            this.totalWeight = this.servers.length;
        }
        block1: for (i = 0; i < this.servers.length; ++i) {
            int thisWeight = 1;
            if (this.weights != null && this.weights[i] != null) {
                thisWeight = this.weights[i];
            }
            double factor = Math.floor((double)(40 * this.servers.length * thisWeight) / (double)this.totalWeight.intValue());
            long j = 0L;
            while ((double)j < factor) {
                byte[] d = md5.digest((this.servers[i] + "-" + j).getBytes());
                for (int h = 0; h < 4; ++h) {
                    Long k = (long)(d[3 + h * 4] & 0xFF) << 24 | (long)(d[2 + h * 4] & 0xFF) << 16 | (long)(d[1 + h * 4] & 0xFF) << 8 | (long)(d[0 + h * 4] & 0xFF);
                    this.consistentBuckets.put(k, this.servers[i]);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("++++ added " + this.servers[i] + " to server bucket");
                }
                ++j;
            }
            if (log.isDebugEnabled()) {
                log.debug("+++ creating initial connections (" + this.initConn + ") for host: " + this.servers[i]);
            }
            for (int j2 = 0; j2 < this.initConn; ++j2) {
                SockIO socket = this.createSocket(this.servers[i]);
                if (socket == null) {
                    log.error("++++ failed to create connection to: " + this.servers[i] + " -- only " + j2 + " created.");
                    continue block1;
                }
                this.addSocketToPool(this.availPool, this.servers[i], socket);
                if (!log.isDebugEnabled()) continue;
                log.debug("++++ created and added socket: " + socket.toString() + " for host " + this.servers[i]);
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SockIO createSocket(String host) {
        long expire;
        SockIO socket = null;
        this.hostDeadLock.lock();
        try {
            if (this.failover && this.failback && this.hostDead.containsKey(host) && this.hostDeadDur.containsKey(host)) {
                Date store = this.hostDead.get(host);
                expire = this.hostDeadDur.get(host);
                if (store.getTime() + expire > System.currentTimeMillis()) {
                    SockIO sockIO = null;
                    return sockIO;
                }
            }
        }
        finally {
            this.hostDeadLock.unlock();
        }
        try {
            socket = new SockIO(this, host, this.socketTO, this.socketConnectTO, this.nagle);
            if (!socket.isConnected()) {
                log.error("++++ failed to get SockIO obj for: " + host + " -- new socket is not connected");
                this.deadPool.put(socket, ZERO);
                socket = null;
            }
        }
        catch (Exception ex) {
            log.error("++++ failed to get SockIO obj for: " + host);
            log.error(ex.getMessage(), (Throwable)ex);
            socket = null;
        }
        this.hostDeadLock.lock();
        try {
            if (socket == null) {
                Date now = new Date();
                this.hostDead.put(host, now);
                long l = expire = this.hostDeadDur.containsKey(host) ? this.hostDeadDur.get(host) * 2L : 1000L;
                if (expire > 600000L) {
                    expire = 600000L;
                }
                this.hostDeadDur.put(host, new Long(expire));
                if (log.isDebugEnabled()) {
                    log.debug("++++ ignoring dead host: " + host + " for " + expire + " ms");
                }
                this.clearHostFromPool(this.availPool, host);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("++++ created socket (" + socket.toString() + ") for host: " + host);
                }
                if (this.hostDead.containsKey(host) || this.hostDeadDur.containsKey(host)) {
                    this.hostDead.remove(host);
                    this.hostDeadDur.remove(host);
                }
            }
        }
        finally {
            this.hostDeadLock.unlock();
        }
        return socket;
    }

    public String getHost(String key) {
        return this.getHost(key, null);
    }

    public String getHost(String key, Integer hashcode) {
        SockIO socket = this.getSock(key, hashcode);
        String host = socket.getHost();
        socket.close();
        return host;
    }

    public SockIO getSock(String key) {
        return this.getSock(key, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SockIO getSock(String key, Integer hashCode) {
        if (log.isDebugEnabled()) {
            log.debug("cache socket pick " + key + " " + hashCode);
        }
        if (!this.initialized) {
            log.error("attempting to get SockIO from uninitialized pool!");
            return null;
        }
        if (this.hashingAlg == 3) {
            if (this.consistentBuckets.size() == 0) return null;
        }
        if (this.buckets != null && this.buckets.size() == 0) {
            return null;
        }
        if (this.hashingAlg == 3 && this.consistentBuckets.size() == 0 || this.buckets != null && this.buckets.size() == 1) {
            SockIO sock;
            SockIO sockIO = sock = this.hashingAlg == 3 ? this.getConnection(this.consistentBuckets.get(this.consistentBuckets.firstKey())) : this.getConnection(this.buckets.get(0));
            if (sock != null && sock.isConnected()) {
                if (!this.aliveCheck) return sock;
                if (sock.isAlive()) return sock;
                sock.close();
                try {
                    sock.trueClose();
                    return null;
                }
                catch (IOException ioe) {
                    log.error("failed to close dead socket");
                }
                return null;
            }
            if (sock == null) return sock;
            this.deadPool.put(sock, ZERO);
            return null;
        }
        HashSet<String> tryServers = new HashSet<String>(Arrays.asList(this.servers));
        long bucket = this.getBucket(key, hashCode);
        String server = this.hashingAlg == 3 ? this.consistentBuckets.get(bucket) : this.buckets.get((int)bucket);
        block4: while (!tryServers.isEmpty()) {
            SockIO sock = this.getConnection(server);
            if (log.isDebugEnabled()) {
                log.debug("cache choose " + server + " for " + key);
            }
            if (sock != null && sock.isConnected()) {
                if (!this.aliveCheck) return sock;
                if (sock.isAlive()) {
                    return sock;
                }
                sock.close();
                try {
                    sock.trueClose();
                }
                catch (IOException ioe) {
                    log.error("failed to close dead socket");
                }
                sock = null;
            } else if (sock != null) {
                this.deadPool.put(sock, ZERO);
                sock = null;
            }
            if (!this.failover) {
                return null;
            }
            tryServers.remove(server);
            if (tryServers.isEmpty()) return null;
            int rehashTries = 0;
            while (true) {
                if (tryServers.contains(server)) continue block4;
                String newKey = String.format("%s%s", rehashTries, key);
                if (log.isDebugEnabled()) {
                    log.debug("rehashing with: " + newKey);
                }
                bucket = this.getBucket(newKey, null);
                server = this.hashingAlg == 3 ? this.consistentBuckets.get(bucket) : this.buckets.get((int)bucket);
                ++rehashTries;
            }
            break;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SockIO getConnection(String host) {
        if (!this.initialized) {
            log.error("attempting to get SockIO from uninitialized pool!");
            return null;
        }
        if (host == null) {
            return null;
        }
        SockIOPool sockIOPool = this;
        synchronized (sockIOPool) {
            Map<SockIO, Long> aSockets;
            if (this.availPool != null && !this.availPool.isEmpty() && (aSockets = this.availPool.get(host)) != null && !aSockets.isEmpty()) {
                Iterator<SockIO> i = aSockets.keySet().iterator();
                while (i.hasNext()) {
                    SockIO socket = i.next();
                    if (socket.isConnected()) {
                        if (log.isDebugEnabled()) {
                            log.debug("++++ moving socket for host (" + host + ") to busy pool ... socket: " + socket);
                        }
                        i.remove();
                        this.addSocketToPool(this.busyPool, host, socket);
                        return socket;
                    }
                    this.deadPool.put(socket, ZERO);
                    i.remove();
                }
            }
        }
        SockIO socket = this.createSocket(host);
        if (socket != null) {
            SockIOPool sockIOPool2 = this;
            synchronized (sockIOPool2) {
                this.addSocketToPool(this.busyPool, host, socket);
            }
        }
        return socket;
    }

    protected void addSocketToPool(Map<String, Map<SockIO, Long>> pool, String host, SockIO socket) {
        Map<Object, Object> sockets;
        if (pool.containsKey(host) && (sockets = pool.get(host)) != null) {
            sockets.put(socket, new Long(System.currentTimeMillis()));
            return;
        }
        sockets = new IdentityHashMap();
        sockets.put(socket, new Long(System.currentTimeMillis()));
        pool.put(host, sockets);
    }

    protected void removeSocketFromPool(Map<String, Map<SockIO, Long>> pool, String host, SockIO socket) {
        Map<SockIO, Long> sockets;
        if (pool.containsKey(host) && (sockets = pool.get(host)) != null) {
            sockets.remove(socket);
        }
    }

    protected void clearHostFromPool(Map<String, Map<SockIO, Long>> pool, String host) {
        Map<SockIO, Long> sockets;
        if (pool.containsKey(host) && (sockets = pool.get(host)) != null && sockets.size() > 0) {
            Iterator<SockIO> i = sockets.keySet().iterator();
            while (i.hasNext()) {
                SockIO socket = i.next();
                try {
                    socket.trueClose();
                }
                catch (IOException ioe) {
                    log.error("++++ failed to close socket: " + ioe.getMessage());
                }
                i.remove();
                socket = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIn(SockIO socket, boolean addToAvail) {
        String host = socket.getHost();
        if (log.isDebugEnabled()) {
            log.debug("++++ calling check-in on socket: " + socket.toString() + " for host: " + host);
        }
        SockIOPool sockIOPool = this;
        synchronized (sockIOPool) {
            if (log.isDebugEnabled()) {
                log.debug("++++ removing socket (" + socket.toString() + ") from busy pool for host: " + host);
            }
            this.removeSocketFromPool(this.busyPool, host, socket);
            if (socket.isConnected() && addToAvail) {
                if (log.isDebugEnabled()) {
                    log.debug("++++ returning socket (" + socket.toString() + " to avail pool for host: " + host);
                }
                this.addSocketToPool(this.availPool, host, socket);
            } else {
                this.deadPool.put(socket, ZERO);
                socket = null;
            }
        }
    }

    private void checkIn(SockIO socket) {
        this.checkIn(socket, true);
    }

    protected void closePool(Map<String, Map<SockIO, Long>> pool) {
        for (String host : pool.keySet()) {
            Map<SockIO, Long> sockets = pool.get(host);
            Iterator<SockIO> j = sockets.keySet().iterator();
            while (j.hasNext()) {
                SockIO socket = j.next();
                try {
                    socket.trueClose();
                }
                catch (IOException ioe) {
                    log.error("++++ failed to trueClose socket: " + socket.toString() + " for host: " + host);
                }
                j.remove();
                socket = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        SockIOPool sockIOPool = this;
        synchronized (sockIOPool) {
            if (log.isDebugEnabled()) {
                log.debug("++++ SockIOPool shutting down...");
            }
            if (this.maintThread != null && this.maintThread.isRunning()) {
                this.stopMaintThread();
                while (this.maintThread.isRunning()) {
                    if (log.isDebugEnabled()) {
                        log.debug("++++ waiting for main thread to finish run +++");
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("++++ closing all internal pools.");
            }
            this.closePool(this.availPool);
            this.closePool(this.busyPool);
            this.availPool = null;
            this.busyPool = null;
            this.buckets = null;
            this.consistentBuckets = null;
            this.hostDeadDur = null;
            this.hostDead = null;
            this.maintThread = null;
            this.initialized = false;
            if (log.isDebugEnabled()) {
                log.debug("++++ SockIOPool finished shutting down.");
            }
        }
    }

    protected void startMaintThread() {
        if (this.maintThread != null) {
            if (this.maintThread.isRunning()) {
                log.error("main thread already running");
            } else {
                this.maintThread.start();
            }
        } else {
            this.maintThread = new MaintThread(this);
            this.maintThread.setInterval(this.maintSleep);
            this.maintThread.start();
        }
    }

    protected void stopMaintThread() {
        if (this.maintThread != null && this.maintThread.isRunning()) {
            this.maintThread.stopThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selfMaint() {
        Set<SockIO> toClose;
        if (log.isDebugEnabled()) {
            log.debug("++++ Starting self maintenance....");
        }
        HashMap<String, Integer> needSockets = new HashMap<String, Integer>();
        SockIOPool sockIOPool = this;
        synchronized (sockIOPool) {
            for (String map : this.availPool.keySet()) {
                Map<SockIO, Long> sockets = this.availPool.get(map);
                if (log.isDebugEnabled()) {
                    log.debug("++++ Size of avail pool for host (" + map + ") = " + sockets.size());
                }
                if (sockets.size() >= this.minConn) continue;
                int need = this.minConn - sockets.size();
                needSockets.put(map, need);
            }
        }
        HashMap newSockets = new HashMap();
        for (String string : needSockets.keySet()) {
            SockIO socket;
            Integer need = (Integer)needSockets.get(string);
            if (log.isDebugEnabled()) {
                log.debug("++++ Need to create " + need + " new sockets for pool for host: " + string);
            }
            HashSet<SockIO> newSock = new HashSet<SockIO>(need);
            for (int j = 0; j < need && (socket = this.createSocket(string)) != null; ++j) {
                newSock.add(socket);
            }
            newSockets.put(string, newSock);
        }
        SockIOPool i = this;
        synchronized (i) {
            for (String host : newSockets.keySet()) {
                Set sockets = (Set)newSockets.get(host);
                for (SockIO socket : sockets) {
                    this.addSocketToPool(this.availPool, host, socket);
                }
            }
            for (String host : this.availPool.keySet()) {
                int needToClose;
                Map<SockIO, Long> sockets = this.availPool.get(host);
                if (log.isDebugEnabled()) {
                    log.debug("++++ Size of avail pool for host (" + host + ") = " + sockets.size());
                }
                if (sockets.size() <= this.maxConn) continue;
                int diff = sockets.size() - this.maxConn;
                int n = needToClose = diff <= this.poolMultiplier ? diff : diff / this.poolMultiplier;
                if (log.isDebugEnabled()) {
                    log.debug("++++ need to remove " + needToClose + " spare sockets for pool for host: " + host);
                }
                Iterator<SockIO> j = sockets.keySet().iterator();
                while (j.hasNext() && needToClose > 0) {
                    SockIO socket = j.next();
                    long expire = sockets.get(socket);
                    if (expire + this.maxIdle >= System.currentTimeMillis()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("+++ removing stale entry from pool as it is past its idle timeout and pool is over max spare");
                    }
                    this.deadPool.put(socket, ZERO);
                    j.remove();
                    --needToClose;
                }
            }
            for (String host : this.busyPool.keySet()) {
                Map<SockIO, Long> sockets = this.busyPool.get(host);
                if (log.isDebugEnabled()) {
                    log.debug("++++ Size of busy pool for host (" + host + ")  = " + sockets.size());
                }
                Iterator<SockIO> j = sockets.keySet().iterator();
                while (j.hasNext()) {
                    SockIO socket = j.next();
                    long hungTime = sockets.get(socket);
                    if (hungTime + this.maxBusyTime >= System.currentTimeMillis()) continue;
                    log.error("+++ removing potentially hung connection from busy pool ... socket in pool for " + (System.currentTimeMillis() - hungTime) + "ms");
                    this.deadPool.put(socket, ZERO);
                    j.remove();
                }
            }
        }
        Map<SockIO, Integer> map = this.deadPool;
        synchronized (map) {
            toClose = this.deadPool.keySet();
            this.deadPool = new IdentityHashMap<SockIO, Integer>();
        }
        for (SockIO socket : toClose) {
            try {
                socket.trueClose(false);
            }
            catch (Exception ex) {
                log.error("++++ failed to close SockIO obj from deadPool");
                log.error(ex.getMessage(), (Throwable)ex);
            }
            socket = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("+++ ending self maintenance.");
        }
    }

    public static class SockIO
    implements LineInputStream {
        private static Logger log = LoggerFactory.getLogger((String)SockIO.class.getName());
        private SockIOPool pool;
        private String host;
        private Socket sock;
        private DataInputStream in;
        private BufferedOutputStream out;

        public SockIO(SockIOPool pool, String host, int port, int timeout, int connectTimeout, boolean noDelay) throws IOException, UnknownHostException {
            this.pool = pool;
            this.sock = SockIO.getSocket(host, port, connectTimeout);
            if (timeout >= 0) {
                this.sock.setSoTimeout(timeout);
            }
            this.sock.setTcpNoDelay(noDelay);
            this.in = new DataInputStream(this.sock.getInputStream());
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
            this.host = host + ":" + port;
        }

        public SockIO(SockIOPool pool, String host, int timeout, int connectTimeout, boolean noDelay) throws IOException, UnknownHostException {
            this.pool = pool;
            String[] ip = host.split(":");
            this.sock = SockIO.getSocket(ip[0], Integer.parseInt(ip[1]), connectTimeout);
            if (timeout >= 0) {
                this.sock.setSoTimeout(timeout);
            }
            this.sock.setTcpNoDelay(noDelay);
            this.in = new DataInputStream(this.sock.getInputStream());
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
            this.host = host;
        }

        protected static Socket getSocket(String host, int port, int timeout) throws IOException {
            SocketChannel sock = SocketChannel.open();
            sock.socket().connect(new InetSocketAddress(host, port), timeout);
            return sock.socket();
        }

        public SocketChannel getChannel() {
            return this.sock.getChannel();
        }

        public String getHost() {
            return this.host;
        }

        public void trueClose() throws IOException {
            this.trueClose(true);
        }

        public void trueClose(boolean addToDeadPool) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug("++++ Closing socket for real: " + this.toString());
            }
            boolean err = false;
            StringBuilder errMsg = new StringBuilder();
            if (this.in == null || this.out == null || this.sock == null) {
                err = true;
                errMsg.append("++++ socket or its streams already null in trueClose call");
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {
                    log.error("++++ error closing input stream for socket: " + this.toString() + " for host: " + this.getHost());
                    log.error(ioe.getMessage(), (Throwable)ioe);
                    errMsg.append("++++ error closing input stream for socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    errMsg.append(ioe.getMessage());
                    err = true;
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException ioe) {
                    log.error("++++ error closing output stream for socket: " + this.toString() + " for host: " + this.getHost());
                    log.error(ioe.getMessage(), (Throwable)ioe);
                    errMsg.append("++++ error closing output stream for socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    errMsg.append(ioe.getMessage());
                    err = true;
                }
            }
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException ioe) {
                    log.error("++++ error closing socket: " + this.toString() + " for host: " + this.getHost());
                    log.error(ioe.getMessage(), (Throwable)ioe);
                    errMsg.append("++++ error closing socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    errMsg.append(ioe.getMessage());
                    err = true;
                }
            }
            if (addToDeadPool && this.sock != null) {
                this.pool.checkIn(this, false);
            }
            this.in = null;
            this.out = null;
            this.sock = null;
            if (err) {
                throw new IOException(errMsg.toString());
            }
        }

        void close() {
            if (log.isDebugEnabled()) {
                log.debug("++++ marking socket (" + this.toString() + ") as closed and available to return to avail pool");
            }
            this.pool.checkIn(this);
        }

        boolean isConnected() {
            return this.sock != null && this.sock.isConnected();
        }

        boolean isAlive() {
            if (!this.isConnected()) {
                return false;
            }
            try {
                this.write("version\r\n".getBytes());
                this.flush();
                String string = this.readLine();
            }
            catch (IOException ex) {
                return false;
            }
            return true;
        }

        @Override
        public String readLine() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            byte[] b = new byte[1];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            boolean eol = false;
            while (this.in.read(b, 0, 1) != -1) {
                if (b[0] == 13) {
                    eol = true;
                } else if (eol) {
                    if (b[0] == 10) break;
                    eol = false;
                }
                bos.write(b, 0, 1);
            }
            if (bos == null || bos.size() <= 0) {
                throw new IOException("++++ Stream appears to be dead, so closing it down");
            }
            return bos.toString().trim();
        }

        @Override
        public void clearEOL() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            byte[] b = new byte[1];
            boolean eol = false;
            while (this.in.read(b, 0, 1) != -1) {
                if (b[0] == 13) {
                    eol = true;
                    continue;
                }
                if (!eol) continue;
                if (b[0] == 10) break;
                eol = false;
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            int count;
            int cnt;
            if (this.sock == null || !this.sock.isConnected()) {
                log.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            for (count = 0; count < b.length; count += cnt) {
                cnt = this.in.read(b, count, b.length - count);
            }
            return count;
        }

        void flush() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error("++++ attempting to write to closed socket");
                throw new IOException("++++ attempting to write to closed socket");
            }
            this.out.flush();
        }

        void write(byte[] b) throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error("++++ attempting to write to closed socket");
                throw new IOException("++++ attempting to write to closed socket");
            }
            this.out.write(b);
        }

        public int hashCode() {
            return this.sock == null ? 0 : this.sock.hashCode();
        }

        public String toString() {
            return this.sock == null ? "" : this.sock.toString();
        }

        protected void finalize() throws Throwable {
            try {
                if (this.sock != null) {
                    log.error("++++ closing potentially leaked socket in finalize");
                    this.sock.close();
                    this.sock = null;
                }
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
            finally {
                super.finalize();
            }
        }
    }

    protected static class MaintThread
    extends Thread {
        private static Logger log = LoggerFactory.getLogger((String)MaintThread.class.getName());
        private SockIOPool pool;
        private long interval = 3000L;
        private boolean stopThread = false;
        private boolean running;

        protected MaintThread(SockIOPool pool) {
            this.pool = pool;
            this.setDaemon(true);
            this.setName("MaintThread");
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void stopThread() {
            this.stopThread = true;
            this.interrupt();
        }

        @Override
        public void run() {
            this.running = true;
            while (!this.stopThread) {
                try {
                    Thread.sleep(this.interval);
                    if (!this.pool.isInitialized()) continue;
                    this.pool.selfMaint();
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
            this.running = false;
        }
    }
}

