/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao;

import com.gemantic.dal.cache.Cache;
import com.gemantic.dal.dao.cachehandler.ListHandler;
import com.gemantic.dal.dao.cachehandler.impl.CommonListHandler;
import com.gemantic.dal.dao.cachehandler.impl.CrossListHandler;
import com.gemantic.dal.dao.helper.LsCacheInfoHelper;
import com.gemantic.dal.dao.model.SectionInfo;
import com.gemantic.dal.dao.model.UpdateInfo;
import com.gemantic.dal.dao.util.CacheHelper;
import com.gemantic.dal.dao.util.ObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListHandlerCenter {
    private Map<Integer, ListHandler> listHandlers = new HashMap<Integer, ListHandler>();
    private static Log log = LogFactory.getLog(ListHandlerCenter.class);
    private static ListHandlerCenter center;

    private ListHandlerCenter() {
        this.listHandlers.put(1, new CommonListHandler());
        this.listHandlers.put(3, new CrossListHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ListHandlerCenter getInstance() {
        if (null != center) return center;
        Class<ListHandlerCenter> clazz = ListHandlerCenter.class;
        synchronized (ListHandlerCenter.class) {
            if (null != center) return center;
            center = new ListHandlerCenter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return center;
        }
    }

    public Map<Integer, List<SectionInfo>> getSavedInfos(Object account_id, Object obj) throws Exception {
        List<LsCacheInfoHelper> allInfolist = ObjectUtil.getLsInfoList(obj);
        ArrayList<LsCacheInfoHelper> commonInfoList = new ArrayList<LsCacheInfoHelper>();
        ArrayList<LsCacheInfoHelper> crossInfoList = new ArrayList<LsCacheInfoHelper>();
        for (LsCacheInfoHelper lsHelper : allInfolist) {
            Integer type = lsHelper.getType();
            String region = lsHelper.getRegion();
            Cache cache = CacheHelper.getListCache(region);
            if (null == cache) continue;
            if (null == type || 1 == type) {
                commonInfoList.add(lsHelper);
                continue;
            }
            if (2 != type) continue;
            crossInfoList.add(lsHelper);
        }
        List<SectionInfo> commonSecs = null;
        List<SectionInfo> crossSecs = null;
        if (commonInfoList.size() > 0) {
            commonSecs = this.listHandlers.get(1).getSavedInfos(account_id, obj, commonInfoList);
        }
        if (crossInfoList.size() > 0) {
            crossSecs = this.listHandlers.get(3).getSavedInfos(account_id, obj, crossInfoList);
        }
        HashMap<Integer, List<SectionInfo>> allSecInfos = new HashMap<Integer, List<SectionInfo>>();
        if (null != commonSecs && commonSecs.size() > 0) {
            allSecInfos.put(1, commonSecs);
        }
        if (null != crossSecs && crossSecs.size() > 0) {
            allSecInfos.put(3, crossSecs);
        }
        return allSecInfos;
    }

    public void processBatchSavedInfos(Object account_id, List objs) throws Exception {
        HashMap<String, List<LsCacheInfoHelper>> commonInfoMap = new HashMap<String, List<LsCacheInfoHelper>>();
        for (Object obj : objs) {
            List<LsCacheInfoHelper> singleObjLs = ObjectUtil.getLsInfoList(obj);
            for (LsCacheInfoHelper lsHelper : singleObjLs) {
                Cache cache;
                Integer type = lsHelper.getType();
                String region = lsHelper.getRegion();
                if (null != type && 1 != type || null == (cache = CacheHelper.getListCache(region))) continue;
                ArrayList<LsCacheInfoHelper> objList = (ArrayList<LsCacheInfoHelper>)commonInfoMap.get(region);
                if (null == objList) {
                    objList = new ArrayList<LsCacheInfoHelper>();
                    commonInfoMap.put(region, objList);
                }
                objList.add(lsHelper);
            }
        }
        if (commonInfoMap.size() > 0) {
            this.listHandlers.get(1).processBatchedSave(commonInfoMap);
        }
    }

    public void processSave(Object account_id, Object obj, Map<Integer, List<SectionInfo>> saveInfos) throws Exception {
        for (Integer type : saveInfos.keySet()) {
            List<SectionInfo> secInfos = saveInfos.get(type);
            this.listHandlers.get(type).processSave(account_id, obj, secInfos);
        }
    }

    public Map<Integer, List<SectionInfo>> getDeleteInfos(Object account_id, Object obj) throws Exception {
        List<LsCacheInfoHelper> allInfolist = ObjectUtil.getLsInfoList(obj);
        ArrayList<LsCacheInfoHelper> commonInfoList = new ArrayList<LsCacheInfoHelper>();
        ArrayList<LsCacheInfoHelper> crossInfoList = new ArrayList<LsCacheInfoHelper>();
        for (LsCacheInfoHelper lsHelper : allInfolist) {
            Integer type = lsHelper.getType();
            String region = lsHelper.getRegion();
            Cache cache = CacheHelper.getListCache(region);
            if (null == cache) continue;
            if (null == type || 1 == type) {
                commonInfoList.add(lsHelper);
                continue;
            }
            if (2 != type) continue;
            crossInfoList.add(lsHelper);
        }
        List<SectionInfo> commonSecs = null;
        List<SectionInfo> crossSecs = null;
        if (commonInfoList.size() > 0) {
            commonSecs = this.listHandlers.get(1).getDeleteInfos(account_id, obj, commonInfoList);
        }
        if (crossInfoList.size() > 0) {
            crossSecs = this.listHandlers.get(3).getDeleteInfos(account_id, obj, crossInfoList);
        }
        HashMap<Integer, List<SectionInfo>> allSecInfos = new HashMap<Integer, List<SectionInfo>>();
        if (null != commonSecs && commonSecs.size() > 0) {
            allSecInfos.put(1, commonSecs);
        }
        if (null != crossSecs && crossSecs.size() > 0) {
            allSecInfos.put(3, crossSecs);
        }
        return allSecInfos;
    }

    public void processDelete(Object account_id, Class clazz, Object obj, Map<Integer, List<SectionInfo>> delInfos) throws Exception {
        for (Integer type : delInfos.keySet()) {
            List<SectionInfo> secInfos = delInfos.get(type);
            this.listHandlers.get(type).processDelete(account_id, clazz, obj, secInfos);
        }
    }

    public Map<Integer, UpdateInfo> getUpdateInfos(Object account_id, Object obj, Object oldObj) throws Exception {
        HashMap<Integer, UpdateInfo> allUpdateInfo = new HashMap<Integer, UpdateInfo>();
        List<LsCacheInfoHelper> allInfolist = ObjectUtil.getLsInfoList(obj);
        HashMap<String, LsCacheInfoHelper> commonInfoMap = new HashMap<String, LsCacheInfoHelper>();
        HashMap<String, LsCacheInfoHelper> crossInfoMap = new HashMap<String, LsCacheInfoHelper>();
        for (LsCacheInfoHelper lsHelper : allInfolist) {
            Integer type = lsHelper.getType();
            String region = lsHelper.getRegion();
            Cache cache = CacheHelper.getListCache(region);
            if (null == cache) continue;
            if (null == type || 1 == type) {
                commonInfoMap.put(region, lsHelper);
                continue;
            }
            if (3 != type) continue;
            crossInfoMap.put(region, lsHelper);
        }
        List<LsCacheInfoHelper> oldAllInfolist = ObjectUtil.getLsInfoList(oldObj);
        HashMap<String, LsCacheInfoHelper> oldCommonInfoMap = new HashMap<String, LsCacheInfoHelper>();
        HashMap<String, LsCacheInfoHelper> oldCrossInfoMap = new HashMap<String, LsCacheInfoHelper>();
        for (LsCacheInfoHelper lsHelper : oldAllInfolist) {
            Integer type = lsHelper.getType();
            String region = lsHelper.getRegion();
            Cache cache = CacheHelper.getListCache(region);
            if (null == cache) continue;
            if (null == type || 1 == type) {
                oldCommonInfoMap.put(region, lsHelper);
                continue;
            }
            if (2 != type) continue;
            oldCommonInfoMap.put(region, lsHelper);
        }
        UpdateInfo commonUpdateInfo = null;
        UpdateInfo crossUpdateInfo = null;
        if (oldCommonInfoMap.size() > 0) {
            commonUpdateInfo = this.listHandlers.get(1).getUpdateInfos(account_id, obj, oldObj, commonInfoMap, oldCommonInfoMap);
        }
        if (oldCrossInfoMap.size() > 0) {
            crossUpdateInfo = this.listHandlers.get(3).getUpdateInfos(account_id, obj, oldObj, crossInfoMap, oldCrossInfoMap);
        }
        if (null != commonUpdateInfo) {
            allUpdateInfo.put(1, commonUpdateInfo);
        }
        if (null != crossUpdateInfo) {
            allUpdateInfo.put(3, crossUpdateInfo);
        }
        return allUpdateInfo;
    }

    public void processUpdate(Object account_id, Class clazz, Object oldObj, Object obj, Map<Integer, UpdateInfo> updateInfos) throws Exception {
        for (Integer type : updateInfos.keySet()) {
            UpdateInfo updateInfo = updateInfos.get(type);
            this.listHandlers.get(type).processUpdate(account_id, clazz, oldObj, obj, updateInfo);
        }
    }
}

