/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.route.strategy;

import com.gemantic.dal.config.GroupConfig;
import com.gemantic.dal.config.helper.DaoHelper;
import com.gemantic.dal.config.helper.GroupHelper;
import com.gemantic.dal.config.model.dao.DbStrategyItem;
import com.gemantic.dal.config.model.dao.PatternItem;
import com.gemantic.dal.config.model.group.GroupItem;
import com.gemantic.dal.dao.exception.StrategyException;
import com.gemantic.dal.route.strategy.IStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.log4j.Logger;

public class DefaultStrategy
implements IStrategy {
    private static Logger logger = Logger.getLogger(DefaultStrategy.class);
    private static ThreadLocal<Integer> groupIndex = new ThreadLocal();

    @Override
    public Object ListShardingStrategy(String listName, Object account, int rw) throws StrategyException {
        DbStrategyItem dbStrategyItem = DaoHelper.getDbStrategyItemByListName(listName);
        if (dbStrategyItem == null) {
            dbStrategyItem = DaoHelper.getDefaultDbStrategyItem();
        }
        if (dbStrategyItem != null) {
            return this.getReadDs(dbStrategyItem, account);
        }
        throw new StrategyException("don't find the DbStrategy!");
    }

    @Override
    public List<String> getOneDSFromEachGroupOfObject(Class clazz, int rw) throws StrategyException {
        ArrayList<String> dsNames = new ArrayList<String>();
        DbStrategyItem dbStrategyItem = DaoHelper.getDbStrategyItemByClass(clazz);
        List<PatternItem> patternItemList = dbStrategyItem.getPatternItemList();
        if (null == patternItemList || patternItemList.size() < 1) {
            throw new StrategyException("don't find the DbStrategy!");
        }
        for (PatternItem patternItem : patternItemList) {
            switch (rw) {
                case 1: {
                    dsNames.add(this.getReadDsByPatternItem(patternItem));
                    break;
                }
                case 2: {
                    dsNames.add(this.getWriteDsByPatternItem(patternItem));
                    break;
                }
            }
        }
        return dsNames;
    }

    @Override
    public Object ObjectShardingStrategy(Class clazz, Object account, int rw) throws StrategyException {
        DbStrategyItem dbStrategyItem = DaoHelper.getDbStrategyItemByClass(clazz);
        if (dbStrategyItem == null) {
            dbStrategyItem = DaoHelper.getDefaultDbStrategyItem();
        }
        if (dbStrategyItem != null) {
            switch (rw) {
                case 1: {
                    return this.getReadDs(dbStrategyItem, account);
                }
                case 2: {
                    return this.getWriteDs(dbStrategyItem, account);
                }
            }
        } else {
            throw new StrategyException("don't find the DbStrategy!");
        }
        return null;
    }

    private String getReadDs(DbStrategyItem dbStrategyItem, Object account) throws StrategyException {
        Map<String, PatternItem> patternMap = dbStrategyItem.getPatternItemMap();
        PatternItem patternItem = this.findPatternItem(patternMap, account);
        return this.getReadDsByPatternItem(patternItem);
    }

    private String getReadDsByPatternItem(PatternItem patternItem) throws StrategyException {
        String groupName;
        GroupItem groupItem;
        Object ds = null;
        if (patternItem != null && (groupItem = GroupHelper.getGroupItem(groupName = patternItem.getGroup())) != null) {
            String dsSalves = groupItem.getSlave();
            if (StringUtils.isBlank((String)dsSalves)) {
                ds = groupItem.getMaster();
            } else {
                Object[] dss = StringUtils.splitPreserveAllTokens((String)dsSalves, (String)GroupConfig.DASNAME_SEPARATOR);
                if (!ArrayUtils.isEmpty((Object[])dss)) {
                    ds = dss[RandomUtils.nextInt((int)dss.length)];
                }
            }
        }
        if (StringUtils.isBlank(ds)) {
            throw new StrategyException("don't find the read datasources!");
        }
        return ds;
    }

    private String getWriteDs(DbStrategyItem dbStrategyItem, Object account) throws StrategyException {
        Map<String, PatternItem> patternMap = dbStrategyItem.getPatternItemMap();
        PatternItem patternItem = this.findPatternItem(patternMap, account);
        return this.getWriteDsByPatternItem(patternItem);
    }

    private String getWriteDsByPatternItem(PatternItem patternItem) throws StrategyException {
        String groupName;
        GroupItem groupItem;
        String master = null;
        if (patternItem != null && (groupItem = GroupHelper.getGroupItem(groupName = patternItem.getGroup())) != null) {
            master = groupItem.getMaster();
        }
        if (StringUtils.isBlank(master)) {
            throw new StrategyException("don't find the write datasources!");
        }
        return master;
    }

    private PatternItem findPatternItem(Map<String, PatternItem> patternMap, Object account) {
        PatternItem patternItem = null;
        if (MapUtils.isNotEmpty(patternMap)) {
            Collection<PatternItem> patternItems = patternMap.values();
            if (patternMap.size() == 1 || null == account) {
                patternItem = patternItems.iterator().next();
            } else {
                for (PatternItem item : patternItems) {
                    Pattern pattern;
                    String value;
                    if (item == null || !StringUtils.isNotEmpty((String)(value = item.getValue())) || !(pattern = Pattern.compile(value)).matcher(ObjectUtils.toString((Object)account)).find()) continue;
                    patternItem = item;
                    break;
                }
            }
        }
        return patternItem;
    }

    @Override
    public Object MapShardingStrategy(String mapName, Object account, int rw) throws StrategyException {
        DbStrategyItem dbStrategyItem = DaoHelper.getDbStrategyItemByMapName(mapName);
        if (dbStrategyItem == null) {
            dbStrategyItem = DaoHelper.getDefaultDbStrategyItem();
        }
        String dsname = null;
        if (dbStrategyItem == null) {
            throw new StrategyException("don't find the DbStrategy!");
        }
        dsname = this.getReadDs(dbStrategyItem, account);
        return dsname;
    }

    @Override
    public boolean isReadWrite(Class clazz, Object account) throws StrategyException {
        String groupName;
        GroupItem groupItem;
        Map<String, PatternItem> patternMap;
        PatternItem patternItem;
        DbStrategyItem dbStrategyItem = DaoHelper.getDbStrategyItemByClass(clazz);
        if (dbStrategyItem == null) {
            dbStrategyItem = DaoHelper.getDefaultDbStrategyItem();
        }
        if (dbStrategyItem != null && (patternItem = this.findPatternItem(patternMap = dbStrategyItem.getPatternItemMap(), account)) != null && (groupItem = GroupHelper.getGroupItem(groupName = patternItem.getGroup())) != null && null != groupItem.getSlave()) {
            return groupItem.getMaster() != groupItem.getSlave();
        }
        return false;
    }

    @Override
    public Object NextListShardingStrategy(String listName, int rw) throws StrategyException {
        Integer gIndex = groupIndex.get();
        gIndex = gIndex == null ? 0 : gIndex;
        String ds = null;
        DbStrategyItem dbStrategyItem = DaoHelper.getDbStrategyItemByListName(listName);
        if (dbStrategyItem == null) {
            dbStrategyItem = DaoHelper.getDefaultDbStrategyItem();
        }
        if (dbStrategyItem != null) {
            List<PatternItem> patternList = dbStrategyItem.getPatternItemList();
            if (patternList != null && patternList.size() > gIndex) {
                PatternItem patternItem = patternList.get(gIndex);
                Integer n = gIndex;
                Integer n2 = gIndex = Integer.valueOf(gIndex + 1);
                groupIndex.set(gIndex);
                ds = this.getReadDsByPatternItem(patternItem);
            } else {
                groupIndex.remove();
            }
        }
        return ds;
    }
}

