/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.id.util;

import com.gemantic.dal.id.util.IdCenterHelper;
import com.gemantic.dal.id.util.SequenceService;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.type.Type;
import org.springframework.stereotype.Component;

@Component(value="idGenerator")
public class IdGenerator
implements IdentifierGenerator,
Configurable {
    private static final Log log = LogFactory.getLog(IdGenerator.class);
    public String sequenceName = null;
    public static int createCnt = 0;

    public Serializable generate(SessionImplementor session, Object arg1) throws HibernateException {
        if (StringUtils.isBlank((String)this.sequenceName)) {
            log.warn((Object)"Attention : The sequence for idcenter is null\r\n");
            return null;
        }
        Long id = SequenceService.getInstance().nextValue(this.sequenceName);
        return id;
    }

    public void configure(Type arg0, Properties props, Dialect arg2) {
        if (StringUtils.isBlank((String)this.sequenceName)) {
            this.sequenceName = props.getProperty(IdCenterHelper.getSeqParamName());
            if (StringUtils.isBlank((String)this.sequenceName)) {
                log.warn((Object)"Warn: The user donesn't supply the <sequence> name when using idcenter\r\n");
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Debug : The squence --" + this.sequenceName + " is created\r\n"));
                ++createCnt;
            }
        }
    }
}

