/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.id.dao;

import com.gemantic.dal.id.util.IdCenterHelper;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcCall;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SequenceDao {
    private static final Log log = LogFactory.getLog(SequenceDao.class);
    protected DataSource dataSource;
    protected SimpleJdbcTemplate simpleJdbcTemplate;
    protected SimpleJdbcInsert insertActor;
    protected SimpleJdbcCall proc;

    public SequenceDao(DataSource db) {
        this.dataSource = db;
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(this.dataSource);
        this.insertActor = new SimpleJdbcInsert(this.dataSource).withTableName(IdCenterHelper.getTableName()).usingGeneratedKeyColumns(new String[]{"id"});
        this.proc = new SimpleJdbcCall(this.dataSource).withProcedureName("getSequence").useInParameterNames(new String[]{"seqName"}).declareParameters(new SqlParameter[]{new SqlOutParameter("oldValue", -5), new SqlOutParameter("newValue", -5)});
    }

    public Map getSeqIds(String seqName) {
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("seqName", (Object)seqName);
        Map map = null;
        try {
            map = this.proc.execute((SqlParameterSource)params);
        }
        catch (Exception e) {
            log.warn((Object)"Warn:IdCenter Exception --> when execute stored procedure \r\n");
            e.printStackTrace(System.err);
        }
        return map;
    }

    public Integer getSeqSpan(String seqName) {
        Integer span = 1;
        try {
            span = this.simpleJdbcTemplate.queryForInt("select span from dalsequence  where name=?", new Object[]{seqName});
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (span < 1) {
            span = 1;
        }
        return span;
    }
}

