/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.util;

public class ParamUtil {
    private ParamUtil() {
    }

    public static int getInt(String stringNumber, int defaultValue) {
        if (stringNumber == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(stringNumber);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getInt(String stringNumber, int min, int defaultValue) {
        try {
            int returnInt = ParamUtil.getInt(stringNumber, defaultValue);
            if (returnInt >= min) {
                return returnInt;
            }
            return defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getInt(String stringNumber, int min, int max, int defaultValue) {
        try {
            int returnInt = ParamUtil.getInt(stringNumber, min, defaultValue);
            if (returnInt <= max) {
                return returnInt;
            }
            return defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long getLong(String stringNumber, long defaultValue) {
        if (stringNumber == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(stringNumber);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long getLong(String stringNumber, long min, long defaultValue) {
        try {
            long returnInt = ParamUtil.getLong(stringNumber, defaultValue);
            if (returnInt >= min) {
                return returnInt;
            }
            return defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long getLong(String stringNumber, long min, long max, long defaultValue) {
        try {
            long returnInt = ParamUtil.getLong(stringNumber, min, defaultValue);
            if (returnInt <= max) {
                return returnInt;
            }
            return defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getString(String input, String defaultValue) {
        if (input == null) {
            return defaultValue.trim();
        }
        return input.trim();
    }

    public static String getString(String input, String[] validValues, String defaultValue) {
        boolean caseSensitive = false;
        return ParamUtil.getString(input, validValues, defaultValue, caseSensitive);
    }

    public static String getString(String input, String[] validValues, String defaultValue, boolean caseSensitive) {
        int i;
        int n;
        if (input == null) {
            return defaultValue;
        }
        if (!caseSensitive) {
            input = input.toLowerCase();
            n = validValues.length;
            for (i = 0; i < n; ++i) {
                validValues[i] = validValues[i].toLowerCase();
            }
        }
        if (validValues != null) {
            n = validValues.length;
            for (i = 0; i < n; ++i) {
                if (!input.equals(validValues[i])) continue;
                return input;
            }
        }
        return defaultValue;
    }
}

