/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.util;

public class ListUtil {
    public static long readLong(byte[] buffer, int[] outpos) {
        if (buffer == null || buffer.length == 0) {
            return 0L;
        }
        int pos = outpos[0];
        byte b = buffer[pos++];
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = buffer[pos++];
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        outpos[0] = pos;
        return i;
    }

    public static byte[] writeLong(long i) {
        byte[] buffer = new byte[10];
        int pos = 0;
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buffer[pos++] = (byte)(i & 0x7FL | 0x80L);
            i >>>= 7;
        }
        buffer[pos++] = (byte)i;
        byte[] result = new byte[pos];
        System.arraycopy(buffer, 0, result, 0, pos);
        return result;
    }

    public static byte[] insertLong(byte[] buffer, long num) {
        byte[] numbyte = ListUtil.writeLong(num);
        byte[] output = new byte[buffer.length + numbyte.length];
        System.arraycopy(buffer, 0, output, 0, buffer.length);
        System.arraycopy(numbyte, 0, output, buffer.length, numbyte.length);
        return output;
    }

    public static long getLastLong(byte[] buffer) {
        byte value;
        int pos;
        if (buffer == null || buffer.length == 0) {
            return -1L;
        }
        for (pos = buffer.length - 2; pos >= 0 && ((value = buffer[pos]) & 0x80) != 0; --pos) {
        }
        int[] outPos = new int[1];
        if (pos >= 0) {
            outPos[0] = pos + 1;
        }
        return ListUtil.readLong(buffer, outPos);
    }

    public static byte[] removeLong(byte[] buffer) {
        byte value;
        int pos;
        for (pos = buffer.length - 2; pos >= 0 && ((value = buffer[pos]) & 0x80) != 0; --pos) {
        }
        if (pos < 0) {
            return new byte[0];
        }
        byte[] result = new byte[pos + 1];
        System.arraycopy(buffer, 0, result, 0, pos + 1);
        return result;
    }

    public static byte[] removeLong(byte[] buffer, int startPosInBuffer, long num, boolean[] outFound) {
        int[] outpos = new int[1];
        if (startPosInBuffer < 0) {
            startPosInBuffer = 0;
        }
        outpos[0] = startPosInBuffer;
        int prePos = 0;
        while (outpos[0] < buffer.length) {
            prePos = outpos[0];
            long value = ListUtil.readLong(buffer, outpos);
            if (value != num) continue;
            byte[] comIdByte = ListUtil.writeLong(value);
            byte[] output = new byte[buffer.length - comIdByte.length];
            System.arraycopy(buffer, 0, output, 0, prePos);
            System.arraycopy(buffer, prePos + comIdByte.length, output, prePos, buffer.length - prePos - comIdByte.length);
            if (outFound != null) {
                outFound[0] = true;
            }
            return output;
        }
        if (outFound != null) {
            outFound[0] = false;
        }
        return buffer;
    }

    public static void main(String[] args) {
        byte[] buffer = ListUtil.writeLong(123L);
        byte[] res = null;
        long result = ListUtil.readLong(buffer, new int[]{0});
        for (int i = 0; i < 10; ++i) {
            res = null == res ? ListUtil.insertLong(buffer, (long)i * 1000L) : ListUtil.insertLong(res, (long)i * 1000L);
            System.out.println(i + " 's last long " + ListUtil.getLastLong(res));
        }
        System.out.println("==============Deleting ================");
        res = ListUtil.removeLong(res);
        while (res.length > 0) {
            System.out.println(" last long " + ListUtil.getLastLong(res));
            res = ListUtil.removeLong(res);
        }
        System.out.println(result);
    }
}

