/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.listloader.impl;

import com.gemantic.dal.dao.ListLoader;
import com.gemantic.dal.dao.exception.DaoException;
import com.gemantic.dal.dao.exception.StrategyException;
import com.gemantic.dal.dao.helper.ListInfoHelper;
import com.gemantic.dal.dao.helper.LogHelper;
import com.gemantic.dal.dao.helper.LsCacheInfoHelper;
import com.gemantic.dal.dao.helper.VisitHelper;
import com.gemantic.dal.dao.impl.DBAgentHibernateImpl;
import com.gemantic.dal.dao.model.ListInfo;
import com.gemantic.dal.dao.model.SectionInfo;
import com.gemantic.dal.dao.util.CacheHelper;
import com.gemantic.dal.dao.util.ObjectUtil;
import com.gemantic.dal.dao.util.SqlUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;

public class CommonListLoader
implements ListLoader {
    private static Log log = LogFactory.getLog(CommonListLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ListInfoHelper getListInfo(Object account_id, LsCacheInfoHelper lsHelper, int strategy, boolean needLock) throws DaoException {
        block8: {
            block6: {
                block7: {
                    infoHelper = null;
                    lock = null;
                    info = CacheHelper.getListInfo(lsHelper);
                    if (null != info) ** GOTO lbl18
                    if (!needLock || null != (lock = VisitHelper.getInstance().checkLsInLoading(lsHelper))) break block6;
                    var8_9 = infoHelper;
                    if (null == lock) break block7;
                    VisitHelper.getInstance().endLsLoading(lsHelper, lock);
                }
                return var8_9;
            }
            try {
                objList = DBAgentHibernateImpl.getInstance().getObjectList(account_id, lsHelper.getRegion(), SqlUtil.getListCountSql(lsHelper), 0L, 1L, strategy, true, false);
                info = new ListInfo(new Long("" + objList.get(0)));
                CacheHelper.putListInfo(lsHelper, info.getSize());
lbl18:
                // 2 sources

                infoHelper = new ListInfoHelper(info);
                if (null == lock) break block8;
                VisitHelper.getInstance().endLsLoading(lsHelper, lock);
            }
            catch (Exception e) {
                try {
                    CommonListLoader.processException(e);
                    if (null == lock) break block8;
                    VisitHelper.getInstance().endLsLoading(lsHelper, lock);
                }
                catch (Throwable var9_11) {
                    if (null != lock) {
                        VisitHelper.getInstance().endLsLoading(lsHelper, lock);
                    }
                    throw var9_11;
                }
            }
        }
        return infoHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List getSectionIdList(LsCacheInfoHelper lsHelper, ListInfoHelper infoHelper, Object account_id, Long sectionNo, int strategy, boolean needLock) throws DaoException {
        Long sectionLock;
        Long listInfoLock;
        List idList;
        block32: {
            List list;
            block31: {
                ArrayList arrayList;
                block30: {
                    ArrayList arrayList2;
                    block29: {
                        ArrayList arrayList3;
                        block28: {
                            idList = new ArrayList();
                            listInfoLock = null;
                            sectionLock = null;
                            try {
                                boolean bLoading = false;
                                if (null == infoHelper && null == (infoHelper = this.getListInfo(account_id, lsHelper, strategy, needLock))) {
                                    arrayList3 = idList;
                                    if (!needLock) return arrayList3;
                                    if (null != listInfoLock) {
                                        VisitHelper.getInstance().endLsLoading(lsHelper, listInfoLock);
                                    }
                                    break block28;
                                }
                                if (sectionNo > infoHelper.getMaxSectionNo()) {
                                    LogHelper.failedLoadListSection(log, lsHelper, infoHelper, sectionNo);
                                    arrayList2 = idList;
                                    if (!needLock) return arrayList2;
                                    break block29;
                                }
                                if (infoHelper.isVisited(sectionNo)) {
                                    idList = (List)CacheHelper.get(lsHelper.getRegion(), lsHelper.getIdListKey(new Long(sectionNo)));
                                    if (null == idList || idList.size() < 1) {
                                        bLoading = true;
                                    }
                                } else {
                                    if (needLock && null == (listInfoLock = VisitHelper.getInstance().checkLsInLoading(lsHelper))) {
                                        arrayList = idList;
                                        if (!needLock) return arrayList;
                                        break block30;
                                    }
                                    infoHelper.addSection(new Long(sectionNo));
                                    CacheHelper.put(lsHelper.getRegion(), lsHelper.getListVisitInfoKey(), infoHelper.getVisitedSections());
                                    CacheHelper.remove(lsHelper.getRegion(), lsHelper.getIdListKey(sectionNo));
                                    bLoading = true;
                                }
                                if (bLoading) {
                                    if (needLock && null == (sectionLock = VisitHelper.getInstance().checkIdLsLoad(lsHelper))) {
                                        list = idList;
                                        if (!needLock) return list;
                                        break block31;
                                    }
                                    Long startIndex = infoHelper.getSectionIndex(sectionNo);
                                    Long secSize = infoHelper.getSectionSize(sectionNo);
                                    idList = DBAgentHibernateImpl.getInstance().getObjectList(account_id, lsHelper.getRegion(), SqlUtil.getListSql(lsHelper, true), startIndex, secSize, strategy, true, false);
                                    if (null != idList && idList.size() > 0) {
                                        ArrayList rvList = new ArrayList();
                                        for (int i = idList.size() - 1; i >= 0; --i) {
                                            rvList.add(idList.get(i));
                                        }
                                        idList = rvList;
                                        CacheHelper.put(lsHelper.getRegion(), lsHelper.getIdListKey(sectionNo), rvList);
                                    } else {
                                        CacheHelper.removeListInfo(lsHelper);
                                        LogHelper.failedLoadOneListSection(log, lsHelper, sectionNo);
                                    }
                                }
                                if (!needLock) return idList;
                                break block32;
                            }
                            catch (Exception e) {
                                CommonListLoader.processException(e);
                                return idList;
                            }
                        }
                        if (null == sectionLock) return arrayList3;
                        VisitHelper.getInstance().endIdLsLoading(lsHelper, sectionLock);
                        return arrayList3;
                    }
                    if (null != listInfoLock) {
                        VisitHelper.getInstance().endLsLoading(lsHelper, listInfoLock);
                    }
                    if (null == sectionLock) return arrayList2;
                    VisitHelper.getInstance().endIdLsLoading(lsHelper, sectionLock);
                    return arrayList2;
                }
                if (null != listInfoLock) {
                    VisitHelper.getInstance().endLsLoading(lsHelper, listInfoLock);
                }
                if (null == sectionLock) return arrayList;
                VisitHelper.getInstance().endIdLsLoading(lsHelper, sectionLock);
                return arrayList;
            }
            if (null != listInfoLock) {
                VisitHelper.getInstance().endLsLoading(lsHelper, listInfoLock);
            }
            if (null == sectionLock) return list;
            VisitHelper.getInstance().endIdLsLoading(lsHelper, sectionLock);
            return list;
        }
        if (null != listInfoLock) {
            VisitHelper.getInstance().endLsLoading(lsHelper, listInfoLock);
        }
        if (null == sectionLock) return idList;
        VisitHelper.getInstance().endIdLsLoading(lsHelper, sectionLock);
        return idList;
        finally {
            if (needLock) {
                if (null != listInfoLock) {
                    VisitHelper.getInstance().endLsLoading(lsHelper, listInfoLock);
                }
                if (null != sectionLock) {
                    VisitHelper.getInstance().endIdLsLoading(lsHelper, sectionLock);
                }
            }
        }
    }

    @Override
    public SectionInfo getUpdatedSection(Object account_id, Object obj, LsCacheInfoHelper lsHelper) throws Exception {
        List idList;
        SectionInfo sectionInfo = null;
        ListInfoHelper infoHelper = this.getListInfo(account_id, lsHelper, 2, false);
        Object objValueOfLs = ObjectUtil.getObjectValueOfList(obj, lsHelper);
        for (long sectionNo = infoHelper.getMaxSectionNo(); sectionNo >= 0L && null != (idList = this.getSectionIdList(lsHelper, infoHelper, account_id, sectionNo, 2, false)) && idList.size() >= 1; --sectionNo) {
            long index = idList.indexOf(objValueOfLs);
            if (index < 0L) continue;
            sectionInfo = new SectionInfo(sectionNo, infoHelper, idList, lsHelper, null);
            break;
        }
        if (null == sectionInfo) {
            LogHelper.failedFindIdFromList(log, lsHelper, objValueOfLs);
        }
        return sectionInfo;
    }

    @Override
    public void removeIdFromList(Object account_id, Object obj, SectionInfo secInfo, boolean bReload) throws Exception {
        ListInfoHelper infoHelper = secInfo.getInfoHelper();
        LsCacheInfoHelper lsHelper = secInfo.getLsHelper();
        infoHelper.removeId(secInfo.getSectionNo());
        if (infoHelper.isSectionsReBuild()) {
            CacheHelper.removeListInfo(lsHelper);
            if (bReload) {
                List idList;
                long oldSectionNo = secInfo.getSectionNo();
                if (oldSectionNo > 0L) {
                    --oldSectionNo;
                }
                infoHelper = this.getListInfo(account_id, lsHelper, 2, false);
                for (long i = oldSectionNo; i <= infoHelper.getMaxSectionNo() && null != (idList = this.getSectionIdList(secInfo.getLsHelper(), null, account_id, i, 2, false)) && idList.size() >= 1; ++i) {
                }
            }
        } else {
            CacheHelper.putListInfo(lsHelper, infoHelper.getListInfo());
            List idList = secInfo.getIdList();
            idList.remove(ObjectUtil.getObjectValueOfList(obj, lsHelper));
            CacheHelper.put(lsHelper.getRegion(), secInfo.getLsHelper().getIdListKey(secInfo.getSectionNo()), idList);
        }
    }

    private static void processException(Exception e) throws DaoException {
        e.printStackTrace(System.out);
        if (e instanceof MappingException) {
            throw new DaoException(401, e);
        }
        if (e instanceof NullPointerException) {
            throw new DaoException(303, e);
        }
        if (e instanceof SQLException) {
            throw new DaoException(500, e);
        }
        if (e instanceof HibernateException) {
            throw new DaoException(400, e);
        }
        if (e instanceof StrategyException) {
            throw new DaoException(306, e);
        }
        if (e instanceof DaoException) {
            throw (DaoException)e;
        }
        throw new DaoException(e);
    }
}

