/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.impl;

import com.gemantic.dal.cache.Cache;
import com.gemantic.dal.cache.MaxIdHolder;
import com.gemantic.dal.cache.exception.CacheException;
import com.gemantic.dal.config.helper.DaoHelper;
import com.gemantic.dal.config.model.dao.ObjectItem;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.ListHandlerCenter;
import com.gemantic.dal.dao.ListLoaderCenter;
import com.gemantic.dal.dao.cachehandler.impl.MapCacheHelper;
import com.gemantic.dal.dao.exception.DaoException;
import com.gemantic.dal.dao.exception.StrategyException;
import com.gemantic.dal.dao.helper.ListInfoHelper;
import com.gemantic.dal.dao.helper.LogHelper;
import com.gemantic.dal.dao.helper.LsCacheInfoHelper;
import com.gemantic.dal.dao.helper.MultiCacheGet;
import com.gemantic.dal.dao.helper.MultiDBGet;
import com.gemantic.dal.dao.helper.VisitHelper;
import com.gemantic.dal.dao.impl.DBAgentHibernateImpl;
import com.gemantic.dal.dao.model.ListLoadInfo;
import com.gemantic.dal.dao.model.LsCacheInfo;
import com.gemantic.dal.dao.model.MapInfo;
import com.gemantic.dal.dao.model.SectionInfo;
import com.gemantic.dal.dao.model.SqlInfo;
import com.gemantic.dal.dao.model.UpdateInfo;
import com.gemantic.dal.dao.util.CacheHelper;
import com.gemantic.dal.dao.util.DalAssert;
import com.gemantic.dal.dao.util.ObjectUtil;
import com.gemantic.dal.dao.util.SqlUtil;
import com.gemantic.dal.datasource.ContextHolder;
import com.gemantic.dal.route.RoutingService;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.springframework.beans.BeanUtils;

public class CompositeDaoImpl
implements Dao {
    private static final int singleUsedTime = 15;
    private static final int lotsUsedTime = 50;
    private Log log = LogFactory.getLog(CompositeDaoImpl.class);
    private Log permLog = LogFactory.getLog((String)"DalPerformance");

    public CompositeDaoImpl() {
    }

    public CompositeDaoImpl(String daoConfigFile) {
        DBAgentHibernateImpl.setDaoConfigFile(daoConfigFile);
        DaoHelper.setDaoConfigFile(daoConfigFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable save(Object account_id, Object object) throws DaoException {
        DalAssert.assertObjectNotNull(object);
        DalAssert.assertObjectIllegal(account_id, object);
        long t1 = System.currentTimeMillis();
        Serializable id = null;
        try {
            VisitHelper.getInstance().inLoadWithSave(object);
            Map<Integer, List<SectionInfo>> saveInfos = ListHandlerCenter.getInstance().getSavedInfos(account_id, object);
            id = DBAgentHibernateImpl.getInstance().save(account_id, object);
            if (null == id) {
                LogHelper.savedError(this.log, object);
                Serializable serializable = id;
                return serializable;
            }
            ListHandlerCenter.getInstance().processSave(account_id, object, saveInfos);
            CacheHelper.save(object.getClass(), id, object);
            if (RoutingService.getInstance().isReadWrite(object.getClass(), account_id)) {
                MapCacheHelper.updateToCache(object);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        finally {
            try {
                VisitHelper.getInstance().endLoadWithSave(object);
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: save region: " + object.getClass().getName() + " params: " + id + " time: " + usedTime));
        }
        return id;
    }

    @Override
    public Serializable save(Object object) throws DaoException {
        return this.save(null, object);
    }

    @Override
    public Serializable save(Object object, String lang) throws DaoException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (StringUtils.isEmpty((String)lang)) {
            return this.save(null, object);
        }
        Class<?> clazz = object.getClass();
        lang = lang.substring(0, 1).toUpperCase() + lang.substring(1);
        Class<?> nClazz = Class.forName(clazz.getName().replace(clazz.getSimpleName(), clazz.getSimpleName() + lang));
        Object nObj = nClazz.newInstance();
        BeanUtils.copyProperties((Object)object, nObj);
        return this.save(null, nObj);
    }

    @Override
    public List save(Object account_id, List objects) throws DaoException {
        DalAssert.assertObjectNotNull(objects);
        DalAssert.assertListIllegal(account_id, objects);
        ArrayList objList = new ArrayList();
        for (Object obj : objects) {
            if (obj == null) continue;
            this.save(account_id, obj);
            objList.add(obj);
        }
        return objList;
    }

    @Override
    public List save(List objects) throws DaoException {
        return this.save(null, objects);
    }

    @Override
    public List batchSave(Object account_id, List objList) throws DaoException {
        DalAssert.assertObjectNotNull(objList);
        long t1 = System.currentTimeMillis();
        Map resMap = null;
        ArrayList resList = new ArrayList();
        try {
            Object obj;
            resMap = DBAgentHibernateImpl.getInstance().save(account_id, objList);
            Long maxObjectId = 0L;
            for (Serializable id : resMap.keySet()) {
                Object obj2 = resMap.get(id);
                resList.add(obj2);
                CacheHelper.save(obj2.getClass(), id, obj2);
                if (new Long("" + id) <= maxObjectId) continue;
                maxObjectId = new Long("" + id);
            }
            if (maxObjectId > 0L) {
                MaxIdHolder.setMaxId((String)("MaxId_" + objList.get(0).getClass().getName()), (Long)maxObjectId);
            }
            ListHandlerCenter.getInstance().processBatchSavedInfos(account_id, resList);
            long usedTime = System.currentTimeMillis() - t1;
            if (usedTime >= 50L && this.permLog.isWarnEnabled() && null != (obj = objList.get(0)) && null != obj.getClass()) {
                this.permLog.warn((Object)("method: batchSave region: " + obj.getClass().getName() + " size: " + objList.size() + " time: " + usedTime));
            }
        }
        catch (Exception e) {
            resList = new ArrayList();
            this.processException(e);
        }
        return resList;
    }

    @Override
    public List batchSave(List objList) throws DaoException {
        return this.batchSave(null, objList);
    }

    @Override
    public List batchSave(List objList, String lang) throws DaoException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (CollectionUtils.isNotEmpty((Collection)objList)) {
            ArrayList nObjList = new ArrayList();
            ArrayList list = new ArrayList();
            if (StringUtils.isNotEmpty((String)lang)) {
                Class<?> clazz = objList.get(0).getClass();
                lang = lang.substring(0, 1).toUpperCase() + lang.substring(1);
                Class<?> nClazz = Class.forName(clazz.getName().replace(clazz.getSimpleName(), clazz.getSimpleName() + lang));
                for (Object o : objList) {
                    Object nObj = nClazz.newInstance();
                    BeanUtils.copyProperties(o, nObj);
                    nObjList.add(nObj);
                }
                List result = this.batchSave(null, nObjList);
                for (Object o : result) {
                    Object obj = clazz.newInstance();
                    BeanUtils.copyProperties(o, obj);
                    list.add(obj);
                }
                return list;
            }
            return this.batchSave(null, objList);
        }
        return this.batchSave(null, objList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateObjs(List objList) throws DaoException {
        long t1 = System.currentTimeMillis();
        boolean bUpdated = true;
        boolean bLock = false;
        HashMap<Serializable, Object> oldObjMap = new HashMap<Serializable, Object>();
        HashMap newObjMap = new HashMap();
        HashMap<Serializable, Map<Integer, UpdateInfo>> updateInfoMap = new HashMap<Serializable, Map<Integer, UpdateInfo>>();
        try {
            ArrayList objIdList = new ArrayList();
            for (Object obj : objList) {
                Serializable objectId = ObjectUtil.getObjectId(obj);
                if (null == objectId) {
                    LogHelper.failedGetObjectId(this.log, obj);
                    boolean bl = bUpdated;
                    return bl;
                }
                Object oldObject = this.get(obj.getClass(), objectId);
                if (null == oldObject) {
                    LogHelper.failedGetObjectById(this.log, null, obj.getClass(), objectId);
                    boolean e = bUpdated;
                    return e;
                }
                VisitHelper.getInstance().inLoadWithUpdate(obj);
                VisitHelper.getInstance().inLoadWithUpdate(oldObject);
                Map<Integer, UpdateInfo> updateInfos = ListHandlerCenter.getInstance().getUpdateInfos(null, obj, oldObject);
                oldObjMap.put(objectId, oldObject);
                newObjMap.put(objectId, obj);
                updateInfoMap.put(objectId, updateInfos);
            }
            bLock = true;
            bUpdated = DBAgentHibernateImpl.getInstance().updateObjs(null, objList);
            if (!bUpdated) {
                boolean bl = bUpdated;
                return bl;
            }
            for (Serializable id : newObjMap.keySet()) {
                Object newObj = newObjMap.get(id);
                Object oldObj = oldObjMap.get(id);
                Map updateMap = (Map)updateInfoMap.get(id);
                ListHandlerCenter.getInstance().processUpdate(null, newObj.getClass(), oldObj, newObj, updateMap);
                CacheHelper.update(newObj.getClass().getName(), id + "", newObj);
                MapCacheHelper.removeFromCache(oldObj);
                MapCacheHelper.updateToCache(newObj);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        finally {
            try {
                if (bLock) {
                    for (Serializable id : newObjMap.keySet()) {
                        Object newObj = newObjMap.get(id);
                        Object oldObj = oldObjMap.get(id);
                        VisitHelper.getInstance().endLoadWithUpdate(newObj);
                        VisitHelper.getInstance().endLoadWithUpdate(oldObj);
                    }
                }
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: updateObjects region: " + usedTime));
        }
        return bUpdated;
    }

    @Override
    public boolean update(Object object) throws DaoException {
        return this.update(null, object);
    }

    @Override
    public boolean update(Object object, String lang) throws DaoException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (StringUtils.isEmpty((String)lang)) {
            return this.update(null, object);
        }
        Class<?> clazz = object.getClass();
        lang = lang.substring(0, 1).toUpperCase() + lang.substring(1);
        Class<?> nClazz = Class.forName(clazz.getName().replace(clazz.getSimpleName(), clazz.getSimpleName() + lang));
        Object nObj = nClazz.newInstance();
        BeanUtils.copyProperties((Object)object, nObj);
        return this.update(null, nObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean update(Object account_id, Object object) throws DaoException {
        long usedTime;
        Serializable objectId;
        boolean bUpdated;
        long t1;
        block29: {
            Map<Integer, UpdateInfo> updateInfos;
            Object oldObject;
            boolean bLock;
            block28: {
                block27: {
                    block26: {
                        DalAssert.assertObjectNotNull(object);
                        DalAssert.assertObjectIllegal(account_id, object);
                        t1 = System.currentTimeMillis();
                        bUpdated = true;
                        bLock = false;
                        oldObject = null;
                        objectId = null;
                        objectId = ObjectUtil.getObjectId(object);
                        if (null != objectId) break block26;
                        LogHelper.failedGetObjectId(this.log, object);
                        boolean bl = bUpdated;
                        try {
                            if (bLock) {
                                VisitHelper.getInstance().endLoadWithUpdate(object);
                                VisitHelper.getInstance().endLoadWithUpdate(oldObject);
                            }
                        }
                        catch (Exception e) {
                            this.processException(e);
                        }
                        return bl;
                    }
                    oldObject = this.get(account_id, object.getClass(), objectId);
                    if (null != oldObject) break block27;
                    LogHelper.failedGetObjectById(this.log, account_id, object.getClass(), objectId);
                    boolean bl = bUpdated;
                    try {
                        if (bLock) {
                            VisitHelper.getInstance().endLoadWithUpdate(object);
                            VisitHelper.getInstance().endLoadWithUpdate(oldObject);
                        }
                    }
                    catch (Exception e) {
                        this.processException(e);
                    }
                    return bl;
                }
                bLock = true;
                VisitHelper.getInstance().inLoadWithUpdate(object);
                VisitHelper.getInstance().inLoadWithUpdate(oldObject);
                updateInfos = ListHandlerCenter.getInstance().getUpdateInfos(account_id, object, oldObject);
                bUpdated = DBAgentHibernateImpl.getInstance().update(account_id, object);
                if (bUpdated) break block28;
                LogHelper.updateError(this.log, object);
                boolean bl = bUpdated;
                try {
                    if (bLock) {
                        VisitHelper.getInstance().endLoadWithUpdate(object);
                        VisitHelper.getInstance().endLoadWithUpdate(oldObject);
                    }
                }
                catch (Exception e) {
                    this.processException(e);
                }
                return bl;
            }
            ListHandlerCenter.getInstance().processUpdate(account_id, object.getClass(), oldObject, object, updateInfos);
            CacheHelper.update(object.getClass().getName(), objectId + "", object);
            MapCacheHelper.removeFromCache(oldObject);
            MapCacheHelper.updateToCache(object);
            try {
                if (bLock) {
                    VisitHelper.getInstance().endLoadWithUpdate(object);
                    VisitHelper.getInstance().endLoadWithUpdate(oldObject);
                }
                break block29;
            }
            catch (Exception e) {
                this.processException(e);
            }
            break block29;
            catch (Exception e) {
                try {
                    this.processException(e);
                }
                catch (Throwable throwable) {
                    try {
                        if (bLock) {
                            VisitHelper.getInstance().endLoadWithUpdate(object);
                            VisitHelper.getInstance().endLoadWithUpdate(oldObject);
                        }
                    }
                    catch (Exception e2) {
                        this.processException(e2);
                    }
                    throw throwable;
                }
                try {
                    if (bLock) {
                        VisitHelper.getInstance().endLoadWithUpdate(object);
                        VisitHelper.getInstance().endLoadWithUpdate(oldObject);
                    }
                }
                catch (Exception e3) {
                    this.processException(e3);
                }
            }
        }
        if ((usedTime = System.currentTimeMillis() - t1) >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: update region: " + object.getClass().getName() + " params: " + objectId + " time: " + usedTime));
        }
        return bUpdated;
    }

    @Override
    public boolean batchUpdate(Object account_id, List objects) throws DaoException {
        DalAssert.assertObjectNotNull(objects);
        DalAssert.assertListIllegal(account_id, objects);
        boolean bUpdated = true;
        try {
            for (Object obj : objects) {
                this.update(account_id, obj);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return bUpdated;
    }

    @Override
    public boolean batchUpdate(List objects) throws DaoException {
        return this.batchUpdate(null, objects);
    }

    @Override
    public boolean batchUpdate(List objects, String lang) throws DaoException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (StringUtils.isEmpty((String)lang)) {
            return this.batchUpdate(null, objects);
        }
        if (CollectionUtils.isNotEmpty((Collection)objects)) {
            Class<?> clazz = objects.get(0).getClass();
            ArrayList nObjList = new ArrayList();
            lang = lang.substring(0, 1).toUpperCase() + lang.substring(1);
            Class<?> nClazz = Class.forName(clazz.getName().replace(clazz.getSimpleName(), clazz.getSimpleName() + lang));
            for (Object object : objects) {
                Object nObj = nClazz.newInstance();
                BeanUtils.copyProperties(object, nObj);
                nObjList.add(nObj);
            }
            return this.batchUpdate(null, nObjList);
        }
        return this.batchUpdate(null, objects);
    }

    @Override
    public boolean delete(Object account_id, Class clazz, Serializable id) throws DaoException {
        return this.realDelete(account_id, clazz, id, true);
    }

    @Override
    public boolean delete(Class clazz, Serializable id) throws DaoException {
        return this.delete(null, clazz, id);
    }

    @Override
    public boolean delete(Class clazz, Serializable id, String lang) throws DaoException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (StringUtils.isEmpty((String)lang)) {
            return this.delete(null, clazz, id);
        }
        lang = lang.substring(0, 1).toUpperCase() + lang.substring(1);
        Class<?> nClazz = Class.forName(clazz.getName().replace(clazz.getSimpleName(), clazz.getSimpleName() + lang));
        return this.delete(null, nClazz, id);
    }

    @Override
    public boolean fakeDelete(Object account_id, Class clazz, Serializable id) throws DaoException {
        return this.realDelete(account_id, clazz, id, false);
    }

    @Override
    public boolean fakeDelete(Class clazz, Serializable id) throws DaoException {
        return this.fakeDelete(null, clazz, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean realDelete(Object account_id, Class clazz, Serializable id, boolean delFlag) throws DaoException {
        long usedTime;
        DalAssert.assertObjectNotNull(clazz);
        DalAssert.assertObjectNotNull(id);
        long t1 = System.currentTimeMillis();
        boolean bDeleted = true;
        Object obj = null;
        Object oldObj = null;
        boolean bLock = false;
        try {
            obj = this.get(account_id, clazz, id);
            if (null == obj) {
                LogHelper.failedGetObjectById(this.log, account_id, clazz, id);
                boolean bl = bDeleted;
                try {
                    if (!bLock) return bl;
                    VisitHelper.getInstance().endLoadWithDelete(obj);
                    if (delFlag) return bl;
                    VisitHelper.getInstance().endLoadWithDelete(oldObj);
                    return bl;
                }
                catch (Exception e) {
                    this.processException(e);
                }
                return bl;
            }
            if (!delFlag) {
                oldObj = this.get(account_id, clazz, id);
            }
            bLock = true;
            VisitHelper.getInstance().inLoadWithDelete(obj);
            bDeleted = delFlag ? DBAgentHibernateImpl.getInstance().delete(account_id, obj) : DBAgentHibernateImpl.getInstance().fakeDelete(account_id, obj);
            if (!bDeleted) {
                LogHelper.deleteError(this.log, clazz, account_id, id, delFlag);
                boolean bl = delFlag;
                try {
                    if (!bLock) return bl;
                    VisitHelper.getInstance().endLoadWithDelete(obj);
                    if (delFlag) return bl;
                    VisitHelper.getInstance().endLoadWithDelete(oldObj);
                    return bl;
                }
                catch (Exception e) {
                    this.processException(e);
                }
                return bl;
            }
            List<LsCacheInfoHelper> lsCacheInfos = ObjectUtil.getLsInfoList(obj);
            if (CollectionUtils.isNotEmpty(lsCacheInfos)) {
                for (LsCacheInfoHelper lsHelper : lsCacheInfos) {
                    Cache cache = CacheHelper.getListCache(lsHelper.getRegion());
                    if (null == cache) continue;
                    cache.remove(lsHelper.getListCountKey());
                    cache.remove(lsHelper.getListVisitInfoKey());
                }
            }
            CacheHelper.delete(clazz.getName(), id + "");
            MapCacheHelper.removeFromCache(obj);
            try {
                if (bLock) {
                    VisitHelper.getInstance().endLoadWithDelete(obj);
                    if (!delFlag) {
                        VisitHelper.getInstance().endLoadWithDelete(oldObj);
                    }
                }
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        finally {
            block26: {
                try {
                    if (!bLock) break block26;
                    VisitHelper.getInstance().endLoadWithDelete(obj);
                    if (!delFlag) {
                        VisitHelper.getInstance().endLoadWithDelete(oldObj);
                    }
                }
                catch (Exception e) {
                    this.processException(e);
                }
            }
        }
        if ((usedTime = System.currentTimeMillis() - t1) < 15L) return bDeleted;
        if (!this.permLog.isWarnEnabled()) return bDeleted;
        this.permLog.warn((Object)("method: realDelete region: " + clazz.getName() + " params: " + id + " time: " + usedTime));
        return bDeleted;
    }

    private boolean realDeleteList(Object account_id, Class clazz, List ids, boolean delFlag) throws DaoException {
        DalAssert.assertObjectNotNull(clazz);
        DalAssert.assertObjectNotNull(ids);
        boolean bDeleted = true;
        try {
            for (Object id : ids) {
                this.realDelete(account_id, clazz, (Serializable)id, delFlag);
            }
        }
        catch (Exception e) {
            bDeleted = false;
            this.processException(e);
        }
        return bDeleted;
    }

    @Override
    public boolean deleteList(Object account_id, Class clazz, List ids) throws DaoException {
        return this.realDeleteList(account_id, clazz, ids, true);
    }

    @Override
    public boolean deleteList(Class clazz, List ids) throws DaoException {
        return this.deleteList(null, clazz, ids);
    }

    @Override
    public boolean fakeDeleteList(Object account_id, Class clazz, List ids) throws DaoException {
        return this.realDeleteList(account_id, clazz, ids, false);
    }

    @Override
    public boolean fakeDeleteList(Class clazz, List ids) throws DaoException {
        return this.fakeDeleteList(null, clazz, ids);
    }

    @Override
    public boolean deleteList(Object account_id, String list_name, Object[] params) throws DaoException {
        DalAssert.assertObjectNotNull(list_name);
        DalAssert.assertObjectNotNull(params);
        boolean res = true;
        try {
            List idList = this.getIdList(account_id, list_name, params, true);
            if (null != idList && idList.size() > 0) {
                String clsName = DaoHelper.getObjectNameByListName(list_name);
                if (StringUtils.isBlank((String)clsName)) {
                    LogHelper.failedGetClassNameByListName(this.log, list_name);
                    return true;
                }
                res = this.deleteList(account_id, Class.forName(clsName), idList);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return res;
    }

    @Override
    public boolean deleteList(String list_name, Object[] params) throws DaoException {
        return this.deleteList((Object)null, list_name, params);
    }

    @Override
    public boolean deleteList(Object account_id, String list_name, Object param) throws DaoException {
        if (null == param) {
            return this.deleteList(account_id, list_name, new Object[0]);
        }
        return this.deleteList(account_id, list_name, new Object[]{param});
    }

    @Override
    public boolean deleteList(String list_name, Object param) throws DaoException {
        return this.deleteList(null, list_name, param);
    }

    @Override
    public boolean fakeDeleteList(Object account_id, String list_name, Object[] params) throws DaoException {
        DalAssert.assertObjectNotNull(list_name);
        DalAssert.assertObjectNotNull(params);
        boolean res = true;
        try {
            List idList = this.getIdList(account_id, list_name, params, true);
            if (null != idList && idList.size() > 0) {
                String clsName = DaoHelper.getObjectNameByListName(list_name);
                if (StringUtils.isBlank((String)clsName)) {
                    LogHelper.failedGetClassNameByListName(this.log, list_name);
                    return true;
                }
                res = this.realDeleteList(account_id, Class.forName(clsName), idList, false);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return res;
    }

    @Override
    public boolean fakeDeleteList(String list_name, Object[] params) throws DaoException {
        return this.fakeDeleteList((Object)null, list_name, params);
    }

    @Override
    public boolean fakeDeleteList(Object account_id, String list_name, Object param) throws DaoException {
        if (null == param) {
            return this.fakeDeleteList(account_id, list_name, new Object[0]);
        }
        return this.fakeDeleteList(account_id, list_name, new Object[]{param});
    }

    @Override
    public boolean fakeDeleteList(String list_name, Object param) throws DaoException {
        return this.fakeDeleteList(null, list_name, param);
    }

    @Override
    public Object get(Object account_id, Class clazz, Serializable id) throws DaoException {
        DalAssert.assertClassTypeNotNull(clazz);
        DalAssert.assertObjectNotNull(id);
        long t1 = System.currentTimeMillis();
        Object obj = null;
        try {
            Cache cache = CacheHelper.getClassCache(clazz);
            if (null == cache) {
                obj = DBAgentHibernateImpl.getInstance().get(account_id, clazz, id);
            } else {
                if (CacheHelper.isDelete(clazz.getName(), id + "")) {
                    LogHelper.objectHasBeenDeleted(this.log, clazz, id);
                    return null;
                }
                obj = CacheHelper.get(clazz.getName(), id + "");
                if (null == obj && null != (obj = DBAgentHibernateImpl.getInstance().get(account_id, clazz, id))) {
                    CacheHelper.put(clazz.getName(), id + "", obj);
                }
            }
            DalAssert.assertObjectIllegal(account_id, obj);
        }
        catch (Exception e) {
            this.processException(e);
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: get region: " + clazz.getName() + " params: " + id + " time: " + usedTime));
        }
        return obj;
    }

    @Override
    public Object get(Class clazz, Serializable id) throws DaoException {
        return this.get(null, clazz, id);
    }

    @Override
    public Object get(Class clazz, Serializable id, String lang) throws DaoException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (StringUtils.isEmpty((String)lang)) {
            return this.get(null, clazz, id);
        }
        lang = lang.substring(0, 1).toUpperCase() + lang.substring(1);
        Class<?> nClazz = Class.forName(clazz.getName().replace(clazz.getSimpleName(), clazz.getSimpleName() + lang));
        Object clazzObj = clazz.newInstance();
        Object nClazzObj = this.get(null, nClazz, id);
        if (null != nClazzObj) {
            BeanUtils.copyProperties((Object)nClazzObj, clazzObj);
        } else {
            clazzObj = null;
        }
        return clazzObj;
    }

    public Object getRealMapping(Object account_id, String mappingName, Object[] params, boolean bExtend) throws DaoException {
        DalAssert.assertObjectNotNull(mappingName);
        DalAssert.assertObjectNotNull(params);
        long t1 = System.currentTimeMillis();
        Object obj = null;
        try {
            Cache cache = CacheHelper.getListCache(mappingName);
            SqlInfo sqlInfo = SqlUtil.getMappingSqlInfo(mappingName, params, bExtend);
            if (null == cache) {
                LogHelper.usingMappingWithDB(this.log);
                RoutingService.getInstance().setRoutingStrategyForMap(mappingName, account_id, 1);
                List objList = DBAgentHibernateImpl.getInstance().getObjectList(account_id, mappingName, sqlInfo, 0L, 0L, 1, false, false);
                if (null == objList || objList.size() < 1) {
                    LogHelper.failedExecuteQueryFromDB(this.log, sqlInfo);
                    return null;
                }
                return objList.get(0);
            }
            MapInfo info = new MapInfo(mappingName, params);
            obj = CacheHelper.get(info.getRegion(), info.getKey());
            if (null == obj) {
                RoutingService.getInstance().setRoutingStrategyForMap(mappingName, account_id, 1);
                String dbName = ContextHolder.getDataSource();
                List objList = DBAgentHibernateImpl.getInstance().getObjectList(account_id, mappingName, sqlInfo, 0L, 0L, 1, false, false);
                if (null != objList && objList.size() > 0 && null != objList.get(0)) {
                    obj = objList.get(0);
                    CacheHelper.put(info.getRegion(), info.getKey(), objList.get(0));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.processException(e);
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: getRealMapping region: " + mappingName + " size: " + params.length + " time: " + usedTime));
        }
        return obj;
    }

    @Override
    public Object getMapping(Object account_id, String mappingName, Object[] params) throws DaoException {
        return this.getRealMapping(account_id, mappingName, params, false);
    }

    @Override
    public Object getMapping(String mappingName, Object[] keys) throws DaoException {
        return this.getMapping((Object)null, mappingName, keys);
    }

    @Override
    public Object getMapping(Object account_id, String mappingName, Object key) throws DaoException {
        if (null == key) {
            return this.getMapping(account_id, mappingName, new Object[0]);
        }
        return this.getMapping(account_id, mappingName, new Object[]{key});
    }

    @Override
    public Object getMapping(String mappingName, Object key) throws DaoException {
        return this.getMapping(null, mappingName, key);
    }

    @Override
    public int count(Object account_id, String list_name, Object[] params) throws DaoException {
        DalAssert.assertObjectNotNull(list_name);
        DalAssert.assertObjectNotNull(params);
        long t1 = System.currentTimeMillis();
        Long count = 0L;
        try {
            long usedTime;
            Cache cache = CacheHelper.getListCache(list_name);
            if (null == cache) {
                SqlInfo sqlInfo = SqlUtil.getListCountSql(list_name, params);
                int lsType = ObjectUtil.getListType(list_name);
                if (lsType == 3) {
                    List<List> list = DBAgentHibernateImpl.getInstance().crossDBList(account_id, list_name, sqlInfo, 0, 1, 1);
                    if (null != list) {
                        for (List ls : list) {
                            count = count + (long)((Number)ls.get(0)).intValue();
                        }
                    }
                    return count.intValue();
                }
                List list = DBAgentHibernateImpl.getInstance().getObjectList(account_id, list_name, sqlInfo, 0L, 1L, 1, true, true);
                return ((Number)list.get(0)).intValue();
            }
            LsCacheInfo lsInfo = new LsCacheInfo(list_name, params);
            ListInfoHelper infoHelper = ListLoaderCenter.getInstance().getListInfo(account_id, new LsCacheInfoHelper(lsInfo), 1, true);
            if (null != infoHelper) {
                count = infoHelper.getSize();
            }
            if ((usedTime = System.currentTimeMillis() - t1) >= 15L && this.permLog.isWarnEnabled()) {
                this.permLog.warn((Object)("method: count region: " + list_name + " params: " + lsInfo.getKey() + " time: " + usedTime));
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return count.intValue();
    }

    @Override
    public int count(String list_name, Object[] params) throws DaoException {
        return this.count((Object)null, list_name, params);
    }

    @Override
    public int count(Object account_id, String list_name, Object param) throws DaoException {
        if (null == param) {
            return this.count(account_id, list_name, new Object[0]);
        }
        return this.count(account_id, list_name, new Object[]{param});
    }

    @Override
    public int count(String list_name, Object param) throws DaoException {
        return this.count(null, list_name, param);
    }

    @Override
    public List getIdList(Object account_id, String list_name, Object[] params, Integer start, Integer count, boolean forward) throws DaoException {
        long t1 = System.currentTimeMillis();
        DalAssert.assertObjectNotNull(list_name);
        DalAssert.assertObjectNotNull(params);
        DalAssert.assertObjectNotNull(start);
        DalAssert.assertObjectNotNull(count);
        ArrayList idList = new ArrayList();
        ListInfoHelper infoHelper = null;
        Cache cache = null;
        LsCacheInfoHelper lsHelper = new LsCacheInfoHelper(list_name, params);
        try {
            long usedTime;
            long j;
            cache = CacheHelper.getListCache(list_name);
            if (null == cache) {
                SqlInfo sqlInfo = SqlUtil.getListSql(list_name, params, forward);
                long lsType = ObjectUtil.getListType(list_name).intValue();
                if (lsType == 3L) {
                    return DBAgentHibernateImpl.getInstance().getOrderedCrossList(account_id, list_name, sqlInfo, new Long(start.intValue()), new Long(count.intValue()), 1, forward);
                }
                return DBAgentHibernateImpl.getInstance().getObjectList(account_id, list_name, sqlInfo, new Long(start.intValue()), new Long(count.intValue()), 1, true, false);
            }
            infoHelper = ListLoaderCenter.getInstance().getListInfo(account_id, lsHelper, 1, true);
            if (null == infoHelper || infoHelper.getSize() < 1L || (long)start.intValue() >= infoHelper.getSize()) {
                return idList;
            }
            ListLoadInfo listLoadInfo = infoHelper.getListLoadInfo(new Long(start.intValue()), forward);
            if (null == listLoadInfo) {
                System.out.println("\r\n ListLoadInfo of List " + lsHelper.getRegion() + " key: " + lsHelper.getKey() + " is null,when list's size is " + infoHelper.getSize() + "\r\n");
                if (infoHelper.getSize() > 0L) {
                    CacheHelper.removeListInfo(lsHelper);
                    infoHelper = ListLoaderCenter.getInstance().getListInfo(account_id, lsHelper, 1, false);
                    if (null == infoHelper || infoHelper.getSize() < 1L || (long)start.intValue() >= infoHelper.getSize()) {
                        System.out.println("\r\n Again : ListLoadInfo of List " + lsHelper.getRegion() + " key: " + lsHelper.getKey() + " is null,when list's size is " + infoHelper.getSize() + "\r\n");
                        return idList;
                    }
                    listLoadInfo = infoHelper.getListLoadInfo(new Long(start.intValue()), forward);
                    if (null == listLoadInfo) {
                        System.out.println("\r\n ListLoadInfo of List " + lsHelper.getRegion() + " key: " + lsHelper.getKey() + " is null,when list's size is " + infoHelper.getSize() + "\r\n");
                        return idList;
                    }
                } else {
                    return idList;
                }
            }
            if (forward) {
                j = count.intValue();
                for (long i = listLoadInfo.sectionNo.longValue(); i >= 0L && j > 0L; --i) {
                    int startIndex = 0;
                    List idCacheList = ListLoaderCenter.getInstance().getSectionIdList(lsHelper, infoHelper, account_id, i, 1, true);
                    if (null == idCacheList || idCacheList.size() < 1) break;
                    if (i == listLoadInfo.sectionNo) {
                        startIndex = listLoadInfo.indexInSection.intValue();
                        if (startIndex >= idCacheList.size()) {
                            LogHelper.listInfoNotMatchSectionInCache(this.log, lsHelper, listLoadInfo, idCacheList);
                            startIndex = idCacheList.size() - 1;
                        }
                    } else {
                        startIndex = idCacheList.size() - 1;
                    }
                    for (int m = startIndex; m >= 0 && j > 0L; --j, --m) {
                        idList.add(idCacheList.get(m));
                    }
                }
            } else {
                j = count.intValue();
                for (long i = listLoadInfo.sectionNo.longValue(); i <= infoHelper.getMaxSectionNo() && j > 0L; ++i) {
                    int startIndex = 0;
                    List idCacheList = ListLoaderCenter.getInstance().getSectionIdList(lsHelper, infoHelper, account_id, i, 1, true);
                    if (null != idCacheList && idCacheList.size() >= 0) {
                        if (i == listLoadInfo.sectionNo) {
                            startIndex = listLoadInfo.indexInSection.intValue();
                            if (startIndex >= idCacheList.size()) {
                                LogHelper.listInfoNotMatchSectionInCache(this.log, lsHelper, listLoadInfo, idCacheList);
                                startIndex = idCacheList.size() - 1;
                            }
                        } else {
                            startIndex = 0;
                        }
                        for (int m = startIndex; m < idCacheList.size() && j > 0L; --j, ++m) {
                            idList.add(idCacheList.get(m));
                        }
                        continue;
                    }
                    break;
                }
            }
            if ((usedTime = System.currentTimeMillis() - t1) >= 15L && this.permLog.isWarnEnabled() && null != lsHelper) {
                this.permLog.warn((Object)("method: getIdList region: " + list_name + " params: " + lsHelper.getKey() + "&" + start + "&" + count + " time: " + usedTime));
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return idList;
    }

    @Override
    public List getIdList(Object account_id, String list_name, Object[] params, boolean forward) throws DaoException {
        int totalCount = this.count(account_id, list_name, params);
        if (totalCount <= 0) {
            return new ArrayList();
        }
        return this.getIdList(account_id, list_name, params, (Integer)0, (Integer)totalCount, forward);
    }

    @Override
    public List getIdList(String list_name, Object[] params, boolean forward) throws DaoException {
        return this.getIdList((Object)null, list_name, params, forward);
    }

    @Override
    public List getIdList(Object account_id, String list_name, Object param, boolean forward) throws DaoException {
        if (null == param) {
            return this.getIdList(account_id, list_name, new Object[0], forward);
        }
        return this.getIdList(account_id, list_name, new Object[]{param}, forward);
    }

    @Override
    public List getIdList(String list_name, Object param, boolean forward) throws DaoException {
        return this.getIdList(null, list_name, param, forward);
    }

    @Override
    public List getIdList(String list_name, Object[] params, Integer start, Integer count, boolean forward) throws DaoException {
        return this.getIdList((Object)null, list_name, params, start, count, forward);
    }

    @Override
    public List getIdList(Object account_id, String list_name, Object param, Integer start, Integer count, boolean forward) throws DaoException {
        if (null == param) {
            return this.getIdList(account_id, list_name, new Object[0], start, count, forward);
        }
        return this.getIdList(account_id, list_name, new Object[]{param}, start, count, forward);
    }

    @Override
    public List getIdList(String list_name, Object param, Integer start, Integer count, boolean forward) throws DaoException {
        return this.getIdList(null, list_name, param, start, count, forward);
    }

    @Override
    public List getList(Object account_id, Class clazz, List ids) throws DaoException {
        List objList = this.getListWithNULLOBJ(account_id, clazz, ids);
        ArrayList resList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)objList)) {
            for (Object obj : objList) {
                if (null == obj) continue;
                resList.add(obj);
            }
        }
        return resList;
    }

    @Override
    public List getList(Class clazz, List ids) throws DaoException {
        return this.getList(null, clazz, ids);
    }

    @Override
    public List getList(Class clazz, List ids, String lang) throws DaoException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (StringUtils.isEmpty((String)lang)) {
            return this.getList(null, clazz, ids);
        }
        ArrayList list = new ArrayList();
        lang = lang.substring(0, 1).toUpperCase() + lang.substring(1);
        Class<?> nClazz = Class.forName(clazz.getName().replace(clazz.getSimpleName(), clazz.getSimpleName() + lang));
        List resultList = this.getList(null, nClazz, ids);
        for (Object o : resultList) {
            Object clazzObj = clazz.newInstance();
            if (o == null) continue;
            BeanUtils.copyProperties(o, clazzObj);
            list.add(clazzObj);
        }
        return list;
    }

    @Override
    public List getListWithNULLOBJ(Object account_id, Class clazz, List ids) throws DaoException {
        DalAssert.assertClassTypeNotNull(clazz);
        DalAssert.assertObjectNotNull(ids);
        long t1 = System.currentTimeMillis();
        List<Object> objList = new ArrayList();
        if (null == ids || ids.size() < 1) {
            this.log.warn((Object)" id list is empty");
            return objList;
        }
        try {
            Cache cache = CacheHelper.getClassCache(clazz);
            if (null == cache) {
                objList = this.getObjectList(account_id, clazz, ids);
            } else {
                List newObjLs;
                List unExistIdList = new ArrayList();
                ArrayList<String> idStrList = new ArrayList<String>();
                ArrayList<Integer> indexLs = new ArrayList<Integer>();
                HashMap<String, Integer> indexIdMap = new HashMap<String, Integer>();
                for (Object id : ids) {
                    if (null != id) {
                        idStrList.add("" + id);
                        continue;
                    }
                    idStrList.add(null);
                }
                Object[] obs = MultiCacheGet.get(cache, idStrList.toArray(new String[idStrList.size()]));
                if (null == obs || 1 == obs.length) {
                    for (int j = 0; j < ids.size(); ++j) {
                        indexLs.add(j);
                        unExistIdList.add(ids.get(j));
                        indexIdMap.put("" + ids.get(j), j);
                    }
                    unExistIdList = ids;
                } else {
                    for (int i = 0; i < obs.length; ++i) {
                        Object object = obs[i];
                        if (null != object) continue;
                        indexLs.add(i);
                        unExistIdList.add(ids.get(i));
                        indexIdMap.put("" + ids.get(i), i);
                    }
                }
                if (unExistIdList.size() > 0 && (newObjLs = this.getObjectList(account_id, clazz, unExistIdList)).size() > 0) {
                    Cache objCache = CacheHelper.getClassCache(clazz);
                    if (newObjLs.size() == unExistIdList.size()) {
                        for (int j = 0; j < newObjLs.size(); ++j) {
                            Object object = newObjLs.get(j);
                            if (null == object) continue;
                            objCache.put(unExistIdList.get(j) + "", object);
                            obs[((Integer)indexLs.get((int)j)).intValue()] = object;
                        }
                    } else if (newObjLs.size() != unExistIdList.size()) {
                        for (Object obj : newObjLs) {
                            Serializable id = ObjectUtil.getObjectId(obj);
                            Integer index = (Integer)indexIdMap.get(id + "");
                            objCache.put(id + "", obj);
                            obs[index.intValue()] = obj;
                        }
                    } else {
                        LogHelper.failedLoadObjectLsByIdLs(this.log, clazz);
                    }
                }
                if (null != obs && obs.length > 0) {
                    for (Object obj : obs) {
                        objList.add(obj);
                    }
                }
            }
            long usedTime = System.currentTimeMillis() - t1;
            if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
                this.permLog.warn((Object)("method: getList region: " + clazz.getName() + " size: " + ids.size() + " time: " + usedTime));
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return objList;
    }

    @Override
    public List getListWithNULLOBJ(Class clazz, List ids) throws DaoException {
        return this.getListWithNULLOBJ(null, clazz, ids);
    }

    private List getObjectList(Object account_id, Class clazz, List ids) throws DaoException {
        List objList = new ArrayList();
        ObjectItem objItem = DaoHelper.getObjectItemByObjectName(clazz.getName());
        String baseSql = objItem.getEntitySql();
        if (null == baseSql || StringUtils.isBlank((String)baseSql)) {
            return objList;
        }
        List<SqlInfo> sqlInfoLs = SqlUtil.getEntityUnionSql(ids, baseSql);
        if (null == sqlInfoLs) {
            return objList;
        }
        try {
            objList = MultiDBGet.get(account_id, clazz, sqlInfoLs);
        }
        catch (CacheException e) {
            e.printStackTrace(System.out);
            e.printStackTrace(System.err);
        }
        for (SqlInfo sqlInfo : sqlInfoLs) {
            List entityLs = DBAgentHibernateImpl.getInstance().getEntityList(account_id, clazz, sqlInfo, 1);
            objList.addAll(entityLs);
        }
        return objList;
    }

    @Override
    public List getMappings(Object accountId, String mapName, List<Object[]> paramsList) throws DaoException {
        DalAssert.assertObjectNotNull(accountId);
        DalAssert.assertObjectNotNull(mapName);
        DalAssert.assertObjectNotNull(paramsList);
        long t1 = System.currentTimeMillis();
        try {
            long usedTime;
            List newObjLs;
            Cache cache = CacheHelper.getListCache(mapName);
            if (null == cache) {
                return DBAgentHibernateImpl.getInstance().getMaps(accountId, mapName, paramsList);
            }
            ArrayList<Object[]> unExistList = new ArrayList<Object[]>();
            ArrayList<String> mapKeyList = new ArrayList<String>();
            ArrayList<Integer> indexLs = new ArrayList<Integer>();
            for (Object[] obs : paramsList) {
                MapInfo mapInfo = new MapInfo(mapName, obs);
                mapKeyList.add(mapInfo.getKey());
            }
            Object[] obs = cache.get(mapKeyList.toArray(new String[mapKeyList.size()]));
            if (null == obs || 1 == obs.length) {
                for (int j = 0; j < paramsList.size(); ++j) {
                    indexLs.add(j);
                    unExistList.add(paramsList.get(j));
                }
            } else {
                for (int i = 0; i < obs.length; ++i) {
                    Object object = obs[i];
                    if (null != object) continue;
                    indexLs.add(i);
                    unExistList.add(paramsList.get(i));
                }
            }
            if (unExistList.size() > 0 && (newObjLs = DBAgentHibernateImpl.getInstance().getMaps(accountId, mapName, unExistList)).size() > 0) {
                if (newObjLs.size() == unExistList.size()) {
                    for (int j = 0; j < newObjLs.size(); ++j) {
                        Object object = newObjLs.get(j);
                        if (null == object) continue;
                        Object[] params = (Object[])unExistList.get(j);
                        MapInfo mapInfo = new MapInfo(mapName, params);
                        cache.put(mapInfo.getKey(), object);
                        obs[((Integer)indexLs.get((int)j)).intValue()] = object;
                    }
                } else {
                    LogHelper.failedLoadMapsLsByParams(this.log, mapName, paramsList);
                }
            }
            ArrayList<Object> objList = new ArrayList<Object>();
            if (null != obs && obs.length > 0) {
                for (Object obj : obs) {
                    objList.add(obj);
                }
            }
            if ((usedTime = System.currentTimeMillis() - t1) >= 15L && this.permLog.isWarnEnabled()) {
                this.permLog.warn((Object)("method: getMappings region: " + mapName + " size: " + paramsList.size() + " time: " + usedTime));
            }
            return objList;
        }
        catch (Exception e) {
            this.processException(e);
            return null;
        }
    }

    @Override
    public Map getMappingsMap(Object accountId, String mapName, List<Object[]> paramsList) throws DaoException {
        HashMap resultMap = new HashMap();
        List resultList = this.getMappings(accountId, mapName, paramsList);
        if (CollectionUtils.isNotEmpty(paramsList) && CollectionUtils.isNotEmpty((Collection)resultList)) {
            int size = paramsList.size();
            for (int i = 0; i < size; ++i) {
                Object[] objects = paramsList.get(i);
                Object obj = resultList.get(i);
                resultMap.put(objects, obj);
            }
        }
        return resultMap;
    }

    @Override
    public List getMapList(List accountIdList, String mapname, List<Object[]> paramsList) throws DaoException {
        ArrayList resList;
        block16: {
            DalAssert.assertObjectNotNull(accountIdList);
            DalAssert.assertObjectNotNull(mapname);
            DalAssert.assertObjectNotNull(paramsList);
            resList = new ArrayList();
            try {
                int i;
                Cache cache = CacheHelper.getListCache(mapname);
                if (null == cache) {
                    HashMap<String, Object> dbParamsMap = new HashMap<String, Object>();
                    HashMap dbAccountMap = new HashMap();
                    for (int index = 0; index < accountIdList.size(); ++index) {
                        Object[] params;
                        Object accountId = accountIdList.get(index);
                        RoutingService.getInstance().setRoutingStrategyForMap(mapname, accountId, 1);
                        String dbName = ContextHolder.getDataSource();
                        if (null == dbAccountMap.get(dbName)) {
                            params = paramsList.get(index);
                            if (null == params) continue;
                            dbAccountMap.put(dbName, accountId);
                            ArrayList newParamList = new ArrayList();
                            newParamList.add(params);
                            dbParamsMap.put(dbName, newParamList);
                            continue;
                        }
                        params = paramsList.get(index);
                        if (null == params) continue;
                        ((List)dbParamsMap.get(dbName)).add(params);
                    }
                    for (String dbName : dbAccountMap.keySet()) {
                        List bufList = new ArrayList();
                        List<SqlInfo> sqlInfoLs = SqlUtil.getMapAggreSqlInfos(mapname, (List)dbParamsMap.get(dbName));
                        RoutingService.getInstance().setRoutingStrategyForMap(mapname, dbAccountMap.get(dbName), 1);
                        for (SqlInfo sqlInfo : sqlInfoLs) {
                            bufList = DBAgentHibernateImpl.getInstance().getObjectList(null, null, sqlInfo, 0L, 0L, 1, false, true);
                            resList.addAll(bufList);
                        }
                    }
                    break block16;
                }
                ArrayList<Object[]> unExistList = new ArrayList<Object[]>();
                ArrayList<String> mapKeyList = new ArrayList<String>();
                ArrayList<Integer> indexLs = new ArrayList<Integer>();
                for (Object[] obs : paramsList) {
                    MapInfo mapInfo = new MapInfo(mapname, obs);
                    mapKeyList.add(mapInfo.getKey());
                }
                Object[] obs = cache.get(mapKeyList.toArray(new String[mapKeyList.size()]));
                if (null == obs || 1 == obs.length) {
                    for (int j = 0; j < paramsList.size(); ++j) {
                        indexLs.add(j);
                        unExistList.add(paramsList.get(j));
                    }
                } else {
                    for (i = 0; i < obs.length; ++i) {
                        Object object = obs[i];
                        if (null != object) continue;
                        indexLs.add(i);
                        unExistList.add(paramsList.get(i));
                    }
                }
                if (unExistList.size() > 0) {
                    for (i = 0; i < unExistList.size(); ++i) {
                        int oldIndex = (Integer)indexLs.get(i);
                        Object obj = this.getRealMapping(accountIdList.get(oldIndex), mapname, (Object[])unExistList.get(i), true);
                        if (null == obj) continue;
                        obs[oldIndex] = obj;
                    }
                }
                ArrayList<Object> objList = new ArrayList<Object>();
                if (null != obs && obs.length > 0) {
                    for (Object obj : obs) {
                        objList.add(obj);
                    }
                }
                return objList;
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
        return resList;
    }

    private void processException(Exception e) throws DaoException {
        e.printStackTrace(System.out);
        if (e instanceof MappingException) {
            throw new DaoException(401, e);
        }
        if (e instanceof NullPointerException) {
            throw new DaoException(303, e);
        }
        if (e instanceof SQLException) {
            throw new DaoException(500, e);
        }
        if (e instanceof HibernateException) {
            throw new DaoException(400, e);
        }
        if (e instanceof StrategyException) {
            throw new DaoException(306, e);
        }
        if (e instanceof DaoException) {
            throw (DaoException)e;
        }
        throw new DaoException(e);
    }

    @Override
    public Long getMaxIdOfClass(Class clazz) throws DaoException {
        return null;
    }

    @Override
    public Object excuteSimpleSql(String sql, Class clazz) throws DaoException {
        return DBAgentHibernateImpl.getInstance().excuteSimpleSql(sql, clazz);
    }

    @Override
    public Object excuteHardSimpleSql(String sql, Class clazz) throws DaoException {
        return DBAgentHibernateImpl.getInstance().excuteHardSimpleSql(sql, clazz);
    }
}

