/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.helper;

import com.gemantic.dal.dao.helper.LogHelper;
import com.gemantic.dal.dao.helper.LsCacheInfoHelper;
import com.gemantic.dal.dao.util.ObjectUtil;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VisitHelper {
    public static VisitHelper helper;
    private ConcurrentHashMap<String, Long> listInfoMaps = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> idListMaps = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> objChangeMaps = new ConcurrentHashMap();
    private static final String saveLockKey = "_-&save";
    private static final String deleteLockKey = "_-&delete";
    private static final String updateLockKey = "_-&update";
    private static final long maxSpan = 30000L;
    private static Log log;

    private VisitHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VisitHelper getInstance() {
        if (null != helper) return helper;
        Class<VisitHelper> clazz = VisitHelper.class;
        synchronized (VisitHelper.class) {
            if (null != helper) return helper;
            helper = new VisitHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return helper;
        }
    }

    public boolean endLsLoading(String region, String key, Long value) {
        String lsKey = region + "%" + key;
        boolean res = this.listInfoMaps.remove(lsKey, value);
        if (!res) {
            LogHelper.listInfoLockHasBeenRemoved(log, region, key);
        }
        return res;
    }

    public boolean endLsLoading(LsCacheInfoHelper lsHelper, Long value) {
        return this.endLsLoading(lsHelper.getRegion(), lsHelper.getKey(), value);
    }

    public Long checkLsInLoading(String region, String key) throws Exception {
        boolean inLoading = this.isObjectBeingChanged(region, key);
        Long lockedValue = null;
        if (!inLoading) {
            Long currTime;
            String lsKey = region + "%" + key;
            Long oldTime = this.listInfoMaps.putIfAbsent(lsKey, currTime = new Long(System.currentTimeMillis()));
            if (null == oldTime) {
                lockedValue = currTime;
            } else if (currTime - oldTime >= 30000L && this.listInfoMaps.replace(lsKey, oldTime, currTime)) {
                lockedValue = currTime;
            }
        }
        return lockedValue;
    }

    public Long checkLsInLoading(LsCacheInfoHelper lsHelper) throws Exception {
        return this.checkLsInLoading(lsHelper.getRegion(), lsHelper.getKey());
    }

    public boolean endIdLsLoading(String region, String key, Long value) {
        String lsKey = region + "%" + key;
        boolean res = this.idListMaps.remove(lsKey, value);
        if (!res) {
            LogHelper.sectionLockHasBeenRemoved(log, region, key);
        }
        return res;
    }

    public boolean endIdLsLoading(LsCacheInfoHelper lsHelper, Long value) {
        return this.endIdLsLoading(lsHelper.getRegion(), lsHelper.getKey(), value);
    }

    public Long checkIdLsLoad(String region, String key) throws Exception {
        boolean inLoading = this.isObjectBeingChanged(region, key);
        Long lockedValue = null;
        if (!inLoading) {
            Long currTime;
            String lsKey = region + "%" + key;
            Long oldTime = this.idListMaps.putIfAbsent(lsKey, currTime = new Long(System.currentTimeMillis()));
            if (null == oldTime) {
                lockedValue = currTime;
            } else if (currTime - oldTime >= 30000L && this.idListMaps.replace(lsKey, oldTime, currTime)) {
                lockedValue = currTime;
            }
        }
        return lockedValue;
    }

    public Long checkIdLsLoad(LsCacheInfoHelper lsHelper) throws Exception {
        return this.checkIdLsLoad(lsHelper.getRegion(), lsHelper.getKey());
    }

    public void inLoadWithSave(Object object) throws Exception {
        this.inLoadWithChanging(object, saveLockKey);
    }

    public void inLoadWithDelete(Object object) throws Exception {
        this.inLoadWithChanging(object, deleteLockKey);
    }

    public void inLoadWithUpdate(Object object) throws Exception {
        this.inLoadWithChanging(object, updateLockKey);
    }

    private void inLoadWithChanging(Object object, String lockKey) throws Exception {
        List<LsCacheInfoHelper> list = ObjectUtil.getLsInfoList(object);
        for (LsCacheInfoHelper lsHelper : list) {
            String lsKey = lsHelper.getRegion() + "%" + lsHelper.getKey();
            String lsLockKey = lsKey + lockKey;
            this.objChangeMaps.put(lsLockKey, System.currentTimeMillis());
            this.listInfoMaps.remove(lsKey);
            this.idListMaps.remove(lsKey);
        }
    }

    public void endLoadWithSave(Object object) throws Exception {
        this.endLoadWithChanging(object, saveLockKey);
    }

    public void endLoadWithDelete(Object object) throws Exception {
        this.endLoadWithChanging(object, deleteLockKey);
    }

    public void endLoadWithUpdate(Object object) throws Exception {
        this.endLoadWithChanging(object, updateLockKey);
    }

    private void endLoadWithChanging(Object object, String lockKey) throws Exception {
        List<LsCacheInfoHelper> list = ObjectUtil.getLsInfoList(object);
        for (LsCacheInfoHelper lsHelper : list) {
            String lsKey = lsHelper.getRegion() + "%" + lsHelper.getKey() + lockKey;
            this.objChangeMaps.remove(lsKey);
        }
    }

    private boolean isObjectSaving(String listName, String key) throws Exception {
        return this.isObjectChanging(listName, key, saveLockKey);
    }

    private boolean isObjectDeleting(String listName, String key) throws Exception {
        return this.isObjectChanging(listName, key, deleteLockKey);
    }

    private boolean isObjectUpdating(String listName, String key) throws Exception {
        return this.isObjectChanging(listName, key, updateLockKey);
    }

    private boolean isObjectChanging(String listName, String key, String lockKey) throws Exception {
        boolean res = true;
        if (StringUtils.isBlank((String)listName)) {
            return false;
        }
        String lsKey = listName + "%" + key + lockKey;
        Long lastLockTime = this.objChangeMaps.get(lsKey);
        if (null == lastLockTime) {
            res = false;
        } else if (System.currentTimeMillis() - lastLockTime >= 30000L) {
            res = !this.objChangeMaps.remove(lsKey, lastLockTime);
        }
        return res;
    }

    private boolean isObjectBeingChanged(String listName, String key) throws Exception {
        return this.isObjectSaving(listName, key) | this.isObjectDeleting(listName, key) | this.isObjectUpdating(listName, key);
    }

    static {
        log = LogFactory.getLog(VisitHelper.class);
    }
}

