/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.helper;

import com.gemantic.dal.dao.helper.LogHelper;
import com.gemantic.dal.dao.model.ListInfo;
import com.gemantic.dal.dao.model.ListLoadInfo;
import com.gemantic.dal.dao.util.Constants;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListInfoHelper {
    private ListInfo info;
    private static Log log = LogFactory.getLog(ListInfoHelper.class);

    public ListInfoHelper(ListInfo ls) {
        this.info = ls;
    }

    public ListInfoHelper(long totalCnt) {
        this.info = new ListInfo(totalCnt);
    }

    public ListInfo getListInfo() {
        return this.info;
    }

    public boolean isVisited() {
        return null != this.info;
    }

    public boolean isSectionsVistied() {
        boolean res = false;
        if (this.isVisited() && this.info.getSize() > 0L && null != this.info.getSections() && this.info.getSections().size() > 0) {
            res = true;
        }
        return res;
    }

    public boolean isVisited(Long SectionNo) {
        Long SectionSize;
        boolean res = false;
        if (null != this.info && null != this.info.getSections() && null != (SectionSize = this.info.getSections().get(SectionNo))) {
            res = true;
        }
        return res;
    }

    public boolean isCrossAggrInfoBuild() {
        boolean res = false;
        if (null != this.info && null != this.info.getMaxMins() && this.info.getMaxMins().size() > 0) {
            res = true;
        }
        return res;
    }

    public boolean isLatestSection(Long sectionNo) {
        boolean res = false;
        if (null != this.info && null != sectionNo && this.info.getSize() > 0L && this.getMaxSectionNo() == (long)sectionNo.intValue()) {
            res = true;
        }
        return res;
    }

    public boolean isLatestSecVisited() {
        boolean res = false;
        if (this.isSectionsVistied()) {
            res = this.isVisited(this.getMaxSectionNo());
        }
        return res;
    }

    public int getSectionsSize() {
        if (null == this.info) {
            return 0;
        }
        if (null == this.info.getSections()) {
            return 0;
        }
        return this.info.getSections().size();
    }

    public Long getSectionSize(Long sectionNo) {
        Long secSize = new Long(0L);
        if (null != this.info && null != sectionNo) {
            secSize = this.isLatestSection(sectionNo) ? this.getLatestSecSize() : (this.isVisited(sectionNo) ? this.info.getSections().get(sectionNo) : Constants.SecCapacity);
        }
        return secSize;
    }

    public synchronized void addSectionInfo(Long sectionNo, Long sectionCnt) {
        if (null != this.info) {
            if (null != sectionNo && null != sectionCnt) {
                this.info.getSections().put(sectionNo, sectionCnt);
            }
        } else {
            log.error((Object)"Error : Add Section Info error -- No ListInfo exists");
        }
    }

    public synchronized void addMinMaxInfo(Long sectionNo, Number min, Number max) {
        this.info.getMaxMins().put(sectionNo, new Number[]{min, max});
    }

    public synchronized void removeSectionInfo(Long sectionNo) {
        this.info.getSections().remove(sectionNo);
    }

    public boolean isSectionMinMaxExist(Long sectionNo) {
        Number[] nums;
        boolean res = false;
        if (null != this.info && null != this.info.getMaxMins() && this.info.getMaxMins().size() > 0 && null != (nums = this.info.getMaxMins().get(sectionNo)) && nums.length > 1) {
            res = true;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addId() {
        if (null != this.info) {
            ListInfo listInfo = this.info;
            synchronized (listInfo) {
                this.info.increaseSize();
                this.info.getSections().remove(this.getMaxSectionNo());
            }
        } else {
            log.error((Object)"Error : Add Id error -- No ListInfo exists");
        }
    }

    public synchronized void increaseSize() {
        if (null != this.info) {
            this.info.increaseSize();
        } else {
            log.error((Object)"Error : Increase List's size error -- No ListInfo exists");
        }
    }

    public synchronized void addSection(Long sectionNo) {
        if (null != this.info) {
            if (this.isVisited(sectionNo)) {
                return;
            }
            Long sectionSize = Constants.SecCapacity;
            if (this.isLatestSection(sectionNo)) {
                sectionSize = this.getLatestSecSize();
            }
            this.info.getSections().put(sectionNo, sectionSize);
        }
    }

    public synchronized void removeId(Long sectionNo) {
        if (null != this.info) {
            if (this.info.getSize() > 0L) {
                long sectionSize = this.getSectionSize(sectionNo);
                if (1L == sectionSize) {
                    this.info.getSections().remove(sectionNo);
                } else {
                    this.info.getSections().put(sectionNo, new Long(sectionSize - 1L));
                }
            }
            this.info.decreaseSize();
        }
    }

    public synchronized void decreateSize() {
        if (null != this.info) {
            this.info.decreaseSize();
        }
    }

    public long getMaxSectionNo() {
        if (null != this.info) {
            return (this.info.getSize() - 1L) / Constants.SecCapacity;
        }
        return -1L;
    }

    public long getNewMaxSectionNo() {
        if (null != this.info) {
            return (this.info.getSize() - 1L + 1L) / Constants.SecCapacity;
        }
        return 0L;
    }

    public Long getLatestSecSize() {
        long sectionSize = 0L;
        if (null != this.info && this.info.getSize() > 0L) {
            if (this.isLatestSecVisited()) {
                sectionSize = this.info.getSections().get(this.getMaxSectionNo());
            } else {
                sectionSize = this.info.getSize();
                Iterator<Long> iter = this.info.getSections().keySet().iterator();
                while (iter.hasNext()) {
                    sectionSize -= (long)this.info.getSections().get(iter.next()).intValue();
                }
                if (0L == (sectionSize %= Constants.SecCapacity.longValue())) {
                    sectionSize = Constants.SecCapacity;
                }
            }
        }
        return new Long(sectionSize);
    }

    public boolean isSectionsReBuild() {
        boolean res = false;
        if (null != this.info && this.info.getSize() > 0L) {
            int totalDeleteCnt = 1;
            if (null != this.info.getSections() && this.info.getSections().size() > 0) {
                try {
                    Iterator<Long> iter = this.info.getSections().keySet().iterator();
                    while (iter.hasNext()) {
                        Long sectionSize = this.info.getSections().get(iter.next());
                        if ((long)(totalDeleteCnt = (int)((long)totalDeleteCnt + (Constants.SecCapacity - (long)sectionSize.intValue()))) < Constants.SecCapacity) continue;
                        res = true;
                        break;
                    }
                    if (!this.isLatestSecVisited() && (long)(totalDeleteCnt = (int)((long)totalDeleteCnt + (Constants.SecCapacity - (long)this.getLatestSecSize().intValue()))) >= Constants.SecCapacity) {
                        res = true;
                    }
                    if (res && 1L == this.getLatestSecSize() && (long)totalDeleteCnt == Constants.SecCapacity) {
                        res = false;
                    }
                }
                catch (Exception e) {
                    LogHelper.errorWhenJudgeListRebuild(log, this.info, e);
                }
            }
        }
        return res;
    }

    public Long getSectionIndex(Long sectionNo) throws Exception {
        long startIndex = -1L;
        if (null != this.info) {
            if (this.getMaxSectionNo() < (long)sectionNo.intValue()) {
                log.warn((Object)("Error: Current Max page No is :" + this.getMaxSectionNo() + ",so section :" + sectionNo + " doesn't exist \r\n"));
                return null;
            }
            startIndex = 0L;
            int i = 0;
            while ((long)i < sectionNo) {
                Long sectionCnt = null;
                sectionCnt = this.info.getSections().get(new Long(i));
                startIndex = null == sectionCnt ? (startIndex += Constants.SecCapacity.longValue()) : (startIndex += (long)sectionCnt.intValue());
                ++i;
            }
            startIndex = this.getSize() - (startIndex + this.getSectionSize(sectionNo));
        }
        return new Long(startIndex);
    }

    public Long getLatestSecIndex() throws Exception {
        Long no = this.getMaxSectionNo();
        return this.getSectionIndex(no);
    }

    public ListLoadInfo getListLoadInfo(Long start, boolean forward) throws Exception {
        ListLoadInfo listLoadInfo = null;
        long realNo = -1L;
        realNo = forward ? this.info.getSize() - (long)start.intValue() - 1L : (long)start.intValue();
        for (long i = 0L; i <= this.getMaxSectionNo(); ++i) {
            long sectionSize = this.getSectionSize(i);
            if (realNo >= sectionSize) {
                realNo -= sectionSize;
                continue;
            }
            listLoadInfo = new ListLoadInfo(i, realNo);
            break;
        }
        return listLoadInfo;
    }

    public Map<Long, Long> getVisitedSections() {
        return this.info.getSections();
    }

    public long getSize() {
        return this.info.getSize();
    }

    public Number[] getMinMaxOfCross(Long sectionNo) {
        if (null == this.info || null == this.info.getMaxMins()) {
            return null;
        }
        return this.info.getMaxMins().get(sectionNo);
    }

    public void setSize(long sizeNum) {
        if (null != this.info) {
            this.info.setSize(sizeNum);
        }
    }

    public void removeLastedVisitedSection() {
        if (null != this.info) {
            this.info.getSections().remove(this.getMaxSectionNo());
        }
    }
}

