/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.cachehandler.impl;

import com.gemantic.dal.cache.Cache;
import com.gemantic.dal.dao.exception.DaoException;
import com.gemantic.dal.dao.exception.StrategyException;
import com.gemantic.dal.dao.helper.LogHelper;
import com.gemantic.dal.dao.model.MapInfo;
import com.gemantic.dal.dao.util.CacheHelper;
import com.gemantic.dal.dao.util.ObjectUtil;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;

public class MapCacheHelper {
    private static Log log = LogFactory.getLog(MapCacheHelper.class);

    public static void removeFromCache(Object object) throws Exception {
        List<MapInfo> oldMaps = ObjectUtil.getMapInfoList(object);
        for (MapInfo info : oldMaps) {
            Cache cache = CacheHelper.getListCache(info.getRegion());
            if (null == cache) {
                LogHelper.cacheDontConfigured(log, info.getRegion());
                continue;
            }
            cache.remove(info.getKey());
        }
    }

    public static void updateToCache(Object object) throws Exception {
        List<MapInfo> newMaps = ObjectUtil.getMapInfoList(object);
        for (MapInfo info : newMaps) {
            Cache cache = CacheHelper.getListCache(info.getRegion());
            if (null == cache) {
                LogHelper.cacheDontConfigured(log, info.getRegion());
                continue;
            }
            cache.put(info.getKey(), info.getValue());
        }
    }

    private static void processException(Exception e) throws DaoException {
        e.printStackTrace(System.out);
        if (e instanceof MappingException) {
            throw new DaoException(401, e);
        }
        if (e instanceof NullPointerException) {
            throw new DaoException(303, e);
        }
        if (e instanceof SQLException) {
            throw new DaoException(500, e);
        }
        if (e instanceof HibernateException) {
            throw new DaoException(400, e);
        }
        if (e instanceof StrategyException) {
            throw new DaoException(306, e);
        }
        if (e instanceof DaoException) {
            throw (DaoException)e;
        }
        throw new DaoException(e);
    }
}

