/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.cachehandler.impl;

import com.gemantic.dal.dao.ListLoaderCenter;
import com.gemantic.dal.dao.cachehandler.ListHandler;
import com.gemantic.dal.dao.helper.ListInfoHelper;
import com.gemantic.dal.dao.helper.LogHelper;
import com.gemantic.dal.dao.helper.LsCacheInfoHelper;
import com.gemantic.dal.dao.impl.DBAgentHibernateImpl;
import com.gemantic.dal.dao.model.ListInfo;
import com.gemantic.dal.dao.model.SectionInfo;
import com.gemantic.dal.dao.model.UpdateInfo;
import com.gemantic.dal.dao.util.CacheHelper;
import com.gemantic.dal.dao.util.Constants;
import com.gemantic.dal.dao.util.ObjectUtil;
import com.gemantic.dal.dao.util.SqlUtil;
import com.gemantic.dal.route.RoutingService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractListHandler
implements ListHandler {
    private static Log log = LogFactory.getLog(AbstractListHandler.class);

    @Override
    public void processBatchedSave(Map<String, List<LsCacheInfoHelper>> lsMap) throws Exception {
        for (String region : lsMap.keySet()) {
            Object[] cntLs;
            List<LsCacheInfoHelper> lsHelperList = lsMap.get(region);
            if (null == lsHelperList || lsHelperList.size() <= 0) continue;
            ArrayList<String> cntKeyList = new ArrayList<String>();
            for (LsCacheInfoHelper lsHelper : lsHelperList) {
                cntKeyList.add(lsHelper.getListCountKey());
            }
            if (cntKeyList.size() <= 0 || null == (cntLs = CacheHelper.gets(region, cntKeyList))) continue;
            for (int i = 0; i < cntLs.length; ++i) {
                if (null == cntLs[i]) continue;
                CacheHelper.increaseListSize(lsHelperList.get(i));
                CacheHelper.removeListVisitedInfo(lsHelperList.get(i));
            }
        }
    }

    @Override
    public List<SectionInfo> getSavedInfos(Object account_id, Object obj, List<LsCacheInfoHelper> infoHelperList) throws Exception {
        ArrayList<SectionInfo> saveInfos = new ArrayList<SectionInfo>();
        if (null == infoHelperList || infoHelperList.size() < 1) {
            return saveInfos;
        }
        boolean bRAndW = RoutingService.getInstance().isReadWrite(obj.getClass(), account_id);
        for (LsCacheInfoHelper lsHelper : infoHelperList) {
            if (lsHelper.isInvalidOnSave()) {
                CacheHelper.removeListInfo(lsHelper);
                continue;
            }
            ListInfoHelper infoHelper = null;
            ListInfo info = CacheHelper.getListInfo(lsHelper);
            if (null == info) {
                if (!bRAndW) continue;
                List objList = DBAgentHibernateImpl.getInstance().getObjectList(account_id, lsHelper.getRegion(), SqlUtil.getListCountSql(lsHelper), 0L, 1L, 2, true, false);
                info = new ListInfo(new Long("" + objList.get(0)));
                infoHelper = new ListInfoHelper(info);
            } else {
                infoHelper = new ListInfoHelper(info);
            }
            long currentMaxSecNo = infoHelper.getMaxSectionNo();
            long newMaxSecNo = infoHelper.getNewMaxSectionNo();
            if (!bRAndW) {
                if ((long)infoHelper.getLatestSecSize().intValue() >= Constants.SecCapacity && currentMaxSecNo == newMaxSecNo && infoHelper.getSize() >= 1L) {
                    CacheHelper.removeListInfo(lsHelper);
                    LogHelper.errorAddObjectToListSection(log, lsHelper, currentMaxSecNo);
                    continue;
                }
                SectionInfo saveInfo = new SectionInfo(null, infoHelper, null, lsHelper, null);
                saveInfos.add(saveInfo);
                continue;
            }
            List currentLatestSecList = null;
            List latestSecIdList = null;
            boolean bReload = false;
            if (currentMaxSecNo != newMaxSecNo || infoHelper.getSize() < 1L) {
                latestSecIdList = new ArrayList();
            } else {
                if ((long)infoHelper.getLatestSecSize().intValue() >= Constants.SecCapacity) {
                    CacheHelper.removeListInfo(lsHelper);
                    LogHelper.errorAddObjectToListSection(log, lsHelper, currentMaxSecNo);
                    continue;
                }
                if (!infoHelper.isLatestSecVisited()) {
                    bReload = true;
                }
                if (!bReload) {
                    currentLatestSecList = (List)CacheHelper.get(lsHelper.getRegion(), lsHelper.getIdListKey(currentMaxSecNo));
                }
                if (!(null != currentLatestSecList && currentLatestSecList.size() >= 1 || null != (currentLatestSecList = ListLoaderCenter.getInstance().getSectionIdList(lsHelper, infoHelper, account_id, currentMaxSecNo, 2, false)) && currentLatestSecList.size() >= 1)) continue;
                latestSecIdList = currentLatestSecList;
            }
            SectionInfo saveInfo = new SectionInfo(newMaxSecNo, infoHelper, latestSecIdList, lsHelper, null);
            if (null != latestSecIdList && latestSecIdList.size() > 0) {
                saveInfo.setLatestId(latestSecIdList.get(latestSecIdList.size() - 1));
            }
            saveInfos.add(saveInfo);
        }
        return saveInfos;
    }

    @Override
    public List<SectionInfo> getDeleteInfos(Object account_id, Object obj, List<LsCacheInfoHelper> infoList) throws Exception {
        ArrayList<SectionInfo> delInfos = new ArrayList<SectionInfo>();
        boolean bRAndW = RoutingService.getInstance().isReadWrite(obj.getClass(), account_id);
        for (LsCacheInfoHelper lsHelper : infoList) {
            SectionInfo delSec;
            ListInfoHelper infoHelper = null;
            ListInfo info = CacheHelper.getListInfo(lsHelper);
            if (null == info) {
                if (!bRAndW) continue;
                List objList = DBAgentHibernateImpl.getInstance().getObjectList(account_id, lsHelper.getRegion(), SqlUtil.getListCountSql(lsHelper), 0L, 1L, 2, true, false);
                info = new ListInfo(new Long("" + objList.get(0)));
                infoHelper = new ListInfoHelper(info);
            } else {
                infoHelper = new ListInfoHelper(info);
            }
            if (!infoHelper.isSectionsVistied() && !bRAndW) {
                CacheHelper.removeListInfo(lsHelper);
                LogHelper.listHasNotVisited(log, lsHelper.getRegion(), lsHelper.getKey());
                continue;
            }
            if (infoHelper.isSectionsReBuild()) {
                CacheHelper.removeListInfo(lsHelper);
                if (!bRAndW) continue;
            }
            if (null == (delSec = ListLoaderCenter.getInstance().getUpdatedSection(account_id, obj, lsHelper))) continue;
            delInfos.add(delSec);
        }
        return delInfos;
    }

    @Override
    public void processDelete(Object account_id, Class clazz, Object obj, List<SectionInfo> delInfos) throws Exception {
        if (null != delInfos && delInfos.size() > 0) {
            boolean bRW = RoutingService.getInstance().isReadWrite(clazz, account_id);
            if (null != delInfos) {
                for (SectionInfo delInfo : delInfos) {
                    ListLoaderCenter.getInstance().removeIdFromList(account_id, obj, delInfo, bRW);
                }
            }
        }
    }

    @Override
    public UpdateInfo getUpdateInfos(Object account_id, Object obj, Object oldObj, Map<String, LsCacheInfoHelper> newObjLsMap, Map<String, LsCacheInfoHelper> oldObjLsMap) throws Exception {
        HashMap<String, LsCacheInfoHelper[]> changedLsHelpers = new HashMap<String, LsCacheInfoHelper[]>();
        for (String region : oldObjLsMap.keySet()) {
            LsCacheInfoHelper oldLsHelper = oldObjLsMap.get(region);
            LsCacheInfoHelper newLsHelper = newObjLsMap.get(region);
            String oldKey = oldLsHelper.getKey();
            String newKey = newLsHelper.getKey();
            String oldOrderByKey = oldLsHelper.getOrderByKey();
            String newOrderByKey = newLsHelper.getOrderByKey();
            Object oldValueOfLs = ObjectUtil.getObjectValueOfList(oldObj, oldLsHelper);
            Object newValueOfLs = ObjectUtil.getObjectValueOfList(obj, newLsHelper);
            if (!oldKey.equalsIgnoreCase(newKey)) {
                changedLsHelpers.put(region, new LsCacheInfoHelper[]{oldLsHelper, newLsHelper});
                continue;
            }
            if (!oldValueOfLs.equals(newValueOfLs)) {
                changedLsHelpers.put(region, new LsCacheInfoHelper[]{newLsHelper});
                continue;
            }
            if (null == oldOrderByKey || oldOrderByKey.length() <= 0 || oldOrderByKey.equalsIgnoreCase(newOrderByKey)) continue;
            changedLsHelpers.put(region, new LsCacheInfoHelper[]{newLsHelper});
        }
        return new UpdateInfo(changedLsHelpers, null, null);
    }

    @Override
    public void processUpdate(Object account_id, Class clazz, Object oldObj, Object obj, UpdateInfo updateInfo) throws Exception {
        if (null != updateInfo && null != updateInfo.getChangedLsHelpers() && updateInfo.getChangedLsHelpers().size() > 0) {
            for (String region : updateInfo.getChangedLsHelpers().keySet()) {
                LsCacheInfoHelper[] lsHelpers = updateInfo.getChangedLsHelpers().get(region);
                CacheHelper.removeListInfos(lsHelpers);
            }
        }
    }
}

