/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.config.model.dao;

import com.gemantic.dal.config.helper.SqlStringHelper;
import com.gemantic.dal.config.model.dao.DbStrategyItem;
import com.gemantic.dal.config.model.dao.ListItem;
import com.gemantic.dal.config.model.dao.MapItem;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Id;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ObjectItem
implements Serializable {
    private static Logger logger = Logger.getLogger(ObjectItem.class);
    private static final long serialVersionUID = -6501567061333306898L;
    private String name;
    private String listenerClass;
    private String strategyProperty;
    private Map<String, ListItem> listMap = new HashMap<String, ListItem>();
    private Map<String, MapItem> mapMap = new HashMap<String, MapItem>();
    private DbStrategyItem dbStrategyItem;
    private Method strategyPropertyMethod;
    private Method idMethod;
    private String delProperty;
    private Method delPropertyMethod;
    private String delValue;
    private Object delValueObject;
    private String entitySql;

    public void setDbStrategyItem(DbStrategyItem dbStrategyItem) {
        if (dbStrategyItem != null) {
            dbStrategyItem.setObjectName(this.name);
        }
        this.dbStrategyItem = dbStrategyItem;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (StringUtils.isNotEmpty((String)name)) {
            try {
                Class<?> objectClass = Class.forName(name);
                Object[] methods = objectClass.getMethods();
                if (!ArrayUtils.isEmpty((Object[])methods)) {
                    for (int i = 0; i < methods.length; ++i) {
                        Object method = methods[i];
                        Id annotation = ((Method)method).getAnnotation(Id.class);
                        if (annotation == null) continue;
                        this.idMethod = method;
                        break;
                    }
                }
                if (this.idMethod == null) {
                    logger.error((Object)("don't found the id annotation for " + name));
                }
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)(name + " class not found"));
            }
        }
    }

    public String getListenerClass() {
        return this.listenerClass;
    }

    public void setListenerClass(String listenerClass) {
        this.listenerClass = listenerClass;
    }

    public String getStrategyProperty() {
        return this.strategyProperty;
    }

    public void setStrategyProperty(String strategyProperty) {
        this.strategyProperty = strategyProperty;
    }

    public Map<String, ListItem> getListMap() {
        return this.listMap;
    }

    public void addListMap(ListItem listItem) {
        if (listItem != null && StringUtils.isNotEmpty((String)listItem.getName())) {
            if (!this.listMap.containsKey(listItem.getName())) {
                listItem.setObjectName(this.getName());
                this.listMap.put(listItem.getName(), listItem);
            } else {
                logger.error((Object)("same <" + listItem.getName() + ">name ListItem exist!"));
            }
        }
    }

    public ListItem getListItem(String listName) {
        return this.listMap.get(listName);
    }

    public void addMapMap(MapItem mapItem) {
        if (mapItem != null && StringUtils.isNotEmpty((String)mapItem.getName())) {
            if (!this.mapMap.containsKey(mapItem.getName())) {
                mapItem.setObjectName(this.getName());
                this.mapMap.put(mapItem.getName(), mapItem);
            } else {
                logger.error((Object)("same <" + mapItem.getName() + ">name ListItem exist!"));
            }
        }
    }

    public MapItem getMapItem(String mapName) {
        return this.mapMap.get(mapName);
    }

    public DbStrategyItem getDbStrategyItem() {
        return this.dbStrategyItem;
    }

    public Method getStrategyPropertyMethod() {
        return this.strategyPropertyMethod;
    }

    public void setStrategyPropertyMethod(Method strategyPropertyMethod) {
        this.strategyPropertyMethod = strategyPropertyMethod;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ObjectItem[");
        buffer.append("]");
        return buffer.toString();
    }

    public Map<String, MapItem> getMapMap() {
        return this.mapMap;
    }

    public Method getIdMethod() {
        return this.idMethod;
    }

    public void setIdMethod(Method idMethod) {
        this.idMethod = idMethod;
    }

    public void setDelProperty(String delProperty) {
        this.delProperty = delProperty;
    }

    public void setDelValue(String delValue) {
        this.delValue = delValue;
    }

    public String getDelProperty() {
        return this.delProperty;
    }

    public String getDelValue() {
        return this.delValue;
    }

    public Method getDelPropertyMethod() {
        return this.delPropertyMethod;
    }

    public void setDelPropertyMethod(Method delPropertyMethod) {
        this.delPropertyMethod = delPropertyMethod;
    }

    public Object getDelValueObject() {
        return this.delValueObject;
    }

    public void setDelValueObject(Object delValueObject) {
        this.delValueObject = delValueObject;
    }

    public String getEntitySql() {
        if (StringUtils.isBlank((String)this.entitySql)) {
            this.entitySql = SqlStringHelper.getLoadObjectSql(this.name);
        }
        return this.entitySql;
    }

    public void setEntitySql(String entitySql) {
        this.entitySql = entitySql;
    }
}

