/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.config.model.dao;

import com.gemantic.dal.config.DaoConfig;
import com.gemantic.dal.config.helper.SqlStringHelper;
import com.gemantic.dal.config.model.method.ItemMethod;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.log4j.Logger;

public class ListItem
implements ItemMethod {
    private static Logger logger = Logger.getLogger(ListItem.class);
    private static final long serialVersionUID = 492940360625423139L;
    private String name;
    private String sqlitem;
    private String sqlcountitem;
    private String sqldelitem;
    private String sqlAggregateItem;
    private String reverseSql;
    private String sqlType;
    private String keyProperty;
    private String valueProperty;
    private String orderByProperty;
    private String sqlCross;
    private String sqlCrossCount;
    private String reverseSqlCross;
    private String crossOrderByColumn;
    private String sqlCrossSecion;
    private String strategyColumn;
    private String objectName;
    private String[] orderbyFields;
    private Method[] orderByMethod;
    private Method[] keyMethod;
    private Method valueMethod;
    private String columnName;
    private Integer type;
    private boolean invalidOnSave = false;
    private Integer crossMaxCnt;

    public boolean isInvalidOnSave() {
        return this.invalidOnSave;
    }

    public void setInvalidOnSave(boolean invalidOnSave) {
        this.invalidOnSave = invalidOnSave;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSqlitem() {
        return this.sqlitem;
    }

    public void setSqlitem(String sqlitem) {
        this.sqlitem = sqlitem;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public String getKeyProperty() {
        return this.keyProperty;
    }

    public void setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
    }

    public String getValueProperty() {
        return this.valueProperty;
    }

    public void setValueProperty(String valueProperty) {
        this.valueProperty = valueProperty;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
        if (StringUtils.isNotEmpty((String)objectName)) {
            String key;
            String[] keys;
            block19: {
                if (StringUtils.isNotEmpty((String)this.keyProperty)) {
                    keys = StringUtils.splitPreserveAllTokens((String)this.keyProperty, (String)DaoConfig.PROPERTY_SEPARATOR);
                    this.keyMethod = new Method[keys.length];
                    try {
                        for (int i = 0; i < keys.length; ++i) {
                            key = StringUtils.trim((String)keys[i]);
                            this.keyMethod[i] = MethodUtils.getAccessibleMethod(Class.forName(objectName), (String)("get" + WordUtils.capitalize((String)key)), (Class[])new Class[0]);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        if (logger.isDebugEnabled()) {
                            e.printStackTrace(System.err);
                        }
                        logger.error((Object)("cann't find " + this.objectName));
                    }
                } else {
                    logger.info((Object)"keyProperty is null");
                }
                if (StringUtils.isNotEmpty((String)this.valueProperty)) {
                    try {
                        String value = StringUtils.trim((String)this.valueProperty);
                        this.valueMethod = MethodUtils.getAccessibleMethod(Class.forName(objectName), (String)("get" + WordUtils.capitalize((String)value)), (Class[])new Class[0]);
                        if (StringUtils.isBlank((String)this.columnName) && StringUtils.isNotEmpty((String)this.sqlitem)) {
                            String tempCol = StringUtils.substringBetween((String)this.sqlitem, (String)"select", (String)"from");
                            this.columnName = StringUtils.trimToEmpty((String)tempCol);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        if (logger.isDebugEnabled()) {
                            e.printStackTrace(System.err);
                            break block19;
                        }
                        logger.error((Object)("cann't find " + this.objectName));
                    }
                } else {
                    logger.info((Object)"valueProperty is null");
                }
            }
            if (StringUtils.isNotEmpty((String)this.orderByProperty)) {
                keys = StringUtils.splitPreserveAllTokens((String)this.orderByProperty, (String)DaoConfig.PROPERTY_SEPARATOR);
                this.orderByMethod = new Method[keys.length];
                try {
                    for (int i = 0; i < keys.length; ++i) {
                        key = StringUtils.trim((String)keys[i]);
                        this.orderByMethod[i] = MethodUtils.getAccessibleMethod(Class.forName(objectName), (String)("get" + WordUtils.capitalize((String)key)), (Class[])new Class[0]);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (logger.isDebugEnabled()) {
                        e.printStackTrace(System.err);
                    }
                    logger.error((Object)("cann't find " + this.objectName));
                }
            } else {
                logger.info((Object)"keyProperty is null");
            }
        }
    }

    @Override
    public Method[] getKeyMethod() {
        return this.keyMethod;
    }

    public Method getValueMethod() {
        return this.valueMethod;
    }

    public String getSqlcountitem() {
        if (StringUtils.isBlank((String)this.sqlcountitem) && StringUtils.isNotEmpty((String)this.sqlitem)) {
            this.sqlcountitem = SqlStringHelper.getCountSql(this.sqlitem);
        }
        return this.sqlcountitem;
    }

    public String getSqldelitem() {
        if (StringUtils.isBlank((String)this.sqldelitem) && StringUtils.isNotEmpty((String)this.sqlitem)) {
            this.sqldelitem = SqlStringHelper.getDelSql(this.sqlitem);
        }
        return this.sqldelitem;
    }

    public String getSqlAggregateItem() {
        if (StringUtils.isBlank((String)this.sqlAggregateItem) && StringUtils.isNotEmpty((String)this.sqlitem)) {
            this.sqlAggregateItem = SqlStringHelper.getAggregateSql(this.sqlitem);
        }
        return this.sqlAggregateItem;
    }

    public String[] getOrderbyFields() {
        if (ArrayUtils.isEmpty((Object[])this.orderbyFields) && StringUtils.isNotEmpty((String)this.sqlitem)) {
            this.orderbyFields = SqlStringHelper.getOrderbyFields(this.sqlitem);
        }
        return this.orderbyFields;
    }

    public void setSqldelitem(String sqldelitem) {
        this.sqldelitem = sqldelitem;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ListItem[");
        buffer.append("columnName = ").append(this.columnName);
        if (this.keyMethod == null) {
            buffer.append(" keyMethod = ").append("null");
        } else {
            buffer.append(" keyMethod = ").append(Arrays.asList(this.keyMethod).toString());
        }
        buffer.append(" keyProperty = ").append(this.keyProperty);
        buffer.append(" name = ").append(this.name);
        buffer.append(" objectName = ").append(this.objectName);
        buffer.append(" sqlcountitem = ").append(this.sqlcountitem);
        buffer.append(" sqldelitem = ").append(this.sqldelitem);
        buffer.append(" sqlitem = ").append(this.sqlitem);
        buffer.append(" sqlType = ").append(this.sqlType);
        buffer.append(" invalidOnSave = ").append(this.invalidOnSave);
        buffer.append(" valueMethod = ").append(this.valueMethod);
        buffer.append(" valueProperty = ").append(this.valueProperty);
        buffer.append("]");
        return buffer.toString();
    }

    public String getReverseSql() {
        if (StringUtils.isBlank((String)this.reverseSql) && StringUtils.isNotEmpty((String)this.sqlitem)) {
            String sTemp = this.sqlitem.replace("  ", " ");
            this.reverseSql = ListItem.reverseSql(this.sqlitem);
        }
        return this.reverseSql;
    }

    public static String reverseSql(String sql) {
        String tempSql = sql + " ";
        Pattern patternDesc = Pattern.compile("order by (\\w+?) desc");
        Matcher matcher = patternDesc.matcher(tempSql);
        if (matcher.find()) {
            return matcher.replaceFirst("order by $1 asc");
        }
        Pattern patternAsc = Pattern.compile("order by (\\w+?) asc");
        matcher = patternAsc.matcher(tempSql);
        if (matcher.find()) {
            return matcher.replaceFirst("order by $1 desc");
        }
        patternAsc = Pattern.compile("order by (\\w+?) ");
        matcher = patternAsc.matcher(tempSql);
        if (matcher.find()) {
            System.out.println(matcher.group(1));
            return matcher.replaceFirst("order by $1 desc");
        }
        patternAsc = Pattern.compile("select (.+?) from");
        matcher = patternAsc.matcher(tempSql);
        if (matcher.find()) {
            return sql + " order by " + matcher.group(1) + " desc";
        }
        return sql;
    }

    public static void main(String[] args) {
        Pattern PatternUploadLiTag = Pattern.compile("<li>.+?href=[\"|']{1}(.+?)[\"|']{1}.+?src=[\"|']{1}(.+?)[\"|']{1}.+?</li>");
        String cc = "<li><a href='/app/album/#/app/album/list/photo.do?u=12&pid=17514'><img class='photo-130' src='http://10.10.82.52/alumb/2009/03/10/14/34/11fef17356b_1.jpg'/></a></li><li><a href='http://sns.sohu.com/app/album/#/app/album/list/photo.do?u=12&pid=17515'><img class='photo-130' src='http://10.10.82.52/alumb/2009/03/10/14/34/11fef17356c_1.jpg'/></a></li>";
        Matcher matcher = PatternUploadLiTag.matcher(cc);
        while (matcher.find()) {
            System.out.println(matcher.group(1));
            System.out.println(matcher.group(2));
        }
    }

    public String getSqlCross() {
        return this.sqlCross;
    }

    public void setSqlCross(String sqlCross) {
        this.sqlCross = sqlCross;
    }

    public String getSqlCrossCount() {
        return this.sqlCrossCount;
    }

    public void setSqlCrossCount(String sqlCrossCount) {
        this.sqlCrossCount = sqlCrossCount;
    }

    public String getSqlCrossSecion() {
        return this.sqlCrossSecion;
    }

    public void setSqlCrossSecion(String sqlCrossSecion) {
        this.sqlCrossSecion = sqlCrossSecion;
    }

    public String getStrategyColumn() {
        return this.strategyColumn;
    }

    public void setStrategyColumn(String strategyColumn) {
        this.strategyColumn = strategyColumn;
    }

    public String getReverseSqlCross() {
        return this.reverseSqlCross;
    }

    public void setReverseSqlCross(String reverseSqlCross) {
        this.reverseSqlCross = reverseSqlCross;
    }

    public String getCrossOrderByColumn() {
        return this.crossOrderByColumn;
    }

    public void setCrossOrderByColumn(String crossOrderByColumn) {
        this.crossOrderByColumn = crossOrderByColumn;
    }

    public Integer getCrossMaxCnt() {
        return this.crossMaxCnt;
    }

    public void setCrossMaxCnt(Integer crossMaxCnt) {
        this.crossMaxCnt = crossMaxCnt;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return this.type;
    }

    public String getOrderByProperty() {
        return this.orderByProperty;
    }

    public void setOrderByProperty(String orderByProperty) {
        this.orderByProperty = orderByProperty;
    }

    public Method[] getOrderByMethod() {
        return this.orderByMethod;
    }

    public void setOrderByMethod(Method[] orderByMethod) {
        this.orderByMethod = orderByMethod;
    }
}

