/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.config.helper;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.common.util.ReflectHelper;

public final class SqlStringHelper {
    private Logger logger = Logger.getLogger(SqlStringHelper.class);

    public static String getDelSql(String selectSql) {
        String result = null;
        if (StringUtils.isNotEmpty((String)selectSql)) {
            String sTemp = selectSql.replace("  ", " ");
            result = sTemp.replaceAll("select (.+?) from", "delete from");
        }
        return result;
    }

    public static String getCountSql(String selectSql) {
        String result = null;
        if (StringUtils.isNotEmpty((String)selectSql)) {
            String sTemp = selectSql.replace("  ", " ");
            result = sTemp.replaceAll("select (.+?) from", "select count($1) from");
        }
        return result;
    }

    public static String[] getOrderbyFields(String selectSql) {
        String[] result = null;
        if (StringUtils.isNotEmpty((String)selectSql)) {
            String orderBy = null;
            String sTemp = selectSql.replace("  ", " ");
            Pattern patternOrder = Pattern.compile("order by ([^desc|^asc|].+)");
            Matcher matcher = patternOrder.matcher(selectSql);
            if (matcher.find()) {
                orderBy = matcher.group(1);
            } else {
                patternOrder = Pattern.compile("select (.+?) from");
                matcher = patternOrder.matcher(selectSql);
                if (matcher.find()) {
                    orderBy = matcher.group(1);
                }
            }
            result = StringUtils.split((String)orderBy, (String)" ");
        }
        return result;
    }

    public static String getAggregateSql(String selectSql) {
        String result = null;
        if (StringUtils.isNotEmpty((String)selectSql)) {
            String sTemp = selectSql.replace("  ", " ");
            String orderByFields = StringUtils.join((Object[])SqlStringHelper.getOrderbyFields(selectSql), (String)" ");
            Pattern pattern = Pattern.compile("select (.+?) from");
            Matcher matcher = pattern.matcher(selectSql);
            StringBuffer sb = new StringBuffer();
            if (matcher.find()) {
                matcher.appendReplacement(sb, "select " + matcher.group(1) + " ," + orderByFields + " from");
            }
            matcher.appendTail(sb);
            result = sb.toString();
        }
        return result;
    }

    public static String getLoadObjectSql(String className) {
        try {
            Method[] methods;
            String id = null;
            String table = null;
            Class clazz = ReflectHelper.classForName((String)className);
            Table annotation = clazz.getAnnotation(Table.class);
            if (annotation != null) {
                table = annotation.name();
            }
            for (Method method : methods = clazz.getMethods()) {
                Id idAnnotation = method.getAnnotation(Id.class);
                if (idAnnotation == null) continue;
                Column column = method.getAnnotation(Column.class);
                if (column != null) {
                    id = column.name();
                    break;
                }
                id = method.getName();
                id = id.length() > 3 ? StringUtils.uncapitalize((String)method.getName().substring(3)) : null;
                break;
            }
            if (StringUtils.isNotBlank((String)table) && StringUtils.isNotBlank(id)) {
                return "select * from " + table + " where " + id + "=?";
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static void main(String[] args) {
        String sql = "select id from photo order by username";
        System.out.println("AggregateSQL: \t" + SqlStringHelper.getAggregateSql(sql));
        System.out.println("delDel: \t" + SqlStringHelper.getDelSql(sql));
        System.out.println("countSQL: \t" + SqlStringHelper.getCountSql(sql));
    }
}

