/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.util;

import com.gemantic.dal.config.helper.DaoHelper;
import com.gemantic.dal.config.model.dao.ListItem;
import com.gemantic.dal.config.model.dao.MapItem;
import com.gemantic.dal.config.model.method.ItemMethod;
import com.gemantic.dal.dao.helper.LsCacheInfoHelper;
import com.gemantic.dal.dao.model.LsCacheInfo;
import com.gemantic.dal.dao.model.MapInfo;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectUtil {
    private static final Log log = LogFactory.getLog(ObjectUtil.class);

    private static Object[] getParams(ItemMethod item, Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method[] methods = item.getKeyMethod();
        if (null == methods || methods.length < 1 || null == object) {
            return null;
        }
        Object[] params = new Object[methods.length];
        StringBuffer keyBuffer = new StringBuffer();
        for (int i = 0; i < methods.length; ++i) {
            Object propValue;
            if (null != methods[i]) {
                propValue = methods[i].invoke(object, new Object[0]);
                if (null == propValue) {
                    return null;
                }
            } else {
                return null;
            }
            params[i] = propValue;
        }
        return params;
    }

    public static Object[] getOrderByParams(ListItem item, Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method[] methods = item.getOrderByMethod();
        if (null == methods || methods.length < 1 || null == object) {
            return null;
        }
        Object[] params = new Object[methods.length];
        StringBuffer keyBuffer = new StringBuffer();
        for (int i = 0; i < methods.length; ++i) {
            Object propValue;
            if (null != methods[i]) {
                propValue = methods[i].invoke(object, new Object[0]);
                if (null == propValue) {
                    return null;
                }
            } else {
                return null;
            }
            params[i] = propValue;
        }
        return params;
    }

    public static Object getObjectValueOfList(Object obj, LsCacheInfoHelper lsHelper) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ListItem listItem = DaoHelper.getListItemByListName(lsHelper.getRegion());
        Method method = listItem.getValueMethod();
        if (null == method) {
            return null;
        }
        Object valueOfObj = method.invoke(obj, new Object[0]);
        return valueOfObj;
    }

    public static Serializable getObjectId(Object object) throws Exception {
        Method method = DaoHelper.getIdMethod(object.getClass());
        if (null == method) {
            return null;
        }
        return (Serializable)method.invoke(object, new Object[0]);
    }

    public static List<MapInfo> getMapInfoList(Object object) throws Exception {
        ArrayList<MapInfo> list = new ArrayList<MapInfo>();
        List<MapItem> mapList = DaoHelper.getMapItemsByObjectName(object.getClass().getName());
        if (null != mapList && mapList.size() > 0) {
            for (MapItem item : mapList) {
                if (null == item) continue;
                String region = item.getName();
                Object[] params = ObjectUtil.getParams(item, object);
                if (null == params || params.length < 1) continue;
                Method method = item.getValueMethod();
                if (null == method) {
                    log.info((Object)"Attention: Value Method in MapItem is null \r\n");
                    continue;
                }
                Object value = method.invoke(object, new Object[0]);
                if (null == value) continue;
                list.add(new MapInfo(region, params, value));
            }
        }
        return list;
    }

    public static List<LsCacheInfoHelper> getLsInfoList(Object object) throws Exception {
        ArrayList<LsCacheInfoHelper> list = new ArrayList<LsCacheInfoHelper>();
        List<ListItem> listItemList = DaoHelper.getListItemsByObjectName(object.getClass().getName());
        if (null != listItemList && listItemList.size() > 0) {
            for (ListItem item : listItemList) {
                Object[] params;
                String region;
                if (null == item || StringUtils.isBlank((String)(region = item.getName())) || null == (params = ObjectUtil.getParams(item, object)) || params.length < 1) continue;
                Object[] orderByParams = ObjectUtil.getOrderByParams(item, object);
                if (null == orderByParams || orderByParams.length < 1) {
                    // empty if block
                }
                LsCacheInfo info = new LsCacheInfo(region, params, orderByParams, item.getType(), item.isInvalidOnSave());
                list.add(new LsCacheInfoHelper(info));
            }
        }
        return list;
    }

    public static Integer getListType(String listName) {
        ListItem listItem = DaoHelper.getListItemByListName(listName);
        Integer type = listItem.getType();
        if (null == type) {
            type = new Integer(1);
        }
        return type;
    }

    public static Object getObjectStrategyPropert(Object obj) throws Exception {
        Method method = DaoHelper.getStrategyPropertyMethod(obj.getClass().getName());
        if (null == method) {
            return null;
        }
        return method.invoke(obj, new Object[0]);
    }

    public static Long getCrossPerDBCount(String listName) throws Exception {
        Integer listTotalCnt = 0;
        long perDbCnt = 0L;
        ListItem listItem = DaoHelper.getListItemByListName(listName);
        if (null != listItem.getType() && 3 == listItem.getType()) {
            int DBCnt;
            listTotalCnt = listItem.getCrossMaxCnt();
            if (null == listTotalCnt || listTotalCnt < 1) {
                listTotalCnt = 200;
            }
            if (0 == (DBCnt = DaoHelper.getCountDaoGroupByListName(listName))) {
                DBCnt = 2;
            }
            perDbCnt = listTotalCnt / DBCnt;
        }
        return perDbCnt;
    }
}

