/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnnotationUtil {
    private static final Log log = LogFactory.getLog(AnnotationUtil.class);

    public static String getTableNameFromEntity(Class clazz) {
        Table table;
        if (clazz != null && null != (table = clazz.getAnnotation(Table.class))) {
            return table.name();
        }
        return null;
    }

    public static String getIdClumnFromEntity(Class clazz) {
        Field[] fields;
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (null == method.getAnnotation(Id.class)) continue;
            Column column = method.getAnnotation(Column.class);
            if (null != column) {
                return column.name();
            }
            String temp = method.getName().replaceAll("get", "");
            if (null != temp && !"".equals(temp.trim())) {
                return WordUtils.uncapitalize((String)temp);
            }
            return null;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (null == field.getAnnotation(Id.class)) continue;
            Column column = field.getAnnotation(Column.class);
            if (null != column) {
                return column.name();
            }
            return field.getName();
        }
        return null;
    }
}

