/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.impl;

import com.gemantic.dal.config.helper.DaoHelper;
import com.gemantic.dal.dao.DBAgent;
import com.gemantic.dal.dao.exception.DaoException;
import com.gemantic.dal.dao.exception.StrategyException;
import com.gemantic.dal.dao.helper.ListOrderHelper;
import com.gemantic.dal.dao.helper.LogHelper;
import com.gemantic.dal.dao.model.ScalarInfo;
import com.gemantic.dal.dao.model.SqlInfo;
import com.gemantic.dal.dao.util.DalAssert;
import com.gemantic.dal.dao.util.DalLRUMap;
import com.gemantic.dal.dao.util.ObjectUtil;
import com.gemantic.dal.dao.util.SqlUtil;
import com.gemantic.dal.datasource.ContextHolder;
import com.gemantic.dal.route.RoutingService;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class DBAgentHibernateImpl
implements DBAgent {
    private static final int singleUsedTime = 8;
    private static final Log log = LogFactory.getLog(DBAgentHibernateImpl.class);
    private Log permLog = LogFactory.getLog((String)"DBPerformance");
    private static DBAgent dbAgent;
    public static final int DEFAULT_SIZE = 5000;
    private SessionFactory sessionFactory;
    private HibernateTemplate hibernateTemplate;
    private Map nonDatas = new DalLRUMap(5000);

    private DBAgentHibernateImpl() {
        this.sessionFactory = DaoHelper.getSessionFactory();
        this.hibernateTemplate = new HibernateTemplate(this.sessionFactory);
    }

    public static DBAgent getInstance() {
        if (null == dbAgent) {
            dbAgent = new DBAgentHibernateImpl();
        }
        return dbAgent;
    }

    @Override
    public Serializable save(Object account_id, Object object) throws DaoException {
        Serializable id = null;
        DalAssert.assertObjectNotNull(object);
        DalAssert.assertObjectIllegal(account_id, object);
        try {
            long t1 = System.currentTimeMillis();
            RoutingService.getInstance().setRoutingStrategyForObject(object.getClass(), account_id, 2);
            this.hibernateTemplate.setFlushMode(2);
            id = this.hibernateTemplate.save(object);
            if (null == id) {
                LogHelper.savedError(log, object);
            }
            String getKey = object.getClass().getName() + id;
            this.nonDatas.remove(getKey);
            long usedTime = System.currentTimeMillis() - t1;
            if (usedTime >= 8L && this.permLog.isWarnEnabled() && null != object) {
                this.permLog.warn((Object)("method: save region: " + object.getClass().getName() + " params: " + id + " time: " + usedTime));
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return id;
    }

    @Override
    public Map save(Object account_id, final List obs) throws DaoException {
        DalAssert.assertObjectNotNull(obs);
        Map map = new HashMap();
        try {
            Object obj;
            long t1 = System.currentTimeMillis();
            RoutingService.getInstance().setRoutingStrategyForObject(obs.get(0).getClass(), account_id, 2);
            map = (Map)this.hibernateTemplate.execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    session.connection().setAutoCommit(false);
                    HashMap idObjMap = new HashMap();
                    Transaction trans = session.beginTransaction();
                    Serializable id = null;
                    for (Object obj : obs) {
                        id = session.save(obj);
                        idObjMap.put(id, obj);
                    }
                    session.flush();
                    session.clear();
                    trans.commit();
                    return idObjMap;
                }
            });
            long usedTime = System.currentTimeMillis() - t1;
            if (usedTime >= 8L && this.permLog.isWarnEnabled() && null != (obj = obs.get(0)) && null != obj.getClass()) {
                this.permLog.warn((Object)("method: BatchSave region: " + obs.get(0).getClass().getName() + " size: " + obs.size() + " time: " + usedTime));
            }
        }
        catch (Exception e) {
            map = new HashMap();
            this.processException(e);
        }
        if (null == map) {
            map = new HashMap();
        }
        return map;
    }

    @Override
    public boolean updateObjs(Object account_id, final List obs) throws DaoException {
        DalAssert.assertObjectNotNull(obs);
        boolean bRes = true;
        try {
            Object obj;
            long t1 = System.currentTimeMillis();
            RoutingService.getInstance().setRoutingStrategyForObject(obs.get(0).getClass(), account_id, 2);
            bRes = (Boolean)this.hibernateTemplate.execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws SQLException {
                    session.connection().setAutoCommit(false);
                    Transaction trans = session.beginTransaction();
                    for (Object obj : obs) {
                        session.update(obj);
                    }
                    session.flush();
                    session.clear();
                    trans.commit();
                    return true;
                }
            });
            long usedTime = System.currentTimeMillis() - t1;
            if (usedTime >= 8L && this.permLog.isWarnEnabled() && null != (obj = obs.get(0)) && null != obj.getClass()) {
                this.permLog.warn((Object)("method: update region: " + obs.get(0).getClass().getName() + " size: " + obs.size() + " time: " + usedTime));
            }
        }
        catch (Exception e) {
            this.processException(e);
            bRes = false;
        }
        return bRes;
    }

    @Override
    public boolean delete(Object account_id, Object obj) throws DaoException {
        boolean res = true;
        DalAssert.assertObjectNotNull(obj);
        try {
            long t1 = System.currentTimeMillis();
            Serializable id = ObjectUtil.getObjectId(obj);
            this.hibernateTemplate.clear();
            RoutingService.getInstance().setRoutingStrategyForObject(obj.getClass(), account_id, 2);
            this.hibernateTemplate.setFlushMode(2);
            this.hibernateTemplate.delete(obj);
            long usedTime = System.currentTimeMillis() - t1;
            if (usedTime >= 8L && this.permLog.isWarnEnabled()) {
                this.permLog.warn((Object)("method: delete region: " + obj.getClass().getName() + " params: " + id + " time: " + usedTime));
            }
        }
        catch (Exception e) {
            res = false;
            this.processException(e);
        }
        return res;
    }

    @Override
    public boolean fakeDelete(Object account_id, Object obj) throws DaoException {
        boolean res = true;
        DalAssert.assertObjectNotNull(obj);
        try {
            long t1 = System.currentTimeMillis();
            Serializable id = ObjectUtil.getObjectId(obj);
            RoutingService.getInstance().setRoutingStrategyForObject(obj.getClass(), account_id, 2);
            Method method = DaoHelper.getDelPropertyMethod(obj.getClass().getName());
            Object delTag = DaoHelper.getDelValue(obj.getClass().getName());
            DalAssert.assertObjectNotNull(method);
            DalAssert.assertObjectNotNull(delTag);
            method.invoke(obj, delTag);
            this.hibernateTemplate.setFlushMode(2);
            this.hibernateTemplate.update(obj);
            long usedTime = System.currentTimeMillis() - t1;
            if (usedTime >= 8L && this.permLog.isWarnEnabled()) {
                this.permLog.warn((Object)("method: fakeDelete region: " + obj.getClass().getName() + " params: " + id + " time: " + usedTime));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.processException(e);
            res = false;
        }
        return res;
    }

    @Override
    public boolean update(Object account_id, Object object) throws DaoException {
        DalAssert.assertObjectNotNull(object);
        try {
            long t1 = System.currentTimeMillis();
            Serializable id = ObjectUtil.getObjectId(object);
            RoutingService.getInstance().setRoutingStrategyForObject(object.getClass(), account_id, 2);
            this.hibernateTemplate.setFlushMode(2);
            this.hibernateTemplate.update(object);
            long usedTime = System.currentTimeMillis() - t1;
            if (usedTime >= 8L && this.permLog.isWarnEnabled()) {
                this.permLog.warn((Object)("method: update region: " + object.getClass().getName() + " params: " + id + " time: " + usedTime));
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return true;
    }

    @Override
    public Object get(Object account_id, Class clazz, Serializable id) throws DaoException {
        Object obj = null;
        DalAssert.assertObjectNotNull(clazz);
        try {
            long usedTime;
            long t1 = System.currentTimeMillis();
            RoutingService.getInstance().setRoutingStrategyForObject(clazz, account_id, 1);
            String getKey = clazz.getName() + id;
            obj = this.hibernateTemplate.get(clazz, id);
            if (obj == null) {
                this.nonDatas.put(getKey, id);
            }
            if ((usedTime = System.currentTimeMillis() - t1) >= 8L && this.permLog.isWarnEnabled()) {
                this.permLog.warn((Object)("method: get region: " + clazz.getName() + " params: " + id + " time: " + usedTime));
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return obj;
    }

    @Override
    public List getObjectList(Object account_id, String listName, final SqlInfo sqlInfo, final Long start, final Long count, int strategy, boolean setDS, final boolean getAll) throws DaoException {
        ArrayList list = null;
        DalAssert.assertObjectNotNull(sqlInfo);
        try {
            long usedTime;
            long t1 = System.currentTimeMillis();
            if (setDS) {
                RoutingService.getInstance().setRoutingStrategyForList(listName, account_id, strategy);
            }
            if (null == (list = (ArrayList)this.hibernateTemplate.execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    SQLQuery query = session.createSQLQuery(sqlInfo.getSql());
                    if (null != sqlInfo.getScalarList() && sqlInfo.getScalarList().size() > 0) {
                        for (ScalarInfo scaInfo : sqlInfo.getScalarList()) {
                            if (null == scaInfo.getColumnType()) {
                                query.addScalar(scaInfo.getColumnName());
                                continue;
                            }
                            query.addScalar(scaInfo.getColumnName(), scaInfo.getColumnType());
                        }
                    }
                    if (null != sqlInfo.getParams() && sqlInfo.getParams().length > 0) {
                        int i = 0;
                        for (Object id : sqlInfo.getParams()) {
                            if (null == id) continue;
                            query.setParameter(i++, id);
                        }
                    }
                    if (!getAll) {
                        LogHelper.runningStartAndCount(log);
                        query.setFirstResult(start.intValue());
                        if (0 != count.intValue()) {
                            query.setMaxResults(count.intValue());
                        }
                    }
                    return query.list();
                }
            }))) {
                list = new ArrayList();
            }
            if ((usedTime = System.currentTimeMillis() - t1) >= 8L && this.permLog.isWarnEnabled() && null != sqlInfo.getParams()) {
                this.permLog.warn((Object)("method: getObjectList region: " + listName + " params: " + sqlInfo.getParamKey() + " time: " + usedTime + " start :" + start + " count :" + count + "\r\n sql: " + sqlInfo.getSql()));
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return list;
    }

    @Override
    public List getEntityList(Object account_id, final Class cls, final SqlInfo sqlInfo, int strategy) throws DaoException {
        ArrayList list = null;
        DalAssert.assertObjectNotNull(cls);
        DalAssert.assertObjectNotNull(sqlInfo);
        try {
            long usedTime;
            long t1 = System.currentTimeMillis();
            RoutingService.getInstance().setRoutingStrategyForObject(cls, account_id, strategy);
            list = (ArrayList)this.hibernateTemplate.execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    SQLQuery query = session.createSQLQuery(sqlInfo.getSql()).addEntity(cls);
                    if (null != sqlInfo.getParams() && sqlInfo.getParams().length > 0) {
                        int i = 0;
                        for (Object id : sqlInfo.getParams()) {
                            if (null == id) continue;
                            query.setParameter(i++, id);
                        }
                    }
                    return query.list();
                }
            });
            if (null == list) {
                list = new ArrayList();
            }
            if ((usedTime = System.currentTimeMillis() - t1) >= 8L && this.permLog.isWarnEnabled()) {
                this.permLog.warn((Object)("method: getEntityList region: " + cls.getName() + " params: " + sqlInfo.getParamKey() + " time: " + usedTime));
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return list;
    }

    @Override
    public List<List> crossDBList(Object account_id, String listName, SqlInfo sqlInfo, Integer start, Integer count, int strategy) throws DaoException {
        ArrayList<List> allList = new ArrayList<List>();
        DBAgent dbAgent = DBAgentHibernateImpl.getInstance();
        try {
            while (RoutingService.getInstance().nextRoutingStrategyForList(listName, strategy)) {
                List objList = dbAgent.getObjectList(null, listName, sqlInfo, new Long("" + start), new Long("" + count), strategy, false, false);
                allList.add(objList);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return allList;
    }

    @Override
    public List getOrderedCrossList(Object account_id, String listName, SqlInfo sqlInfo, Long start, Long count, int strategy, boolean forward) throws DaoException {
        int realStart = start.intValue();
        if (realStart < 0) {
            realStart = 0;
        }
        List resList = new ArrayList();
        List<List> allList = this.crossDBList(account_id, listName, sqlInfo, 0, new Integer("" + realStart + count), strategy);
        resList = ListOrderHelper.getOrderedList(allList, forward);
        if (realStart > resList.size() - 1) {
            return resList;
        }
        if ((long)realStart + count > (long)resList.size()) {
            return resList.subList(realStart, resList.size());
        }
        return resList.subList(realStart, realStart + count.intValue());
    }

    @Override
    public List getMaps(Object accountId, String mapName, List<Object[]> paramsList) throws StrategyException, DaoException {
        ArrayList resList = new ArrayList();
        for (Object[] params : paramsList) {
            SqlInfo sqlInfo = SqlUtil.getMappingSqlInfo(mapName, params, false);
            RoutingService.getInstance().setRoutingStrategyForMap(mapName, accountId, 1);
            List objList = this.getObjectList(null, null, sqlInfo, 0L, 0L, 1, false, true);
            if (null == objList || objList.size() < 1) {
                LogHelper.failedExecuteQueryFromDB(log, sqlInfo);
                resList.add(null);
                continue;
            }
            resList.add(objList.get(0));
        }
        return resList;
    }

    private void processException(Exception e) throws DaoException {
        if (e instanceof MappingException) {
            throw new DaoException(401, e);
        }
        if (e instanceof NullPointerException) {
            throw new DaoException(303, e);
        }
        if (e instanceof SQLException) {
            throw new DaoException(500, e);
        }
        if (e instanceof HibernateException) {
            throw new DaoException(400, e);
        }
        if (e instanceof StrategyException) {
            throw new DaoException(306, e);
        }
        if (e instanceof DaoException) {
            throw (DaoException)e;
        }
        throw new DaoException(e);
    }

    @Override
    public Object excuteSimpleSql(final String sql, Class clazz) throws DaoException {
        Long enter = System.nanoTime();
        Object obj = null;
        if (null != clazz) {
            try {
                clazz.newInstance();
                List<String> dsNames = RoutingService.getInstance().getReadDsFromEachGroupForObject(clazz);
                if (null == dsNames || dsNames.size() <= 0) {
                    log.error((Object)("can't find ds for " + clazz.getName()));
                    return null;
                }
                ContextHolder.setDataSource(dsNames.get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)(e + " excuteSimpleSql: clazz not exist"));
                return null;
            }
        } else {
            log.info((Object)"clazz is null");
        }
        try {
            obj = this.hibernateTemplate.execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    if (sql.startsWith("update")) {
                        log.info((Object)(sql + " is ready to update "));
                        session.connection().setAutoCommit(false);
                        Transaction trans = session.beginTransaction();
                        Connection conn = session.connection();
                        PreparedStatement stmt = conn.prepareStatement(sql);
                        int cnt = stmt.executeUpdate();
                        log.info((Object)("update rows is " + cnt));
                        session.flush();
                        session.clear();
                        trans.commit();
                        return Collections.singletonList(BigInteger.valueOf(cnt));
                    }
                    List list = session.createSQLQuery(sql).list();
                    if (list.size() < 0) {
                        return null;
                    }
                    if (list.size() == 1) {
                        return list.get(0);
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            log.error((Object)sql);
            this.processException(e);
        }
        return obj;
    }

    @Override
    public Object excuteHardSimpleSql(final String sql, Class clazz) throws DaoException {
        Long enter = System.nanoTime();
        Object obj = null;
        if (null != clazz) {
            try {
                clazz.newInstance();
                List<String> dsNames = RoutingService.getInstance().getReadDsFromEachGroupForObject(clazz);
                if (null == dsNames || dsNames.size() <= 0) {
                    log.error((Object)("can't find ds for " + clazz.getName()));
                    return null;
                }
                ContextHolder.setDataSource(dsNames.get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)(e + " excuteSimpleSql: clazz not exist"));
                return null;
            }
        } else {
            log.info((Object)"clazz is null");
        }
        try {
            obj = this.hibernateTemplate.execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    if (sql.startsWith("update")) {
                        log.info((Object)(sql + " is ready to update "));
                        session.connection().setAutoCommit(false);
                        Transaction trans = session.beginTransaction();
                        Connection conn = session.connection();
                        PreparedStatement stmt = conn.prepareStatement(sql);
                        int cnt = stmt.executeUpdate();
                        session.flush();
                        session.clear();
                        trans.commit();
                        log.info((Object)("update rows is " + cnt));
                        return Collections.singletonList(BigInteger.valueOf(cnt));
                    }
                    List list = session.createSQLQuery(sql).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP).list();
                    if (list.size() < 0) {
                        return null;
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            log.error((Object)sql);
            this.processException(e);
        }
        return obj;
    }
}

