/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.impl;

import com.gemantic.dal.cache.Cache;
import com.gemantic.dal.dao.FriendDao;
import com.gemantic.dal.dao.exception.DaoException;
import com.gemantic.dal.dao.exception.StrategyException;
import com.gemantic.dal.dao.impl.DBAgentHibernateImpl;
import com.gemantic.dal.dao.model.SqlInfo;
import com.gemantic.dal.dao.util.CacheHelper;
import com.gemantic.dal.dao.util.DalAssert;
import com.gemantic.dal.dao.util.SqlUtil;
import com.gemantic.dal.datasource.ContextHolder;
import com.gemantic.dal.route.RoutingService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;

public class FriendDaoImpl
implements FriendDao {
    @Override
    public List getMappings(List accountIdList, String mapname, List<Object[]> paramsList) throws DaoException {
        DalAssert.assertObjectNotNull(accountIdList);
        DalAssert.assertObjectNotNull(paramsList);
        DalAssert.assertObjectNotNull(mapname);
        ArrayList resList = new ArrayList();
        try {
            Cache cache = CacheHelper.getListCache(mapname);
            if (null == cache) {
                HashMap dbParamsMap = new HashMap();
                HashMap dbAccountMap = new HashMap();
                for (int index = 0; index < accountIdList.size(); ++index) {
                    Object[] params;
                    Object accountId = accountIdList.get(index);
                    RoutingService.getInstance().setRoutingStrategyForMap(mapname, accountId, 1);
                    String dbName = ContextHolder.getDataSource();
                    if (null == dbAccountMap.get(dbName)) {
                        params = paramsList.get(index);
                        if (null == params) continue;
                        dbAccountMap.put(dbName, accountId);
                        ArrayList<Object[]> newParamList = new ArrayList<Object[]>();
                        newParamList.add(params);
                        dbParamsMap.put(dbName, newParamList);
                        continue;
                    }
                    params = paramsList.get(index);
                    if (null == params) continue;
                    ((List)dbParamsMap.get(dbName)).add(params);
                }
                for (String dbName : dbAccountMap.keySet()) {
                    List bufList = new ArrayList();
                    List<SqlInfo> sqlInfoLs = SqlUtil.getMapAggreSqlInfos(mapname, (List)dbParamsMap.get(dbName));
                    RoutingService.getInstance().setRoutingStrategyForMap(mapname, dbAccountMap.get(dbName), 1);
                    for (SqlInfo sqlInfo : sqlInfoLs) {
                        bufList = DBAgentHibernateImpl.getInstance().getObjectList(null, null, sqlInfo, 0L, 0L, 1, false, true);
                        resList.addAll(bufList);
                    }
                }
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return resList;
    }

    private void processException(Exception e) throws DaoException {
        e.printStackTrace(System.out);
        if (e instanceof MappingException) {
            throw new DaoException(401, e);
        }
        if (e instanceof NullPointerException) {
            throw new DaoException(303, e);
        }
        if (e instanceof SQLException) {
            throw new DaoException(500, e);
        }
        if (e instanceof HibernateException) {
            throw new DaoException(400, e);
        }
        if (e instanceof StrategyException) {
            throw new DaoException(306, e);
        }
        if (e instanceof DaoException) {
            throw (DaoException)e;
        }
        throw new DaoException(e);
    }
}

