/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.config;

import com.gemantic.dal.config.helper.GroupHelper;
import com.gemantic.dal.config.model.dao.ConfigItem;
import com.gemantic.dal.config.model.dao.DbStrategyItem;
import com.gemantic.dal.config.model.dao.IdCenterDsItem;
import com.gemantic.dal.config.model.dao.ListItem;
import com.gemantic.dal.config.model.dao.MapItem;
import com.gemantic.dal.config.model.dao.ObjectItem;
import com.gemantic.dal.config.model.dao.PatternItem;
import com.gemantic.dal.datasource.DynamicDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.annotation.AnnotationSessionFactoryBean;
import org.xml.sax.SAXException;

public final class DaoConfig {
    private static String DAO_CONFIG_FILE = "/daoConfig.xml";
    private static Logger logger = Logger.getLogger(DaoConfig.class);
    private AnnotationSessionFactoryBean sessionFactoryBean;
    private Map<String, ObjectItem> objectMap = new HashMap<String, ObjectItem>();
    private Map<String, ListItem> listItemMap = new HashMap<String, ListItem>();
    private Map<String, MapItem> mapItemMap = new HashMap<String, MapItem>();
    private DbStrategyItem defaultDbStrategyItem = null;
    private SessionFactory sessionFactory = null;
    private static DaoConfig config;
    private IdCenterDsItem idCenterDsItem;
    public static String DASNAME_SEPARATOR;
    public static String PROPERTY_SEPARATOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DaoConfig getInstance() {
        if (config != null) return config;
        Class<DaoConfig> clazz = DaoConfig.class;
        synchronized (DaoConfig.class) {
            if (config != null) return config;
            config = new DaoConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }

    private DaoConfig() {
        try {
            this.initObjects();
            this.initDefault(this.getClass().getResourceAsStream(DAO_CONFIG_FILE));
            this.initSessionFactory();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.out);
            }
            logger.error((Object)("init config file " + DAO_CONFIG_FILE + " error: " + e.getMessage()));
        }
    }

    private void initObjects() {
        InputStream groupConfigFile = this.getClass().getResourceAsStream(DAO_CONFIG_FILE);
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("dal/list/", ArrayList.class);
        digester.addObjectCreate("dal/list/config", ConfigItem.class);
        digester.addBeanPropertySetter("dal/list/config/path");
        digester.addSetNext("dal/list/config", "add");
        Object objectList = null;
        try {
            objectList = digester.parse(groupConfigFile);
            if (objectList != null && objectList instanceof ArrayList) {
                List list = (List)objectList;
                for (ConfigItem config : list) {
                    this.initObject(this.getClass().getResourceAsStream("/" + config.getPath()));
                }
            }
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            } else {
                logger.error((Object)("init error: " + e.getMessage()));
            }
        }
        catch (SAXException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            }
            logger.error((Object)("init parse fail : " + e.getMessage()));
        }
    }

    private void initObject(InputStream groupConfigFile) {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("dal/route/", ArrayList.class);
        digester.addObjectCreate("dal/route/object", ObjectItem.class);
        digester.addSetNext("dal/route/object", "add");
        digester.addSetProperties("dal/route/object");
        digester.addObjectCreate("dal/route/object/list", ListItem.class);
        digester.addSetProperties("dal/route/object/list");
        digester.addSetNext("dal/route/object/list", "addListMap");
        digester.addObjectCreate("dal/route/object/map", MapItem.class);
        digester.addSetProperties("dal/route/object/map");
        digester.addSetNext("dal/route/object/map", "addMapMap");
        digester.addObjectCreate("dal/route/object/dbStrategy", DbStrategyItem.class);
        digester.addSetProperties("dal/route/object/dbStrategy");
        digester.addSetNext("dal/route/object/dbStrategy", "setDbStrategyItem");
        digester.addObjectCreate("dal/route/object/dbStrategy/pattern", PatternItem.class);
        digester.addSetProperties("dal/route/object/dbStrategy/pattern");
        digester.addSetNext("dal/route/object/dbStrategy/pattern", "addPatternItem");
        try {
            Object objectList = digester.parse(groupConfigFile);
            if (objectList != null && objectList instanceof ArrayList) {
                List list = (List)objectList;
                for (ObjectItem objectItem : list) {
                    this.addObjectItem(objectItem);
                    this.listAggregate(objectItem);
                    this.mapAggregate(objectItem);
                }
            }
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            } else {
                logger.error((Object)("init error: " + e.getMessage()));
            }
        }
        catch (SAXException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            }
            logger.error((Object)("init parse fail : " + e.getMessage()));
        }
    }

    private void initDefault(InputStream groupConfigFile) {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("dal/default/", ArrayList.class);
        digester.addObjectCreate("dal/default/dbStrategy", DbStrategyItem.class);
        digester.addSetNext("dal/default/dbStrategy", "add");
        digester.addSetProperties("dal/default/dbStrategy");
        digester.addObjectCreate("dal/default/dbStrategy/pattern", PatternItem.class);
        digester.addSetProperties("dal/default/dbStrategy/pattern");
        digester.addSetNext("dal/default/dbStrategy/pattern", "addPatternItem");
        digester.addObjectCreate("dal/default/idCenterDS", IdCenterDsItem.class);
        digester.addSetNext("dal/default/idCenterDS", "add");
        digester.addSetProperties("dal/default/idCenterDS");
        try {
            Object objectList = digester.parse(groupConfigFile);
            if (objectList != null && objectList instanceof ArrayList) {
                List list = (List)objectList;
                for (Object defaultObject : list) {
                    if (defaultObject == null) continue;
                    if (defaultObject instanceof DbStrategyItem) {
                        this.defaultDbStrategyItem = (DbStrategyItem)defaultObject;
                        continue;
                    }
                    if (!(defaultObject instanceof IdCenterDsItem)) continue;
                    this.idCenterDsItem = (IdCenterDsItem)defaultObject;
                }
            }
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            } else {
                logger.error((Object)("init error: " + e.getMessage()));
            }
        }
        catch (SAXException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            }
            logger.error((Object)("init parse fail : " + e.getMessage()));
        }
    }

    private void listAggregate(ObjectItem objectItem) {
        Map<String, ListItem> listMap;
        if (objectItem != null && StringUtils.isNotEmpty((String)objectItem.getName()) && MapUtils.isNotEmpty(listMap = objectItem.getListMap())) {
            for (ListItem item : listMap.values()) {
                if (this.listItemMap.containsKey(item.getName())) {
                    logger.error((Object)("same <" + item.getName() + "> list exist!"));
                    continue;
                }
                logger.info((Object)item.toString());
                this.listItemMap.put(item.getName(), item);
            }
        }
    }

    private void mapAggregate(ObjectItem objectItem) {
        Map<String, MapItem> listMap;
        if (objectItem != null && StringUtils.isNotEmpty((String)objectItem.getName()) && MapUtils.isNotEmpty(listMap = objectItem.getMapMap())) {
            for (MapItem item : listMap.values()) {
                if (this.mapItemMap.containsKey(item.getName())) {
                    logger.error((Object)("same <" + item.getName() + "> list exist!"));
                    continue;
                }
                logger.info((Object)item.toString());
                this.mapItemMap.put(item.getName(), item);
            }
        }
    }

    private void initSessionFactory() {
        DynamicDataSource dds = new DynamicDataSource();
        dds.setTargetDataSources(GroupHelper.getDataSourceMap());
        dds.afterPropertiesSet();
        Properties hibernateProperties = new Properties();
        hibernateProperties.setProperty("hibernate.show_sql", "false");
        hibernateProperties.setProperty("hibernate.generate_statistics", "false");
        hibernateProperties.setProperty("hibernate.cache.use_query_cache", "false");
        hibernateProperties.setProperty("hibernate.transaction.factory_class", "org.hibernate.transaction.JDBCTransactionFactory");
        hibernateProperties.setProperty("hibernate.statement_cache.size", "50");
        hibernateProperties.setProperty("hibernate.jdbc.fetch_size", "100");
        hibernateProperties.setProperty("hibernate.jdbc.batch_size", "100");
        hibernateProperties.setProperty("hibernate.jdbc.use_scrollable_resultset", "true");
        hibernateProperties.setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        hibernateProperties.setProperty("hibernate.max_fetch_depth", "3");
        hibernateProperties.setProperty("hibernate.bytecode.use_reflection_optimizer", "true");
        hibernateProperties.setProperty("hibernate.query.substitutions", "true 1, false 0");
        hibernateProperties.setProperty("hibernate.current_session_context_class", "thread");
        AnnotationSessionFactoryBean sessionFactoryBean = new AnnotationSessionFactoryBean();
        sessionFactoryBean.setHibernateProperties(hibernateProperties);
        sessionFactoryBean.setDataSource((DataSource)((Object)dds));
        Set<String> objectClassNames = this.objectMap.keySet();
        Class[] clazzs = new Class[objectClassNames.size()];
        int i = 0;
        for (String className : objectClassNames) {
            if (StringUtils.isNotEmpty((String)className)) {
                try {
                    Class<?> clazz;
                    clazzs[i] = clazz = Class.forName(className);
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        e.printStackTrace(System.err);
                    }
                    logger.error((Object)("Class.forName fail:" + className));
                }
            }
            ++i;
        }
        sessionFactoryBean.setAnnotatedClasses(clazzs);
        try {
            sessionFactoryBean.afterPropertiesSet();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            }
            logger.error((Object)("afterPropertiesSet fail: " + e.getMessage()));
        }
        this.sessionFactory = sessionFactoryBean.getObject();
    }

    private void addObjectItem(ObjectItem objectItem) {
        if (objectItem != null && StringUtils.isNotEmpty((String)objectItem.getName())) {
            if (!this.objectMap.containsKey(objectItem.getName())) {
                String className = objectItem.getName();
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e1) {
                    if (logger.isDebugEnabled()) {
                        e1.printStackTrace(System.err);
                    }
                    logger.error((Object)("Class " + StringUtils.defaultIfEmpty((String)className, (String)"") + " don't fond"));
                }
                if (clazz != null) {
                    Method method = MethodUtils.getAccessibleMethod(clazz, (String)("get" + WordUtils.capitalize((String)objectItem.getStrategyProperty())), (Class[])new Class[0]);
                    if (method == null) {
                        logger.warn((Object)("Class " + className + " method get " + StringUtils.defaultIfEmpty((String)objectItem.getStrategyProperty(), (String)"") + " don't fond!"));
                    } else {
                        objectItem.setStrategyPropertyMethod(method);
                    }
                    method = MethodUtils.getAccessibleMethod(clazz, (String)("get" + WordUtils.capitalize((String)objectItem.getDelProperty())), (Class[])new Class[0]);
                    if (method == null) {
                        logger.warn((Object)("Class " + className + " method get " + StringUtils.defaultIfEmpty((String)objectItem.getDelProperty(), (String)"") + " don't fond!"));
                    } else {
                        Method setMethod = MethodUtils.getAccessibleMethod(clazz, (String)("set" + WordUtils.capitalize((String)objectItem.getDelProperty())), (Class[])new Class[]{method.getReturnType()});
                        if (setMethod != null) {
                            objectItem.setDelPropertyMethod(setMethod);
                            if (StringUtils.isNotEmpty((String)objectItem.getDelValue())) {
                                objectItem.setDelValueObject(ConvertUtils.convert((String)objectItem.getDelValue(), method.getReturnType()));
                            }
                        } else {
                            logger.error((Object)("Class " + className + " method set " + StringUtils.defaultIfEmpty((String)objectItem.getDelProperty(), (String)"") + " don't fond!"));
                        }
                    }
                }
                this.objectMap.put(objectItem.getName(), objectItem);
            } else {
                logger.error((Object)("same <" + objectItem.getName() + "> name ObjectItem exist!"));
            }
        } else {
            logger.error((Object)"ObjectItem must has value and name");
        }
    }

    public ObjectItem getObjectItem(String objectName) {
        return this.objectMap.get(objectName);
    }

    public ListItem getListItem(String listName) {
        return this.listItemMap.get(listName);
    }

    public MapItem getMapItem(String mapName) {
        return this.mapItemMap.get(mapName);
    }

    public static void main(String[] args) {
        DaoConfig.getInstance();
    }

    public DbStrategyItem getDefaultDbStrategyItem() {
        return this.defaultDbStrategyItem;
    }

    public IdCenterDsItem getIdCenterDsItem() {
        return this.idCenterDsItem;
    }

    public void destroy() {
        if (this.sessionFactoryBean != null) {
            this.sessionFactoryBean.destroy();
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    static {
        DASNAME_SEPARATOR = ",";
        PROPERTY_SEPARATOR = ",";
    }
}

