/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.commons.code.manager.ios.impl;

import com.gemantic.commons.code.manager.ios.IOSCodeGenerate;
import com.gemantic.commons.code.model.ios.IOSController;
import com.gemantic.commons.code.model.ios.IOSInterface;
import com.gemantic.commons.code.model.ios.IOSModel;
import com.gemantic.commons.code.model.ios.IOSProject;
import com.gemantic.commons.code.model.ios.IOSService;
import com.gemantic.commons.code.model.ios.IOSView;
import com.gemantic.commons.code.model.ios.TemplateConfig;
import com.qding.common.util.FileUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.velocity.VelocityEngineUtils;

@Component(value="iOSCodeGenerate")
public class IOSCodeGenerateImpl
implements IOSCodeGenerate {
    private static final Log log = LogFactory.getLog(IOSCodeGenerateImpl.class);
    @Autowired
    private VelocityEngine velocityEngine;

    @Override
    public List<String> generateControllerMFile(IOSProject project) {
        List<IOSController> controllers = project.getControllers();
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("project", project);
        ArrayList<String> contents = new ArrayList<String>();
        Map<String, String> template_path = project.getName_template();
        String mpath = template_path.get("template_controller_m");
        for (IOSController controller : controllers) {
            try {
                model.put("controller", controller);
                log.info((Object)("generate controller is " + controllers));
                TemplateConfig templateConfig = controller.getMTemplateConfig();
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)mpath, model);
                log.info((Object)(controller.getName() + " write content is " + content));
                FileUtil.writeFile((String)(templateConfig.getTargetPath() + templateConfig.getTargetName()), (boolean)false, (String)content);
                log.info((Object)(templateConfig.getTargetPath() + " =========create============== " + templateConfig.getTargetName()));
                contents.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    @Override
    public List<String> generateControllerHFile(IOSProject project) {
        List<IOSController> controllers = project.getControllers();
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("project", project);
        ArrayList<String> contents = new ArrayList<String>();
        Map<String, String> template_path = project.getName_template();
        String hpath = template_path.get("template_controller_h");
        for (IOSController controller : controllers) {
            try {
                model.put("controller", controller);
                log.info((Object)("generate controller is " + controllers));
                TemplateConfig templateConfig = controller.gethTemplateConfig();
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)hpath, model);
                log.info((Object)(controller.getName() + " write content is " + content));
                FileUtil.writeFile((String)(templateConfig.getTargetPath() + templateConfig.getTargetName()), (boolean)false, (String)content);
                log.info((Object)(templateConfig.getTargetPath() + " =========create============== " + templateConfig.getTargetName()));
                contents.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    @Override
    public List<String> generateViewMFile(IOSProject project) {
        List<IOSView> views = project.getViews();
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("project", project);
        ArrayList<String> contents = new ArrayList<String>();
        Map<String, String> template_path = project.getName_template();
        String mpath = template_path.get("template_view_m");
        for (IOSView view : views) {
            try {
                model.put("view", view);
                log.info((Object)("generate view is " + views));
                TemplateConfig templateConfig = view.getmTemplateConfig();
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)mpath, model);
                log.info((Object)(view.getName() + " write content is " + content));
                FileUtil.writeFile((String)(templateConfig.getTargetPath() + templateConfig.getTargetName()), (boolean)false, (String)content);
                log.info((Object)(templateConfig.getTargetPath() + " =========create============== " + templateConfig.getTargetName()));
                contents.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    @Override
    public List<String> generateViewHFile(IOSProject project) {
        List<IOSView> views = project.getViews();
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("project", project);
        ArrayList<String> contents = new ArrayList<String>();
        Map<String, String> template_path = project.getName_template();
        String hpath = template_path.get("template_view_h");
        for (IOSView view : views) {
            try {
                model.put("view", view);
                log.info((Object)("generate controller is " + views));
                TemplateConfig templateConfig = view.gethTemplateConfig();
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)hpath, model);
                log.info((Object)(view.getName() + " write content is " + content));
                FileUtil.writeFile((String)(templateConfig.getTargetPath() + templateConfig.getTargetName()), (boolean)false, (String)content);
                log.info((Object)(templateConfig.getTargetPath() + " =========create============== " + templateConfig.getTargetName()));
                contents.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    @Override
    public List<String> generateModelMFile(IOSProject project) {
        List<IOSModel> models = project.getModels();
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("project", project);
        ArrayList<String> contents = new ArrayList<String>();
        Map<String, String> template_path = project.getName_template();
        String mpath = template_path.get("template_model_m");
        for (IOSModel m : models) {
            try {
                model.put("model", m);
                log.info((Object)("generate is " + m));
                TemplateConfig templateConfig = m.getmTemplateConfig();
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)mpath, model);
                log.info((Object)(m.getName() + " write content is " + content));
                FileUtil.writeFile((String)(templateConfig.getTargetPath() + templateConfig.getTargetName()), (boolean)false, (String)content);
                log.info((Object)(templateConfig.getTargetPath() + " =========create============== " + templateConfig.getTargetName()));
                contents.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    @Override
    public List<String> generateModelHFile(IOSProject project) {
        List<IOSModel> models = project.getModels();
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("project", project);
        ArrayList<String> contents = new ArrayList<String>();
        Map<String, String> template_path = project.getName_template();
        String hpath = template_path.get("template_model_h");
        for (IOSModel m : models) {
            try {
                model.put("model", m);
                log.info((Object)("generate controller is " + m));
                TemplateConfig templateConfig = m.gethTemplateConfig();
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)hpath, model);
                log.info((Object)(m.getName() + " write content is " + content));
                FileUtil.writeFile((String)(templateConfig.getTargetPath() + templateConfig.getTargetName()), (boolean)false, (String)content);
                log.info((Object)(templateConfig.getTargetPath() + " =========create============== " + templateConfig.getTargetName()));
                contents.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    @Override
    public List<String> generateServiceHFile(IOSProject project) {
        List<IOSService> services = project.getServices();
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("project", project);
        ArrayList<String> contents = new ArrayList<String>();
        Map<String, String> template_path = project.getName_template();
        String hpath = template_path.get("template_service_h");
        for (IOSService service : services) {
            try {
                model.put("service", service);
                log.info((Object)("generate interface h is " + service));
                TemplateConfig templateConfig = service.gethTemplateConfig();
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)hpath, model);
                log.info((Object)(service.getName() + " write content is " + content));
                FileUtil.writeFile((String)(templateConfig.getTargetPath() + templateConfig.getTargetName()), (boolean)false, (String)content);
                log.info((Object)(templateConfig.getTargetPath() + " =========create============== " + templateConfig.getTargetName()));
                contents.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    @Override
    public List<String> generateServiceMFile(IOSProject project) {
        List<IOSService> services = project.getServices();
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("project", project);
        ArrayList<String> contents = new ArrayList<String>();
        Map<String, String> template_path = project.getName_template();
        String hpath = template_path.get("template_service_m");
        for (IOSService service : services) {
            try {
                model.put("service", service);
                log.info((Object)("generate interface h is " + service));
                TemplateConfig templateConfig = service.getmTemplateConfig();
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)hpath, model);
                log.info((Object)(service.getName() + " write content is " + content));
                FileUtil.writeFile((String)(templateConfig.getTargetPath() + templateConfig.getTargetName()), (boolean)false, (String)content);
                log.info((Object)(templateConfig.getTargetPath() + " =========create============== " + templateConfig.getTargetName()));
                contents.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    @Override
    public List<String> generateInterfaceConfigFile(IOSProject project) {
        List<IOSService> services = project.getServices();
        ArrayList<IOSInterface> interfaces = new ArrayList<IOSInterface>();
        for (IOSService service : services) {
            interfaces.addAll(service.getInterfaces());
        }
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("project", project);
        model.put("interfaces", interfaces);
        ArrayList<String> contents = new ArrayList<String>();
        Map<String, String> template_path = project.getName_template();
        String path = template_path.get("template_interface_config");
        try {
            log.info((Object)"generate config is ");
            TemplateConfig templateConfig = project.getHttpConfig();
            String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)path, model);
            log.info((Object)(templateConfig.getTargetName() + " write content is " + content));
            FileUtil.writeFile((String)(templateConfig.getTargetPath() + templateConfig.getTargetName()), (boolean)false, (String)content);
            log.info((Object)(templateConfig.getTargetPath() + " =========create============== " + templateConfig.getTargetName()));
            contents.add(content);
        }
        catch (VelocityException e) {
            e.printStackTrace();
        }
        return contents;
    }
}

