/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.commons.code.manager.impl;

import com.gemantic.common.exception.ServiceException;
import com.gemantic.commons.code.cmodel.CConstant;
import com.gemantic.commons.code.cmodel.CController;
import com.gemantic.commons.code.cmodel.CField;
import com.gemantic.commons.code.cmodel.CMold;
import com.gemantic.commons.code.cmodel.CProject;
import com.gemantic.commons.code.cmodel.CReference;
import com.gemantic.commons.code.cmodel.CRequest;
import com.gemantic.commons.code.cmodel.DocContentConfigSheetModel;
import com.gemantic.commons.code.cmodel.DocContentControllerSheetModel;
import com.gemantic.commons.code.cmodel.DocContentDBServiceSheetModel;
import com.gemantic.commons.code.cmodel.DocTagContentConstantModel;
import com.gemantic.commons.code.cmodel.DocTagContentSqlModel;
import com.gemantic.commons.code.cmodel.DocTagContentTableFieldModel;
import com.gemantic.commons.code.cmodel.DocTagPosConfigSheetModel;
import com.gemantic.commons.code.cmodel.DocTagPosControllerSheetModel;
import com.gemantic.commons.code.cmodel.DocTagPosDBServiceSheetModel;
import com.gemantic.commons.code.cmodel.DocTagPosModel;
import com.gemantic.commons.code.manager.DesignDocParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Component;

@Component(value="excelDesignDocParser")
public class ExcelDesignDocParser
implements DesignDocParser {
    private static final Log log = LogFactory.getLog(ExcelDesignDocParser.class);

    @Override
    public CProject parseDesignDoc(String docPath) throws Exception {
        CProject cProject = new CProject();
        Workbook wb = this.initExcelWorkbook(docPath);
        if (wb == null) {
            return null;
        }
        int sheetNum = wb.getNumberOfSheets();
        if (sheetNum < 1) {
            return null;
        }
        Sheet configSheet = wb.getSheetAt(0);
        DocContentConfigSheetModel configSheetContent = this.parseConfigSheet(configSheet);
        String artifactID = configSheetContent.getArtifactId();
        cProject.setArtifactID(artifactID);
        List<CReference> referenceList = configSheetContent.getReferenceList();
        cProject.setReferences(referenceList);
        ArrayList<CMold> cMoldList = new ArrayList<CMold>();
        ArrayList<CController> cControllerList = new ArrayList<CController>();
        for (int sheetCounter = 1; sheetCounter < sheetNum; ++sheetCounter) {
            Map<String, CMold> cMoldMap;
            DocContentControllerSheetModel controllerSheetContent;
            List<CController> cControllers;
            Sheet sheet = wb.getSheetAt(sheetCounter);
            String sheetName = sheet.getSheetName();
            if (StringUtils.isBlank((String)sheetName)) continue;
            if (sheetName.startsWith("tbl_")) {
                CMold cMold;
                DocContentDBServiceSheetModel dbServiceSheetContent = this.parseDBServiceSheet(sheet);
                if (dbServiceSheetContent.isEmpty() || (cMold = this.convertDocContentDBServiceSheetModelToCMold(dbServiceSheetContent)) == null) continue;
                cMoldList.add(cMold);
                continue;
            }
            if (!sheetName.startsWith("ctr_") || !CollectionUtils.isNotEmpty(cControllers = this.convertDocContentControllerSheetModelToCControllerList(controllerSheetContent = this.parseControllerSheet(sheet), cMoldMap = this.convertCmoldList2Map(cMoldList)))) continue;
            for (CController cController : cControllers) {
                if (cController == null) continue;
                cControllerList.add(cController);
            }
        }
        cProject.setMolds(cMoldList);
        cProject.setControllers(cControllerList);
        return cProject;
    }

    private CMold convertDocContentDBServiceSheetModelToCMold(DocContentDBServiceSheetModel dbServiceSheetContent) {
        String tableName = dbServiceSheetContent.getTableName();
        String servicePort = dbServiceSheetContent.getServicePort();
        List<DocTagContentTableFieldModel> tableFieldContents = dbServiceSheetContent.getTableFieldContents();
        List<DocTagContentSqlModel> sqls = dbServiceSheetContent.getSqls();
        List<DocTagContentConstantModel> constants = dbServiceSheetContent.getConstants();
        List<String> indexs = dbServiceSheetContent.getIndexs();
        LinkedHashMap<String, String[]> indexsMap = new LinkedHashMap<String, String[]>();
        for (String string : indexs) {
            String[] index = StringUtils.split((String)string, (String)",");
            StringBuilder indexKey = new StringBuilder("idx");
            for (String field : index) {
                indexKey.append("_").append(field);
            }
            indexsMap.put(indexKey.toString(), index);
        }
        ArrayList<CField> cFieldList = new ArrayList<CField>();
        if (CollectionUtils.isNotEmpty(tableFieldContents)) {
            for (DocTagContentTableFieldModel docTagContentTableField : tableFieldContents) {
                CField cField = this.convertDocTagContentTableFieldModelToCField(docTagContentTableField);
                if (cField == null) continue;
                cFieldList.add(cField);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> sqlKeyDalTypeValueMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(sqls)) {
            for (DocTagContentSqlModel docTagContentSqlModel : sqls) {
                String sqlSentence = docTagContentSqlModel.getSqlSentence();
                String sqlResultType = docTagContentSqlModel.getSqlResultType();
                boolean needCountMethod = docTagContentSqlModel.isNeedCountMethod();
                log.info((Object)(sqlSentence + " create count method is " + needCountMethod));
                if (!StringUtils.isNotBlank((String)sqlSentence) || !StringUtils.isNotBlank((String)sqlResultType)) continue;
                arrayList.add(sqlSentence);
                sqlKeyDalTypeValueMap.put(sqlSentence, sqlResultType);
            }
        }
        ArrayList<CConstant> constantList = new ArrayList<CConstant>();
        if (CollectionUtils.isNotEmpty(constants)) {
            for (DocTagContentConstantModel constantContent : constants) {
                CConstant cConstant = this.convertDocTagContentConstantModelToCConstant(constantContent);
                if (cConstant == null) continue;
                constantList.add(cConstant);
            }
        }
        CMold cMold = new CMold();
        cMold.setTable(tableName);
        cMold.setIndexs(indexsMap);
        cMold.setPort(servicePort);
        cMold.setFields(cFieldList);
        cMold.setSqls(arrayList);
        cMold.setSql_typ(sqlKeyDalTypeValueMap);
        cMold.setConstants(constantList);
        return cMold;
    }

    private CConstant convertDocTagContentConstantModelToCConstant(DocTagContentConstantModel constantContent) {
        if (constantContent == null) {
            return null;
        }
        String constantName = constantContent.getConstantName();
        String constantValue = constantContent.getConstantValue();
        String constantType = constantContent.getConstantType();
        String constantComment = constantContent.getConstantComment();
        CConstant cConstant = null;
        if (StringUtils.isNotBlank((String)constantName) && StringUtils.isNotBlank((String)constantValue) && StringUtils.isNotBlank((String)constantType)) {
            cConstant = new CConstant(constantType, constantName, constantValue, constantComment);
        }
        return cConstant;
    }

    private CField convertDocTagContentTableFieldModelToCField(DocTagContentTableFieldModel docTagContentTableField) {
        if (docTagContentTableField == null) {
            return null;
        }
        String columnName = docTagContentTableField.getColumnName();
        String columnType = docTagContentTableField.getColumnType();
        String columnJavaField = docTagContentTableField.getColumnJavaField();
        String columnJavaFieldType = docTagContentTableField.getColumnJavaFieldType();
        String mockValue1 = docTagContentTableField.getMockValue1();
        String mockValue2 = docTagContentTableField.getMockValue2();
        String columnNull = docTagContentTableField.getColumnNull();
        if (StringUtils.isBlank((String)columnJavaField) || StringUtils.isBlank((String)columnJavaFieldType)) {
            return null;
        }
        CField cField = new CField(columnJavaField, columnJavaFieldType, columnName, columnType, columnNull);
        cField.setComment(docTagContentTableField.getColumnComment());
        if (StringUtils.isNotBlank((String)mockValue1) && StringUtils.isNotBlank((String)mockValue2)) {
            cField.addValue(mockValue1);
            cField.addValue(mockValue2);
        }
        return cField;
    }

    private Workbook initExcelWorkbook(String docPath) throws ServiceException {
        if (StringUtils.isBlank((String)docPath)) {
            return null;
        }
        XSSFWorkbook wb = null;
        POIFSFileSystem fs = null;
        FileInputStream inp = null;
        String fileName = ExcelDesignDocParser.class.getClassLoader().getResource(docPath).getFile();
        try {
            if (this.isExcel2007(docPath)) {
                wb = new XSSFWorkbook(fileName);
            } else {
                File file = new File(fileName);
                inp = new FileInputStream(file);
                fs = new POIFSFileSystem((InputStream)inp);
                wb = new HSSFWorkbook(fs);
                ((InputStream)inp).close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new ServiceException((Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ServiceException((Throwable)e);
        }
        finally {
            inp = null;
        }
        return wb;
    }

    private boolean isExcel2007(String docPath) {
        return docPath.matches("^.+\\.(?i)(xlsx)$");
    }

    private DocContentConfigSheetModel parseConfigSheet(Sheet configSheet) {
        if (configSheet == null) {
            return null;
        }
        DocTagPosConfigSheetModel docTagPosConfigSheetModel = this.parseConfigSheetTagPos(configSheet);
        DocTagPosModel artifactIDTagPos = null;
        DocTagPosModel referenceTagPos = null;
        if (docTagPosConfigSheetModel != null) {
            artifactIDTagPos = docTagPosConfigSheetModel.getArtifactIDTagPos();
            referenceTagPos = docTagPosConfigSheetModel.getReferenceTagPos();
        }
        String artifactID = this.getSingleLineTagContent(configSheet, artifactIDTagPos);
        List<CReference> cReferenceList = this.getReferenceTagContent(configSheet, referenceTagPos);
        DocContentConfigSheetModel configSheetModel = new DocContentConfigSheetModel();
        configSheetModel.setArtifactId(artifactID);
        configSheetModel.setReferenceList(cReferenceList);
        return configSheetModel;
    }

    private DocContentControllerSheetModel parseControllerSheet(Sheet controllerSheet) {
        if (controllerSheet == null) {
            return null;
        }
        DocTagPosControllerSheetModel docTagPosControllerSheetModel = this.parseControllerSheetTagPos(controllerSheet);
        DocTagPosModel urlTagPos = null;
        DocTagPosModel methodNameTagPos = null;
        DocTagPosModel returnPathTagPos = null;
        DocTagPosModel paramsTagPos = null;
        DocTagPosModel referenceTableTagPos = null;
        if (docTagPosControllerSheetModel != null) {
            urlTagPos = docTagPosControllerSheetModel.getUrlTagPos();
            methodNameTagPos = docTagPosControllerSheetModel.getMethodNameTagPos();
            returnPathTagPos = docTagPosControllerSheetModel.getReturnPathTagPos();
            paramsTagPos = docTagPosControllerSheetModel.getParamsTagPos();
            referenceTableTagPos = docTagPosControllerSheetModel.getReferenceTableTagPos();
        }
        String url = this.getSingleLineTagContent(controllerSheet, urlTagPos);
        String methodName = this.getSingleLineTagContent(controllerSheet, methodNameTagPos);
        String returnPath = this.getSingleLineTagContent(controllerSheet, returnPathTagPos);
        List<CField> paramList = this.getParamsTagContent(controllerSheet, paramsTagPos);
        List<String> referenceTableList = this.getMultiLineTagContent(controllerSheet, referenceTableTagPos);
        DocContentControllerSheetModel controllerSheetModel = new DocContentControllerSheetModel();
        controllerSheetModel.setUrl(url);
        controllerSheetModel.setMethodName(methodName);
        controllerSheetModel.setReturnPath(returnPath);
        controllerSheetModel.setParamList(paramList);
        controllerSheetModel.setReferenceTableList(referenceTableList);
        return controllerSheetModel;
    }

    private DocContentDBServiceSheetModel parseDBServiceSheet(Sheet configSheet) {
        if (configSheet == null) {
            return null;
        }
        DocTagPosDBServiceSheetModel docTagPosDBServiceSheetModel = this.parseDBServiceSheetTagPos(configSheet);
        DocTagPosModel tableNameTagPos = null;
        DocTagPosModel tableFieldTagPos = null;
        DocTagPosModel tableIndexTagPos = null;
        DocTagPosModel sqlTagPos = null;
        DocTagPosModel constantTagPos = null;
        DocTagPosModel servicePortTagPos = null;
        if (docTagPosDBServiceSheetModel != null) {
            tableNameTagPos = docTagPosDBServiceSheetModel.getTableNameTagPos();
            tableFieldTagPos = docTagPosDBServiceSheetModel.getTableFieldTagPos();
            tableIndexTagPos = docTagPosDBServiceSheetModel.getTableIndexTagPos();
            sqlTagPos = docTagPosDBServiceSheetModel.getSqlTagPos();
            constantTagPos = docTagPosDBServiceSheetModel.getConstantTagPos();
            servicePortTagPos = docTagPosDBServiceSheetModel.getServicePortTagPos();
        }
        String tableName = this.getSingleLineTagContent(configSheet, tableNameTagPos);
        List<DocTagContentTableFieldModel> tableFieldContents = this.getTableFieldTagContent(configSheet, tableFieldTagPos);
        List<String> indexs = this.getMultiLineTagContent(configSheet, tableIndexTagPos);
        List<DocTagContentSqlModel> sqls = this.getSqlTagContent(configSheet, sqlTagPos);
        List<DocTagContentConstantModel> constants = this.getConstantTagContent(configSheet, constantTagPos);
        String servicePort = this.getSingleLineTagContent(configSheet, servicePortTagPos);
        DocContentDBServiceSheetModel docContentDBServiceSheetModel = new DocContentDBServiceSheetModel();
        docContentDBServiceSheetModel.setTableName(tableName);
        docContentDBServiceSheetModel.setTableFieldContents(tableFieldContents);
        docContentDBServiceSheetModel.setIndexs(indexs);
        docContentDBServiceSheetModel.setSqls(sqls);
        docContentDBServiceSheetModel.setConstants(constants);
        docContentDBServiceSheetModel.setServicePort(servicePort);
        return docContentDBServiceSheetModel;
    }

    private DocTagPosConfigSheetModel parseConfigSheetTagPos(Sheet configSheet) {
        if (configSheet == null) {
            return null;
        }
        DocTagPosModel artifactIDTagPos = new DocTagPosModel();
        DocTagPosModel referenceTagPos = new DocTagPosModel();
        DocTagPosConfigSheetModel configSheetTagPosModel = new DocTagPosConfigSheetModel();
        configSheetTagPosModel.setArtifactIDTagPos(artifactIDTagPos);
        configSheetTagPosModel.setReferenceTagPos(referenceTagPos);
        int rowNum = configSheet.getLastRowNum();
        for (int i = 0; i <= rowNum; ++i) {
            Row row = configSheet.getRow(i);
            if (row == null || row.getLastCellNum() < 1) continue;
            Cell cell = row.getCell(0);
            String cellValue = this.getCellValue(cell);
            if ("ArtifactID(begin)".equalsIgnoreCase(cellValue)) {
                artifactIDTagPos.setTagName("artifactID");
                artifactIDTagPos.setStart(i);
                continue;
            }
            if ("ArtifactID(end)".equalsIgnoreCase(cellValue)) {
                artifactIDTagPos.setEnd(i);
                continue;
            }
            if ("references(begin)".equalsIgnoreCase(cellValue)) {
                referenceTagPos.setTagName("references");
                referenceTagPos.setStart(i);
                continue;
            }
            if (!"references(end)".equalsIgnoreCase(cellValue)) continue;
            referenceTagPos.setEnd(i);
        }
        return configSheetTagPosModel;
    }

    private DocTagPosControllerSheetModel parseControllerSheetTagPos(Sheet controllerSheet) {
        if (controllerSheet == null) {
            return null;
        }
        DocTagPosModel urlTagPos = new DocTagPosModel();
        DocTagPosModel methodNameTagPos = new DocTagPosModel();
        DocTagPosModel returnPathTagPos = new DocTagPosModel();
        DocTagPosModel paramsTagPos = new DocTagPosModel();
        DocTagPosModel referenceTableTagPos = new DocTagPosModel();
        DocTagPosControllerSheetModel controllerSheetTagPosModel = new DocTagPosControllerSheetModel();
        controllerSheetTagPosModel.setUrlTagPos(urlTagPos);
        controllerSheetTagPosModel.setMethodNameTagPos(methodNameTagPos);
        controllerSheetTagPosModel.setReturnPathTagPos(returnPathTagPos);
        controllerSheetTagPosModel.setParamsTagPos(paramsTagPos);
        controllerSheetTagPosModel.setReferenceTableTagPos(referenceTableTagPos);
        int rowNum = controllerSheet.getLastRowNum();
        for (int i = 0; i <= rowNum; ++i) {
            Row row = controllerSheet.getRow(i);
            if (row == null || row.getLastCellNum() < 1) continue;
            Cell cell = row.getCell(0);
            String cellValue = this.getCellValue(cell);
            if ("url(begin)".equalsIgnoreCase(cellValue)) {
                urlTagPos.setTagName("url");
                urlTagPos.setStart(i);
                continue;
            }
            if ("url(end)".equalsIgnoreCase(cellValue)) {
                urlTagPos.setEnd(i);
                continue;
            }
            if ("methodName(begin)".equalsIgnoreCase(cellValue)) {
                methodNameTagPos.setTagName("methodName");
                methodNameTagPos.setStart(i);
                continue;
            }
            if ("methodName(end)".equalsIgnoreCase(cellValue)) {
                methodNameTagPos.setEnd(i);
                continue;
            }
            if ("returnPath(begin)".equalsIgnoreCase(cellValue)) {
                returnPathTagPos.setTagName("returnPath");
                returnPathTagPos.setStart(i);
                continue;
            }
            if ("returnPath(end)".equalsIgnoreCase(cellValue)) {
                returnPathTagPos.setEnd(i);
                continue;
            }
            if ("params(begin)".equalsIgnoreCase(cellValue)) {
                paramsTagPos.setTagName("params");
                paramsTagPos.setStart(i);
                continue;
            }
            if ("params(end)".equalsIgnoreCase(cellValue)) {
                paramsTagPos.setEnd(i);
                continue;
            }
            if ("referenceTable(begin)".equalsIgnoreCase(cellValue)) {
                referenceTableTagPos.setTagName("referenceTable");
                referenceTableTagPos.setStart(i);
                continue;
            }
            if (!"referenceTable(end)".equalsIgnoreCase(cellValue)) continue;
            referenceTableTagPos.setEnd(i);
        }
        return controllerSheetTagPosModel;
    }

    private DocTagPosDBServiceSheetModel parseDBServiceSheetTagPos(Sheet dbServiceSheet) {
        if (dbServiceSheet == null) {
            return null;
        }
        DocTagPosModel tableNameTagPos = new DocTagPosModel();
        DocTagPosModel tableFieldTagPos = new DocTagPosModel();
        DocTagPosModel tableIndexTagPos = new DocTagPosModel();
        DocTagPosModel sqlTagPos = new DocTagPosModel();
        DocTagPosModel constantTagPos = new DocTagPosModel();
        DocTagPosModel servicePortTagPos = new DocTagPosModel();
        DocTagPosDBServiceSheetModel dBServiceSheetTagPosModel = new DocTagPosDBServiceSheetModel();
        dBServiceSheetTagPosModel.setTableNameTagPos(tableNameTagPos);
        dBServiceSheetTagPosModel.setTableFieldTagPos(tableFieldTagPos);
        dBServiceSheetTagPosModel.setTableIndexTagPos(tableIndexTagPos);
        dBServiceSheetTagPosModel.setSqlTagPos(sqlTagPos);
        dBServiceSheetTagPosModel.setConstantTagPos(constantTagPos);
        dBServiceSheetTagPosModel.setServicePortTagPos(servicePortTagPos);
        int rowNum = dbServiceSheet.getLastRowNum();
        for (int i = 0; i <= rowNum; ++i) {
            Row row = dbServiceSheet.getRow(i);
            if (row == null || row.getLastCellNum() < 1) continue;
            Cell cell = row.getCell(0);
            String cellValue = this.getCellValue(cell);
            if ("\u8868\u540d(begin)".equalsIgnoreCase(cellValue)) {
                tableNameTagPos.setTagName("tableName");
                tableNameTagPos.setStart(i);
                continue;
            }
            if ("\u8868\u540d(end)".equalsIgnoreCase(cellValue)) {
                tableNameTagPos.setEnd(i);
                continue;
            }
            if ("\u8868\u5b57\u6bb5(begin)".equalsIgnoreCase(cellValue)) {
                tableFieldTagPos.setTagName("tableField");
                tableFieldTagPos.setStart(i);
                continue;
            }
            if ("\u8868\u5b57\u6bb5(end)".equalsIgnoreCase(cellValue)) {
                tableFieldTagPos.setEnd(i);
                continue;
            }
            if ("\u7d22\u5f15(begin)".equalsIgnoreCase(cellValue)) {
                tableIndexTagPos.setTagName("tableIndex");
                tableIndexTagPos.setStart(i);
                continue;
            }
            if ("\u7d22\u5f15(end)".equalsIgnoreCase(cellValue)) {
                tableIndexTagPos.setEnd(i);
                continue;
            }
            if ("SQL\u6587(begin)".equalsIgnoreCase(cellValue)) {
                sqlTagPos.setTagName("sql");
                sqlTagPos.setStart(i);
                continue;
            }
            if ("SQL\u6587(end)".equalsIgnoreCase(cellValue)) {
                sqlTagPos.setEnd(i);
                continue;
            }
            if ("\u5e38\u91cf(begin)".equalsIgnoreCase(cellValue)) {
                constantTagPos.setTagName("constant");
                constantTagPos.setStart(i);
                continue;
            }
            if ("\u5e38\u91cf(end)".equalsIgnoreCase(cellValue)) {
                constantTagPos.setEnd(i);
                continue;
            }
            if ("service\u7aef\u53e3(begin)".equalsIgnoreCase(cellValue)) {
                servicePortTagPos.setTagName("servicePort");
                servicePortTagPos.setStart(i);
                continue;
            }
            if (!"service\u7aef\u53e3(end)".equalsIgnoreCase(cellValue)) continue;
            servicePortTagPos.setEnd(i);
        }
        return dBServiceSheetTagPosModel;
    }

    private List<CReference> getReferenceTagContent(Sheet configSheet, DocTagPosModel referenceTagPos) {
        ArrayList<CReference> referenceList = new ArrayList<CReference>();
        int start = referenceTagPos.getStart();
        int end = referenceTagPos.getEnd();
        if (end - start < 3) {
            return referenceList;
        }
        for (int i = start + 2; i < end; ++i) {
            Row row = configSheet.getRow(i);
            if (row == null) continue;
            String serviceName = this.getCellValue(row.getCell(0));
            String servicePackage = this.getCellValue(row.getCell(1));
            String rmiResourceName = this.getCellValue(row.getCell(2));
            String rmiServiceName = this.getCellValue(row.getCell(3));
            boolean isServiceNameBlank = StringUtils.isBlank((String)serviceName);
            boolean isServicePackageBlank = StringUtils.isBlank((String)servicePackage);
            boolean isRmiResourceNameBlank = StringUtils.isBlank((String)rmiResourceName);
            boolean isRmiServiceNameBlank = StringUtils.isBlank((String)rmiServiceName);
            if (isServiceNameBlank || isServicePackageBlank || isRmiResourceNameBlank || isRmiServiceNameBlank) continue;
            CReference reference = new CReference(serviceName, servicePackage, rmiResourceName, rmiServiceName);
            referenceList.add(reference);
        }
        return referenceList;
    }

    private String getSingleLineTagContent(Sheet sheet, DocTagPosModel tagPos) {
        String result = null;
        int start = tagPos.getStart();
        int end = tagPos.getEnd();
        if (end - start < 2) {
            return "";
        }
        block0: for (int i = start + 1; i < end; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            int cellNum = row.getLastCellNum();
            for (int cellCounter = 0; cellCounter < cellNum; ++cellCounter) {
                Cell cell = row.getCell(cellCounter);
                result = this.getCellValue(cell);
                if (StringUtils.isNotBlank((String)result)) break block0;
            }
        }
        return result;
    }

    private List<CField> getParamsTagContent(Sheet controllerSheet, DocTagPosModel paramsTagPos) {
        ArrayList<CField> paramsList = new ArrayList<CField>();
        int start = paramsTagPos.getStart();
        int end = paramsTagPos.getEnd();
        if (end - start < 3) {
            return paramsList;
        }
        for (int i = start + 2; i < end; ++i) {
            Row row = controllerSheet.getRow(i);
            if (row == null) continue;
            String paramName = this.getCellValue(row.getCell(0));
            String paramType = this.getCellValue(row.getCell(1));
            boolean isParamNameBlank = StringUtils.isBlank((String)paramName);
            boolean isParamTypeBlank = StringUtils.isBlank((String)paramType);
            if (isParamNameBlank || isParamTypeBlank) continue;
            CField cField = new CField(paramName, paramType, "", "");
            paramsList.add(cField);
        }
        return paramsList;
    }

    private List<DocTagContentTableFieldModel> getTableFieldTagContent(Sheet dbServiceSheet, DocTagPosModel tableFieldTagPos) {
        ArrayList<DocTagContentTableFieldModel> docTableFieldModelList = new ArrayList<DocTagContentTableFieldModel>();
        int start = tableFieldTagPos.getStart();
        int end = tableFieldTagPos.getEnd();
        if (end - start < 3) {
            return docTableFieldModelList;
        }
        for (int i = start + 2; i < end; ++i) {
            Row row = dbServiceSheet.getRow(i);
            if (row == null) continue;
            String columnName = this.getCellValue(row.getCell(0));
            String columnJavaField = this.getCellValue(row.getCell(1));
            String columnType = this.getCellValue(row.getCell(2));
            String columnJavaFieldType = this.getCellValue(row.getCell(3));
            String columnNull = this.getCellValue(row.getCell(4));
            String columnDefaultValue = this.getCellValue(row.getCell(5));
            String columnPrimaryKey = this.getCellValue(row.getCell(6));
            String columnComment = this.getCellValue(row.getCell(7));
            String mockValue1 = this.simpleFormatMockValue(this.getCellValue(row.getCell(8)), columnJavaFieldType);
            String mockValue2 = this.simpleFormatMockValue(this.getCellValue(row.getCell(9)), columnJavaFieldType);
            if (StringUtils.isBlank((String)columnName) && StringUtils.isBlank((String)columnJavaField)) continue;
            DocTagContentTableFieldModel docTableFieldModel = new DocTagContentTableFieldModel();
            docTableFieldModel.setColumnName(columnName);
            docTableFieldModel.setColumnJavaField(columnJavaField);
            docTableFieldModel.setColumnType(columnType);
            docTableFieldModel.setColumnJavaFieldType(columnJavaFieldType);
            docTableFieldModel.setColumnNull(columnNull);
            docTableFieldModel.setColumnDefaultValue(columnDefaultValue);
            docTableFieldModel.setColumnPrimaryKey(columnPrimaryKey);
            docTableFieldModel.setColumnComment(columnComment);
            docTableFieldModel.setMockValue1(mockValue1);
            docTableFieldModel.setMockValue2(mockValue2);
            docTableFieldModelList.add(docTableFieldModel);
        }
        return docTableFieldModelList;
    }

    private List<String> getMultiLineTagContent(Sheet sheet, DocTagPosModel tagPos) {
        ArrayList<String> resultList = new ArrayList<String>();
        int start = tagPos.getStart();
        int end = tagPos.getEnd();
        if (end - start < 2) {
            return resultList;
        }
        for (int i = start + 1; i < end; ++i) {
            String result;
            Row row = sheet.getRow(i);
            if (row == null || !StringUtils.isNotBlank((String)(result = this.getCellValue(row.getCell(0))))) continue;
            resultList.add(result);
        }
        return resultList;
    }

    private List<DocTagContentSqlModel> getSqlTagContent(Sheet dbServiceSheet, DocTagPosModel sqlTagPos) {
        ArrayList<DocTagContentSqlModel> sqlList = new ArrayList<DocTagContentSqlModel>();
        int start = sqlTagPos.getStart();
        int end = sqlTagPos.getEnd();
        if (end - start < 3) {
            return sqlList;
        }
        for (int i = start + 2; i < end; ++i) {
            Row row = dbServiceSheet.getRow(i);
            if (row == null) continue;
            String sqlSentence = this.getCellValue(row.getCell(0));
            String sqlResultType = this.getCellValue(row.getCell(1));
            String creatCount = this.getCellValue(row.getCell(2));
            if (StringUtils.isBlank((String)sqlSentence)) continue;
            DocTagContentSqlModel docTagContentSqlModel = new DocTagContentSqlModel();
            docTagContentSqlModel.setSqlSentence(sqlSentence);
            docTagContentSqlModel.setSqlResultType(sqlResultType);
            if ("yes".equalsIgnoreCase(creatCount)) {
                docTagContentSqlModel.setNeedCountMethod(true);
            }
            sqlList.add(docTagContentSqlModel);
        }
        return sqlList;
    }

    private List<DocTagContentConstantModel> getConstantTagContent(Sheet dbServiceSheet, DocTagPosModel constantTagPos) {
        ArrayList<DocTagContentConstantModel> constantList = new ArrayList<DocTagContentConstantModel>();
        int start = constantTagPos.getStart();
        int end = constantTagPos.getEnd();
        if (end - start < 3) {
            return constantList;
        }
        for (int i = start + 2; i < end; ++i) {
            Row row = dbServiceSheet.getRow(i);
            if (row == null) continue;
            String constantName = this.getCellValue(row.getCell(0));
            String constantValue = this.getCellValue(row.getCell(1));
            String constantType = this.getCellValue(row.getCell(2));
            String constantComment = this.getCellValue(row.getCell(3));
            if ("long".equalsIgnoreCase(constantType)) {
                constantValue = constantValue + "L";
            } else if ("String".equalsIgnoreCase(constantType)) {
                constantValue = "\"" + constantValue + "\"";
            }
            boolean isConstantNameBlank = StringUtils.isBlank((String)constantName);
            boolean isConstantValueBlank = StringUtils.isBlank((String)constantValue);
            boolean isConstantTypeBlank = StringUtils.isBlank((String)constantType);
            if (isConstantNameBlank || isConstantValueBlank || isConstantTypeBlank) continue;
            DocTagContentConstantModel docTagContentConstantModel = new DocTagContentConstantModel();
            docTagContentConstantModel.setConstantName(constantName);
            docTagContentConstantModel.setConstantValue(constantValue);
            docTagContentConstantModel.setConstantType(constantType);
            docTagContentConstantModel.setConstantComment(constantComment);
            constantList.add(docTagContentConstantModel);
        }
        return constantList;
    }

    private String getCellValue(Cell cell) {
        try {
            String cellValue = "";
            if (cell == null) {
                return cellValue;
            }
            int cellType = cell.getCellType();
            switch (cellType) {
                case 0: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        cellValue = cell.getDateCellValue() + "";
                        break;
                    }
                    cellValue = this.getNumericStr(cell.getNumericCellValue() + "");
                    break;
                }
                case 1: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case 4: {
                    cellValue = cell.getBooleanCellValue() + "";
                    break;
                }
                default: {
                    cellValue = cell.toString() + "";
                }
            }
            log.info((Object)StringUtils.trim((String)cellValue));
            return StringUtils.trim((String)cellValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            log.error((Object)"parse wrong");
            log.error((Object)(cell.getRowIndex() + "," + cell.getColumnIndex() + "," + cell.getRow().getSheet().getSheetName()));
            return "";
        }
    }

    private String getNumericStr(String num) {
        DecimalFormat decimalFormat = new DecimalFormat("#0");
        String resultStr = decimalFormat.format(Double.valueOf(num));
        if (resultStr.matches("^[-+]?\\d+\\.[0]+$")) {
            resultStr = resultStr.substring(0, resultStr.indexOf("."));
        }
        return resultStr;
    }

    private String simpleFormatMockValue(String mockValue, String columnJavaFieldType) {
        String result = "";
        if (StringUtils.isBlank((String)mockValue)) {
            return result;
        }
        result = "String".equalsIgnoreCase(columnJavaFieldType) ? "\"" + mockValue + "\"" : ("Long".equalsIgnoreCase(columnJavaFieldType) ? mockValue + "L" : ("Float".equalsIgnoreCase(columnJavaFieldType) ? mockValue + "F" : mockValue));
        return result;
    }

    private Map<String, CMold> convertCmoldList2Map(List<CMold> cMoldList) {
        HashMap<String, CMold> cMoldMap = new HashMap<String, CMold>();
        if (CollectionUtils.isEmpty(cMoldList)) {
            return cMoldMap;
        }
        for (CMold cMold : cMoldList) {
            String tableName;
            if (cMold == null || StringUtils.isBlank((String)(tableName = cMold.getTable()))) continue;
            cMoldMap.put(tableName, cMold);
        }
        return cMoldMap;
    }

    private List<CController> convertDocContentControllerSheetModelToCControllerList(DocContentControllerSheetModel controllerSheetContent, Map<String, CMold> cMoldMap) {
        ArrayList<CController> cControllerList = new ArrayList<CController>();
        if (controllerSheetContent == null) {
            return cControllerList;
        }
        String url = controllerSheetContent.getUrl();
        String methodName = controllerSheetContent.getMethodName();
        String returnPath = controllerSheetContent.getReturnPath();
        List<CField> paramList = controllerSheetContent.getParamList();
        List<String> referenceTableList = controllerSheetContent.getReferenceTableList();
        CRequest cRequest = new CRequest(url, methodName, paramList, returnPath);
        if (CollectionUtils.isNotEmpty(referenceTableList)) {
            String referenceTable = referenceTableList.get(0);
            CMold cMold = cMoldMap.get(referenceTable);
            cRequest.setMold(cMold);
        }
        ArrayList<CRequest> cRequestList = new ArrayList<CRequest>();
        cRequestList.add(cRequest);
        CController cController = new CController();
        cController.setRequests(cRequestList);
        cControllerList.add(cController);
        return cControllerList;
    }
}

