/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.commons.code.manager.android.impl;

import com.gemantic.commons.code.manager.android.AndroidCodeGenerate;
import com.gemantic.commons.code.model.android.AndroidModel;
import com.gemantic.commons.code.model.android.AndroidPresenter;
import com.gemantic.commons.code.model.android.AndroidProject;
import com.gemantic.commons.code.model.android.AndroidService;
import com.gemantic.commons.code.model.ios.TemplateConfig;
import com.qding.common.util.FileUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.velocity.VelocityEngineUtils;

@Component(value="androidCodeGenerate")
public class AndroidProjectImpl
implements AndroidCodeGenerate {
    private static final Log log = LogFactory.getLog(AndroidProjectImpl.class);
    @Autowired
    private VelocityEngine velocityEngine;

    @Override
    public List<String> generateModelFile(AndroidProject project) {
        List<AndroidModel> models = project.getModels();
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("project", project);
        ArrayList<String> contents = new ArrayList<String>();
        Map<String, String> template_path = project.getName_template();
        String hpath = template_path.get("template_model");
        for (AndroidModel m : models) {
            try {
                model.put("model", m);
                log.info((Object)("generate model h is " + m));
                TemplateConfig templateConfig = m.getTemplateConfig();
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)hpath, model);
                log.info((Object)(m.getName() + " write content is " + content));
                FileUtil.writeFile((String)(templateConfig.getTargetPath() + templateConfig.getTargetName()), (boolean)false, (String)content);
                log.info((Object)(templateConfig.getTargetPath() + " =========create============== " + templateConfig.getTargetName()));
                contents.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    @Override
    public List<String> generatePresenterFile(AndroidProject project) {
        List<AndroidPresenter> presenters = project.getPersenters();
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("project", project);
        ArrayList<String> contents = new ArrayList<String>();
        Map<String, String> template_path = project.getName_template();
        String hpath = template_path.get("template_persenter");
        for (AndroidPresenter presenter : presenters) {
            try {
                model.put("presenter", presenter);
                log.info((Object)("generate model h is " + presenter));
                TemplateConfig templateConfig = presenter.getTemplateConfig();
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)hpath, model);
                log.info((Object)(presenter.getName() + " write content is " + content));
                FileUtil.writeFile((String)(templateConfig.getTargetPath() + templateConfig.getTargetName()), (boolean)false, (String)content);
                log.info((Object)(templateConfig.getTargetPath() + " =========create============== " + templateConfig.getTargetName()));
                contents.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    @Override
    public List<String> generateServiceFile(AndroidProject project) {
        List<AndroidService> services = project.getServices();
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("project", project);
        ArrayList<String> contents = new ArrayList<String>();
        Map<String, String> template_path = project.getName_template();
        String hpath = template_path.get("template_service");
        for (AndroidService service : services) {
            try {
                model.put("service", service);
                log.info((Object)("generate model h is " + service));
                TemplateConfig templateConfig = service.getTemplateConfig();
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)hpath, model);
                log.info((Object)(service.getName() + " write content is " + content));
                FileUtil.writeFile((String)(templateConfig.getTargetPath() + templateConfig.getTargetName()), (boolean)false, (String)content);
                log.info((Object)(templateConfig.getTargetPath() + " =========create============== " + templateConfig.getTargetName()));
                contents.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return contents;
    }
}

