/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.commons.code.manager.impl;

import com.gemantic.commons.code.cmodel.CConfig;
import com.gemantic.commons.code.cmodel.CMold;
import com.gemantic.commons.code.cmodel.CProject;
import com.gemantic.commons.code.manager.CodeGenerate;
import com.gemantic.commons.code.util.CConfigUtil;
import com.qding.common.util.FileUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.tools.generic.EscapeTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.velocity.VelocityEngineUtils;

@Component(value="codeGenerate")
public class CodeGenerateImpl
implements CodeGenerate {
    private static final Log log = LogFactory.getLog(CodeGenerateImpl.class);
    @Autowired
    private VelocityEngine velocityEngine;

    @Override
    public boolean generateServiceProject(CProject project) {
        this.generateImpls(project);
        String server = this.generateServer(project);
        CConfigUtil.generateConfigs(project);
        List<String> configs = this.generateConfigs(project);
        List<String> tests = this.generateTests(project);
        return true;
    }

    @Override
    public List<String> generateTests(CProject project) {
        ArrayList<String> tests = new ArrayList<String>();
        for (CMold m : project.getMolds()) {
            log.info((Object)("generate test " + m.getImplClass()));
            try {
                HashMap<String, Serializable> model = new HashMap<String, Serializable>();
                model.put("project", project);
                model.put("cm", m);
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/test/test.vm", model);
                FileUtil.writeFile((String)(m.getTestPath() + "/"), (String)(m.getTestClass() + ".java"), (boolean)project.isAppend(), (String)content);
                tests.add(content);
                log.info((Object)(m.getTestPath() + m.getTestClass() + ".java created ==============succeess "));
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return tests;
    }

    @Override
    public List<String> generateConfigs(CProject project) {
        List<CConfig> configs = project.getConfigs();
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("project", project);
        ArrayList<String> contents = new ArrayList<String>();
        for (CConfig config : configs) {
            try {
                model.put("config", config);
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)config.getPvelocity(), model);
                FileUtil.writeFile((String)(config.getFilePath() + "/"), (String)config.getName(), (boolean)project.isAppend(), (String)content);
                log.info((Object)(config.getFilePath() + " =========create============== " + config.getName()));
                contents.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    @Override
    public String generateServer(CProject project) {
        try {
            HashMap<String, CProject> model = new HashMap<String, CProject>();
            model.put("project", project);
            String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/server.vm", model);
            FileUtil.writeFile((String)(project.getServerPath() + "/"), (String)(project.getServerClass() + ".java"), (boolean)project.isAppend(), (String)content);
            return content;
        }
        catch (VelocityException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<String> generateImpls(CProject project) {
        ArrayList<String> ms = new ArrayList<String>();
        for (CMold cm : project.getMolds()) {
            log.info((Object)("generate impl " + cm.getImplClass()));
            try {
                HashMap<String, CMold> model = new HashMap<String, CMold>();
                model.put("cm", cm);
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/impl.vm", model);
                FileUtil.writeFile((String)(cm.getImplPath() + "/"), (String)(cm.getImplClass() + ".java"), (boolean)project.isAppend(), (String)content);
                ms.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return ms;
    }

    @Override
    public List<String> generateInterfaces(CProject project) {
        ArrayList<String> ms = new ArrayList<String>();
        for (CMold cm : project.getMolds()) {
            try {
                HashMap<String, CMold> model = new HashMap<String, CMold>();
                model.put("cm", cm);
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/interface.vm", model);
                FileUtil.writeFile((String)(cm.getInterfacePath() + "/"), (String)(cm.getInterfaceClass() + ".java"), (boolean)project.isAppend(), (String)content);
                ms.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return ms;
    }

    @Override
    public List<String> generateModels(CProject project) {
        ArrayList<String> ms = new ArrayList<String>();
        for (CMold cm : project.getMolds()) {
            log.info((Object)(cm.getModelPath() + " generate model " + cm.getModelClass()));
            try {
                HashMap<String, CMold> model = new HashMap<String, CMold>();
                model.put("cm", cm);
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/model.vm", model);
                FileUtil.writeFile((String)(cm.getModelPath() + "/"), (String)(cm.getModelClass() + ".java"), (boolean)project.isAppend(), (String)content);
                ms.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return ms;
    }

    @Override
    public boolean generateCoreProject(CProject project) {
        List<CMold> cms = project.getMolds();
        log.info((Object)"generate model ");
        List<String> models = this.generateModels(project);
        log.info((Object)("generate model success " + models.size()));
        List<String> interfaces = this.generateInterfaces(project);
        log.info((Object)("generate interfaces success " + interfaces.size()));
        return true;
    }

    @Override
    public boolean generateClientProject(CProject project) {
        for (CMold m : project.getMolds()) {
            log.info((Object)("generate client " + m.getImplClass()));
            try {
                HashMap<String, Serializable> model = new HashMap<String, Serializable>();
                model.put("project", project);
                model.put("cm", m);
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/client.vm", model);
                FileUtil.writeFile((String)(m.getClientPath() + "/"), (String)(m.getClientClass() + ".java"), (boolean)project.isAppend(), (String)content);
                log.info((Object)(m.getClientPath() + m.getClientClass() + ".java created ==============succeess "));
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public boolean generateControllerProject(CProject project) {
        ArrayList<String> ms = new ArrayList<String>();
        for (CMold cm : project.getMolds()) {
            log.info((Object)(cm.getModelPath() + " generate table " + cm.getModelClass()));
            try {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("esc", new EscapeTool());
                model.put("cm", cm);
                model.put("project", project);
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/controller/controller.vm", model);
                FileUtil.writeFile((String)(project.getControllerPath() + "/"), (String)(cm.getModelClass() + "Controller" + ".java"), (boolean)project.isAppend(), (String)content);
                log.info((Object)(project.getControllerPath() + " =========create============== " + cm.getModelClass() + "Controller" + ".java"));
                String jsonListContent = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/json/list.vm", model);
                FileUtil.writeFile((String)(project.getJsonPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/json/"), (String)(cm.uncapitalize(cm.getModelClass()) + "ListJson.jsp"), (boolean)project.isAppend(), (String)jsonListContent);
                log.info((Object)(project.getJsonPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/json/" + " =========create============== " + cm.uncapitalize(cm.getModelClass()) + "ListJson.jsp"));
                String jsonDetailContent = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/json/detail.vm", model);
                FileUtil.writeFile((String)(project.getJsonPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/json/"), (String)(cm.uncapitalize(cm.getModelClass()) + "DetailJson.jsp"), (boolean)project.isAppend(), (String)jsonDetailContent);
                log.info((Object)(project.getJsonPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/json/" + " =========create============== " + cm.uncapitalize(cm.getModelClass()) + "DetailJson.jsp"));
                String jspListContent = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/jsp/list.vm", model);
                FileUtil.writeFile((String)(project.getJspPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/view/"), (String)(cm.uncapitalize(cm.getModelClass()) + "List.jsp"), (boolean)project.isAppend(), (String)jspListContent);
                log.info((Object)(project.getJspPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/view/" + " =========create============== " + cm.uncapitalize(cm.getModelClass()) + "List.jsp"));
                String jspDetailContent = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/jsp/detail.vm", model);
                FileUtil.writeFile((String)(project.getJspPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/view/"), (String)(cm.uncapitalize(cm.getModelClass()) + "Detail.jsp"), (boolean)project.isAppend(), (String)jspDetailContent);
                log.info((Object)(project.getJspPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/view/" + " =========create============== " + cm.uncapitalize(cm.getModelClass()) + "Detail.jsp"));
                String listControllerJSContent = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/js/controller/list.vm", model);
                FileUtil.writeFile((String)(project.getJsPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/"), (String)(cm.uncapitalize(cm.getModelClass()) + "Controller.js"), (boolean)project.isAppend(), (String)listControllerJSContent.replace("|-angularjs-|", "$"));
                log.info((Object)(project.getJsPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/" + " =========create============== " + cm.uncapitalize(cm.getModelClass()) + "Controller.js"));
                String detailControllerJSContent = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/js/controller/detail.vm", model);
                FileUtil.writeFile((String)(project.getJsPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/"), (String)(cm.uncapitalize(cm.getModelClass()) + "DetailController.js"), (boolean)project.isAppend(), (String)detailControllerJSContent.replace("|-angularjs-|", "$"));
                log.info((Object)(project.getJsPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/" + " =========create============== " + cm.uncapitalize(cm.getModelClass()) + "DetailController.js"));
                String listHtmlContent = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/js/html/list.vm", model);
                FileUtil.writeFile((String)(project.getJsPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/"), (String)(cm.uncapitalize(cm.getModelClass()) + "List.html"), (boolean)project.isAppend(), (String)listHtmlContent);
                log.info((Object)(project.getJsPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/" + " =========create============== " + cm.uncapitalize(cm.getModelClass()) + "List.html"));
                String detailHtmlContent = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/js/html/detail.vm", model);
                FileUtil.writeFile((String)(project.getJsPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/"), (String)(cm.uncapitalize(cm.getModelClass()) + "Detail.html"), (boolean)project.isAppend(), (String)detailHtmlContent);
                log.info((Object)(project.getJsPath() + "/" + project.getArtifactID() + "/" + cm.uncapitalize(cm.getModelClass()) + "/" + " =========create============== " + cm.uncapitalize(cm.getModelClass()) + "Detail.html"));
                String serviceJSContent = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/js/service/service.vm", model);
                FileUtil.writeFile((String)(project.getJsPath() + "/" + project.getArtifactID() + "/service.js"), (boolean)project.isAppend(), (String)serviceJSContent.replace("|-angularjs-|", "$"));
                log.info((Object)(project.getJsPath() + "/" + project.getArtifactID() + "/service.js"));
                String routeJSContent = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/js/route/route.vm", model);
                FileUtil.writeFile((String)(project.getJsPath() + "/" + project.getArtifactID() + "/route.js"), (boolean)project.isAppend(), (String)routeJSContent);
                log.info((Object)(project.getJsPath() + "/" + project.getArtifactID() + "/route.js"));
                ms.add(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public boolean generateDataBaseScript(CProject project) {
        ArrayList<String> ms = new ArrayList<String>();
        StringBuffer allSB = new StringBuffer();
        for (CMold cm : project.getMolds()) {
            log.info((Object)(cm.getModelPath() + " generate table " + cm.getModelClass()));
            try {
                HashMap<String, CMold> model = new HashMap<String, CMold>();
                model.put("cm", cm);
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/db/table.vm", model);
                FileUtil.writeFile((String)(project.getDbresource() + "/"), (String)(cm.getTable() + ".sql"), (boolean)project.isAppend(), (String)content);
                ms.add(content);
                allSB = allSB.append(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        FileUtil.writeFile((String)(project.getDbresource() + "/"), (String)"all.sql", (boolean)project.isAppend(), (String)allSB.toString());
        return true;
    }

    @Override
    public boolean generateResourcesSqlScript(CProject project) {
        ArrayList<String> ms = new ArrayList<String>();
        String hostName = project.getArtifactID().replaceAll("-", ".");
        StringBuffer allSB = new StringBuffer();
        for (CMold cm : project.getMolds()) {
            log.info((Object)(cm.getModelPath() + " generate resources sql " + cm.getModelClass()));
            try {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("cm", cm);
                model.put("hostName", hostName);
                String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"velocity/db/resources.vm", model);
                FileUtil.writeFile((String)(project.getDbresource() + "/"), (String)(cm.getTable() + "_resources" + ".sql"), (boolean)project.isAppend(), (String)content);
                ms.add(content);
                allSB = allSB.append(content);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
        }
        FileUtil.writeFile((String)(project.getDbresource() + "/"), (String)"all-resource.sql", (boolean)project.isAppend(), (String)allSB.toString());
        return true;
    }
}

