/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.common.stat.aop.time;

import com.gemantic.common.stat.aop.CommonAOPStat;
import org.aspectj.lang.ProceedingJoinPoint;

public class AroundTimeConsume
extends CommonAOPStat {
    private static long LOG_THREASHOLD_TIME = 50L;

    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        long t1 = System.currentTimeMillis();
        Object ret = pjp.proceed();
        long time = System.currentTimeMillis() - t1;
        this.logger.info((Object)this.printInfo(pjp, time, null, 0, false));
        return ret;
    }

    private String printInfo(ProceedingJoinPoint pjp, long time, StringBuilder sb, int size, boolean isDetail) {
        StringBuffer sbuffer = new StringBuffer();
        sbuffer = sbuffer.append(pjp.getTarget().getClass());
        sbuffer = sbuffer.append(".").append(pjp.getSignature().getName());
        sbuffer = sbuffer.append("(");
        sbuffer = sbuffer.append(pjp.getSignature().getDeclaringTypeName());
        sbuffer = sbuffer.append(") ");
        sbuffer = sbuffer.append("pjp.toShortString()");
        sbuffer = sbuffer.append(" process time: ");
        sbuffer = sbuffer.append(time);
        sbuffer = sbuffer.append(" size: ");
        sbuffer = sbuffer.append(size);
        if (isDetail) {
            sbuffer = sbuffer.append(" params: ");
            sbuffer = sbuffer.append(sb.toString());
        }
        return sbuffer.toString();
    }

    private StringBuilder convert2ParamStrings(ProceedingJoinPoint pjp) {
        StringBuilder sb = new StringBuilder();
        Object[] args = pjp.getArgs();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                sb.append(" p").append(i).append("=").append(args[i]);
            }
        }
        return sb;
    }

    public void before() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void after() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void afterReturn(Object retVal) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

