/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.util;

import com.alibaba.fastjson.JSON;
import com.foxinmy.weixin4j.http.HttpParams;
import com.foxinmy.weixin4j.model.WeixinAccount;
import com.foxinmy.weixin4j.model.WeixinPayAccount;
import com.foxinmy.weixin4j.token.FileTokenStorager;
import com.foxinmy.weixin4j.token.TokenStorager;
import com.foxinmy.weixin4j.util.StringUtil;
import com.foxinmy.weixin4j.util.Weixin4jConfigUtil;

public class Weixin4jSettings {
    private WeixinPayAccount weixinPayAccount;
    private WeixinAccount weixinAccount;
    private HttpParams httpParams;
    private TokenStorager tokenStorager;
    private String tmpdir;
    private String certificateFile;

    public Weixin4jSettings() {
        this((WeixinPayAccount)JSON.parseObject((String)Weixin4jConfigUtil.getValue("account"), WeixinPayAccount.class), null);
    }

    public Weixin4jSettings(WeixinPayAccount weixinPayAccount, String certificateFile) {
        this(weixinPayAccount);
        this.certificateFile = certificateFile;
    }

    public Weixin4jSettings(WeixinPayAccount weixinPayAccount) {
        this.weixinPayAccount = weixinPayAccount;
        this.weixinAccount = new WeixinAccount(weixinPayAccount.getId(), weixinPayAccount.getSecret());
    }

    public Weixin4jSettings(WeixinAccount weixinAccount) {
        this.weixinAccount = weixinAccount;
    }

    public WeixinPayAccount getWeixinPayAccount() {
        return this.weixinPayAccount;
    }

    public WeixinAccount getWeixinAccount() {
        return this.weixinAccount;
    }

    public HttpParams getHttpParams() {
        return this.httpParams;
    }

    public HttpParams getHttpParams0() {
        if (this.httpParams == null) {
            return new HttpParams();
        }
        return this.httpParams;
    }

    public String getTmpdir() {
        return this.tmpdir;
    }

    public String getTmpdir0() {
        if (StringUtil.isBlank(this.tmpdir)) {
            return Weixin4jConfigUtil.getClassPathValue("weixin4j.tmpdir", System.getProperty("java.io.tmpdir"));
        }
        return this.tmpdir;
    }

    public TokenStorager getTokenStorager() {
        return this.tokenStorager;
    }

    public TokenStorager getTokenStorager0() {
        if (this.tokenStorager == null) {
            return new FileTokenStorager(this.getTmpdir0());
        }
        return this.tokenStorager;
    }

    public String getCertificateFile() {
        return this.certificateFile;
    }

    public String getCertificateFile0() {
        if (StringUtil.isBlank(this.certificateFile)) {
            return Weixin4jConfigUtil.getClassPathValue("weixin4j.certificate.file", "classpath:ca.p12");
        }
        return this.certificateFile;
    }

    public void setHttpParams(HttpParams httpParams) {
        this.httpParams = httpParams;
    }

    public void setTmpdir(String tmpdir) {
        this.tmpdir = tmpdir;
    }

    public void setTokenStorager(TokenStorager tokenStorager) {
        this.tokenStorager = tokenStorager;
    }

    public void setCertificateFile(String certificateFile) {
        this.certificateFile = certificateFile;
    }

    public String toString() {
        return "Weixin4jSettings [weixinAccount=" + this.weixinAccount + ", httpParams=" + this.httpParams + ",tokenStorager=" + this.tokenStorager + ", tmpdir=" + this.tmpdir + ", certificateFile= " + this.certificateFile + "]";
    }
}

