/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.token;

import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.token.TokenCreator;
import com.foxinmy.weixin4j.token.TokenStorager;

public class TokenHolder {
    private final TokenCreator tokenCreator;
    private final TokenStorager tokenStorager;

    public TokenHolder(TokenCreator tokenCreator, TokenStorager tokenStorager) {
        this.tokenCreator = tokenCreator;
        this.tokenStorager = tokenStorager;
    }

    public Token getToken() throws WeixinException {
        String cacheKey = this.tokenCreator.getCacheKey();
        Token token = (Token)this.tokenStorager.lookup(cacheKey);
        if (token == null) {
            token = this.tokenCreator.createToken();
            this.tokenStorager.caching(cacheKey, token);
        }
        return token;
    }

    public String getAccessToken() throws WeixinException {
        return this.getToken().getAccessToken();
    }

    public Token refreshToken() throws WeixinException {
        String cacheKey = this.tokenCreator.getCacheKey();
        Token token = this.tokenCreator.createToken();
        this.tokenStorager.caching(cacheKey, token);
        return token;
    }

    public Token evictToken() throws WeixinException {
        String cacheKey = this.tokenCreator.getCacheKey();
        return (Token)this.tokenStorager.evict(cacheKey);
    }
}

