/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.token;

import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.token.TokenStorager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Pipeline;

public class RedisTokenStorager
implements TokenStorager {
    private JedisPool jedisPool;
    public static final int PORT = 6379;
    public static final int MAX_TOTAL = 50;
    public static final int MAX_IDLE = 5;
    public static final int MAX_WAIT_MILLIS = 2000;
    public static final boolean TEST_ON_BORROW = false;
    public static final boolean TEST_ON_RETURN = true;
    private static final String ACCESSTOKEN_KEY = "accessToken";
    private static final String EXPIRESIN_KEY = "expiresIn";
    private static final String CREATETIME_KEY = "createTime";
    private static final String ORIGINAL_KEY = "originalResult";

    public RedisTokenStorager() {
        this("localhost", 6379);
    }

    public RedisTokenStorager(String host, int port) {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(50);
        jedisPoolConfig.setMaxIdle(5);
        jedisPoolConfig.setMaxWaitMillis(2000L);
        jedisPoolConfig.setTestOnBorrow(false);
        jedisPoolConfig.setTestOnReturn(true);
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port);
    }

    public RedisTokenStorager(String host, int port, JedisPoolConfig jedisPoolConfig) {
        this(new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port));
    }

    public RedisTokenStorager(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token lookup(String cacheKey) throws WeixinException {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Map map = jedis.hgetAll(cacheKey);
            if (map != null && !map.isEmpty()) {
                Token token = this.map2token(map);
                return token;
            }
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caching(String cacheKey, Token token) throws WeixinException {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.hmset(cacheKey, this.token2map(token));
            if (token.getExpiresIn() > 0) {
                jedis.expire(cacheKey, token.getExpiresIn() - 60);
            }
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    protected Map<String, String> token2map(Token token) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ACCESSTOKEN_KEY, token.getAccessToken());
        map.put(EXPIRESIN_KEY, Integer.toString(token.getExpiresIn()));
        map.put(CREATETIME_KEY, Long.toString(token.getCreateTime()));
        map.put(ORIGINAL_KEY, token.getOriginalResult());
        return map;
    }

    protected Token map2token(Map<String, String> map) {
        Token token = new Token(map.get(ACCESSTOKEN_KEY));
        token.setExpiresIn(Integer.parseInt(map.get(EXPIRESIN_KEY)));
        token.setCreateTime(Long.parseLong(map.get(CREATETIME_KEY)));
        token.setOriginalResult(map.get(ORIGINAL_KEY));
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token evict(String cacheKey) throws WeixinException {
        Token token = this.lookup(cacheKey);
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.del(cacheKey);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws WeixinException {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Set cacheKeys = jedis.keys(String.format("%s*", "weixin4j_"));
            if (!cacheKeys.isEmpty()) {
                Pipeline pipeline = jedis.pipelined();
                for (String cacheKey : cacheKeys) {
                    pipeline.del(cacheKey);
                }
                pipeline.sync();
            }
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }
}

